/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class StateContainer<LETTER, STATE> {
    protected final STATE mState;
    protected final int mSerialNumber;
    protected NestedWordAutomatonReachableStates.ReachProp mReachProp;
    protected final Map<STATE, Integer> mDownStates;
    protected Set<STATE> mUnpropagatedDownStates;
    protected final boolean mCanHaveOutgoingReturn;

    public StateContainer(STATE STATE, int n, Map<STATE, Integer> map, boolean bl) {
        this.mState = STATE;
        this.mSerialNumber = n;
        this.mDownStates = map;
        this.mReachProp = NestedWordAutomatonReachableStates.ReachProp.REACHABLE;
        this.mCanHaveOutgoingReturn = bl;
    }

    public String toString() {
        return this.mState.toString();
    }

    public int getSerialNumber() {
        return this.mSerialNumber;
    }

    public NestedWordAutomatonReachableStates.ReachProp getReachProp() {
        return this.mReachProp;
    }

    public void setReachProp(NestedWordAutomatonReachableStates.ReachProp reachProp) {
        this.mReachProp = reachProp;
    }

    protected Map<STATE, Integer> getDownStates() {
        return this.mDownStates;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StateContainer stateContainer = (StateContainer)object;
        return this.mCanHaveOutgoingReturn == stateContainer.mCanHaveOutgoingReturn && Objects.equals(this.mDownStates, stateContainer.mDownStates) && this.mReachProp == stateContainer.mReachProp && this.mSerialNumber == stateContainer.mSerialNumber && Objects.equals(this.mState, stateContainer.mState) && Objects.equals(this.mUnpropagatedDownStates, stateContainer.mUnpropagatedDownStates);
    }

    public int hashCode() {
        return this.mState.hashCode();
    }

    protected STATE getState() {
        return this.mState;
    }

    boolean addReachableDownState(STATE STATE) {
        assert (!this.mDownStates.containsKey(STATE) || this.mDownStates.get(STATE) == 0);
        Integer n = this.mDownStates.put(STATE, 0);
        if (n == null) {
            if (this.mUnpropagatedDownStates == null) {
                this.mUnpropagatedDownStates = new HashSet<STATE>();
            }
            this.mUnpropagatedDownStates.add(STATE);
            return true;
        }
        return false;
    }

    boolean setDownProp(STATE STATE, DownStateProp downStateProp) {
        int n = this.mDownStates.get(STATE);
        if ((n & downStateProp.getBitCode()) == 0) {
            int n2 = n | downStateProp.getBitCode();
            this.mDownStates.put(STATE, n2);
            if (this.mUnpropagatedDownStates == null) {
                this.mUnpropagatedDownStates = new HashSet<STATE>();
            }
            this.mUnpropagatedDownStates.add(STATE);
            return true;
        }
        return false;
    }

    boolean hasDownProp(STATE STATE, DownStateProp downStateProp) {
        int n = this.mDownStates.get(STATE);
        return (n & downStateProp.getBitCode()) != 0;
    }

    Set<STATE> getUnpropagatedDownStates() {
        return this.mUnpropagatedDownStates;
    }

    void eraseUnpropagatedDownStates() {
        this.mUnpropagatedDownStates = null;
    }

    protected boolean containsInternalTransition(LETTER LETTER, STATE STATE) {
        for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : this.internalSuccessors(LETTER)) {
            if (!STATE.equals(outgoingInternalTransition.getSucc())) continue;
            return true;
        }
        return false;
    }

    protected boolean containsCallTransition(LETTER LETTER, STATE STATE) {
        for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : this.callSuccessors(LETTER)) {
            if (!STATE.equals(outgoingCallTransition.getSucc())) continue;
            return true;
        }
        return false;
    }

    protected boolean containsReturnTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.returnSuccessors(STATE, LETTER)) {
            if (!STATE2.equals(outgoingReturnTransition.getSucc())) continue;
            return true;
        }
        return false;
    }

    public abstract Set<LETTER> lettersInternal();

    public abstract Set<LETTER> lettersInternalIncoming();

    public abstract Set<LETTER> lettersCall();

    public abstract Set<LETTER> lettersCallIncoming();

    public abstract Set<LETTER> lettersReturn(STATE var1);

    public abstract Set<LETTER> lettersReturn();

    public abstract Set<LETTER> lettersReturnIncoming();

    public abstract Collection<STATE> succInternal(LETTER var1);

    public abstract Collection<STATE> predInternal(LETTER var1);

    public abstract Collection<STATE> succCall(LETTER var1);

    public abstract Collection<STATE> predCall(LETTER var1);

    public abstract Collection<STATE> hierPred(LETTER var1);

    public abstract Collection<STATE> succReturn(STATE var1, LETTER var2);

    public abstract Collection<STATE> predReturnLin(LETTER var1, STATE var2);

    public abstract Collection<STATE> predReturnHier(LETTER var1);

    public abstract Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(LETTER var1);

    public abstract Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors();

    public abstract Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(LETTER var1);

    public abstract Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors();

    public abstract Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(LETTER var1);

    public abstract Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors();

    public abstract Iterable<IncomingCallTransition<LETTER, STATE>> callPredecessors(LETTER var1);

    public abstract Iterable<IncomingCallTransition<LETTER, STATE>> callPredecessors();

    public abstract Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE var1, LETTER var2);

    public abstract Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(LETTER var1);

    public abstract Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors();

    public abstract Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE var1);

    public abstract Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(STATE var1, LETTER var2);

    public abstract Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors(LETTER var1);

    public abstract Iterable<IncomingReturnTransition<LETTER, STATE>> returnPredecessors();

    abstract void addInternalOutgoing(OutgoingInternalTransition<LETTER, STATE> var1);

    abstract void addInternalIncoming(IncomingInternalTransition<LETTER, STATE> var1);

    abstract void addCallOutgoing(OutgoingCallTransition<LETTER, STATE> var1);

    abstract void addCallIncoming(IncomingCallTransition<LETTER, STATE> var1);

    abstract void addReturnOutgoing(OutgoingReturnTransition<LETTER, STATE> var1);

    abstract void addReturnIncoming(IncomingReturnTransition<LETTER, STATE> var1);

    public static <LETTER, STATE> StateContainer<LETTER, STATE> returnLower(StateContainer<LETTER, STATE> stateContainer, StateContainer<LETTER, STATE> stateContainer2) {
        if (stateContainer == null) {
            return stateContainer2;
        }
        if (stateContainer2 == null) {
            return stateContainer;
        }
        if (stateContainer.getSerialNumber() < stateContainer2.getSerialNumber()) {
            return stateContainer;
        }
        assert (stateContainer.getSerialNumber() != stateContainer2.getSerialNumber() || stateContainer == stateContainer2) : "two state container with similar serial number";
        return stateContainer2;
    }

    static enum DownStateProp {
        REACH_FINAL_ONCE(1),
        REACH_FINAL_INFTY(2),
        REACHABLE_FROM_FINAL_WITHOUT_CALL(4),
        REACHABLE_AFTER_DEADEND_REMOVAL(8),
        REACHABLE_AFTER_NONLIVE_REMOVAL(16);

        private final int mBitcode;

        private DownStateProp(int n2) {
            this.mBitcode = n2;
        }

        public int getBitCode() {
            return this.mBitcode;
        }
    }
}

