/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetAndAutomataInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.Marking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.TransitionUnifier;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class BoundedPetriNet<LETTER, PLACE>
implements IPetriNet<LETTER, PLACE> {
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final Set<LETTER> mAlphabet;
    private final Set<PLACE> mPlaces = new HashSet<PLACE>();
    private final Set<PLACE> mInitialPlaces = new HashSet<PLACE>();
    private final Set<PLACE> mAcceptingPlaces = new HashSet<PLACE>();
    private final Set<Transition<LETTER, PLACE>> mTransitions = new HashSet<Transition<LETTER, PLACE>>();
    private final Set<Integer> mTransitionIds = new HashSet<Integer>();
    private final TransitionUnifier<LETTER, PLACE> mTransitionUnifier = new TransitionUnifier();
    private final HashRelation<PLACE, Transition<LETTER, PLACE>> mPredecessors = new HashRelation();
    private final HashRelation<PLACE, Transition<LETTER, PLACE>> mSuccessors = new HashRelation();
    private final boolean mConstantTokenAmount;
    private int mSizeOfFlowRelation;

    public BoundedPetriNet(AutomataLibraryServices automataLibraryServices, Set<LETTER> set, boolean bl) {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mAlphabet = set;
        this.mConstantTokenAmount = bl;
    }

    public BoundedPetriNet(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, PLACE> iNestedWordAutomaton) {
        this(automataLibraryServices, iNestedWordAutomaton.getVpAlphabet().getInternalAlphabet(), true);
        HashMap<PLACE, PLACE> hashMap = new HashMap<PLACE, PLACE>();
        for (PLACE PLACE : iNestedWordAutomaton.getStates()) {
            boolean bl;
            boolean bl2;
            boolean bl3 = this.addPlace(PLACE, bl2 = iNestedWordAutomaton.isInitial(PLACE), bl = iNestedWordAutomaton.isFinal(PLACE));
            if (!bl3) {
                throw new AssertionError((Object)("Automaton must not contain state twice: " + String.valueOf(PLACE)));
            }
            hashMap.put(PLACE, PLACE);
        }
        for (PLACE PLACE : iNestedWordAutomaton.getStates()) {
            ImmutableSet immutableSet = ImmutableSet.singleton(hashMap.get(PLACE));
            for (OutgoingInternalTransition outgoingInternalTransition : iNestedWordAutomaton.internalSuccessors(PLACE)) {
                ImmutableSet immutableSet2 = ImmutableSet.singleton(hashMap.get(outgoingInternalTransition.getSucc()));
                this.addTransition(outgoingInternalTransition.getLetter(), immutableSet, immutableSet2);
            }
        }
        assert (this.constantTokenAmountGuaranteed());
    }

    private boolean constantTokenAmountGuaranteed() {
        return !this.constantTokenAmount() || this.transitionsPreserveTokenAmount();
    }

    private boolean transitionsPreserveTokenAmount() {
        return this.mTransitions.parallelStream().allMatch(transition -> transition.getPredecessors().size() == transition.getSuccessors().size());
    }

    public boolean checkResult(INestedWordAutomaton<LETTER, PLACE> iNestedWordAutomaton, IPetriNetAndAutomataInclusionStateFactory<PLACE> iPetriNetAndAutomataInclusionStateFactory) throws AutomataLibraryException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Testing correctness of constructor" + this.getClass().getSimpleName()));
        }
        boolean bl = new IsEquivalent<LETTER, PLACE>(this.mServices, iPetriNetAndAutomataInclusionStateFactory, this, iNestedWordAutomaton).getResult();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of constructor " + this.getClass().getSimpleName()));
        }
        return bl;
    }

    public boolean addPlace(PLACE PLACE, boolean bl, boolean bl2) {
        boolean bl3 = this.mPlaces.add(PLACE);
        if (bl3) {
            if (bl) {
                this.mInitialPlaces.add(PLACE);
            }
            if (bl2) {
                this.mAcceptingPlaces.add(PLACE);
            }
        } else {
            if (this.mInitialPlaces.contains(PLACE) != bl) {
                throw new IllegalArgumentException("Place " + String.valueOf(PLACE) + " was already added with different isInitial status");
            }
            if (this.mAcceptingPlaces.contains(PLACE) != bl2) {
                throw new IllegalArgumentException("Place " + String.valueOf(PLACE) + " was already added with different isAccepting status");
            }
        }
        return bl3;
    }

    public Transition<LETTER, PLACE> addTransition(LETTER LETTER, ImmutableSet<PLACE> immutableSet, ImmutableSet<PLACE> immutableSet2, int n) {
        assert (this.mAlphabet.contains(LETTER)) : "Letter not in alphabet: " + String.valueOf(LETTER);
        if (this.mTransitionIds.contains(n)) {
            throw new IllegalArgumentException("Transition with id " + n + " was already added.");
        }
        Transition<LETTER, PLACE> transition = new Transition<LETTER, PLACE>(LETTER, immutableSet, immutableSet2, n);
        Transition<LETTER, PLACE> transition2 = this.mTransitionUnifier.findOrRegister(transition);
        if (transition2 != null) {
            return transition2;
        }
        for (Object e : immutableSet) {
            assert (this.mPlaces.contains(e)) : "Place not in net: " + String.valueOf(e);
            this.mSuccessors.addPair(e, transition);
        }
        for (Object e : immutableSet2) {
            assert (this.mPlaces.contains(e)) : "Place not in net: " + String.valueOf(e);
            this.mPredecessors.addPair(e, transition);
        }
        this.mTransitions.add(transition);
        this.mTransitionIds.add(transition.getTotalOrderId());
        this.mSizeOfFlowRelation += immutableSet.size() + immutableSet2.size();
        return transition;
    }

    public Transition<LETTER, PLACE> addTransition(LETTER LETTER, ImmutableSet<PLACE> immutableSet, ImmutableSet<PLACE> immutableSet2) {
        return this.addTransition(LETTER, immutableSet, immutableSet2, this.mTransitions.size());
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return this.mAlphabet;
    }

    @Override
    public Set<PLACE> getPlaces() {
        return this.mPlaces;
    }

    @Override
    public Set<PLACE> getInitialPlaces() {
        return this.mInitialPlaces;
    }

    @Override
    public Set<PLACE> getAcceptingPlaces() {
        return this.mAcceptingPlaces;
    }

    @Override
    public Set<Transition<LETTER, PLACE>> getTransitions() {
        return this.mTransitions;
    }

    @Override
    public Set<Transition<LETTER, PLACE>> getSuccessors(PLACE PLACE) {
        return this.mSuccessors.getImage(PLACE);
    }

    @Override
    public Set<Transition<LETTER, PLACE>> getPredecessors(PLACE PLACE) {
        return this.mPredecessors.getImage(PLACE);
    }

    public boolean constantTokenAmount() {
        return this.mConstantTokenAmount;
    }

    @Override
    public boolean isAccepting(Marking<PLACE> marking) {
        for (PLACE PLACE : marking) {
            if (!this.getAcceptingPlaces().contains(PLACE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.mSizeOfFlowRelation;
    }

    @Override
    public String sizeInformation() {
        return "has " + this.mPlaces.size() + " places, " + this.mTransitions.size() + " transitions, " + this.mSizeOfFlowRelation + " flow";
    }

    @Override
    public int flowSize() {
        return this.mPredecessors.size() + this.mSuccessors.size();
    }

    @Override
    public boolean isAccepting(PLACE PLACE) {
        if (!this.mPlaces.contains(PLACE)) {
            throw new IllegalArgumentException("unknown place " + String.valueOf(PLACE));
        }
        return this.mAcceptingPlaces.contains(PLACE);
    }

    public String toString() {
        return AutomatonDefinitionPrinter.toString(this.mServices, "net", this);
    }
}

