/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization;

import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization.PetriNetInitialNode;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization.PlaceNode;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization.TransitionNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableDirectedGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class PetriNetToUltimateModel<LETTER, PLACE> {
    public PetriNetInitialNode transformToUltimateModel(IPetriNet<LETTER, PLACE> iPetriNet) {
        Set<Collection<PLACE>> set = Collections.singleton(iPetriNet.getAcceptingPlaces());
        PetriNetInitialNode petriNetInitialNode = new PetriNetInitialNode(this.printAcceptingMarkings(set));
        Set set2 = iPetriNet.getInitialPlaces();
        HashMap hashMap = new HashMap();
        HashMap<Transition<LETTER, PLACE>, TransitionNode> hashMap2 = new HashMap<Transition<LETTER, PLACE>, TransitionNode>();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object : set2) {
            linkedList.add(object);
            PlaceNode placeNode = new PlaceNode(object, this.participatedAcceptingMarkings(object, set));
            hashMap.put(object, placeNode);
            petriNetInitialNode.connectOutgoing((IModifiableDirectedGraph)placeNode);
        }
        while (!linkedList.isEmpty()) {
            Object object;
            object = linkedList.remove();
            if (object instanceof Transition) {
                this.transitionHandling(set, hashMap, hashMap2, linkedList, (Transition)object);
                continue;
            }
            this.placeHandling(iPetriNet, hashMap, hashMap2, linkedList, object);
        }
        return petriNetInitialNode;
    }

    private void placeHandling(IPetriNet<LETTER, PLACE> iPetriNet, Map<PLACE, PlaceNode> map, Map<Transition<LETTER, PLACE>, TransitionNode> map2, Queue<Object> queue, PLACE PLACE) {
        PlaceNode placeNode = map.get(PLACE);
        for (Transition transition : iPetriNet.getSuccessors(PLACE)) {
            TransitionNode transitionNode = map2.get(transition);
            if (transitionNode == null) {
                transitionNode = new TransitionNode(transition);
                map2.put(transition, transitionNode);
                queue.add(transition);
            }
            placeNode.connectOutgoing((IModifiableDirectedGraph)transitionNode);
        }
    }

    private Collection<String> participatedAcceptingMarkings(PLACE PLACE, Collection<Collection<PLACE>> collection) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Collection<PLACE> collection2 : collection) {
            if (!collection2.contains(PLACE)) continue;
            this.addAcceptingMarkingString(linkedList, collection2);
        }
        return linkedList;
    }

    private void transitionHandling(Collection<Collection<PLACE>> collection, Map<PLACE, PlaceNode> map, Map<Transition<LETTER, PLACE>, TransitionNode> map2, Queue<Object> queue, Transition<LETTER, PLACE> transition) {
        TransitionNode transitionNode = map2.get(transition);
        for (Object e : transition.getSuccessors()) {
            PlaceNode placeNode = map.get(e);
            if (placeNode == null) {
                placeNode = new PlaceNode(e, this.participatedAcceptingMarkings(e, collection));
                map.put(e, placeNode);
                queue.add(e);
            }
            transitionNode.connectOutgoing((IModifiableDirectedGraph)placeNode);
        }
    }

    private Collection<String> printAcceptingMarkings(Collection<Collection<PLACE>> collection) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Collection<PLACE> collection2 : collection) {
            if (collection2.isEmpty()) {
                linkedList.add("{ }");
                continue;
            }
            this.addAcceptingMarkingString(linkedList, collection2);
        }
        return linkedList;
    }

    private void addAcceptingMarkingString(Collection<String> collection, Collection<PLACE> collection2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        String string = "";
        for (PLACE PLACE : collection2) {
            stringBuilder.append(PLACE).append(string);
            string = " , ";
        }
        stringBuilder.append('}');
        collection.add(stringBuilder.toString());
    }
}

