/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.visualization;

import de.uni_freiburg.informatik.ultimate.automata.GeneralAutomatonPrinter;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TreeAutomatonWriter<LETTER extends IRankedLetter, STATE>
extends GeneralAutomatonPrinter {
    private final TreeAutomatonBU<LETTER, STATE> mTreeAutomaton;
    private final String mQuote;

    public TreeAutomatonWriter(PrintWriter printWriter, String string, TreeAutomatonBU<LETTER, STATE> treeAutomatonBU) {
        this(printWriter, string, treeAutomatonBU, "\"");
    }

    protected TreeAutomatonWriter(PrintWriter printWriter, String string, TreeAutomatonBU<LETTER, STATE> treeAutomatonBU, String string2) {
        super(printWriter);
        this.mTreeAutomaton = treeAutomatonBU;
        this.mQuote = string2;
        Map<LETTER, String> map = this.getAlphabetMapping(this.mTreeAutomaton.getAlphabet());
        Map<STATE, String> map2 = this.getStateMapping(this.mTreeAutomaton.getStates());
        this.print("TreeAutomaton ");
        this.print(string);
        this.print(" = ");
        this.print("TreeAutomaton (\n");
        this.printAlphabet(this.mTreeAutomaton.getAlphabet(), map);
        this.printStates(this.mTreeAutomaton.getStates(), map2);
        this.printFinalStates(this.mTreeAutomaton.getFinalStates(), map2);
        this.printTransitionTable(this.mTreeAutomaton.getRules(), map, map2);
        this.printAutomatonSuffix();
        this.finish();
    }

    private void printTransitionTable(Iterable<TreeAutomatonRule<LETTER, STATE>> iterable, Map<LETTER, String> map, Map<STATE, String> map2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\ttransitionTable = {");
        for (TreeAutomatonRule<LETTER, STATE> treeAutomatonRule : iterable) {
            StringBuilder stringBuilder22;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            StringBuilder stringBuilder3 = new StringBuilder();
            for (StringBuilder stringBuilder22 : treeAutomatonRule.getSource()) {
                if (stringBuilder3.length() > 0) {
                    stringBuilder3.append(" ");
                }
                stringBuilder3.append(this.mQuote);
                stringBuilder3.append(map2.get(stringBuilder22));
                stringBuilder3.append(this.mQuote);
            }
            stringBuilder22 = new StringBuilder();
            stringBuilder22.append(this.mQuote);
            stringBuilder22.append(map2.get(treeAutomatonRule.getDest()));
            stringBuilder22.append(this.mQuote);
            StringBuilder stringBuilder4 = new StringBuilder();
            stringBuilder4.append(this.mQuote);
            stringBuilder4.append(map.get(treeAutomatonRule.getLetter()));
            stringBuilder4.append(this.mQuote);
            stringBuilder.append(String.format("\t\t((%s) %s %s)", stringBuilder3, stringBuilder4, stringBuilder22));
        }
        stringBuilder.append("}");
        this.println(stringBuilder.toString());
    }

    private void printFinalStates(Set<STATE> set, Map<STATE, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\tfinalStates = {");
        for (STATE STATE : set) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.mQuote);
            stringBuilder.append(map.get(STATE));
            stringBuilder.append(this.mQuote);
        }
        stringBuilder.append("},");
        this.println(stringBuilder.toString());
    }

    private void printStates(Set<STATE> set, Map<STATE, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\tstates = {");
        for (STATE STATE : set) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.mQuote);
            stringBuilder.append(map.get(STATE));
            stringBuilder.append(this.mQuote);
        }
        stringBuilder.append("},");
        this.println(stringBuilder.toString());
    }

    private void printAlphabet(Set<LETTER> set, Map<LETTER, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\talphabet = {");
        for (IRankedLetter iRankedLetter : set) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.mQuote);
            stringBuilder.append(map.get(iRankedLetter));
            stringBuilder.append(this.mQuote);
        }
        stringBuilder.append("},");
        this.println(stringBuilder.toString());
    }

    protected Map<LETTER, String> getAlphabetMapping(Collection<LETTER> collection) {
        HashMap<IRankedLetter, String> hashMap = new HashMap<IRankedLetter, String>();
        for (IRankedLetter iRankedLetter : this.mTreeAutomaton.getAlphabet()) {
            hashMap.put(iRankedLetter, iRankedLetter.toString());
        }
        return hashMap;
    }

    protected Map<STATE, String> getStateMapping(Collection<STATE> collection) {
        HashMap<STATE, String> hashMap = new HashMap<STATE, String>();
        for (STATE STATE : this.mTreeAutomaton.getStates()) {
            hashMap.put(STATE, STATE.toString());
        }
        return hashMap;
    }
}

