/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter;

import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.AssignableTest;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.InterpreterException;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.ListExistingOperations;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AssignmentExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.BinaryExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.ConditionalBooleanExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.ConditionalBooleanOperatorAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.ForStatementAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.IfElseStatementAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.IfStatementAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.OperationInvocationExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.RelationalExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.StatementListAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.UnaryExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.VariableDeclarationAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.VariableExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.WhileStatementAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AtsASTNode;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AutomataScriptTypeChecker {
    private static final int NUMBER_OF_FOR_ARGUMENTS = 4;
    private static final int NUMBER_OF_ITE_ARGUMENTS = 3;
    private static final String GOT = "\tGot: ";
    private static final String CONDITION_HAS_INCORRECT_TYPE = "Condition has incorrect type.";
    private static final String NUM_OF_OPERANDS = "Num of operands: ";
    private static final String EXPECTED = "Expected: ";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Map<String, Set<Class<?>>> mExistingOperations;
    private final Map<String, Class<?>> mLocalVariables = new HashMap();

    AutomataScriptTypeChecker(Map<String, Set<Class<?>>> map) {
        this.mExistingOperations = map;
    }

    public void checkTestFile(AtsASTNode atsASTNode, Map<String, Object> map) throws InterpreterException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.mLocalVariables.put(entry.getKey(), entry.getValue().getClass());
        }
        this.checkType(atsASTNode);
    }

    private void checkType(AtsASTNode atsASTNode) throws InterpreterException {
        if (atsASTNode instanceof AssignmentExpressionAST) {
            this.checkType((AssignmentExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof BinaryExpressionAST) {
            this.checkType((BinaryExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof ConditionalBooleanExpressionAST) {
            this.checkType((ConditionalBooleanExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof ForStatementAST) {
            AutomataScriptTypeChecker.checkType((ForStatementAST)atsASTNode);
        } else if (atsASTNode instanceof IfElseStatementAST) {
            this.checkType((IfElseStatementAST)atsASTNode);
        } else if (atsASTNode instanceof IfStatementAST) {
            this.checkType((IfStatementAST)atsASTNode);
        } else if (atsASTNode instanceof OperationInvocationExpressionAST) {
            this.checkType((OperationInvocationExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof RelationalExpressionAST) {
            this.checkType((RelationalExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof StatementListAST) {
            for (AtsASTNode atsASTNode2 : atsASTNode.getOutgoingNodes()) {
                this.checkType(atsASTNode2);
            }
        } else if (atsASTNode instanceof UnaryExpressionAST) {
            this.checkType((UnaryExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof VariableDeclarationAST) {
            this.checkType((VariableDeclarationAST)atsASTNode);
        } else if (atsASTNode instanceof VariableExpressionAST) {
            this.checkType((VariableExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof WhileStatementAST) {
            AutomataScriptTypeChecker.checkType((WhileStatementAST)atsASTNode);
        }
    }

    private void checkType(AssignmentExpressionAST assignmentExpressionAST) throws InterpreterException {
        List list = assignmentExpressionAST.getOutgoingNodes();
        ILocation iLocation = assignmentExpressionAST.getLocation();
        if (list.size() != 2) {
            Object object2 = "Assignment should have 2 operands." + LINE_SEPARATOR;
            object2 = ((String)object2).concat("On the left-hand side there  must be a variable, ");
            Object object3 = object2 = ((String)object2).concat("on the right-hand side there can be an arbitrary expression.");
            throw new InterpreterException(iLocation, (String)object3);
        }
        this.checkType((AtsASTNode)list.get(0));
        this.checkType((AtsASTNode)list.get(1));
        VariableExpressionAST variableExpressionAST = (VariableExpressionAST)list.get(0);
        for (Class<?> object4 : this.getTypes((AtsASTNode)list.get(1))) {
            ((AtsASTNode)list.get(1)).setType(object4);
            if (!AssignableTest.isAssignableFrom(variableExpressionAST.getReturnType(), object4)) continue;
            return;
        }
        String string2 = "Right side has incorrect type." + LINE_SEPARATOR;
        string2 = string2.concat(EXPECTED + variableExpressionAST.getReturnType().getSimpleName() + GOT + ((AtsASTNode)list.get(1)).getReturnType().getSimpleName());
        String string3 = string2;
        throw new InterpreterException(iLocation, string3);
    }

    private void checkType(BinaryExpressionAST binaryExpressionAST) throws InterpreterException {
        Object object;
        List list = binaryExpressionAST.getOutgoingNodes();
        ILocation iLocation = binaryExpressionAST.getLocation();
        if (list.size() != 2) {
            String string;
            String string2 = string = binaryExpressionAST.getOperatorAsString() + " should have 2 operands of type \"int\"." + LINE_SEPARATOR + NUM_OF_OPERANDS + list.size();
            throw new InterpreterException(iLocation, string2);
        }
        this.checkType((AtsASTNode)list.get(0));
        this.checkType((AtsASTNode)list.get(1));
        if (binaryExpressionAST.getReturnType() == String.class) {
            return;
        }
        boolean bl = false;
        for (Class<?> object22 : this.getTypes((AtsASTNode)list.get(0))) {
            if (!AssignableTest.isAssignableFrom(binaryExpressionAST.getReturnType(), object22)) continue;
            bl = true;
        }
        if (!bl) {
            String string2 = "Left operand of \"" + binaryExpressionAST.getOperatorAsString() + "\" has incorrect type." + LINE_SEPARATOR;
            string2 = string2.concat(EXPECTED + binaryExpressionAST.getReturnType().getSimpleName() + GOT + ((AtsASTNode)list.get(0)).getReturnType().getSimpleName());
            object = string2;
            throw new InterpreterException(iLocation, (String)object);
        }
        for (Class<?> clazz : this.getTypes((AtsASTNode)list.get(1))) {
            if (!AssignableTest.isAssignableFrom(binaryExpressionAST.getReturnType(), clazz)) continue;
            return;
        }
        String string3 = "Right operand of \"" + binaryExpressionAST.getOperatorAsString() + "\" has incorrect type." + LINE_SEPARATOR;
        string3 = string3.concat(EXPECTED + binaryExpressionAST.getReturnType().getSimpleName() + GOT + ((AtsASTNode)list.get(1)).getReturnType().getSimpleName());
        object = string3;
        throw new InterpreterException(iLocation, (String)object);
    }

    private void checkType(ConditionalBooleanExpressionAST conditionalBooleanExpressionAST) throws InterpreterException {
        Object object;
        List list = conditionalBooleanExpressionAST.getOutgoingNodes();
        ILocation iLocation = conditionalBooleanExpressionAST.getLocation();
        if (conditionalBooleanExpressionAST.getOperator() == ConditionalBooleanOperatorAST.NOT && list.size() != 1) {
            String string;
            String string2 = string = "\"!\" operator should have 1 operand." + LINE_SEPARATOR + NUM_OF_OPERANDS + list.size();
            throw new InterpreterException(iLocation, string2);
        }
        if (conditionalBooleanExpressionAST.getOperator() == ConditionalBooleanOperatorAST.AND && list.size() != 2) {
            String string;
            String string3 = string = "\"&&\" operator should have 2 operands." + LINE_SEPARATOR + NUM_OF_OPERANDS + list.size();
            throw new InterpreterException(iLocation, string3);
        }
        if (conditionalBooleanExpressionAST.getOperator() == ConditionalBooleanOperatorAST.OR && list.size() != 2) {
            String string;
            String string4 = string = " \"||\" operator should have 2 operands." + LINE_SEPARATOR + NUM_OF_OPERANDS + list.size();
            throw new InterpreterException(iLocation, string4);
        }
        this.checkType((AtsASTNode)list.get(0));
        if (list.size() == 2) {
            this.checkType((AtsASTNode)list.get(1));
        }
        boolean bl = false;
        for (Class<?> object22 : this.getTypes((AtsASTNode)list.get(0))) {
            if (!AssignableTest.isAssignableFrom(conditionalBooleanExpressionAST.getReturnType(), object22)) continue;
            bl = true;
        }
        if (!bl) {
            String string2 = (list.size() == 2 ? "Left " : "") + "argument has incorrect type." + LINE_SEPARATOR;
            string2 = string2.concat(EXPECTED + conditionalBooleanExpressionAST.getReturnType().getSimpleName() + GOT + ((AtsASTNode)list.get(0)).getReturnType().getSimpleName());
            object = string2;
            throw new InterpreterException(iLocation, (String)object);
        }
        if (list.size() == 2) {
            for (Class<?> clazz : this.getTypes((AtsASTNode)list.get(1))) {
                if (!AssignableTest.isAssignableFrom(conditionalBooleanExpressionAST.getReturnType(), clazz)) continue;
                return;
            }
            String string3 = "Right argument has incorrect type." + LINE_SEPARATOR;
            string3 = string3.concat(EXPECTED + conditionalBooleanExpressionAST.getReturnType().getSimpleName() + GOT + ((AtsASTNode)list.get(1)).getReturnType().getSimpleName());
            object = string3;
            throw new InterpreterException(iLocation, (String)object);
        }
    }

    private static void checkType(ForStatementAST forStatementAST) throws InterpreterException {
        List list = forStatementAST.getOutgoingNodes();
        ILocation iLocation = forStatementAST.getLocation();
        if (list.size() != 4) {
            Object object = "ForStatement should have 4 arguments (initStmt, condition, updateStmt) {stmtList}." + LINE_SEPARATOR;
            Object object2 = object = ((String)object).concat("Num of children: " + list.size());
            throw new InterpreterException(iLocation, (String)object2);
        }
        if (list.get(0) != null && ((AtsASTNode)list.get(0)).getReturnType() != Boolean.class) {
            Object object = "Loopcondition has incorrect type." + LINE_SEPARATOR;
            Object object3 = object = ((String)object).concat(EXPECTED + Boolean.class.getSimpleName() + GOT + ((AtsASTNode)list.get(0)).getReturnType().getSimpleName());
            throw new InterpreterException(iLocation, (String)object3);
        }
    }

    private void checkType(IfElseStatementAST ifElseStatementAST) throws InterpreterException {
        List list = ifElseStatementAST.getOutgoingNodes();
        ILocation iLocation = ifElseStatementAST.getLocation();
        if (list.size() != 3) {
            Object object = "IfElseStatement should have 3 operands (Condition) { Thenstatements} {Elsestatements})" + LINE_SEPARATOR;
            Object object2 = object = ((String)object).concat(NUM_OF_OPERANDS + list.size());
            throw new InterpreterException(iLocation, (String)object2);
        }
        this.checkType((AtsASTNode)list.get(0));
        if (((AtsASTNode)list.get(0)).getReturnType() != Boolean.class) {
            Object object = CONDITION_HAS_INCORRECT_TYPE + LINE_SEPARATOR;
            Object object3 = object = ((String)object).concat(EXPECTED + Boolean.class.getSimpleName() + GOT + ((AtsASTNode)list.get(0)).getReturnType().getSimpleName());
            throw new InterpreterException(iLocation, (String)object3);
        }
    }

    private void checkType(IfStatementAST ifStatementAST) throws InterpreterException {
        List list = ifStatementAST.getOutgoingNodes();
        ILocation iLocation = ifStatementAST.getLocation();
        if (list.size() != 2) {
            Object object = "IfStatement should have 2 operands (condition) {thenStatements}" + LINE_SEPARATOR;
            Object object2 = object = ((String)object).concat(NUM_OF_OPERANDS + list.size());
            throw new InterpreterException(iLocation, (String)object2);
        }
        this.checkType((AtsASTNode)list.get(0));
        if (((AtsASTNode)list.get(0)).getReturnType() != Boolean.class) {
            Object object = CONDITION_HAS_INCORRECT_TYPE + LINE_SEPARATOR;
            Object object3 = object = ((String)object).concat(EXPECTED + Boolean.class.getSimpleName() + GOT + ((AtsASTNode)list.get(0)).getReturnType().getSimpleName());
            throw new InterpreterException(iLocation, (String)object3);
        }
    }

    private void checkType(OperationInvocationExpressionAST operationInvocationExpressionAST) throws InterpreterException {
        AtsASTNode atsASTNode2;
        ILocation iLocation = operationInvocationExpressionAST.getLocation();
        String string = operationInvocationExpressionAST.getOperationName();
        if (!(this.mExistingOperations.containsKey(string) || string.equals("assert") || string.equals("print") || string.equals("write"))) {
            String string2;
            String string3 = string2 = "Unsupported operation \"" + operationInvocationExpressionAST.getOperationName() + "\"";
            String string4 = new ListExistingOperations(this.mExistingOperations).prettyPrint();
            Object object = !Character.isLowerCase(string.charAt(0)) ? "Operation names have to start with a lowercase letter." + LINE_SEPARATOR : "";
            Object object2 = object = (String)object + "We support only the following operations " + LINE_SEPARATOR + string4;
            throw new InterpreterException(iLocation, string3, (String)object2);
        }
        if (operationInvocationExpressionAST.getOutgoingNodes() != null && operationInvocationExpressionAST.getOutgoingNodes().get(0) != null) {
            for (AtsASTNode atsASTNode2 : ((AtsASTNode)operationInvocationExpressionAST.getOutgoingNodes().get(0)).getOutgoingNodes()) {
                this.checkType(atsASTNode2);
            }
        }
        if (string.equals("print")) {
            return;
        }
        atsASTNode2 = this.getTypes((AtsASTNode)operationInvocationExpressionAST);
        if (!atsASTNode2.isEmpty()) {
            Class[] classArray = new Class[1];
            classArray = atsASTNode2.toArray(classArray);
            operationInvocationExpressionAST.setType(classArray[0]);
        }
    }

    private void checkType(RelationalExpressionAST relationalExpressionAST) throws InterpreterException {
        Object object;
        List list = relationalExpressionAST.getOutgoingNodes();
        ILocation iLocation = relationalExpressionAST.getLocation();
        if (list.size() != 2) {
            String string;
            String string2 = string = "\"" + relationalExpressionAST.getOperatorAsString() + " should have 2 operands." + LINE_SEPARATOR + NUM_OF_OPERANDS + list.size();
            throw new InterpreterException(iLocation, string2);
        }
        this.checkType((AtsASTNode)list.get(0));
        this.checkType((AtsASTNode)list.get(1));
        boolean bl = false;
        for (Class<?> object22 : this.getTypes((AtsASTNode)list.get(0))) {
            if (!AssignableTest.isAssignableFrom(relationalExpressionAST.getExpectingType(), object22)) continue;
            bl = true;
        }
        if (!bl) {
            String string2 = "Left operand has incorrect type." + LINE_SEPARATOR;
            string2 = string2.concat(EXPECTED + relationalExpressionAST.getExpectingType().getSimpleName() + GOT + ((AtsASTNode)list.get(0)).getReturnType().getSimpleName());
            object = string2;
            throw new InterpreterException(iLocation, (String)object);
        }
        for (Class<?> clazz : this.getTypes((AtsASTNode)list.get(1))) {
            if (!AssignableTest.isAssignableFrom(relationalExpressionAST.getExpectingType(), clazz)) continue;
            return;
        }
        String string3 = "Right operand has incorrect type." + LINE_SEPARATOR;
        string3 = string3.concat(EXPECTED + relationalExpressionAST.getExpectingType().getSimpleName() + GOT + ((AtsASTNode)list.get(1)).getReturnType().getSimpleName());
        object = string3;
        throw new InterpreterException(iLocation, (String)object);
    }

    private void checkType(UnaryExpressionAST unaryExpressionAST) throws InterpreterException {
        List list = unaryExpressionAST.getOutgoingNodes();
        ILocation iLocation = unaryExpressionAST.getLocation();
        if (list.size() != 1) {
            String string;
            String object3 = string = "\"" + unaryExpressionAST.getOperatorAsString() + "\" should have one variable as argument." + LINE_SEPARATOR + "Num of arguments: " + list.size();
            throw new InterpreterException(iLocation, object3);
        }
        this.checkType((AtsASTNode)list.get(0));
        if (!(list.get(0) instanceof VariableExpressionAST)) {
            String string;
            String string2 = string = "Unary operators are applicable only on variables." + LINE_SEPARATOR + "You want to apply it on " + ((AtsASTNode)list.get(0)).getClass().getSimpleName();
            throw new InterpreterException(iLocation, string2);
        }
        for (Class<?> object2 : this.getTypes((AtsASTNode)list.get(0))) {
            if (!AssignableTest.isAssignableFrom(unaryExpressionAST.getExpectingType(), object2)) continue;
            return;
        }
        String string3 = "Operand has incorrect type." + LINE_SEPARATOR;
        string3 = string3.concat(EXPECTED + unaryExpressionAST.getExpectingType().getSimpleName() + GOT + ((AtsASTNode)list.get(0)).getReturnType().getSimpleName());
        String string4 = string3;
        throw new InterpreterException(iLocation, string4);
    }

    private void checkType(VariableExpressionAST variableExpressionAST) throws InterpreterException {
        ILocation iLocation = variableExpressionAST.getLocation();
        if (!this.mLocalVariables.containsKey(variableExpressionAST.getIdentifier())) {
            String string = "Variable \"" + variableExpressionAST.getIdentifier() + "\" was not declared.";
            throw new InterpreterException(iLocation, "Undeclared variable", string);
        }
        variableExpressionAST.setType(this.mLocalVariables.get(variableExpressionAST.getIdentifier()));
    }

    private void checkType(VariableDeclarationAST variableDeclarationAST) throws InterpreterException {
        List list = variableDeclarationAST.getOutgoingNodes();
        ILocation iLocation = variableDeclarationAST.getLocation();
        if (list.size() > 1) {
            throw new InterpreterException(iLocation, "Variabledeclaration can have at most one operand. (the value to assign)");
        }
        for (String object2 : variableDeclarationAST.getIdentifiers()) {
            this.mLocalVariables.put(object2, variableDeclarationAST.getExpectingType());
        }
        if (list.isEmpty()) {
            return;
        }
        this.checkType((AtsASTNode)list.get(0));
        for (Class clazz : this.getTypes((AtsASTNode)list.get(0))) {
            if (!AssignableTest.isAssignableFrom(variableDeclarationAST.getReturnType(), clazz)) continue;
            return;
        }
        String string = "Operand on the right side has incorrect type." + LINE_SEPARATOR + EXPECTED + variableDeclarationAST.getExpectingType().getSimpleName() + GOT + ((AtsASTNode)list.get(0)).getReturnType().getSimpleName();
        String object3 = string;
        throw new InterpreterException(iLocation, object3);
    }

    private static void checkType(WhileStatementAST whileStatementAST) throws InterpreterException {
        List list = whileStatementAST.getOutgoingNodes();
        ILocation iLocation = whileStatementAST.getLocation();
        if (list.size() != 2) {
            Object object = "WhileStatement should have 2 operands (condition) {stmtList}" + LINE_SEPARATOR;
            Object object2 = object = ((String)object).concat("Number of children: " + list.size());
            throw new InterpreterException(iLocation, (String)object2);
        }
        if (list.get(0) != null && ((AtsASTNode)list.get(0)).getReturnType() != Boolean.class) {
            Object object = CONDITION_HAS_INCORRECT_TYPE + LINE_SEPARATOR;
            Object object3 = object = ((String)object).concat(EXPECTED + Boolean.class.getSimpleName() + GOT + ((AtsASTNode)list.get(0)).getReturnType().getSimpleName());
            throw new InterpreterException(iLocation, (String)object3);
        }
    }

    private Set<Class<?>> getTypes(AtsASTNode atsASTNode) {
        if (atsASTNode instanceof OperationInvocationExpressionAST) {
            OperationInvocationExpressionAST operationInvocationExpressionAST = (OperationInvocationExpressionAST)atsASTNode;
            String string = operationInvocationExpressionAST.getOperationName();
            HashSet hashSet = new HashSet();
            if (string.equals("print") || string.equals("assert") || string.equals("write")) {
                return hashSet;
            }
            if (!this.mExistingOperations.containsKey(string)) {
                throw new UnsupportedOperationException("Operation \"" + string + "\" was not found!");
            }
            Set<Class<?>> set = this.mExistingOperations.get(string);
            for (Class<?> clazz : set) {
                Method[] methodArray = clazz.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if ("getResult".equals(method.getName())) {
                        hashSet.add(method.getReturnType());
                    }
                    ++n2;
                }
            }
            if (hashSet.isEmpty()) {
                throw new UnsupportedOperationException("Operation \"" + string + "\" has no operation \"getResult()\"");
            }
            return hashSet;
        }
        HashSet hashSet = new HashSet();
        hashSet.add(atsASTNode.getReturnType());
        return hashSet;
    }
}

