/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.LinearRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.ComposableTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AffineTemplate
extends ComposableTemplate {
    private static final String s_name_delta = "delta_";
    private static final String s_name_function = "rank_";
    private Term mdelta;
    private AffineFunctionGenerator mfgen;

    @Override
    protected void init() {
        this.mdelta = this.newDelta(s_name_delta + this.getInstanceNumber());
        this.mfgen = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_function + this.getInstanceNumber());
    }

    @Override
    public String getName() {
        return "affine";
    }

    public String toString() {
        return "Affine template:\n   delta > 0\n/\\ f(x) > 0\n/\\ f(x) > f(x') + delta";
    }

    @Override
    public List<List<LinearInequality>> getConstraintsDec(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        LinearInequality linearInequality = this.mfgen.generate(map);
        LinearInequality linearInequality2 = this.mfgen.generate(map2);
        linearInequality2.negate();
        linearInequality.add(linearInequality2);
        AffineTerm affineTerm = new AffineTerm(this.mdelta, Rational.MONE);
        linearInequality.add(affineTerm);
        linearInequality.setStrict(true);
        linearInequality.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
        return Collections.singletonList(Collections.singletonList(linearInequality));
    }

    @Override
    public List<List<LinearInequality>> getConstraintsNonInc(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        LinearInequality linearInequality = this.mfgen.generate(map);
        LinearInequality linearInequality2 = this.mfgen.generate(map2);
        linearInequality2.negate();
        linearInequality.add(linearInequality2);
        linearInequality.setStrict(false);
        linearInequality.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
        return Collections.singletonList(Collections.singletonList(linearInequality));
    }

    @Override
    public List<List<LinearInequality>> getConstraintsBounded(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        LinearInequality linearInequality = this.mfgen.generate(map);
        linearInequality.setStrict(true);
        linearInequality.mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
        return Collections.singletonList(Collections.singletonList(linearInequality));
    }

    @Override
    public List<String> getAnnotationsDec() {
        return Collections.singletonList("rank decreasing");
    }

    @Override
    public List<String> getAnnotationsNonInc() {
        return Collections.singletonList("rank nonincreasing");
    }

    @Override
    public List<String> getAnnotationsBounded() {
        return Collections.singletonList("rank bounded");
    }

    @Override
    public Collection<Term> getCoefficients() {
        Collection<Term> collection = this.mfgen.getCoefficients();
        collection.add(this.mdelta);
        return collection;
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> map) throws SMTLIBException {
        AffineFunction affineFunction = this.mfgen.extractAffineFunction(map);
        return new LinearRankingFunction(affineFunction);
    }

    @Override
    public int getDegree() {
        return 0;
    }
}

