/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.variables;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoUnderConstruction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LassoPartitioneer {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final LassoUnderConstruction mLasso;
    private final NestedMap2<Part, NonTheorySymbol<?>, ModifiableTransFormula> mSymbol2OriginalTF = new NestedMap2();
    private HashRelation<NonTheorySymbol<?>, Term> mSymbol2StemConjuncts;
    private HashSet<NonTheorySymbol<?>> mStemSymbolsWithoutConjuncts;
    private HashRelation<NonTheorySymbol<?>, Term> mSymbol2LoopConjuncts;
    private HashSet<NonTheorySymbol<?>> mLoopSymbolsWithoutConjuncts;
    private List<Term> mStemConjunctsWithoutSymbols;
    private List<Term> mLoopConjunctsWithoutSymbols;
    private final UnionFind<NonTheorySymbol<?>> mEquivalentSymbols = new UnionFind();
    private final Set<IProgramVar> mAllRankVars = new HashSet<IProgramVar>();
    private final List<LassoUnderConstruction> mNewLassos = new ArrayList<LassoUnderConstruction>();

    public LassoPartitioneer(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, LassoUnderConstruction lassoUnderConstruction) {
        this.mServices = iUltimateServiceProvider;
        this.mMgdScript = managedScript;
        this.mLasso = lassoUnderConstruction;
        this.doPartition();
    }

    public List<LassoUnderConstruction> getNewLassos() {
        return this.mNewLassos;
    }

    private void doPartition() {
        ImmutableSet immutableSet;
        this.mSymbol2StemConjuncts = new HashRelation();
        this.mSymbol2LoopConjuncts = new HashRelation();
        this.mStemSymbolsWithoutConjuncts = new HashSet();
        this.mLoopSymbolsWithoutConjuncts = new HashSet();
        this.mStemConjunctsWithoutSymbols = new ArrayList<Term>();
        this.mLoopConjunctsWithoutSymbols = new ArrayList<Term>();
        this.extractSymbols(Part.STEM, this.mLasso.getStem(), this.mSymbol2StemConjuncts, this.mStemSymbolsWithoutConjuncts, this.mStemConjunctsWithoutSymbols);
        this.extractSymbols(Part.LOOP, this.mLasso.getLoop(), this.mSymbol2LoopConjuncts, this.mLoopSymbolsWithoutConjuncts, this.mLoopConjunctsWithoutSymbols);
        for (IProgramVar iProgramVar : this.mAllRankVars) {
            immutableSet = new HashSet();
            this.extractInVarAndOutVarSymbols(iProgramVar, (Set<NonTheorySymbol<?>>)immutableSet, this.mLasso.getStem());
            this.extractInVarAndOutVarSymbols(iProgramVar, (Set<NonTheorySymbol<?>>)immutableSet, this.mLasso.getLoop());
            this.announceEquivalence((Set<NonTheorySymbol<?>>)immutableSet);
        }
        for (IProgramVar iProgramVar : this.mEquivalentSymbols.getAllRepresentatives()) {
            NonTheorySymbol nonTheorySymbol2;
            immutableSet = this.mEquivalentSymbols.getEquivalenceClassMembers((Object)iProgramVar);
            HashSet<Term> hashSet = new HashSet<Term>();
            HashSet<Term> hashSet2 = new HashSet<Term>();
            HashSet hashSet3 = new HashSet();
            HashSet hashSet4 = new HashSet();
            for (NonTheorySymbol nonTheorySymbol2 : immutableSet) {
                if (this.mSymbol2StemConjuncts.getDomain().contains(nonTheorySymbol2)) {
                    hashSet.addAll(this.mSymbol2StemConjuncts.getImage((Object)nonTheorySymbol2));
                    continue;
                }
                if (this.mStemSymbolsWithoutConjuncts.contains(nonTheorySymbol2)) {
                    hashSet3.add(nonTheorySymbol2);
                    continue;
                }
                if (this.mSymbol2LoopConjuncts.getDomain().contains(nonTheorySymbol2)) {
                    hashSet2.addAll(this.mSymbol2LoopConjuncts.getImage((Object)nonTheorySymbol2));
                    continue;
                }
                if (this.mLoopSymbolsWithoutConjuncts.contains(nonTheorySymbol2)) {
                    hashSet4.add(nonTheorySymbol2);
                    continue;
                }
                throw new AssertionError((Object)("unknown variable " + String.valueOf(nonTheorySymbol2)));
            }
            if (hashSet.isEmpty() && hashSet3.isEmpty() && hashSet2.isEmpty() && hashSet4.isEmpty()) continue;
            nonTheorySymbol2 = this.constructTransFormulaLR(Part.STEM, hashSet, hashSet3);
            ModifiableTransFormula modifiableTransFormula = this.constructTransFormulaLR(Part.LOOP, hashSet2, hashSet4);
            this.mNewLassos.add(new LassoUnderConstruction((ModifiableTransFormula)nonTheorySymbol2, modifiableTransFormula));
        }
        if (!this.emptyOrTrue(this.mStemConjunctsWithoutSymbols) || !this.emptyOrTrue(this.mLoopConjunctsWithoutSymbols)) {
            IProgramVar iProgramVar;
            iProgramVar = this.constructTransFormulaLR(Part.STEM, this.mStemConjunctsWithoutSymbols);
            Iterator<Object> iterator = this.constructTransFormulaLR(Part.LOOP, this.mLoopConjunctsWithoutSymbols);
            this.mNewLassos.add(new LassoUnderConstruction((ModifiableTransFormula)iProgramVar, (ModifiableTransFormula)iterator));
        }
    }

    private boolean emptyOrTrue(List<Term> list) {
        if (list.isEmpty()) {
            return true;
        }
        Term term = SmtUtils.and((Script)this.mMgdScript.getScript(), list);
        return term.toString().equals("true");
    }

    private void extractInVarAndOutVarSymbols(IProgramVar iProgramVar, Set<NonTheorySymbol<?>> set, ModifiableTransFormula modifiableTransFormula) {
        Term term;
        Term term2 = (Term)modifiableTransFormula.getInVars().get(iProgramVar);
        if (term2 != null) {
            set.add(this.constructSymbol(term2));
        }
        if ((term = (Term)modifiableTransFormula.getOutVars().get(iProgramVar)) != null) {
            set.add(this.constructSymbol(term));
        }
        assert (term2 == null == (term == null)) : "both or none";
    }

    private ModifiableTransFormula constructTransFormulaLR(Part part, Set<Term> set, Set<NonTheorySymbol<?>> set2) {
        Term term = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])set.toArray(new Term[set.size()]));
        ModifiableTransFormula modifiableTransFormula = new ModifiableTransFormula(term);
        for (NonTheorySymbol nonTheorySymbol : NonTheorySymbol.extractNonTheorySymbols((Term)term)) {
            this.addInOuAuxVar(part, modifiableTransFormula, nonTheorySymbol);
        }
        for (NonTheorySymbol nonTheorySymbol : set2) {
            this.addInOuAuxVar(part, modifiableTransFormula, nonTheorySymbol);
        }
        return modifiableTransFormula;
    }

    private ModifiableTransFormula constructTransFormulaLR(Part part, List<Term> list) {
        Term term = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])list.toArray(new Term[list.size()]));
        ModifiableTransFormula modifiableTransFormula = new ModifiableTransFormula(term);
        return modifiableTransFormula;
    }

    private void addInOuAuxVar(Part part, ModifiableTransFormula modifiableTransFormula, NonTheorySymbol<?> nonTheorySymbol) {
        boolean bl;
        TermVariable termVariable;
        ModifiableTransFormula modifiableTransFormula2 = (ModifiableTransFormula)this.mSymbol2OriginalTF.get((Object)part, nonTheorySymbol);
        if (nonTheorySymbol instanceof NonTheorySymbol.Variable) {
            termVariable = (TermVariable)nonTheorySymbol.getSymbol();
            bl = false;
        } else if (nonTheorySymbol instanceof NonTheorySymbol.Constant) {
            termVariable = (TermVariable)nonTheorySymbol.getSymbol();
            bl = true;
        } else {
            throw new UnsupportedOperationException("function symbols not yet supported");
        }
        IProgramVar iProgramVar = (IProgramVar)modifiableTransFormula2.getInVarsReverseMapping().get(termVariable);
        IProgramVar iProgramVar2 = (IProgramVar)modifiableTransFormula2.getOutVarsReverseMapping().get(termVariable);
        boolean bl2 = modifiableTransFormula2.getAuxVars().contains(termVariable);
        assert (bl || !bl2 || iProgramVar == null && iProgramVar2 == null) : "auxVar may neither be inVar nor outVar";
        assert (bl || iProgramVar != null || iProgramVar2 != null || bl2) : "neither inVar nor outVar may be auxVar";
        if (iProgramVar != null) {
            modifiableTransFormula.addInVar(iProgramVar, termVariable);
        }
        if (iProgramVar2 != null) {
            modifiableTransFormula.addOutVar(iProgramVar2, termVariable);
        }
        if (bl2) {
            TermVariable termVariable2 = termVariable;
            modifiableTransFormula.addAuxVars(Collections.singleton(termVariable2));
        }
    }

    private HashRelation<NonTheorySymbol<?>, Term> extractSymbols(Part part, ModifiableTransFormula modifiableTransFormula, HashRelation<NonTheorySymbol<?>, Term> hashRelation, HashSet<NonTheorySymbol<?>> hashSet, List<Term> list) {
        Term[] termArray;
        this.mAllRankVars.addAll(modifiableTransFormula.getInVars().keySet());
        this.mAllRankVars.addAll(modifiableTransFormula.getOutVars().keySet());
        Term term = SmtUtils.toCnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)modifiableTransFormula.getFormula());
        Term[] termArray2 = termArray = SmtUtils.getConjuncts((Term)term);
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term object = termArray2[n2];
            Set set = NonTheorySymbol.extractNonTheorySymbols((Term)object);
            if (set.isEmpty()) {
                list.add(object);
            } else {
                for (NonTheorySymbol nonTheorySymbol : set) {
                    ModifiableTransFormula modifiableTransFormula2 = (ModifiableTransFormula)this.mSymbol2OriginalTF.put((Object)part, (Object)nonTheorySymbol, (Object)modifiableTransFormula);
                    assert (modifiableTransFormula2 == null || modifiableTransFormula2 == modifiableTransFormula) : "may not be modified";
                    set.add(nonTheorySymbol);
                    if (this.mEquivalentSymbols.find((Object)nonTheorySymbol) == null) {
                        this.mEquivalentSymbols.makeEquivalenceClass((Object)nonTheorySymbol);
                    }
                    hashRelation.addPair((Object)nonTheorySymbol, (Object)object);
                }
                this.announceEquivalence(set);
            }
            ++n2;
        }
        for (Map.Entry entry : modifiableTransFormula.getInVars().entrySet()) {
            this.addIfNotAlreadyAdded(part, hashSet, modifiableTransFormula, (Term)entry.getValue(), hashRelation);
        }
        for (Map.Entry entry : modifiableTransFormula.getOutVars().entrySet()) {
            this.addIfNotAlreadyAdded(part, hashSet, modifiableTransFormula, (Term)entry.getValue(), hashRelation);
        }
        return hashRelation;
    }

    private void addIfNotAlreadyAdded(Part part, HashSet<NonTheorySymbol<?>> hashSet, ModifiableTransFormula modifiableTransFormula, Term term, HashRelation<NonTheorySymbol<?>, Term> hashRelation) {
        NonTheorySymbol<?> nonTheorySymbol = this.constructSymbol(term);
        if (!hashRelation.getDomain().contains(nonTheorySymbol) && !hashSet.contains(nonTheorySymbol)) {
            if (this.mEquivalentSymbols.find(nonTheorySymbol) == null) {
                this.mEquivalentSymbols.makeEquivalenceClass(nonTheorySymbol);
            }
            hashSet.add(nonTheorySymbol);
            ModifiableTransFormula modifiableTransFormula2 = (ModifiableTransFormula)this.mSymbol2OriginalTF.put((Object)part, nonTheorySymbol, (Object)modifiableTransFormula);
            assert (modifiableTransFormula2 == null || modifiableTransFormula2 == modifiableTransFormula) : "may not be modified";
        }
    }

    private NonTheorySymbol<?> constructSymbol(Term term) {
        if (term instanceof TermVariable) {
            return new NonTheorySymbol.Variable((TermVariable)term);
        }
        if (SmtUtils.isConstant((Term)term)) {
            return new NonTheorySymbol.Constant((ApplicationTerm)term);
        }
        throw new IllegalArgumentException();
    }

    private void announceEquivalence(Set<NonTheorySymbol<?>> set) {
        NonTheorySymbol<?> nonTheorySymbol = null;
        for (NonTheorySymbol<?> nonTheorySymbol2 : set) {
            if (nonTheorySymbol != null) {
                this.mEquivalentSymbols.union(nonTheorySymbol2, nonTheorySymbol);
            }
            nonTheorySymbol = nonTheorySymbol2;
        }
    }

    private static enum Part {
        STEM,
        LOOP;

    }
}

