/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CExpressionTranslator;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.BitvectorTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.IFloatingPointHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.INameHandler;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.OverapproxVariable;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;

public class MathLibraryModel
implements ILibraryModel {
    private static final String[] UNSUPPORTED_FLOAT_OPERATIONS = new String[]{"frexp", "ldexp", "pow", "hypot", "cbrt", "drem", "significand", "j0", "j1", "jn", "y0", "y1", "yn", "erfc", "lgamma", "tgamma", "gamma", "lgamma_r", "nextafter", "nexttoward", "scalbn", "ilogb", "scalbln", "remquo", "fma", "scalb", "frexpf", "ldexpf", "powf", "hypotf", "cbrtf", "dremf", "significandf", "j0f", "j1f", "jnf", "y0f", "y1f", "ynf", "erfcf", "lgammaf", "tgammaf", "gammaf", "lgammaf_r", "nextafterf", "nexttowardf", "scalbnf", "ilogbf", "scalblnf", "remquof", "fmaf", "scalbf", "frexpl", "ldexpl", "powl", "hypotl", "cbrtl", "dreml", "significandl", "j0l", "j1l", "jnl", "y0l", "y1l", "ynl", "erfcl", "lgammal", "tgammal", "gammal", "lgammal_r", "nextafterl", "nexttowardl", "scalbnl", "ilogbl", "scalblnl", "remquol", "fmal", "scalbl", "signgam;", "modf", "modff", "modfl"};
    private final FunctionModelHelper mHelper;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final ExpressionTranslation mExpressionTranslation;
    private final IFloatingPointHandler mFloatHandler;
    private final CExpressionTranslator mCEpressionTranslator;
    private final INameHandler mNameHandler;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;

    public MathLibraryModel(FunctionModelHelper functionModelHelper, ExpressionResultTransformer expressionResultTransformer, ExpressionTranslation expressionTranslation, CExpressionTranslator cExpressionTranslator, INameHandler iNameHandler, AuxVarInfoBuilder auxVarInfoBuilder) {
        this.mHelper = functionModelHelper;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mExpressionTranslation = expressionTranslation;
        this.mFloatHandler = expressionTranslation.getFloatingPointHandler();
        this.mCEpressionTranslator = cExpressionTranslator;
        this.mNameHandler = iNameHandler;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        ArrayList<ILibraryModel.FunctionModel> arrayList = new ArrayList<ILibraryModel.FunctionModel>();
        arrayList.add(new ILibraryModel.FunctionModel("sqrt", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleSqrt(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("sqrtf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleSqrt(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("sqrtl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleSqrt(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        IdentifierExpression identifierExpression = BitvectorTranslation.SmtRoundingMode.RTZ.getBoogieIdentifierExpression();
        IdentifierExpression identifierExpression2 = BitvectorTranslation.SmtRoundingMode.RTN.getBoogieIdentifierExpression();
        IdentifierExpression identifierExpression3 = BitvectorTranslation.SmtRoundingMode.RTP.getBoogieIdentifierExpression();
        IdentifierExpression identifierExpression4 = BitvectorTranslation.SmtRoundingMode.RNA.getBoogieIdentifierExpression();
        arrayList.add(new ILibraryModel.FunctionModel("trunc", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$3((Expression)identifierExpression, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("truncf", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$4((Expression)identifierExpression, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("truncl", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$5((Expression)identifierExpression, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("floor", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$6((Expression)identifierExpression2, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("floorf", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$7((Expression)identifierExpression2, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("floorl", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$8((Expression)identifierExpression2, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("ceil", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$9((Expression)identifierExpression3, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("ceilf", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$10((Expression)identifierExpression3, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("ceill", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$11((Expression)identifierExpression3, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("round", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$12((Expression)identifierExpression4, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("roundf", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$13((Expression)identifierExpression4, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("roundl", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$14((Expression)identifierExpression4, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("lround", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$15((Expression)identifierExpression4, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("lroundf", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$16((Expression)identifierExpression4, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("lroundl", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$17((Expression)identifierExpression4, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("llround", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$18((Expression)identifierExpression4, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("llroundf", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$19((Expression)identifierExpression4, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("llroundl", (arg_0, arg_1, arg_2, arg_3) -> this.lambda$20((Expression)identifierExpression4, arg_0, arg_1, arg_2, arg_3)));
        arrayList.add(new ILibraryModel.FunctionModel("rint", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE), this.mExpressionTranslation.getCurrentRoundingMode())));
        arrayList.add(new ILibraryModel.FunctionModel("rintf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT), this.mExpressionTranslation.getCurrentRoundingMode())));
        arrayList.add(new ILibraryModel.FunctionModel("rintl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE), this.mExpressionTranslation.getCurrentRoundingMode())));
        arrayList.add(new ILibraryModel.FunctionModel("lrint", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRoundWithIntConversion(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE), new CPrimitive(CPrimitive.CPrimitives.LONG), this.mExpressionTranslation.getCurrentRoundingMode())));
        arrayList.add(new ILibraryModel.FunctionModel("lrintf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRoundWithIntConversion(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT), new CPrimitive(CPrimitive.CPrimitives.LONG), this.mExpressionTranslation.getCurrentRoundingMode())));
        arrayList.add(new ILibraryModel.FunctionModel("lrintl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRoundWithIntConversion(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE), new CPrimitive(CPrimitive.CPrimitives.LONG), this.mExpressionTranslation.getCurrentRoundingMode())));
        arrayList.add(new ILibraryModel.FunctionModel("llrint", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRoundWithIntConversion(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE), new CPrimitive(CPrimitive.CPrimitives.LONGLONG), this.mExpressionTranslation.getCurrentRoundingMode())));
        arrayList.add(new ILibraryModel.FunctionModel("llrintf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRoundWithIntConversion(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT), new CPrimitive(CPrimitive.CPrimitives.LONGLONG), this.mExpressionTranslation.getCurrentRoundingMode())));
        arrayList.add(new ILibraryModel.FunctionModel("llrintl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRoundWithIntConversion(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE), new CPrimitive(CPrimitive.CPrimitives.LONGLONG), this.mExpressionTranslation.getCurrentRoundingMode())));
        arrayList.add(new ILibraryModel.FunctionModel("nearbyint", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE), this.mExpressionTranslation.getCurrentRoundingMode())));
        arrayList.add(new ILibraryModel.FunctionModel("nearbyintf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT), this.mExpressionTranslation.getCurrentRoundingMode())));
        arrayList.add(new ILibraryModel.FunctionModel("nearbyintl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE), this.mExpressionTranslation.getCurrentRoundingMode())));
        arrayList.add(new ILibraryModel.FunctionModel("fabs", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFabs(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("fabsf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFabs(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("fabsl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFabs(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("isnan", this::handleIsNan));
        arrayList.add(new ILibraryModel.FunctionModel("__isnan", this::handleIsNan));
        arrayList.add(new ILibraryModel.FunctionModel("isnanf", this::handleIsNan));
        arrayList.add(new ILibraryModel.FunctionModel("isnanl", this::handleIsNan));
        arrayList.add(new ILibraryModel.FunctionModel("__isnanf", this::handleIsNan));
        arrayList.add(new ILibraryModel.FunctionModel("__isnanl", this::handleIsNan));
        arrayList.add(new ILibraryModel.FunctionModel("isinf", this::handleIsInf));
        arrayList.add(new ILibraryModel.FunctionModel("__isinf", this::handleIsInf));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_isinf_sign", this::handleIsInfSign));
        arrayList.add(new ILibraryModel.FunctionModel("isinff", this::handleIsInf));
        arrayList.add(new ILibraryModel.FunctionModel("isinfl", this::handleIsInf));
        arrayList.add(new ILibraryModel.FunctionModel("__isinff", this::handleIsInf));
        arrayList.add(new ILibraryModel.FunctionModel("__isinfl", this::handleIsInf));
        arrayList.add(new ILibraryModel.FunctionModel("isfinite", this::handleIsFinite));
        arrayList.add(new ILibraryModel.FunctionModel("finite", this::handleIsFinite));
        arrayList.add(new ILibraryModel.FunctionModel("finitel", this::handleIsFinite));
        arrayList.add(new ILibraryModel.FunctionModel("__finite", this::handleIsFinite));
        arrayList.add(new ILibraryModel.FunctionModel("__finitef", this::handleIsFinite));
        arrayList.add(new ILibraryModel.FunctionModel("__finitel", this::handleIsFinite));
        arrayList.add(new ILibraryModel.FunctionModel("fpclassify", this::handleFpClassify));
        arrayList.add(new ILibraryModel.FunctionModel("__fpclassify", this::handleFpClassify));
        arrayList.add(new ILibraryModel.FunctionModel("__fpclassifyf", this::handleFpClassify));
        arrayList.add(new ILibraryModel.FunctionModel("__fpclassifyl", this::handleFpClassify));
        arrayList.add(new ILibraryModel.FunctionModel("isnormal", this::handleIsNormal));
        arrayList.add(new ILibraryModel.FunctionModel("signbit", this::handleSignbit));
        arrayList.add(new ILibraryModel.FunctionModel("__signbit", this::handleSignbit));
        arrayList.add(new ILibraryModel.FunctionModel("__signbitl", this::handleSignbit));
        arrayList.add(new ILibraryModel.FunctionModel("__signbitf", this::handleSignbit));
        arrayList.add(new ILibraryModel.FunctionModel("copysign", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleCopysign(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("copysignf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleCopysign(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("copysignl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleCopysign(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("cos", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleCos(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("cosf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleCos(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("cosl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleCos(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("sin", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleSin(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("sinf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleSin(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("sinl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleSin(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("exp", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleExp(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("expf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleExp(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("expl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleExp(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("expm1", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleExpm1(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("expm1f", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleExpm1(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("expm1l", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleExpm1(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("erf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleErf(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("erff", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleErf(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("erfl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleErf(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("tanh", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleTanh(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("tanhf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleTanh(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("tanhl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleTanh(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("log", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleLog(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("logf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleLog(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("logl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleLog(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("fmax", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFmax(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("fmaxf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFmax(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("fmaxl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFmax(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("fmin", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFmin(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("fminf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFmin(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("fminl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFmin(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("fdim", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFdim(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("fdimf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFdim(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("fdiml", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFdim(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("nan", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNan(iLocation, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("nanf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNan(iLocation, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("nanl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNan(iLocation, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_nan", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNan(iLocation, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_nanf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNan(iLocation, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_nanl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNan(iLocation, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_inff", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleInf(iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_huge_val", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleInf(iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_huge_valf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleInf(iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_isgreater", this::handleIsGreater));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_isgreaterequal", this::handleIsGreaterEqual));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_isless", this::handleIsLess));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_islessequal", this::handleIsLessEqual));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_isunordered", this::handleIsUnordered));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_islessgreater", this::handleIsLessGreater));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_isnan", this::handleIsNan));
        arrayList.add(new ILibraryModel.FunctionModel("isgreater", this::handleIsGreater));
        arrayList.add(new ILibraryModel.FunctionModel("isgreaterequal", this::handleIsGreaterEqual));
        arrayList.add(new ILibraryModel.FunctionModel("isless", this::handleIsLess));
        arrayList.add(new ILibraryModel.FunctionModel("islessequal", this::handleIsLessEqual));
        arrayList.add(new ILibraryModel.FunctionModel("isunordered", this::handleIsUnordered));
        arrayList.add(new ILibraryModel.FunctionModel("islessgreater", this::handleIsLessGreater));
        arrayList.add(new ILibraryModel.FunctionModel("remainder", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRemainder(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("remainderf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRemainder(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("remainderl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleRemainder(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("fmod", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFmod(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.FunctionModel("fmodf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFmod(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT))));
        arrayList.add(new ILibraryModel.FunctionModel("fmodl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleFmod(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE))));
        return arrayList;
    }

    @Override
    public Collection<String> getUnsupportedFunctions() {
        return Arrays.asList(UNSUPPORTED_FLOAT_OPERATIONS);
    }

    private ExpressionResult handleNan(ILocation iLocation, CPrimitive cPrimitive) {
        return new ExpressionResult(new RValue(this.mFloatHandler.createNan(iLocation, cPrimitive), cPrimitive));
    }

    private ExpressionResult handleInf(ILocation iLocation) {
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.DOUBLE);
        return new ExpressionResult(new RValue(this.mFloatHandler.createInfinity(iLocation, cPrimitive), cPrimitive));
    }

    private List<ExpressionResult> handleFloatArguments(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, int n, CPrimitive cPrimitive) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, n, string, iASTInitializerClauseArray);
        ArrayList<ExpressionResult> arrayList = new ArrayList<ExpressionResult>();
        IASTInitializerClause[] iASTInitializerClauseArray2 = iASTInitializerClauseArray;
        int n2 = iASTInitializerClauseArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IASTInitializerClause iASTInitializerClause = iASTInitializerClauseArray2[n3];
            ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClause);
            ExpressionResult expressionResult2 = this.mExprResultTransformer.convertIfNecessary(iLocation, expressionResult, cPrimitive);
            arrayList.add(expressionResult2);
            ++n3;
        }
        return arrayList;
    }

    private Result handleIsLess(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleBinaryComparison(iDispatcher, iASTFunctionCallExpression, iLocation, string, 8);
    }

    private Result handleIsLessEqual(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleBinaryComparison(iDispatcher, iASTFunctionCallExpression, iLocation, string, 10);
    }

    private Result handleIsGreater(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleBinaryComparison(iDispatcher, iASTFunctionCallExpression, iLocation, string, 9);
    }

    private Result handleIsGreaterEqual(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleBinaryComparison(iDispatcher, iASTFunctionCallExpression, iLocation, string, 11);
    }

    private Result handleBinaryComparison(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, int n) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        return this.mCEpressionTranslator.handleRelationalOperators(iLocation, n, expressionResult, expressionResult2);
    }

    private Result handleIsUnordered(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        Expression expression = this.mFloatHandler.isNan(iLocation, expressionResult.getLrValue().getValue(), (CPrimitive)expressionResult.getCType());
        Expression expression2 = this.mFloatHandler.isNan(iLocation, expressionResult2.getLrValue().getValue(), (CPrimitive)expressionResult2.getCType());
        Expression expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression, (Expression)expression2);
        RValue rValue = new RValue(expression3, new CPrimitive(CPrimitive.CPrimitives.INT), true);
        ExpressionResult expressionResult3 = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2).setLrValue(rValue).build();
        assert (CTranslationUtil.isAuxVarMapComplete(this.mNameHandler, expressionResult3.getDeclarations(), expressionResult3.getAuxVars()));
        return expressionResult3;
    }

    private Result handleIsLessGreater(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        Pair<ExpressionResult, ExpressionResult> pair = this.mExprResultTransformer.usualArithmeticConversions(iLocation, expressionResult, expressionResult2);
        expressionResult = (ExpressionResult)pair.getFirst();
        expressionResult2 = (ExpressionResult)pair.getSecond();
        ExpressionResult expressionResult3 = this.mCEpressionTranslator.handleRelationalOperators(iLocation, 8, expressionResult, expressionResult2);
        ExpressionResult expressionResult4 = this.mCEpressionTranslator.handleRelationalOperators(iLocation, 9, expressionResult, expressionResult2);
        Expression expression = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expressionResult3.getLrValue().getValue(), (Expression)expressionResult4.getLrValue().getValue());
        RValue rValue = new RValue(expression, new CPrimitive(CPrimitive.CPrimitives.INT), true);
        ExpressionResult expressionResult5 = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult3, expressionResult4).setLrValue(rValue).build();
        assert (CTranslationUtil.isAuxVarMapComplete(this.mNameHandler, expressionResult5.getDeclarations(), expressionResult5.getAuxVars()));
        return expressionResult5;
    }

    private ExpressionResult handleSqrt(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        ExpressionResult expressionResult = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, cPrimitive).getFirst();
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(new RValue(this.mExpressionTranslation.getFloatingPointHandler().sqrt(iLocation, expressionResult.getLrValue().getValue(), cPrimitive), cPrimitive)).build();
    }

    private ExpressionResult handleRound(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive, Expression expression) {
        ExpressionResult expressionResult = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, cPrimitive).getFirst();
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(new RValue(this.mFloatHandler.roundToIntegral(iLocation, expressionResult.getLrValue().getValue(), cPrimitive, expression), cPrimitive)).build();
    }

    private ExpressionResult handleRoundWithIntConversion(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive, CPrimitive cPrimitive2, Expression expression) {
        return this.mExpressionTranslation.convertFloatToInt(iLocation, this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, cPrimitive, expression), cPrimitive2);
    }

    private ExpressionResult handleFabs(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        ExpressionResult expressionResult = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, cPrimitive).getFirst();
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(new RValue(this.mExpressionTranslation.getFloatingPointHandler().abs(iLocation, expressionResult.getLrValue().getValue(), cPrimitive), cPrimitive)).build();
    }

    private ExpressionResult handleIsNan(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(new RValue(this.mFloatHandler.isNan(iLocation, expressionResult.getLrValue().getValue(), (CPrimitive)expressionResult.getCType()), new CPrimitive(CPrimitive.CPrimitives.INT), true)).build();
    }

    private ExpressionResult handleIsInf(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(new RValue(this.mFloatHandler.isInfinite(iLocation, expressionResult.getLrValue().getValue(), (CPrimitive)expressionResult.getCType()), new CPrimitive(CPrimitive.CPrimitives.INT), true)).build();
    }

    private ExpressionResult handleIsInfSign(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        Expression expression = expressionResult.getLrValue().getValue();
        CPrimitive cPrimitive2 = (CPrimitive)expressionResult.getCType();
        Expression expression2 = this.mFloatHandler.isInfinite(iLocation, expression, cPrimitive2);
        Expression expression3 = this.mFloatHandler.isPositive(iLocation, expression, cPrimitive2);
        Expression expression4 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression2, (Expression)ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression3, (Expression)this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ONE), (Expression)this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ONE.negate())), (Expression)this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO));
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(new RValue(expression4, new CPrimitive(CPrimitive.CPrimitives.INT))).build();
    }

    private ExpressionResult handleIsFinite(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        Expression expression = expressionResult.getLrValue().getValue();
        CPrimitive cPrimitive = (CPrimitive)expressionResult.getCType();
        Expression expression2 = ExpressionFactory.or((ILocation)iLocation, (Expression[])new Expression[]{this.mFloatHandler.isNormal(iLocation, expression, cPrimitive), this.mFloatHandler.isSubnormal(iLocation, expression, cPrimitive), this.mFloatHandler.isZero(iLocation, expression, cPrimitive)});
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(new RValue(expression2, new CPrimitive(CPrimitive.CPrimitives.INT), true)).build();
    }

    private ExpressionResult handleFpClassify(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        Expression expression = expressionResult.getLrValue().getValue();
        CPrimitive cPrimitive = (CPrimitive)expressionResult.getCType();
        Expression expression2 = this.mFloatHandler.isInfinite(iLocation, expression, cPrimitive);
        Expression expression3 = this.mFloatHandler.isNan(iLocation, expression, cPrimitive);
        Expression expression4 = this.mFloatHandler.isNormal(iLocation, expression, cPrimitive);
        Expression expression5 = this.mFloatHandler.isSubnormal(iLocation, expression, cPrimitive);
        Expression expression6 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression2, (Expression)Classification.INFINITE.asExpression(iLocation, this.mExpressionTranslation), (Expression)ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression3, (Expression)Classification.NAN.asExpression(iLocation, this.mExpressionTranslation), (Expression)ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression4, (Expression)Classification.NORMAL.asExpression(iLocation, this.mExpressionTranslation), (Expression)ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression5, (Expression)Classification.SUBNORMAL.asExpression(iLocation, this.mExpressionTranslation), (Expression)Classification.ZERO.asExpression(iLocation, this.mExpressionTranslation)))));
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(new RValue(expression6, new CPrimitive(CPrimitive.CPrimitives.INT))).build();
    }

    private ExpressionResult handleIsNormal(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(new RValue(this.mFloatHandler.isNormal(iLocation, expressionResult.getLrValue().getValue(), (CPrimitive)expressionResult.getCType()), new CPrimitive(CPrimitive.CPrimitives.INT), true)).build();
    }

    private ExpressionResult handleCos(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        ExpressionResult expressionResult = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, cPrimitive).getFirst();
        Expression expression = this.mFloatHandler.createNan(iLocation, cPrimitive);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
        Expression expression2 = this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ONE);
        Expression expression3 = this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ONE.negate());
        Expression expression4 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 11, (Expression)auxVarInfo.getExp(), cPrimitive, expression3, cPrimitive);
        Expression expression5 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 10, (Expression)auxVarInfo.getExp(), cPrimitive, expression2, cPrimitive);
        return this.overapproximateUnaryFloatFunction(iLocation, string, expressionResult, auxVarInfo, expression, expression, expression2, List.of(expression4, expression5));
    }

    private ExpressionResult handleSin(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        ExpressionResult expressionResult = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, cPrimitive).getFirst();
        Expression expression = this.mFloatHandler.createNan(iLocation, cPrimitive);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
        Expression expression2 = this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ONE);
        Expression expression3 = this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ONE.negate());
        Expression expression4 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 11, (Expression)auxVarInfo.getExp(), cPrimitive, expression3, cPrimitive);
        Expression expression5 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 10, (Expression)auxVarInfo.getExp(), cPrimitive, expression2, cPrimitive);
        return this.overapproximateUnaryFloatFunction(iLocation, string, expressionResult, auxVarInfo, expression, expression, expressionResult.getLrValue().getValue(), List.of(expression4, expression5));
    }

    private ExpressionResult handleExp(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        ExpressionResult expressionResult = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, cPrimitive).getFirst();
        Expression expression = expressionResult.getLrValue().getValue();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
        Expression expression2 = this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ONE);
        Expression expression3 = this.mFloatHandler.isPositive(iLocation, (Expression)auxVarInfo.getExp(), cPrimitive);
        Expression expression4 = ExpressionFactory.or((ILocation)iLocation, (Expression[])new Expression[]{this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 11, expression, cPrimitive, this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ZERO), cPrimitive), this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 8, (Expression)auxVarInfo.getExp(), cPrimitive, expression2, cPrimitive)});
        Expression expression5 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 11, (Expression)auxVarInfo.getExp(), cPrimitive, this.mExpressionTranslation.constructArithmeticExpression(iLocation, 4, expression, cPrimitive, expression2, cPrimitive), cPrimitive);
        return this.overapproximateUnaryFloatFunction(iLocation, string, expressionResult, auxVarInfo, this.mFloatHandler.createPlusZero(iLocation, cPrimitive), expression, expression2, List.of(expression3, expression4, expression5));
    }

    private ExpressionResult handleExpm1(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        ExpressionResult expressionResult = this.handleExp(iDispatcher, iASTFunctionCallExpression, iLocation, string, cPrimitive);
        Expression expression = this.mExpressionTranslation.constructArithmeticExpression(iLocation, 5, expressionResult.getLrValue().getValue(), cPrimitive, this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ONE), cPrimitive);
        return new ExpressionResultBuilder(expressionResult).resetLrValue(new RValue(expression, cPrimitive)).build();
    }

    private ExpressionResult handleErf(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        ExpressionResult expressionResult = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, cPrimitive).getFirst();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
        Expression expression = this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ONE);
        Expression expression2 = this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ONE.negate());
        Expression expression3 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 11, (Expression)auxVarInfo.getExp(), cPrimitive, expression2, cPrimitive);
        Expression expression4 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 10, (Expression)auxVarInfo.getExp(), cPrimitive, expression, cPrimitive);
        return this.overapproximateUnaryFloatFunction(iLocation, string, expressionResult, auxVarInfo, expression2, expression, expressionResult.getLrValue().getValue(), List.of(expression3, expression4));
    }

    private ExpressionResult handleTanh(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        ExpressionResult expressionResult = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, cPrimitive).getFirst();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
        Expression expression = this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ONE);
        Expression expression2 = this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ONE.negate());
        Expression expression3 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 11, (Expression)auxVarInfo.getExp(), cPrimitive, expression2, cPrimitive);
        Expression expression4 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 10, (Expression)auxVarInfo.getExp(), cPrimitive, expression, cPrimitive);
        return this.overapproximateUnaryFloatFunction(iLocation, string, expressionResult, auxVarInfo, expression2, expression, expressionResult.getLrValue().getValue(), List.of(expression3, expression4));
    }

    private ExpressionResult handleLog(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        ExpressionResult expressionResult = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, cPrimitive).getFirst();
        Expression expression = expressionResult.getLrValue().getValue();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
        Expression expression2 = this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ONE);
        Expression expression3 = ExpressionFactory.or((ILocation)iLocation, (Expression[])new Expression[]{this.mFloatHandler.isPositive(iLocation, expression, cPrimitive), this.mFloatHandler.isNan(iLocation, (Expression)auxVarInfo.getExp(), cPrimitive)});
        Expression expression4 = ExpressionFactory.or((ILocation)iLocation, (Expression[])new Expression[]{this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 29, expression, cPrimitive, expression2, cPrimitive), this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 28, (Expression)auxVarInfo.getExp(), cPrimitive, this.mFloatHandler.createPlusZero(iLocation, cPrimitive), cPrimitive)});
        Expression expression5 = ExpressionFactory.or((ILocation)iLocation, (Expression[])new Expression[]{this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 10, expression, cPrimitive, expression2, cPrimitive), this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 9, (Expression)auxVarInfo.getExp(), cPrimitive, this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ZERO), cPrimitive)});
        Expression expression6 = ExpressionFactory.or((ILocation)iLocation, (Expression[])new Expression[]{ExpressionFactory.not((ILocation)iLocation, (Expression)this.mFloatHandler.isPositive(iLocation, expression, cPrimitive)), this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 10, (Expression)auxVarInfo.getExp(), cPrimitive, this.mExpressionTranslation.constructArithmeticExpression(iLocation, 5, expression, cPrimitive, expression2, cPrimitive), cPrimitive)});
        return this.overapproximateUnaryFloatFunction(iLocation, string, expressionResult, auxVarInfo, this.mFloatHandler.createNan(iLocation, cPrimitive), expression, this.mFloatHandler.createMinusInfinity(iLocation, cPrimitive), List.of(expression3, expression4, expression5, expression6));
    }

    private ExpressionResult overapproximateUnaryFloatFunction(ILocation iLocation, String string, ExpressionResult expressionResult, AuxVarInfo auxVarInfo, Expression expression, Expression expression2, Expression expression3, List<Expression> list) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        IdentifierExpression identifierExpression = auxVarInfo.getExp();
        CPrimitive cPrimitive = (CPrimitive)expressionResult.getCType();
        Expression expression4 = expressionResult.getLrValue().getValue();
        expressionResultBuilder.setLrValue(new RValue((Expression)identifierExpression, cPrimitive));
        VariableLHS variableLHS = auxVarInfo.getLhs();
        HavocStatement havocStatement = new HavocStatement(iLocation, new VariableLHS[]{variableLHS});
        AssumeStatement assumeStatement = new AssumeStatement(iLocation, ExpressionFactory.and((ILocation)iLocation, list));
        AtomicStatement atomicStatement = new AtomicStatement(iLocation, new Statement[]{havocStatement, assumeStatement});
        new OverapproxVariable(string, iLocation).annotate((IElement)atomicStatement);
        Expression expression5 = this.mFloatHandler.isZero(iLocation, expression4, cPrimitive);
        Expression expression6 = this.mFloatHandler.isNan(iLocation, expression4, cPrimitive);
        Expression expression7 = this.mFloatHandler.isInfinite(iLocation, expression4, cPrimitive);
        Expression expression8 = this.mFloatHandler.isPositive(iLocation, expression4, cPrimitive);
        Statement statement = StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)expression5, List.of(StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)variableLHS, (Expression)expression3)), List.of(StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)expression6, List.of(StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)variableLHS, (Expression)expression4)), List.of(StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)expression7, List.of(StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)variableLHS, (Expression)ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression8, (Expression)expression2, (Expression)expression))), List.of(atomicStatement))))));
        return expressionResultBuilder.addStatement(statement).build();
    }

    private ExpressionResult handleFmin(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        List<ExpressionResult> list = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, cPrimitive);
        return new ExpressionResultBuilder().addAllExceptLrValue(list).setLrValue(new RValue(this.mFloatHandler.min(iLocation, list.get(0).getLrValue().getValue(), list.get(1).getLrValue().getValue(), cPrimitive), cPrimitive)).build();
    }

    private ExpressionResult handleFmax(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        List<ExpressionResult> list = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, cPrimitive);
        return new ExpressionResultBuilder().addAllExceptLrValue(list).setLrValue(new RValue(this.mFloatHandler.max(iLocation, list.get(0).getLrValue().getValue(), list.get(1).getLrValue().getValue(), cPrimitive), cPrimitive)).build();
    }

    private ExpressionResult handleFdim(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        List<ExpressionResult> list = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, cPrimitive);
        Expression expression = list.get(0).getLrValue().getValue();
        Expression expression2 = list.get(1).getLrValue().getValue();
        Expression expression3 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 9, expression, cPrimitive, expression2, cPrimitive);
        Expression expression4 = this.mExpressionTranslation.constructArithmeticExpression(iLocation, 5, expression, cPrimitive, expression2, cPrimitive);
        Expression expression5 = this.mExpressionTranslation.constructLiteralForFloatingType(iLocation, cPrimitive, BigDecimal.ZERO);
        Expression expression6 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression3, (Expression)expression4, (Expression)expression5);
        Expression expression7 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)this.mFloatHandler.isNan(iLocation, expression2, cPrimitive), (Expression)expression2, (Expression)expression6);
        Expression expression8 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)this.mFloatHandler.isNan(iLocation, expression, cPrimitive), (Expression)expression, (Expression)expression7);
        return new ExpressionResultBuilder().addAllExceptLrValue(list).setLrValue(new RValue(expression8, cPrimitive)).build();
    }

    private ExpressionResult handleSignbit(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        Expression expression = expressionResult.getLrValue().getValue();
        CPrimitive cPrimitive2 = (CPrimitive)expressionResult.getCType();
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult);
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        HavocStatement havocStatement = new HavocStatement(iLocation, new VariableLHS[]{auxVarInfo.getLhs()});
        new OverapproxVariable("sign of NaN", iLocation).annotate((IElement)havocStatement);
        Expression expression2 = this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO);
        expressionResultBuilder.addStatement(StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)this.mFloatHandler.isNan(iLocation, expression, cPrimitive2), List.of(havocStatement), List.of(StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)this.mFloatHandler.isPositive(iLocation, expression, cPrimitive2), List.of(StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)auxVarInfo.getLhs(), (Expression)expression2)), List.of(new AssumeStatement(iLocation, ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPNEQ, (Expression)auxVarInfo.getExp(), (Expression)expression2)))))));
        return expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), cPrimitive)).build();
    }

    private ExpressionResult handleCopysign(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        List<ExpressionResult> list = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, cPrimitive);
        Expression expression = list.get(0).getLrValue().getValue();
        Expression expression2 = list.get(1).getLrValue().getValue();
        return new ExpressionResultBuilder().addAllExceptLrValue(list).addAllIncludingLrValue(this.handleCopysign(expression, expression2, iLocation, cPrimitive)).build();
    }

    private ExpressionResult handleCopysign(Expression expression, Expression expression2, ILocation iLocation, CPrimitive cPrimitive) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive, SFO.AUXVAR.RETURNED);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        Expression expression3 = this.mFloatHandler.abs(iLocation, expression, cPrimitive);
        AssumeStatement assumeStatement = new AssumeStatement(iLocation, ExpressionFactory.or((ILocation)iLocation, (Expression[])new Expression[]{this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 28, (Expression)auxVarInfo.getExp(), cPrimitive, expression, cPrimitive), this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 28, (Expression)auxVarInfo.getExp(), cPrimitive, this.mExpressionTranslation.constructUnaryExpression(iLocation, 3, expression, cPrimitive), cPrimitive)}));
        new OverapproxVariable("sign of NaN", iLocation).annotate((IElement)assumeStatement);
        expressionResultBuilder.addStatement(StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)this.mFloatHandler.isNan(iLocation, expression, cPrimitive), List.of(StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)auxVarInfo.getLhs(), (Expression)expression)), List.of(StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)this.mFloatHandler.isNan(iLocation, expression2, cPrimitive), List.of(assumeStatement), List.of(StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)auxVarInfo.getLhs(), (Expression)ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)this.mFloatHandler.isPositive(iLocation, expression2, cPrimitive), (Expression)expression3, (Expression)this.mExpressionTranslation.constructUnaryExpression(iLocation, 3, expression3, cPrimitive))))))));
        return expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), cPrimitive)).build();
    }

    private ExpressionResult handleRemainder(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        List<ExpressionResult> list = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, cPrimitive);
        Expression expression = list.get(0).getLrValue().getValue();
        Expression expression2 = list.get(1).getLrValue().getValue();
        return new ExpressionResultBuilder().addAllExceptLrValue(list).setLrValue(new RValue(this.mFloatHandler.remainder(iLocation, expression, expression2, cPrimitive), cPrimitive)).build();
    }

    private ExpressionResult handleFmod(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, CPrimitive cPrimitive) {
        List<ExpressionResult> list = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, cPrimitive);
        Expression expression = list.get(0).getLrValue().getValue();
        Expression expression2 = list.get(1).getLrValue().getValue();
        Expression expression3 = this.mFloatHandler.remainder(iLocation, this.mFloatHandler.abs(iLocation, expression, cPrimitive), this.mFloatHandler.abs(iLocation, expression2, cPrimitive), cPrimitive);
        Expression expression4 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)this.mFloatHandler.isPositive(iLocation, expression3, cPrimitive), (Expression)expression3, (Expression)this.mExpressionTranslation.constructArithmeticExpression(iLocation, 4, expression3, cPrimitive, this.mFloatHandler.abs(iLocation, expression2, cPrimitive), cPrimitive));
        return new ExpressionResultBuilder().addAllExceptLrValue(list).addAllIncludingLrValue(this.handleCopysign(expression4, expression, iLocation, cPrimitive)).build();
    }

    @Override
    public Collection<ILibraryModel.TypeModel> getTypeModels() {
        return List.of(new ILibraryModel.TypeModel("float_t", new CPrimitive(CPrimitive.CPrimitives.FLOAT)), new ILibraryModel.TypeModel("double_t", new CPrimitive(CPrimitive.CPrimitives.DOUBLE)));
    }

    @Override
    public Collection<ILibraryModel.ConstantModel> getConstantModels() {
        ArrayList<ILibraryModel.ConstantModel> arrayList = new ArrayList<ILibraryModel.ConstantModel>();
        arrayList.add(new ILibraryModel.ConstantModel("NAN", iLocation -> this.handleNan(iLocation, new CPrimitive(CPrimitive.CPrimitives.DOUBLE))));
        arrayList.add(new ILibraryModel.ConstantModel("INFINITY", iLocation -> this.handleInf(iLocation)));
        arrayList.add(new ILibraryModel.ConstantModel("inf", iLocation -> this.handleInf(iLocation)));
        Classification[] classificationArray = Classification.values();
        int n = classificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Classification classification = classificationArray[n2];
            arrayList.add(new ILibraryModel.ConstantModel(classification.getName(), iLocation -> new ExpressionResult(new RValue(classification.asExpression(iLocation, this.mExpressionTranslation), new CPrimitive(CPrimitive.CPrimitives.INT)))));
            ++n2;
        }
        return arrayList;
    }

    private /* synthetic */ Result lambda$3(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE), expression);
    }

    private /* synthetic */ Result lambda$4(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT), expression);
    }

    private /* synthetic */ Result lambda$5(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE), expression);
    }

    private /* synthetic */ Result lambda$6(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE), expression);
    }

    private /* synthetic */ Result lambda$7(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT), expression);
    }

    private /* synthetic */ Result lambda$8(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE), expression);
    }

    private /* synthetic */ Result lambda$9(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE), expression);
    }

    private /* synthetic */ Result lambda$10(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT), expression);
    }

    private /* synthetic */ Result lambda$11(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE), expression);
    }

    private /* synthetic */ Result lambda$12(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE), expression);
    }

    private /* synthetic */ Result lambda$13(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT), expression);
    }

    private /* synthetic */ Result lambda$14(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRound(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE), expression);
    }

    private /* synthetic */ Result lambda$15(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRoundWithIntConversion(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE), new CPrimitive(CPrimitive.CPrimitives.LONG), expression);
    }

    private /* synthetic */ Result lambda$16(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRoundWithIntConversion(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT), new CPrimitive(CPrimitive.CPrimitives.LONG), expression);
    }

    private /* synthetic */ Result lambda$17(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRoundWithIntConversion(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE), new CPrimitive(CPrimitive.CPrimitives.LONG), expression);
    }

    private /* synthetic */ Result lambda$18(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRoundWithIntConversion(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.DOUBLE), new CPrimitive(CPrimitive.CPrimitives.LONGLONG), expression);
    }

    private /* synthetic */ Result lambda$19(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRoundWithIntConversion(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.FLOAT), new CPrimitive(CPrimitive.CPrimitives.LONGLONG), expression);
    }

    private /* synthetic */ Result lambda$20(Expression expression, IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleRoundWithIntConversion(iDispatcher, iASTFunctionCallExpression, iLocation, string, new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE), new CPrimitive(CPrimitive.CPrimitives.LONGLONG), expression);
    }

    private static enum Classification {
        NAN("FP_NAN", 0),
        INFINITE("FP_INFINITE", 1),
        ZERO("FP_ZERO", 2),
        SUBNORMAL("FP_SUBNORMAL", 3),
        NORMAL("FP_NORMAL", 4);

        private final String mName;
        private final int mValue;

        private Classification(String string2, int n2) {
            this.mName = string2;
            this.mValue = n2;
        }

        public String getName() {
            return this.mName;
        }

        public Expression asExpression(ILocation iLocation, ExpressionTranslation expressionTranslation) {
            return expressionTranslation.constructLiteralForIntegerType(iLocation, new CPrimitive(CPrimitive.CPrimitives.INT), BigInteger.valueOf(this.mValue));
        }
    }
}

