/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DfsBookkeeping<V> {
    private final List<V> mStack = new ArrayList<V>();
    private final Map<V, Pair<Integer, V>> mVisited2LoopHeadIndex = new HashMap<V, Pair<Integer, V>>();

    public boolean isVisited(V v) {
        return this.mVisited2LoopHeadIndex.containsKey(v);
    }

    public boolean hasStarted() {
        return !this.mVisited2LoopHeadIndex.isEmpty();
    }

    public boolean isStackEmpty() {
        return this.mStack.isEmpty();
    }

    public int stackIndexOf(V v) {
        return this.mStack.indexOf(v);
    }

    public boolean push(V v) {
        boolean bl = this.isVisited(v);
        if (!bl) {
            this.mVisited2LoopHeadIndex.put(v, null);
        }
        assert (!this.mStack.contains(v)) : "must not infinitely unroll loop";
        this.mStack.add(v);
        return !bl;
    }

    public V peek() {
        return this.mStack.get(this.mStack.size() - 1);
    }

    private V pop() {
        return this.mStack.remove(this.mStack.size() - 1);
    }

    public boolean backtrack() {
        V v = this.pop();
        assert (this.isVisited(v)) : "stack node must have been visited";
        Pair<Integer, V> pair = this.mVisited2LoopHeadIndex.get(v);
        if (pair != null && pair.getSecond() == v) {
            this.mVisited2LoopHeadIndex.put(v, null);
            pair = null;
        }
        if (pair != null) {
            assert (!this.mStack.isEmpty()) : "Initial node must not be in a loop (except as loop head)";
            assert (this.validLoopHead(pair)) : "Backtracked node's loop head must be higher on the stack";
            this.updateLoopHead(this.peek(), pair);
        }
        return pair == null;
    }

    public void updateLoopHead(V v, Pair<Integer, V> pair) {
        assert (this.mStack.contains(v)) : "loop head can only be updated for stack nodes";
        assert (this.isVisited(v)) : "loop head can only be updated for visited nodes";
        assert (this.validLoopHead(pair)) : "new loop head is invalid";
        Pair<Integer, V> pair2 = this.mVisited2LoopHeadIndex.get(v);
        assert (pair2 == null || this.validLoopHead(pair2)) : "old loop head has become invalid";
        if (pair2 == null || pair.getFirst() < pair2.getFirst()) {
            this.mVisited2LoopHeadIndex.put((Pair<Integer, V>)v, (Pair<Integer, Pair<Integer, V>>)pair);
        }
    }

    public void backPropagateLoopHead(V v, V v2) {
        Pair<Integer, V> pair = this.getStackedLoopHead(v2);
        if (pair != null) {
            this.updateLoopHead(v, pair);
        }
    }

    private Pair<Integer, V> getStackedLoopHead(V v) {
        int n = Integer.MAX_VALUE;
        V v2 = v;
        while (true) {
            assert (n >= 0) : "negative loop head index";
            assert (this.isVisited(v2)) : "encountered unvisited node in loop head chain";
            Pair<Integer, V> pair = this.mVisited2LoopHeadIndex.get(v2);
            if (pair == null || this.validLoopHead(pair)) {
                return pair;
            }
            V v3 = pair.getSecond();
            if (v3 == v2) {
                return null;
            }
            assert (pair.getFirst() < n) : "loop head index must decrease";
            n = pair.getFirst();
            v2 = v3;
        }
    }

    private boolean validLoopHead(Pair<Integer, V> pair) {
        return pair.getFirst() < this.mStack.size() && this.mStack.get(pair.getFirst()) == pair.getSecond();
    }
}

