/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import java.math.BigInteger;

public class BigIntegerOption
extends Option {
    private BigInteger mValue;
    private BigInteger mDefaultValue;

    public BigIntegerOption(BigInteger bigInteger, boolean bl, String string) {
        super(bl, string);
        this.mValue = this.mDefaultValue = bigInteger;
    }

    BigIntegerOption(BigIntegerOption bigIntegerOption) {
        super(bigIntegerOption.isOnlineModifiable(), bigIntegerOption.getDescription());
        this.mValue = bigIntegerOption.mValue;
        this.mDefaultValue = bigIntegerOption.mDefaultValue;
    }

    @Override
    public Option copy() {
        return new BigIntegerOption(this);
    }

    @Override
    public void set(Object object) {
        if (object instanceof BigInteger) {
            this.mValue = (BigInteger)object;
        } else if (object instanceof String) {
            try {
                this.mValue = new BigInteger((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SMTLIBException(numberFormatException.getMessage());
            }
        } else {
            throw new SMTLIBException("Not a number: " + String.valueOf(object));
        }
    }

    public final BigInteger getValue() {
        return this.mValue;
    }

    @Override
    public Object get() {
        return this.mValue;
    }

    @Override
    public void reset() {
        this.mValue = this.mDefaultValue;
    }

    @Override
    public Object defaultValue() {
        return this.mDefaultValue;
    }

    @Override
    public void started() {
        this.mDefaultValue = this.mValue;
    }
}

