/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Monomial;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.ArithmeticUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.SparseMapBuilder;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class PolynomialTermUtils {
    private PolynomialTermUtils() {
    }

    public static Rational bringBitvectorValueInRange(Rational rational, Sort sort) {
        assert (SmtSortUtils.isBitvecSort(sort));
        int n = SmtSortUtils.getBitvectorLength(sort);
        BigInteger bigInteger = rational.numerator();
        BigInteger bigInteger2 = BigInteger.valueOf(2L).pow(n);
        BigInteger bigInteger3 = ArithmeticUtils.euclideanMod((BigInteger)bigInteger, (BigInteger)bigInteger2);
        return Rational.valueOf((BigInteger)bigInteger3, (BigInteger)BigInteger.ONE);
    }

    public static Rational bringValueInRange(Rational rational, Sort sort) {
        if (SmtSortUtils.isBitvecSort(sort)) {
            return PolynomialTermUtils.bringBitvectorValueInRange(rational, sort);
        }
        return rational;
    }

    public static boolean isAffineMap(Map<Monomial, Rational> map) {
        for (Map.Entry<Monomial, Rational> entry : map.entrySet()) {
            if (entry.getKey().isLinear()) continue;
            return false;
        }
        return true;
    }

    public static Map<Term, Rational> convertToAffineMap(Map<Monomial, Rational> map) {
        SparseMapBuilder sparseMapBuilder = new SparseMapBuilder();
        for (Map.Entry<Monomial, Rational> entry : map.entrySet()) {
            Map<Term, Rational> map2 = entry.getKey().getVariable2Exponent();
            assert (map2.size() == 1) : "Cannot convert to AffineMap.";
            Term term = map2.keySet().iterator().next();
            sparseMapBuilder.put((Object)term, (Object)entry.getValue());
        }
        return sparseMapBuilder.getBuiltMap();
    }

    static <T extends AbstractGeneralizedAffineTerm<?>, MNL> T constructSum(Function<IPolynomialTerm, Map<MNL, Rational>> function, GeneralizedConstructor<MNL, T> generalizedConstructor, IPolynomialTerm ... iPolynomialTermArray) {
        Sort sort = iPolynomialTermArray[0].getSort();
        HashMap<MNL, Rational> hashMap = new HashMap<MNL, Rational>();
        Rational rational = Rational.ZERO;
        IPolynomialTerm[] iPolynomialTermArray2 = iPolynomialTermArray;
        int n = iPolynomialTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPolynomialTerm iPolynomialTerm = iPolynomialTermArray2[n2];
            for (Map.Entry<MNL, Rational> entry : function.apply(iPolynomialTerm).entrySet()) {
                Rational rational2 = (Rational)hashMap.get(entry.getKey());
                if (rational2 == null) {
                    hashMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                Rational rational3 = PolynomialTermUtils.bringValueInRange(rational2.add(entry.getValue()), sort);
                if (rational3.equals((Object)Rational.ZERO)) {
                    hashMap.remove(entry.getKey());
                    continue;
                }
                hashMap.put(entry.getKey(), rational3);
            }
            rational = PolynomialTermUtils.bringValueInRange(rational.add(iPolynomialTerm.getConstant()), sort);
            ++n2;
        }
        return (T)((AbstractGeneralizedAffineTerm)generalizedConstructor.apply(sort, rational, hashMap));
    }

    static <T extends IPolynomialTerm, MNL> T constructMul(Function<IPolynomialTerm, Map<MNL, Rational>> function, GeneralizedConstructor<MNL, T> generalizedConstructor, IPolynomialTerm iPolynomialTerm, Rational rational) {
        Map<Object, Object> map;
        Rational rational2;
        Sort sort;
        if (rational.equals((Object)Rational.ZERO)) {
            sort = iPolynomialTerm.getSort();
            rational2 = Rational.ZERO;
            map = Collections.emptyMap();
        } else if (rational.equals((Object)Rational.ONE)) {
            sort = iPolynomialTerm.getSort();
            rational2 = iPolynomialTerm.getConstant();
            map = function.apply(iPolynomialTerm);
        } else {
            map = new HashMap();
            sort = iPolynomialTerm.getSort();
            rational2 = PolynomialTermUtils.bringValueInRange(iPolynomialTerm.getConstant().mul(rational), sort);
            for (Map.Entry<MNL, Rational> entry : function.apply(iPolynomialTerm).entrySet()) {
                Rational rational3 = PolynomialTermUtils.bringValueInRange(entry.getValue().mul(rational), sort);
                map.put(entry.getKey(), rational3);
            }
        }
        return (T)((IPolynomialTerm)generalizedConstructor.apply(sort, rational2, map));
    }

    public static Rational divInvertible(Sort sort, Rational rational, Rational rational2) {
        Object object;
        if (rational2.equals((Object)Rational.ZERO)) {
            object = null;
        } else if (SmtSortUtils.isRealSort(sort)) {
            Rational rational3;
            object = rational3 = rational.div(rational2);
        } else if (SmtSortUtils.isIntSort(sort)) {
            Rational rational4 = rational.div(rational2);
            object = rational4.isIntegral() ? rational4 : null;
        } else if (SmtSortUtils.isBitvecSort(sort)) {
            object = rational2.equals((Object)Rational.ONE) || SmtUtils.isBvMinusOneButNotOne(rational2, sort) ? PolynomialTermUtils.bringBitvectorValueInRange(rational.mul(rational2), sort) : null;
        } else {
            throw new AssertionError((Object)"unsupported sort");
        }
        return object;
    }

    @FunctionalInterface
    public static interface GeneralizedConstructor<V, T> {
        public T apply(Sort var1, Rational var2, Map<V, Rational> var3);
    }

    @FunctionalInterface
    public static interface TriFunction<T, U, R, S> {
        public S apply(T var1, U var2, R var3);
    }
}

