/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonCoreBooleanSubTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class PrenexNormalForm
extends TermTransformer {
    private final Script mScript;
    private final ManagedScript mMgdScript;

    public PrenexNormalForm(ManagedScript managedScript) {
        this.mScript = managedScript.getScript();
        this.mMgdScript = managedScript;
    }

    protected void convert(Term term) {
        ApplicationTerm applicationTerm;
        String string;
        if (term instanceof ApplicationTerm && (string = (applicationTerm = (ApplicationTerm)term).getFunction().getName()).equals("ite")) {
            if (QuantifierUtils.isQuantifierFree((Term)applicationTerm)) {
                this.setResult((Term)applicationTerm);
                return;
            }
            throw new UnsupportedOperationException("ite Term with quantifier, use IteRemover first");
        }
        super.convert(term);
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        if (!NonCoreBooleanSubTermTransformer.isCoreBooleanNonAtom(applicationTerm)) {
            super.convertApplicationTerm(applicationTerm, termArray);
        } else {
            String string = applicationTerm.getFunction().getName();
            if (string.equals("not")) {
                Term term2 = this.pullQuantifiersNot(termArray);
                this.setResult(term2);
            } else if (string.equals("and")) {
                Term term3 = this.pullQuantifiers(applicationTerm, termArray);
                this.setResult(term3);
            } else if (string.equals("or")) {
                Term term4 = this.pullQuantifiers(applicationTerm, termArray);
                this.setResult(term4);
            } else if (string.equals("=") || string.equals("=>") || string.equals("xor") || string.equals("distinct") || string.equals("ite")) {
                if (Arrays.stream(termArray).anyMatch(term -> term instanceof QuantifiedFormula)) {
                    throw new UnsupportedOperationException("not yet implemented, we need subterm in NNF");
                }
                super.convertApplicationTerm(applicationTerm, termArray);
            } else {
                throw new AssertionError((Object)"unknown core boolean term");
            }
        }
    }

    private Term pullQuantifiersNot(Term[] termArray) {
        assert (termArray.length == 1) : "no not";
        Term term = termArray[0];
        QuantifierSequence quantifierSequence = new QuantifierSequence(this.mMgdScript, term);
        Term term2 = quantifierSequence.getInnerTerm();
        List<QuantifierSequence.QuantifiedVariables> list = quantifierSequence.getQuantifierBlocks();
        Term term3 = SmtUtils.not(this.mScript, term2);
        int n = list.size() - 1;
        while (n >= 0) {
            QuantifierSequence.QuantifiedVariables quantifiedVariables = list.get(n);
            int n2 = (quantifiedVariables.getQuantifier() + 1) % 2;
            term3 = SmtUtils.quantifier(this.mScript, n2, quantifiedVariables.getVariables(), term3);
            --n;
        }
        return term3;
    }

    private Term pullQuantifiers(ApplicationTerm applicationTerm, Term[] termArray) {
        QuantifierSequence[] quantifierSequenceArray = new QuantifierSequence[termArray.length];
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        int n = 0;
        while (n < termArray.length) {
            hashSet.addAll(Arrays.asList(termArray[n].getFreeVars()));
            quantifierSequenceArray[n] = new QuantifierSequence(this.mMgdScript, termArray[n]);
            ++n;
        }
        Term term = QuantifierSequence.mergeQuantifierSequences(this.mMgdScript, applicationTerm.getFunction().getName(), quantifierSequenceArray, hashSet);
        return term;
    }

    public void postConvertLet(LetTerm letTerm, Term[] termArray, Term term) {
        throw new UnsupportedOperationException("not yet implemented, we need term without let");
    }

    public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
        if (SmtUtils.isQuantifiedFormulaWithSameQuantifier(quantifiedFormula.getQuantifier(), term) != null) {
            Term term2 = SmtUtils.quantifier(this.mScript, quantifiedFormula.getQuantifier(), new HashSet<TermVariable>(Arrays.asList(quantifiedFormula.getVariables())), term);
            this.setResult(term2);
        } else {
            super.postConvertQuantifier(quantifiedFormula, term);
        }
    }

    public void postConvertAnnotation(AnnotatedTerm annotatedTerm, Annotation[] annotationArray, Term term) {
        this.setResult(term);
    }
}

