/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.source.smtparser.chc;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.ChcCategoryInfo;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornAnnot;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClauseAST;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.HistoryRecordingScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.CnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.SkolemNormalForm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.INonSolverScript;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.source.smtparser.Activator;
import de.uni_freiburg.informatik.ultimate.source.smtparser.chc.HornClauseHead;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class HornClauseParserScript
extends HistoryRecordingScript
implements INonSolverScript {
    private final String M_COMPLEX_TERM = "sbcnst";
    private final String M_REPEATING_VARS = "sbrptng";
    private final ManagedScript mBackendSmtSolver;
    private final Logics mLogic;
    private final HashSet<String> mDeclaredPredicateSymbols;
    private final List<HornClause> mParsedHornClauses;
    private final HcSymbolTable mSymbolTable;
    private final String mFilename;
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mManagedScript;
    private final ILogger mLogger;
    private final boolean mDoSolverBasedSanityChecks = false;
    private boolean mSawCheckSat = false;
    private boolean mFinished;
    private final Deque<Triple<String, List<String>, List<Term>>> mSimplificationStack;
    private final IPreferenceProvider mPreferences;

    public HornClauseParserScript(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, String string, ManagedScript managedScript, Logics logics) {
        super((Script)new NoopScript());
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mFilename = string;
        this.mBackendSmtSolver = managedScript;
        this.mLogic = logics;
        this.mDeclaredPredicateSymbols = new HashSet();
        this.mManagedScript = new ManagedScript(iUltimateServiceProvider, (Script)this);
        this.mParsedHornClauses = new ArrayList<HornClause>();
        this.mSymbolTable = new HcSymbolTable((Script)this, this.mBackendSmtSolver);
        this.mSimplificationStack = new ArrayDeque<Triple<String, List<String>, List<Term>>>();
        this.mPreferences = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
    }

    private boolean isUninterpretedPredicateSymbol(FunctionSymbol functionSymbol) {
        return this.mDeclaredPredicateSymbols.contains(functionSymbol.getName());
    }

    public IElement getHornClauses() {
        this.mFinished = true;
        this.mSymbolTable.finishConstruction();
        HornAnnot hornAnnot = new HornAnnot(this.mFilename, this.mBackendSmtSolver, this.mSymbolTable, this.mParsedHornClauses, this.mSawCheckSat, new ChcCategoryInfo(Logics.ALL, true));
        return HornClauseAST.create((HornAnnot)hornAnnot);
    }

    public void setLogic(String string) throws UnsupportedOperationException {
        if (!string.equals("HORN")) {
            throw new UnsupportedOperationException("Error: the SmtParser-setting HornSolverMode is set, but the smt2 file sets the logic to something other than HORN");
        }
        super.setLogic(this.mLogic);
    }

    public void declareFun(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        super.declareFun(string, sortArray, sort);
        if (SmtSortUtils.isBoolSort((Sort)sort)) {
            this.mDeclaredPredicateSymbols.add(string);
        }
    }

    private List<HornClauseHead> parseCnf(Term term) throws SMTLIBException {
        Term term2;
        Term[] termArray;
        ArrayList<HornClauseHead> arrayList = new ArrayList<HornClauseHead>();
        if (term instanceof QuantifiedFormula) {
            termArray = (Term[])term;
            if (termArray.getQuantifier() == 0) {
                throw new AssertionError((Object)"Input not skolemized??");
            }
            term2 = ((QuantifiedFormula)term).getSubformula();
        } else {
            term2 = term;
        }
        if (term2 instanceof QuantifiedFormula) {
            throw new AssertionError((Object)"Input not skolemized??");
        }
        Term[] termArray2 = termArray = SmtUtils.getConjuncts((Term)term2);
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term3 = termArray2[n2];
            HornClauseHead hornClauseHead = new HornClauseHead(this);
            Term[] termArray3 = SmtUtils.getDisjuncts((Term)term3);
            int n3 = termArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                Term term4;
                Term term5 = term4 = termArray3[n4];
                boolean bl = true;
                if (SmtUtils.isFunctionApplication((Term)term4, (String)"not")) {
                    term5 = ((ApplicationTerm)term4).getParameters()[0];
                    bl = false;
                }
                if (term5 instanceof ApplicationTerm) {
                    ApplicationTerm applicationTerm = (ApplicationTerm)term5;
                    FunctionSymbol functionSymbol = applicationTerm.getFunction();
                    if (this.isUninterpretedPredicateSymbol(functionSymbol)) {
                        if (bl) {
                            boolean bl2 = hornClauseHead.setHead(this.mapFormulasToVars(hornClauseHead, (Term)applicationTerm));
                            if (!bl2) {
                                throw new AssertionError((Object)"two positive literals in a clause --> not Horn!");
                            }
                        } else {
                            hornClauseHead.addPredicateToBody(applicationTerm);
                        }
                    } else if (bl) {
                        hornClauseHead.addTransitionFormula(this.term("not", new Term[]{term4}));
                    } else {
                        hornClauseHead.addTransitionFormula((Term)applicationTerm);
                    }
                } else if (term5 instanceof TermVariable) {
                    hornClauseHead.addTransitionFormula(this.term("not", new Term[]{term4}));
                } else {
                    throw new AssertionError((Object)"TODO: check this case");
                }
                ++n4;
            }
            arrayList.add(hornClauseHead);
            ++n2;
        }
        return arrayList;
    }

    private ApplicationTerm mapFormulasToVars(HornClauseHead hornClauseHead, Term term) {
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        Term[] termArray = new Term[applicationTerm.getParameters().length];
        int n = 0;
        while (n < termArray.length) {
            Term term2 = applicationTerm.getParameters()[n];
            boolean bl = Arrays.asList(termArray).contains(term2);
            if (term2 instanceof TermVariable && !bl) {
                termArray[n] = term2;
            } else if (term2 instanceof TermVariable && bl) {
                termArray[n] = this.mManagedScript.constructFreshTermVariable("sbrptng", term2.getSort());
                hornClauseHead.addTransitionFormula(this.term("=", new Term[]{termArray[n], term2}));
            } else {
                termArray[n] = this.mManagedScript.constructFreshTermVariable("sbcnst", term2.getSort());
                hornClauseHead.addTransitionFormula(this.term("=", new Term[]{termArray[n], term2}));
            }
            ++n;
        }
        ApplicationTerm applicationTerm2 = (ApplicationTerm)this.term(applicationTerm.getFunction().getName(), termArray);
        return applicationTerm2;
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        assert (!this.mFinished);
        Term term2 = this.normalizeInputFormula(term);
        List<HornClauseHead> list = this.parseCnf(term2);
        ArrayList<HornClause> arrayList = new ArrayList<HornClause>();
        for (HornClauseHead hornClauseHead : list) {
            HornClause hornClause = hornClauseHead.convertToHornClause(this.mBackendSmtSolver, this.mSymbolTable, (Script)this);
            if (hornClause == null) continue;
            arrayList.add(hornClause);
            if (!this.mLogger.isDebugEnabled()) continue;
            this.mLogger.debug((Object)("PARSED: " + hornClause.debugString()));
        }
        this.mParsedHornClauses.addAll(arrayList);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Parsed so far: " + String.valueOf(this.mParsedHornClauses)));
            this.mLogger.debug((Object)"");
        }
        return Script.LBool.UNKNOWN;
    }

    public Term normalizeInputFormula(Term term2) {
        TermVariable termVariable;
        Term term3;
        TermVariable[] termVariableArray;
        Term term4;
        Object object;
        Term term5 = new NormalizingTermTransformer().transform(term2);
        Term term6 = new FormulaUnLet(FormulaUnLet.UnletType.SMTLIB).unlet(term5);
        Term term7 = new NnfTransformer(this.mManagedScript, this.mServices, NnfTransformer.QuantifierHandling.KEEP).transform(term6);
        Term term8 = new PrenexNormalForm(this.mManagedScript).transform(term7);
        SkolemNormalForm skolemNormalForm = new SkolemNormalForm(this.mManagedScript, term8);
        Term term9 = skolemNormalForm.getSkolemizedFormula();
        this.mSymbolTable.announceSkolemFunctions(skolemNormalForm.getSkolemFunctions());
        if (term9 instanceof QuantifiedFormula) {
            object = (QuantifiedFormula)term9;
            term4 = object.getSubformula();
            termVariableArray = object.getVariables();
            assert (object.getQuantifier() == 1);
        } else {
            term4 = term9;
            termVariableArray = null;
        }
        object = SubTermFinder.find((Term)term4, term -> term.getSort().getName().equals("Bool") && this.hasNoUninterpretedPredicates((Term)term), (boolean)true);
        HashMap<Term, TermVariable> hashMap = new HashMap<Term, TermVariable>();
        HashMap<TermVariable, Term> hashMap2 = new HashMap<TermVariable, Term>();
        Term term10 = object.iterator();
        while (term10.hasNext()) {
            term3 = (Term)term10.next();
            termVariable = this.mManagedScript.constructFreshTermVariable("cnstrnt", this.sort("Bool", new Sort[0]));
            hashMap.put(term3, termVariable);
            assert (!hashMap2.containsValue(termVariable));
            hashMap2.put(termVariable, term3);
        }
        term3 = PureSubstitution.apply((Script)this, hashMap, (Term)term4);
        term10 = new CnfTransformer(this.mManagedScript, this.mServices).transform(term3);
        termVariable = PureSubstitution.apply((Script)this, hashMap2, (Term)term10);
        Object object2 = term9 instanceof QuantifiedFormula ? this.quantifier(1, termVariableArray, (Term)termVariable, new Term[0][]) : termVariable;
        assert (this.checkEquivalence(term2, (Term)object2)) : "transformation unsound";
        return object2;
    }

    public boolean checkEquivalence(Term term, Term term2) {
        return true;
    }

    private boolean hasNoUninterpretedPredicates(Term term2) {
        NoSubtermFulfillsPredicate noSubtermFulfillsPredicate = new NoSubtermFulfillsPredicate(term -> term instanceof ApplicationTerm && this.isUninterpretedPredicateSymbol(((ApplicationTerm)term).getFunction()));
        noSubtermFulfillsPredicate.transform(term2);
        boolean bl = noSubtermFulfillsPredicate.getResult();
        return bl;
    }

    public Script.LBool checkSat() {
        assert (!this.mFinished);
        if (this.mSawCheckSat) {
            throw new UnsupportedOperationException("only one check-sat command is supported in Horn solver mode");
        }
        this.mSawCheckSat = true;
        return super.checkSat();
    }

    public Term term(String string, String[] stringArray, Sort sort, Term ... termArray) throws SMTLIBException {
        Term term;
        List<Term> list;
        if (string.equals("and") && termArray.length == 1) {
            return this.term(string, new Term[]{termArray[0], this.term("true", new Term[0])});
        }
        if (!this.mPreferences.getBoolean("Use SMTUtils to do local simplifications during parsing")) {
            return super.term(string, stringArray, sort, termArray);
        }
        List<String> list2 = stringArray == null ? null : Arrays.asList(stringArray);
        List<Term> list3 = list = termArray == null ? null : Arrays.asList(termArray);
        if (!this.mSimplificationStack.isEmpty() && this.mSimplificationStack.peek().equals((Object)new Triple((Object)string, list2, list))) {
            term = super.term(string, stringArray, sort, termArray);
        } else {
            this.mSimplificationStack.push((Triple<String, List<String>, List<Term>>)new Triple((Object)string, list2, list));
            term = SmtUtils.unfTerm((Script)this, (String)string, (String[])stringArray, (Sort)sort, (Term[])termArray);
            this.mSimplificationStack.pop();
        }
        return term;
    }

    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        return new Model(){

            public Term getFunctionDefinition(String string, TermVariable[] termVariableArray) {
                throw new UnsupportedOperationException();
            }

            public Set<FunctionSymbol> getDefinedFunctions() {
                throw new UnsupportedOperationException();
            }

            public Map<Term, Term> evaluate(Term[] termArray) {
                throw new UnsupportedOperationException();
            }

            public Term evaluate(Term term) {
                throw new UnsupportedOperationException();
            }
        };
    }

    static class NoSubtermFulfillsPredicate
    extends TermTransformer {
        private boolean mResult;
        private final Predicate<Term> mPred;

        public NoSubtermFulfillsPredicate(Predicate<Term> predicate) {
            this.mPred = predicate;
            this.mResult = true;
        }

        protected void convert(Term term) {
            if (this.mPred.test(term)) {
                this.mResult = false;
            }
            super.convert(term);
        }

        boolean getResult() {
            return this.mResult;
        }
    }

    class NormalizingTermTransformer
    extends TermTransformer {
        NormalizingTermTransformer() {
        }

        public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
            Term[] termArray2;
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            Sort[] sortArray = functionSymbol.getParameterSorts();
            ApplicationTerm applicationTerm2 = applicationTerm;
            Term[] termArray3 = termArray;
            if (sortArray.length == 2 && sortArray[0].getName().equals("Real") && sortArray[1] == sortArray[0]) {
                if (termArray3 == applicationTerm.getParameters()) {
                    termArray3 = (Term[])termArray3.clone();
                }
                boolean bl = false;
                termArray2 = new Term[termArray3.length];
                Term[] termArray4 = new Term[termArray3.length];
                int n = 0;
                while (n < termArray3.length) {
                    Term term = termArray3[n];
                    if (term.getSort().getName().equals("Int")) {
                        termArray2[n] = HornClauseParserScript.this.term("to_real", new Term[]{term});
                        termArray4[n] = termArray2[n];
                        bl = true;
                    } else {
                        termArray2[n] = term;
                        termArray4[n] = term;
                    }
                    ++n;
                }
                if (bl) {
                    applicationTerm2 = HornClauseParserScript.this.term(functionSymbol.getName(), termArray4);
                }
            }
            Term[] termArray5 = applicationTerm2.getParameters();
            if (functionSymbol.getDefinition() != null) {
                termArray2 = new HashMap();
                int n = 0;
                while (n < termArray5.length) {
                    termArray2.put(functionSymbol.getDefinitionVars()[n], termArray5[n]);
                    ++n;
                }
                FormulaUnLet formulaUnLet = new FormulaUnLet();
                formulaUnLet.addSubstitutions((Map)termArray2);
                Term term = formulaUnLet.unlet(functionSymbol.getDefinition());
                applicationTerm2 = term;
            }
            if (applicationTerm2 != applicationTerm) {
                this.setResult((Term)applicationTerm2);
            } else {
                super.convertApplicationTerm(applicationTerm, termArray);
            }
        }
    }
}

