/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils;

import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class CoverageAnalysis<CL> {
    public static final Function<Object, Function<Object, Object>> DEFAULT_AGGREGATION = object -> object2 -> new BackwardCoveringInformation((BackwardCoveringInformation)object, (BackwardCoveringInformation)object2);
    protected final IUltimateServiceProvider mServices;
    protected final ILogger mLogger;
    private final List<CL> mProgramPointSequence;
    private final IPredicateUnifier mPredicateUnifier;
    private final Map<CL, List<Integer>> mProgramPoint2Occurence = new HashMap<CL, List<Integer>>();
    private int mUnsat;
    private int mSat;
    private int mUnknown;
    private int mTrivial;
    private int mNotchecked;
    protected final TracePredicates mIpp;

    public CoverageAnalysis(IUltimateServiceProvider iUltimateServiceProvider, TracePredicates tracePredicates, List<CL> list, ILogger iLogger, IPredicateUnifier iPredicateUnifier) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mProgramPointSequence = list;
        this.mPredicateUnifier = iPredicateUnifier;
        this.mIpp = tracePredicates;
    }

    public void analyze() {
        assert (this.mProgramPointSequence.size() - 2 == this.mIpp.getPredicates().size()) : "Wrong amount of interpolants";
        this.preprocess();
        int n = 0;
        while (n < this.mProgramPointSequence.size() - 1) {
            this.processCodeBlock(n);
            CL CL = this.mProgramPointSequence.get(n);
            List<Integer> list = this.mProgramPoint2Occurence.get(CL);
            if (list == null) {
                list = new ArrayList<Integer>();
                this.mProgramPoint2Occurence.put(CL, list);
            } else {
                for (int n2 : list) {
                    IPredicate iPredicate;
                    assert (n > n2);
                    IPredicate iPredicate2 = this.mIpp.getPredicate(n);
                    if (iPredicate2 == (iPredicate = this.mIpp.getPredicate(n2))) {
                        ++this.mTrivial;
                        continue;
                    }
                    IncrementalPlicationChecker.Validity validity = this.mPredicateUnifier.getCoverageRelation().isCovered(iPredicate2, iPredicate);
                    this.processCoveringResult(n, n2, validity);
                    switch (validity) {
                        case VALID: {
                            ++this.mUnsat;
                            break;
                        }
                        case INVALID: {
                            ++this.mSat;
                            break;
                        }
                        case UNKNOWN: {
                            ++this.mUnknown;
                            break;
                        }
                        case NOT_CHECKED: {
                            ++this.mNotchecked;
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
            }
            list.add(n);
            ++n;
        }
        assert (this.sumCountedOccurrences() == this.mProgramPointSequence.size() - 1);
        this.postprocess();
        this.mLogger.info((Object)("Checked inductivity of " + (this.mUnsat + this.mSat + this.mUnknown + this.mTrivial + this.mNotchecked) + " backedges. " + this.mUnsat + " proven. " + this.mSat + " refuted. " + this.mUnknown + " times theorem prover too weak. " + this.mTrivial + " trivial. " + this.mNotchecked + " not checked."));
    }

    private int sumCountedOccurrences() {
        int n = 0;
        for (Map.Entry<CL, List<Integer>> entry : this.mProgramPoint2Occurence.entrySet()) {
            n += entry.getValue().size();
        }
        return n;
    }

    protected void processCodeBlock(int n) {
    }

    protected void processCoveringResult(int n, int n2, IncrementalPlicationChecker.Validity validity) {
    }

    protected void postprocess() {
    }

    protected void preprocess() {
    }

    public static List<IcfgLocation> extractProgramPoints(IRun<?, IPredicate> iRun) {
        List list = iRun.getStateSequence();
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        for (IPredicate iPredicate : list) {
            arrayList.add(((ISLPredicate)iPredicate).getProgramPoint());
        }
        return arrayList;
    }

    public BackwardCoveringInformation getBackwardCoveringInformation() {
        int n = this.mUnsat + this.mSat + this.mUnknown + this.mTrivial + this.mNotchecked;
        int n2 = this.mUnsat + this.mTrivial;
        return new BackwardCoveringInformation(n, n2);
    }

    public static class BackwardCoveringInformation {
        private final int mPotentialBackwardCoverings;
        private final int mSuccessfullBackwardCoverings;

        public BackwardCoveringInformation(int n, int n2) {
            this.mPotentialBackwardCoverings = n;
            this.mSuccessfullBackwardCoverings = n2;
        }

        public BackwardCoveringInformation(BackwardCoveringInformation backwardCoveringInformation, BackwardCoveringInformation backwardCoveringInformation2) {
            this.mPotentialBackwardCoverings = backwardCoveringInformation.getPotentialBackwardCoverings() + backwardCoveringInformation2.getPotentialBackwardCoverings();
            this.mSuccessfullBackwardCoverings = backwardCoveringInformation.getSuccessfullBackwardCoverings() + backwardCoveringInformation2.getSuccessfullBackwardCoverings();
        }

        public int getPotentialBackwardCoverings() {
            return this.mPotentialBackwardCoverings;
        }

        public int getSuccessfullBackwardCoverings() {
            return this.mSuccessfullBackwardCoverings;
        }

        public String toString() {
            return this.mSuccessfullBackwardCoverings + "/" + this.mPotentialBackwardCoverings;
        }
    }
}

