/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter.yaml;

import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.FunctionContract;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.GhostUpdate;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.GhostVariable;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Location;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.LocationInvariant;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.LoopInvariant;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Segment;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.ViolationSequence;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Waypoint;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Witness;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WitnessEntry;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.MetadataProvider;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.YamlWitnessWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class YamlWitnessWriterV2
extends YamlWitnessWriter {
    private final MetadataProvider mMetadataProvider;
    private final boolean mWriteFunctionContracts;
    private final boolean mAllowGhostVariables;

    public YamlWitnessWriterV2(MetadataProvider metadataProvider, boolean bl, boolean bl2) {
        this.mMetadataProvider = metadataProvider;
        this.mWriteFunctionContracts = bl;
        this.mAllowGhostVariables = bl2;
    }

    @Override
    public String toString(Witness witness) {
        return YamlWitnessWriterV2.formatYaml(witness.isCorrectnessWitness() ? this.writeCorrectnessWitness(witness) : this.writeViolationWitness(witness));
    }

    private List<Map<String, Object>> writeCorrectnessWitness(Witness witness) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        List list = witness.getEntries().stream().filter(witnessEntry -> witnessEntry instanceof LoopInvariant || witnessEntry instanceof LocationInvariant || this.mWriteFunctionContracts && witnessEntry instanceof FunctionContract).map(this::asInvariantSetContentMap).collect(Collectors.toList());
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("entry_type", "invariant_set");
        linkedHashMap.put("metadata", this.mMetadataProvider.getFreshMetadata());
        linkedHashMap.put("content", list);
        arrayList.add(linkedHashMap);
        List<Map<String, Object>> list2 = YamlWitnessWriterV2.extractGhostVariables(witness);
        if (!list2.isEmpty()) {
            if (!this.mAllowGhostVariables) {
                throw new UnsupportedOperationException("Unsupported witness format for ghost variables");
            }
            LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
            linkedHashMap2.put("entry_type", "ghost_instrumentation");
            linkedHashMap2.put("metadata", this.mMetadataProvider.getFreshMetadata());
            LinkedHashMap<String, List<Map<String, Object>>> linkedHashMap3 = new LinkedHashMap<String, List<Map<String, Object>>>();
            linkedHashMap3.put("ghost_variables", list2);
            linkedHashMap3.put("ghost_updates", YamlWitnessWriterV2.extractGhostUpdates(witness));
            linkedHashMap2.put("content", linkedHashMap3);
            arrayList.add(linkedHashMap2);
        }
        return arrayList;
    }

    private static List<Map<String, Object>> extractGhostVariables(Witness witness) {
        return witness.getEntries().stream().filter(GhostVariable.class::isInstance).map(witnessEntry -> YamlWitnessWriterV2.extractGhostVariableMap((GhostVariable)witnessEntry)).collect(Collectors.toList());
    }

    private static List<Map<String, Object>> extractGhostUpdates(Witness witness) {
        WitnessEntry witnessEntry2;
        HashMap<Location, List> hashMap = new HashMap<Location, List>();
        for (WitnessEntry witnessEntry2 : witness.getEntries()) {
            if (!(witnessEntry2 instanceof GhostUpdate)) continue;
            GhostUpdate ghostUpdate = (GhostUpdate)witnessEntry2;
            hashMap.computeIfAbsent(ghostUpdate.getLocation(), location -> new ArrayList()).add(ghostUpdate);
        }
        witnessEntry2 = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put("location", entry.getKey());
            List list = ((List)entry.getValue()).stream().map(YamlWitnessWriterV2::extractGhostUpdateMap).collect(Collectors.toList());
            linkedHashMap.put("updates", list);
            witnessEntry2.add(linkedHashMap);
        }
        return witnessEntry2;
    }

    private static Map<String, String> extractGhostUpdateMap(GhostUpdate ghostUpdate) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("variable", ghostUpdate.getName());
        linkedHashMap.put("value", ghostUpdate.getValue());
        linkedHashMap.put("format", ghostUpdate.getValueFormat());
        return linkedHashMap;
    }

    private static Map<String, Object> extractGhostVariableMap(GhostVariable ghostVariable) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("name", ghostVariable.getVariable());
        linkedHashMap.put("type", ghostVariable.getType());
        linkedHashMap.put("scope", ghostVariable.getScope());
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        linkedHashMap2.put("value", ghostVariable.getInitialValue());
        linkedHashMap2.put("format", ghostVariable.getValueFormat());
        linkedHashMap.put("initial", linkedHashMap2);
        return linkedHashMap;
    }

    private Map<String, Object> asInvariantSetContentMap(WitnessEntry witnessEntry) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("type", witnessEntry.getName());
        if (witnessEntry instanceof LoopInvariant) {
            LoopInvariant loopInvariant = (LoopInvariant)witnessEntry;
            linkedHashMap.put("location", loopInvariant.getLocation().toMap());
            linkedHashMap.put("value", loopInvariant.getInvariant());
            linkedHashMap.put("format", loopInvariant.getFormat());
        } else if (witnessEntry instanceof LocationInvariant) {
            LocationInvariant locationInvariant = (LocationInvariant)witnessEntry;
            linkedHashMap.put("location", locationInvariant.getLocation().toMap());
            linkedHashMap.put("value", locationInvariant.getInvariant());
            linkedHashMap.put("format", locationInvariant.getFormat());
        } else if (witnessEntry instanceof FunctionContract) {
            FunctionContract functionContract = (FunctionContract)witnessEntry;
            linkedHashMap.put("location", functionContract.getLocation().toMap());
            if (functionContract.getRequires() != null) {
                linkedHashMap.put("requires", functionContract.getRequires());
            }
            if (functionContract.getEnsures() != null) {
                linkedHashMap.put("ensures", functionContract.getEnsures());
            }
            linkedHashMap.put("format", functionContract.getFormat());
        } else {
            throw new UnsupportedOperationException("Unknown entry type " + witnessEntry.getClass().getSimpleName());
        }
        return Map.of("invariant", linkedHashMap);
    }

    private List<Map<String, Object>> writeViolationWitness(Witness witness) {
        return witness.getEntries().stream().map(this::formatViolationEntry).collect(Collectors.toList());
    }

    private Map<String, Object> formatViolationEntry(WitnessEntry witnessEntry) {
        if (!(witnessEntry instanceof ViolationSequence)) {
            throw new UnsupportedOperationException("Unknown entry type " + witnessEntry.getClass().getSimpleName());
        }
        ViolationSequence violationSequence = (ViolationSequence)witnessEntry;
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("entry_type", "violation_sequence");
        linkedHashMap.put("metadata", this.mMetadataProvider.getFreshMetadata());
        ArrayList arrayList = new ArrayList();
        for (Segment segment : violationSequence.getSegments()) {
            ArrayList<Map<String, Map>> arrayList2 = new ArrayList<Map<String, Map>>();
            for (Waypoint waypoint : segment.getAvoidWaypoints()) {
                arrayList2.add(Map.of("waypoint", waypoint.toMap("avoid")));
            }
            arrayList2.add(Map.of("waypoint", segment.getFollowOrCycleWaypoint().toMap(segment.getType().getAction())));
            arrayList.add(Map.of("segment", arrayList2));
        }
        linkedHashMap.put("content", arrayList);
        return linkedHashMap;
    }
}

