/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorStatistics;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.statistics.BenchmarkWithCounters;
import java.util.HashSet;
import java.util.Set;

public class HeapSeparatorBenchmark
extends BenchmarkWithCounters {
    private final Set<ArrayGroup> mHeapArrayGroups = new HashSet<ArrayGroup>();
    private final NestedMap3<ArrayGroup, Integer, HeapSeparatorStatistics, Number> mPerArrayAndDimensionInfo = new NestedMap3();
    private final NestedMap2<ArrayGroup, HeapSeparatorStatistics, Number> mPerArrayInfo = new NestedMap2();

    protected void generateColumnTitlesAndResults() {
        int n;
        if (this.mAlreadyGeneratedColumnTitlesAndResults) {
            return;
        }
        super.generateColumnTitlesAndResults();
        for (ArrayGroup arrayGroup : this.mHeapArrayGroups) {
            int n2 = 0;
            while (n2 < arrayGroup.getDimensionality()) {
                HeapSeparatorStatistics[] heapSeparatorStatisticsArray = HeapSeparatorStatistics.values();
                int n3 = heapSeparatorStatisticsArray.length;
                n = 0;
                while (n < n3) {
                    HeapSeparatorStatistics heapSeparatorStatistics = heapSeparatorStatisticsArray[n];
                    if (heapSeparatorStatistics == HeapSeparatorStatistics.COUNT_BLOCKS || heapSeparatorStatistics == HeapSeparatorStatistics.COUNT_ARRAY_WRITES) {
                        this.mColumnTitles.add(heapSeparatorStatistics.name() + "_for_" + String.valueOf(arrayGroup) + "_at_dim_" + n2);
                        this.mResults.add((Number)this.mPerArrayAndDimensionInfo.get((Object)arrayGroup, (Object)n2, (Object)heapSeparatorStatistics));
                    }
                    ++n;
                }
                ++n2;
            }
        }
        for (ArrayGroup arrayGroup : this.mHeapArrayGroups) {
            HeapSeparatorStatistics[] heapSeparatorStatisticsArray = HeapSeparatorStatistics.values();
            n = heapSeparatorStatisticsArray.length;
            int n4 = 0;
            while (n4 < n) {
                HeapSeparatorStatistics heapSeparatorStatistics = heapSeparatorStatisticsArray[n4];
                if (heapSeparatorStatistics == HeapSeparatorStatistics.COUNT_ARRAY_READS) {
                    this.mColumnTitles.add(heapSeparatorStatistics.name() + " for " + String.valueOf(arrayGroup));
                    this.mResults.add((Number)this.mPerArrayInfo.get((Object)arrayGroup, (Object)heapSeparatorStatistics));
                }
                ++n4;
            }
        }
    }

    void registerArrayGroup(ArrayGroup arrayGroup) {
        boolean bl = this.mHeapArrayGroups.add(arrayGroup);
        if (bl) {
            this.registerCounter(this.getNewArrayVarCounterName(arrayGroup));
        }
    }

    private String getNewArrayVarCounterName(ArrayGroup arrayGroup) {
        return HeapSeparatorStatistics.COUNT_NEW_ARRAY_VARS.name() + "_" + String.valueOf(arrayGroup);
    }

    void registerPerArrayInfo(ArrayGroup arrayGroup, HeapSeparatorStatistics heapSeparatorStatistics, Number number) {
        this.mPerArrayInfo.put((Object)arrayGroup, (Object)heapSeparatorStatistics, (Object)number);
    }

    void registerPerArrayAndDimensionInfo(ArrayGroup arrayGroup, int n, HeapSeparatorStatistics heapSeparatorStatistics, Number number) {
        this.mPerArrayAndDimensionInfo.put((Object)arrayGroup, (Object)n, (Object)heapSeparatorStatistics, (Object)number);
    }

    public String toString() {
        this.generateColumnTitlesAndResults();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        int n = 0;
        while (n < this.mColumnTitles.size()) {
            stringBuilder.append(String.format("%-80s : %7d %n", this.mColumnTitles.get(n), this.mResults.get(n)));
            ++n;
        }
        return stringBuilder.toString();
    }

    public void incrementNewArrayVarCounter(ArrayGroup arrayGroup) {
        super.incrementCounter(this.getNewArrayVarCounterName(arrayGroup));
    }
}

