/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.lassoranker;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;

public abstract class AbstractLassoExtractor<LETTER extends IAction> {
    protected NestedWord<LETTER> mStem;
    protected NestedWord<LETTER> mLoop;
    protected IcfgLocation mHonda;
    protected boolean mLassoFound;
    protected IcfgLocation mSomeNoneForErrorReport;

    public NestedWord<LETTER> getStem() {
        if (!this.mLassoFound) {
            throw new UnsupportedOperationException("no lasso was found");
        }
        return this.mStem;
    }

    public NestedWord<LETTER> getLoop() {
        if (!this.mLassoFound) {
            throw new UnsupportedOperationException("no lasso was found");
        }
        return this.mLoop;
    }

    public IcfgLocation getHonda() {
        if (!this.mLassoFound) {
            throw new UnsupportedOperationException("no lasso was found");
        }
        return this.mHonda;
    }

    public boolean wasLassoFound() {
        return this.mLassoFound;
    }

    public IcfgLocation getSomeNoneForErrorReport() {
        if (this.mLassoFound) {
            throw new UnsupportedOperationException("lasso was found, there was no error");
        }
        return this.mSomeNoneForErrorReport;
    }
}

