/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;

class FloydWarshall<VERTEX, EDGELABEL> {
    private final BiPredicate<EDGELABEL, EDGELABEL> mSmallerThan;
    private BiFunction<EDGELABEL, EDGELABEL, EDGELABEL> mPlus;
    private BiFunction<Pair<EDGELABEL, EDGELABEL>, Triple<VERTEX, VERTEX, VERTEX>, EDGELABEL> mOtherPlus;
    private final EDGELABEL mNullLabel;
    private final Map<Doubleton<VERTEX>, EDGELABEL> mDist;
    private final List<VERTEX> mVertices;
    private boolean mPerformedChanges;
    private final BiFunction<EDGELABEL, EDGELABEL, EDGELABEL> mMeet;

    public FloydWarshall(BiPredicate<EDGELABEL, EDGELABEL> biPredicate, BiFunction<EDGELABEL, EDGELABEL, EDGELABEL> biFunction, BiFunction<EDGELABEL, EDGELABEL, EDGELABEL> biFunction2, EDGELABEL EDGELABEL, Map<Doubleton<VERTEX>, EDGELABEL> map, Function<EDGELABEL, EDGELABEL> function) {
        this(biPredicate, biFunction2, EDGELABEL, map, function);
        this.mPlus = Objects.requireNonNull(biFunction);
        this.run();
    }

    public FloydWarshall(BiPredicate<EDGELABEL, EDGELABEL> biPredicate, BiFunction<Pair<EDGELABEL, EDGELABEL>, Triple<VERTEX, VERTEX, VERTEX>, EDGELABEL> biFunction, BiFunction<EDGELABEL, EDGELABEL, EDGELABEL> biFunction2, EDGELABEL EDGELABEL, Map<Doubleton<VERTEX>, EDGELABEL> map, Function<EDGELABEL, EDGELABEL> function, boolean bl) {
        this(biPredicate, biFunction2, EDGELABEL, map, function);
        this.mOtherPlus = Objects.requireNonNull(biFunction);
        this.run();
    }

    private FloydWarshall(BiPredicate<EDGELABEL, EDGELABEL> biPredicate, BiFunction<EDGELABEL, EDGELABEL, EDGELABEL> biFunction, EDGELABEL EDGELABEL, Map<Doubleton<VERTEX>, EDGELABEL> map, Function<EDGELABEL, EDGELABEL> function) {
        this.mSmallerThan = biPredicate;
        this.mMeet = biFunction;
        this.mNullLabel = EDGELABEL;
        this.mPerformedChanges = false;
        this.mDist = new HashMap<Doubleton<VERTEX>, EDGELABEL>();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Map.Entry<Doubleton<VERTEX>, EDGELABEL> entry : map.entrySet()) {
            hashSet.add(entry.getKey().getOneElement());
            hashSet.add(entry.getKey().getOtherElement());
            this.mDist.put(entry.getKey(), function.apply(entry.getValue()));
        }
        this.mVertices = new ArrayList<VERTEX>(hashSet);
    }

    public boolean performedChanges() {
        return this.mPerformedChanges;
    }

    private void run() {
        int n = 0;
        while (n < this.mVertices.size()) {
            int n2 = 0;
            while (n2 < this.mVertices.size()) {
                if (n2 != n) {
                    int n3 = 0;
                    while (n3 < this.mVertices.size()) {
                        if (n3 != n2 && n3 != n && n2 <= n3) {
                            EDGELABEL EDGELABEL;
                            EDGELABEL EDGELABEL2 = this.getDist(n2, n3);
                            EDGELABEL EDGELABEL3 = this.getDist(n2, n);
                            EDGELABEL EDGELABEL4 = this.getDist(n, n3);
                            assert (this.mPlus == null != (this.mOtherPlus == null));
                            EDGELABEL EDGELABEL5 = EDGELABEL = this.mPlus != null ? this.mPlus.apply(EDGELABEL3, EDGELABEL4) : this.mOtherPlus.apply(new Pair(EDGELABEL3, EDGELABEL4), new Triple(this.mVertices.get(n2), this.mVertices.get(n), this.mVertices.get(n3)));
                            if (!this.mSmallerThan.test(EDGELABEL2, EDGELABEL)) {
                                EDGELABEL EDGELABEL6 = this.mMeet.apply(EDGELABEL, EDGELABEL2);
                                this.mDist.put(new Doubleton(this.mVertices.get(n2), this.mVertices.get(n3)), EDGELABEL6);
                                this.mPerformedChanges = true;
                            }
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private EDGELABEL getDist(int n, int n2) {
        EDGELABEL EDGELABEL = this.mDist.get(new Doubleton(this.mVertices.get(n), this.mVertices.get(n2)));
        if (EDGELABEL == null) {
            EDGELABEL = this.mNullLabel;
        }
        return EDGELABEL;
    }

    public Map<Doubleton<VERTEX>, EDGELABEL> getResult() {
        return Collections.unmodifiableMap(this.mDist);
    }
}

