/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.SdHoareTripleCheckHelper;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;

class InternalCheckHelper
extends SdHoareTripleCheckHelper<IInternalAction> {
    private static final String PRE_HIER_ERROR = "Unexpected hierarchical precondition for internal action";

    InternalCheckHelper(IPredicateCoverageChecker iPredicateCoverageChecker, IPredicate iPredicate, IPredicate iPredicate2, HoareTripleCheckerStatisticsGenerator hoareTripleCheckerStatisticsGenerator, ModifiableGlobalsTable modifiableGlobalsTable) {
        super(iPredicateCoverageChecker, iPredicate, iPredicate2, hoareTripleCheckerStatisticsGenerator, modifiableGlobalsTable);
    }

    @Override
    public IncrementalPlicationChecker.Validity sdecToFalse(IPredicate iPredicate, IPredicate iPredicate2, IInternalAction iInternalAction) {
        assert (iPredicate2 == null) : "Unexpected hierarchical precondition for internal action";
        UnmodifiableTransFormula unmodifiableTransFormula = iInternalAction.getTransformula();
        switch (unmodifiableTransFormula.isInfeasible()) {
            case INFEASIBLE: {
                return IncrementalPlicationChecker.Validity.VALID;
            }
            case UNPROVEABLE: {
                if (InternalCheckHelper.varsDisjointFromInVars(iPredicate, unmodifiableTransFormula) && InternalCheckHelper.disjointFunctions(iPredicate, unmodifiableTransFormula) && !this.containsConflictingNonModifiableOldVars(iInternalAction.getPrecedingProcedure(), iPredicate)) {
                    this.mStatistics.getSDtfsCounter().incIn();
                    return IncrementalPlicationChecker.Validity.INVALID;
                }
                return null;
            }
            case NOT_DETERMINED: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isInductiveSelfloop(IPredicate iPredicate, IPredicate iPredicate2, IInternalAction iInternalAction, IPredicate iPredicate3) {
        assert (iPredicate2 == null) : "Unexpected hierarchical precondition for internal action";
        if (iPredicate != iPredicate3) {
            return false;
        }
        if (InternalCheckHelper.varsDisjointFromAssignedVars(iPredicate, iInternalAction.getTransformula())) {
            this.mStatistics.getSDsluCounter().incIn();
            return true;
        }
        return false;
    }

    @Override
    public IncrementalPlicationChecker.Validity sdec(IPredicate iPredicate, IPredicate iPredicate2, IInternalAction iInternalAction, IPredicate iPredicate3) {
        assert (iPredicate2 == null) : "Unexpected hierarchical precondition for internal action";
        UnmodifiableTransFormula unmodifiableTransFormula = iInternalAction.getTransformula();
        IncrementalPlicationChecker.Validity validity = this.mCoverage.isCovered(iPredicate, iPredicate3);
        switch (validity) {
            case VALID: {
                if (InternalCheckHelper.varsDisjointFromAssignedVars(iPredicate, unmodifiableTransFormula) || InternalCheckHelper.varsDisjointFromAssignedVars(iPredicate3, unmodifiableTransFormula)) {
                    this.mStatistics.getSDsluCounter().incIn();
                    return IncrementalPlicationChecker.Validity.VALID;
                }
                return null;
            }
            case INVALID: {
                break;
            }
            case UNKNOWN: 
            case NOT_CHECKED: {
                return null;
            }
            default: {
                throw new AssertionError((Object)"illegal value");
            }
        }
        if (!(InternalCheckHelper.varsDisjointFromInVars(iPredicate, unmodifiableTransFormula) && InternalCheckHelper.varsDisjointFromInVars(iPredicate3, unmodifiableTransFormula) && InternalCheckHelper.varsDisjointFromAssignedVars(iPredicate3, unmodifiableTransFormula))) {
            return null;
        }
        if (!InternalCheckHelper.disjointFunctions(iPredicate, unmodifiableTransFormula) || !InternalCheckHelper.disjointFunctions(iPredicate3, unmodifiableTransFormula)) {
            return null;
        }
        String string = iInternalAction.getPrecedingProcedure();
        if (!string.equals(iInternalAction.getSucceedingProcedure())) {
            assert (iInternalAction instanceof IIcfgForkTransitionThreadOther || iInternalAction instanceof IIcfgJoinTransitionThreadOther) : "internal statement must not change procedure";
            return null;
        }
        if (this.containsConflictingNonModifiableOldVars(string, iPredicate, iPredicate3) || this.containsConflictingNonModifiableOldVars(string, iPredicate) || this.containsConflictingNonModifiableOldVars(string, iPredicate3)) {
            return null;
        }
        switch (iInternalAction.getTransformula().isInfeasible()) {
            case INFEASIBLE: {
                throw new IllegalArgumentException("case should have been handled before");
            }
            case NOT_DETERMINED: {
                return null;
            }
            case UNPROVEABLE: {
                this.mStatistics.getSDsCounter().incIn();
                return IncrementalPlicationChecker.Validity.INVALID;
            }
        }
        throw new AssertionError((Object)"illegal value");
    }

    @Override
    @Deprecated
    public IncrementalPlicationChecker.Validity sdLazyEc(IPredicate iPredicate, IPredicate iPredicate2, IInternalAction iInternalAction, IPredicate iPredicate3) {
        assert (iPredicate2 == null) : "Unexpected hierarchical precondition for internal action";
        if (InternalCheckHelper.isOrIteFormula(iPredicate3)) {
            return this.sdec(iPredicate, (IPredicate)null, iInternalAction, iPredicate3);
        }
        for (IProgramVar iProgramVar : iPredicate3.getVars()) {
            if (iPredicate.getVars().contains(iProgramVar) && iInternalAction.getTransformula().getInVars().containsKey(iProgramVar) && iInternalAction.getTransformula().getOutVars().containsKey(iProgramVar)) continue;
            this.mStatistics.getSdLazyCounter().incIn();
            return IncrementalPlicationChecker.Validity.INVALID;
        }
        return null;
    }

    private boolean containsConflictingNonModifiableOldVars(String string, IPredicate iPredicate, IPredicate iPredicate2) {
        for (IProgramVar iProgramVar : iPredicate.getVars()) {
            IProgramNonOldVar iProgramNonOldVar;
            if (!(iProgramVar instanceof IProgramOldVar ? !this.mModifiableGlobals.isModifiable(iProgramNonOldVar = ((IProgramOldVar)iProgramVar).getNonOldVar(), string) && iPredicate2.getVars().contains(iProgramNonOldVar) : iProgramVar instanceof IProgramNonOldVar && !this.mModifiableGlobals.isModifiable(iProgramNonOldVar = (IProgramNonOldVar)iProgramVar, string) && iPredicate2.getVars().contains(iProgramNonOldVar.getOldVar()))) continue;
            return true;
        }
        return false;
    }
}

