/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer;

import de.uni_freiburg.informatik.ultimate.core.lib.results.ResultUtil;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class BuchiAutomizerModuleDecompositionBenchmark
implements ICsvProviderProvider<String> {
    private final TreeMap<Integer, Integer> mModuleSizeTrivial = new TreeMap();
    private final TreeMap<Integer, Integer> mModuleSizeDeterministic = new TreeMap();
    private final TreeMap<Integer, Integer> mModuleSizeNondeterministic = new TreeMap();
    private final TreeMap<Integer, String> mRankingFunction = new TreeMap();
    private Boolean mHasRemainderModule;
    private int mRemainderModuleLocations;
    private boolean mRemainderModuleNonterminationKnown;
    private final IBacktranslationService mBacktranslationService;

    public BuchiAutomizerModuleDecompositionBenchmark(IBacktranslationService iBacktranslationService) {
        this.mBacktranslationService = iBacktranslationService;
    }

    public void reportTrivialModule(Integer n, Integer n2) {
        this.mModuleSizeTrivial.put(n, n2);
    }

    public void reportDeterministicModule(Integer n, Integer n2) {
        this.mModuleSizeDeterministic.put(n, n2);
    }

    public void reportNonDeterministicModule(Integer n, Integer n2) {
        this.mModuleSizeNondeterministic.put(n, n2);
    }

    public void reportRankingFunction(Integer n, RankingFunction rankingFunction, Script script) {
        this.mRankingFunction.put(n, this.prettyPrintRankingFunction(rankingFunction, script));
    }

    public void reportRemainderModule(int n, boolean bl) {
        assert (this.mHasRemainderModule == null) : "remainder module already reported";
        this.mHasRemainderModule = true;
        this.mRemainderModuleLocations = n;
        this.mRemainderModuleNonterminationKnown = bl;
    }

    public void reportNoRemainderModule() {
        assert (this.mHasRemainderModule == null) : "remainder module already reported";
        this.mHasRemainderModule = false;
    }

    private String prettyPrintRankingFunction(RankingFunction rankingFunction, Script script) {
        return rankingFunction.getName() + " ranking function " + ResultUtil.translateExpressionToString((IBacktranslationService)this.mBacktranslationService, Term.class, (Object[])rankingFunction.asLexTerm(script));
    }

    public String toString() {
        if (this.mHasRemainderModule == null) {
            return "Decomposition not yet finished";
        }
        int n = this.mModuleSizeTrivial.size() + this.mModuleSizeDeterministic.size() + this.mModuleSizeNondeterministic.size();
        if (n == 0) {
            if (!this.mHasRemainderModule.booleanValue()) {
                return "Trivial decomposition. There is no loop in your program.";
            }
            if (this.mRemainderModuleNonterminationKnown) {
                return "Trivial decomposition into one nonterminating module.";
            }
            return "Trivial decomposition into one module whose termination is unknown.";
        }
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Your program was decomposed into ");
        stringBuilder.append(n);
        stringBuilder.append(" terminating modules ");
        stringBuilder.append("(");
        stringBuilder.append(this.mModuleSizeTrivial.size());
        stringBuilder.append(" trivial, ");
        stringBuilder.append(this.mModuleSizeDeterministic.size());
        stringBuilder.append(" deterministic, ");
        stringBuilder.append(this.mModuleSizeNondeterministic.size());
        stringBuilder.append(" nondeterministic)");
        if (this.mHasRemainderModule.booleanValue()) {
            if (this.mRemainderModuleNonterminationKnown) {
                stringBuilder.append(" and one nonterminating remainder module.");
            } else {
                stringBuilder.append(" and one module whose termination is unknown.");
            }
        } else {
            stringBuilder.append(". ");
        }
        for (Map.Entry<Integer, Integer> entry : this.mModuleSizeDeterministic.entrySet()) {
            stringBuilder.append("One deterministic module has ");
            stringBuilder.append(this.mRankingFunction.get(entry.getKey()));
            stringBuilder.append(" and consists of ");
            stringBuilder.append(entry.getValue());
            stringBuilder.append(" locations. ");
        }
        for (Map.Entry<Integer, Integer> entry : this.mModuleSizeNondeterministic.entrySet()) {
            stringBuilder.append("One nondeterministic module has ");
            stringBuilder.append(this.mRankingFunction.get(entry.getKey()));
            stringBuilder.append(" and consists of ");
            stringBuilder.append(entry.getValue());
            stringBuilder.append(" locations. ");
        }
        for (Map.Entry<Integer, Integer> entry : this.mModuleSizeTrivial.entrySet()) {
            if (entry.getValue() <= n2) continue;
            n2 = entry.getValue();
        }
        if (!this.mModuleSizeTrivial.isEmpty()) {
            stringBuilder.append(this.mModuleSizeTrivial.size());
            stringBuilder.append(" modules have a trivial ranking function, the largest among these consists of ");
            stringBuilder.append(n2);
            stringBuilder.append(" locations.");
        }
        if (this.mHasRemainderModule.booleanValue()) {
            stringBuilder.append(" The remainder module has ");
            stringBuilder.append(this.mRemainderModuleLocations);
            stringBuilder.append(" locations.");
        }
        return stringBuilder.toString();
    }

    public ICsvProvider<String> createCsvProvider() {
        MinAvgMax minAvgMax;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Modules");
        arrayList.add("Trivial modules");
        arrayList.add("Deterministic modules");
        arrayList.add("Nondeterministic modules");
        arrayList.add("Remainer module");
        arrayList.add("Min Locs trivial modules");
        arrayList.add("Avg Locs trivial modules");
        arrayList.add("Max Locs trivial modules");
        arrayList.add("Min Locs deterministic modules");
        arrayList.add("Avg Locs deterministic modules");
        arrayList.add("Max Locs deterministic modules");
        arrayList.add("Min Locs nondeterministic modules");
        arrayList.add("Avg Locs nondeterministic modules");
        arrayList.add("Max Locs nondeterministic modules");
        int n = this.mModuleSizeTrivial.size() + this.mModuleSizeDeterministic.size() + this.mModuleSizeNondeterministic.size();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(String.valueOf(n));
        if (n == 0) {
            arrayList2.add(null);
            arrayList2.add(null);
            arrayList2.add(null);
            if (this.mHasRemainderModule == null) {
                arrayList2.add("Decomposition not yet finished");
            } else if (this.mHasRemainderModule.booleanValue()) {
                if (this.mRemainderModuleNonterminationKnown) {
                    arrayList2.add("Nonterminating");
                } else {
                    arrayList2.add("Unknown");
                }
            } else {
                arrayList2.add("No loop");
            }
            arrayList2.add(null);
            arrayList2.add(null);
            arrayList2.add(null);
            arrayList2.add(null);
            arrayList2.add(null);
            arrayList2.add(null);
            arrayList2.add(null);
            arrayList2.add(null);
            arrayList2.add(null);
        } else {
            arrayList2.add(String.valueOf(this.mModuleSizeTrivial.size()));
            arrayList2.add(String.valueOf(this.mModuleSizeDeterministic.size()));
            arrayList2.add(String.valueOf(this.mModuleSizeNondeterministic.size()));
            if (this.mHasRemainderModule == null) {
                arrayList2.add("Decomposition not yet finished");
            } else if (this.mHasRemainderModule.booleanValue()) {
                if (this.mRemainderModuleNonterminationKnown) {
                    arrayList2.add("Nonterminating");
                } else {
                    arrayList2.add("Unknown");
                }
            } else {
                arrayList2.add(null);
            }
            minAvgMax = this.getMinAvgMax(this.mModuleSizeTrivial);
            MinAvgMax minAvgMax2 = this.getMinAvgMax(this.mModuleSizeDeterministic);
            MinAvgMax minAvgMax3 = this.getMinAvgMax(this.mModuleSizeNondeterministic);
            arrayList2.add(String.valueOf(minAvgMax.min));
            arrayList2.add(String.valueOf(minAvgMax.avg));
            arrayList2.add(String.valueOf(minAvgMax.max));
            arrayList2.add(String.valueOf(minAvgMax2.min));
            arrayList2.add(String.valueOf(minAvgMax2.avg));
            arrayList2.add(String.valueOf(minAvgMax2.max));
            arrayList2.add(String.valueOf(minAvgMax3.min));
            arrayList2.add(String.valueOf(minAvgMax3.avg));
            arrayList2.add(String.valueOf(minAvgMax3.max));
        }
        minAvgMax = new SimpleCsvProvider(arrayList);
        minAvgMax.addRow(arrayList2);
        return minAvgMax;
    }

    private MinAvgMax getMinAvgMax(TreeMap<Integer, Integer> treeMap) {
        MinAvgMax minAvgMax = new MinAvgMax();
        if (treeMap == null || treeMap.entrySet().size() == 0) {
            minAvgMax.min = 0;
            minAvgMax.avg = 0.0;
            minAvgMax.max = 0;
            return minAvgMax;
        }
        for (Map.Entry<Integer, Integer> entry : treeMap.entrySet()) {
            Integer n = entry.getValue();
            if (n < minAvgMax.min) {
                minAvgMax.min = n;
            }
            if (n > minAvgMax.max) {
                minAvgMax.max = n;
            }
            minAvgMax.avg += (double)n.intValue();
        }
        minAvgMax.avg /= (double)treeMap.entrySet().size();
        return minAvgMax;
    }

    private static class MinAvgMax {
        int min = Integer.MAX_VALUE;
        double avg = 0.0;
        int max = Integer.MIN_VALUE;

        private MinAvgMax() {
        }
    }
}

