/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.EpsilonNestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaBasis;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Accepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Intersect;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveDeadEnds;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.TaskCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IncrementalHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.MonolithicHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.SmtParserUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SmtFreePredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.SubtaskIterationIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.TaskIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.RefinementEngineStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.NwaFloydHoareValidityCheck;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.cfg2automaton.Cfg2Automaton;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.PathProgram;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.IcfgAngelicProgramExecution;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AbstractCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IPostconditionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IPreconditionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PathProgramDumpController;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryRefinement;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryResultChecking;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.TraceAbstractionUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorlocalization.FlowSensitiveFaultLocalizer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.AbstractInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.DeterministicInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.NondeterministicInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.StrategyFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TaCheckAndRefinementPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TraceAbstractionRefinementEngine;
import de.uni_freiburg.informatik.ultimate.util.HistogramOfIterable;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public abstract class BasicCegarLoop<L extends IIcfgTransition<?>, A extends IAutomaton<L, IPredicate>>
extends AbstractCegarLoop<L, A> {
    private static final boolean NON_EA_INDUCTIVITY_CHECK = false;
    protected final PredicateFactoryRefinement mStateFactoryForRefinement;
    protected final PredicateFactoryForInterpolantAutomata mPredicateFactoryInterpolantAutomata;
    protected final PredicateFactoryResultChecking mPredicateFactoryResultChecking;
    protected final TraceAbstractionPreferenceInitializer.RelevanceAnalysisMode mFaultLocalizationMode;
    private final boolean mFaultLocalizationAngelic;
    private final StrategyFactory<L> mStrategyFactory;
    private final PathProgramDumpController<L> mPathProgramDumpController;
    private final boolean mStoreFloydHoareAutomata;
    private final Set<Pair<AbstractInterpolantAutomaton<L>, IPredicateUnifier>> mFloydHoareAutomata;
    protected boolean mFallbackToFpIfInterprocedural;
    protected IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> mRefinementResult;
    private boolean mFirstReuseDump;

    public BasicCegarLoop(DebugIdentifier debugIdentifier, A a, IIcfg<?> iIcfg, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, TAPreferences tAPreferences, Set<? extends IcfgLocation> set, boolean bl, IUltimateServiceProvider iUltimateServiceProvider, Class<L> clazz, PredicateFactoryRefinement predicateFactoryRefinement) {
        block4: {
            super(iUltimateServiceProvider, debugIdentifier, a, iIcfg, cfgSmtToolkit, predicateFactory, tAPreferences, set);
            this.mFloydHoareAutomata = new LinkedHashSet<Pair<AbstractInterpolantAutomaton<L>, IPredicateUnifier>>();
            this.mFallbackToFpIfInterprocedural = false;
            this.mFirstReuseDump = true;
            this.mPathProgramDumpController = new PathProgramDumpController(this.getServices(), this.mPref, this.mIcfg);
            InterpolationTechnique interpolationTechnique = tAPreferences.interpolation();
            if (this.mFallbackToFpIfInterprocedural && iIcfg.getProcedureEntryNodes().size() > 1 && interpolationTechnique == InterpolationTechnique.FPandBP) {
                this.mLogger.info((Object)"fallback from FPandBP to FP because CFG is interprocedural");
                interpolationTechnique = InterpolationTechnique.ForwardPredicates;
            }
            this.mStoreFloydHoareAutomata = tAPreferences.getFloydHoareAutomataReuse() != TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuse.NONE;
            this.mStateFactoryForRefinement = predicateFactoryRefinement;
            this.mPredicateFactoryInterpolantAutomata = new PredicateFactoryForInterpolantAutomata(this.mCsToolkit.getManagedScript(), this.mPredicateFactory, bl);
            this.mPredicateFactoryResultChecking = new PredicateFactoryResultChecking((SmtFreePredicateFactory)this.mPredicateFactory);
            this.mCegarLoopBenchmark = new CegarLoopStatisticsGenerator();
            this.mCegarLoopBenchmark.start(CegarLoopStatisticsDefinitions.OverallTime.toString());
            IPreferenceProvider iPreferenceProvider = this.getServices().getPreferenceProvider(Activator.PLUGIN_ID);
            this.mFaultLocalizationMode = (TraceAbstractionPreferenceInitializer.RelevanceAnalysisMode)iPreferenceProvider.getEnum("Highlight relevant statements in error traces", TraceAbstractionPreferenceInitializer.RelevanceAnalysisMode.class);
            this.mFaultLocalizationAngelic = iPreferenceProvider.getBoolean("Angelic verification mode");
            TaCheckAndRefinementPreferences taCheckAndRefinementPreferences = new TaCheckAndRefinementPreferences(this.getServices(), this.mPref, interpolationTechnique, this.mSimplificationTechnique, this.mCsToolkit, this.mPredicateFactory, this.mIcfg);
            this.mStrategyFactory = new StrategyFactory(this.mLogger, this.mPref, taCheckAndRefinementPreferences, this.mIcfg, this.mPredicateFactory, this.mPredicateFactoryInterpolantAutomata, clazz);
            if (this.mPref.dumpOnlyReuseAutomata()) {
                this.mLogger.info((Object)("Dumping reuse automata for " + this.mTaskIdentifier.toString()));
                String string = String.valueOf(this.mTaskIdentifier) + "-reuse";
                String string2 = this.mPref.dumpPath() + File.separator + string + "." + this.mPrintAutomataLabeling.getFormat().getFileEnding();
                File file = new File(string2);
                try {
                    FileWriter fileWriter = new FileWriter(file, false);
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    if (!this.mLogger.isErrorEnabled()) break block4;
                    this.mLogger.error((Object)"Creating FileWriter did not work.", (Throwable)iOException);
                }
            }
        }
    }

    @Override
    protected void initialize() throws AutomataLibraryException {
        if (this.mPref.readInitialProof()) {
            this.readInitialProof();
        }
    }

    protected final void readInitialProof() throws AutomataLibraryException {
        Term term;
        String string;
        Scanner scanner;
        VpAlphabet vpAlphabet;
        Throwable throwable;
        String string2 = ILocation.getAnnotation((IElement)this.mIcfg).getFileName() + ".proof.smt2";
        Path path = Paths.get(string2, new String[0]).toAbsolutePath();
        if (Files.notExists(path, new LinkOption[0])) {
            this.mLogger.warn("Could not find file with proof assertions: %s", new Object[]{path.toString()});
            return;
        }
        this.mLogger.warn("First iteration: Refining with proof given in %s", new Object[]{path.toString()});
        ArrayList<BasicPredicate> arrayList = new ArrayList<BasicPredicate>();
        try {
            throwable = null;
            vpAlphabet = null;
            try {
                scanner = new Scanner(path, StandardCharsets.UTF_8);
                try {
                    while (scanner.hasNextLine()) {
                        string = scanner.nextLine();
                        if (string.isBlank() || string.stripLeading().startsWith("#")) continue;
                        term = SmtParserUtils.parseWithVariables((String)string, (IUltimateServiceProvider)this.mServices, (CfgSmtToolkit)this.mCsToolkit);
                        BasicPredicate basicPredicate = this.mPredicateFactory.newPredicate(term);
                        arrayList.add(basicPredicate);
                    }
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        throwable = new PredicateUnifier(this.mLogger, this.mServices, this.mCsToolkit.getManagedScript(), (BasicPredicateFactory)this.mPredicateFactory, this.mCsToolkit.getSymbolTable(), this.mSimplificationTechnique, (IPredicate[])arrayList.toArray(IPredicate[]::new));
        vpAlphabet = this.mAbstraction instanceof INwaBasis ? ((INwaBasis)this.mAbstraction).getVpAlphabet() : new VpAlphabet(this.mAbstraction.getAlphabet());
        scanner = new NestedWordAutomaton(new AutomataLibraryServices(this.mServices), vpAlphabet, (IEmptyStackStateFactory)this.mStateFactoryForRefinement);
        string = throwable.getTruePredicate();
        scanner.addState(true, false, string);
        term = throwable.getFalsePredicate();
        scanner.addState(false, true, term);
        for (BasicPredicate basicPredicate : arrayList) {
            scanner.addState(false, false, basicPredicate);
        }
        this.mRefinementResult = new IRefinementEngineResult.BasicRefinementEngineResult(Script.LBool.UNSAT, (Object)scanner, null, false, List.of(new QualifiedTracePredicates(new TracePredicates((IPredicate)string, (IPredicate)term, arrayList), this.getClass(), false)), new Lazy(() -> new MonolithicHoareTripleChecker(this.mCsToolkit)), new Lazy((Object)throwable));
        this.mInterpolAutomaton = (NestedWordAutomaton)this.mRefinementResult.getInfeasibilityProof();
        this.refineAbstraction();
    }

    protected abstract List<?> getControlConfigurationsFromCounterexample(IRun<L, ?> var1);

    @Override
    protected Pair<Script.LBool, IProgramExecution<L, Term>> isCounterexampleFeasible() throws AutomataOperationCanceledException {
        Script.LBool lBool;
        RefinementEngineStatisticsGenerator refinementEngineStatisticsGenerator = null;
        List<?> list = this.getControlConfigurationsFromCounterexample(this.mCounterexample);
        Counterexample counterexample = new Counterexample(this.mCounterexample.getWord(), list);
        TraceAbstractionRefinementEngine.ITARefinementStrategy iTARefinementStrategy = this.mStrategyFactory.constructStrategy(this.getServices(), counterexample, this.mAbstraction, (TaskIdentifier)new SubtaskIterationIdentifier(this.mTaskIdentifier, this.getIteration()), (IEmptyStackStateFactory<IPredicate>)this.mPredicateFactoryInterpolantAutomata, this.getPreconditionProvider(), this.getPostconditionProvider());
        try {
            if (this.mPref.hasLimitPathProgramCount() && this.mPref.getLimitPathProgramCount() < this.mStrategyFactory.getPathProgramCache().getPathProgramCount(this.mCounterexample.getWord())) {
                String string = "bailout by path program count limit in iteration " + this.getIteration();
                throw new TaskCanceledException(TaskCanceledException.UserDefinedLimit.PATH_PROGRAM_ATTEMPTS, this.getClass(), string);
            }
            lBool = new TraceAbstractionRefinementEngine(this.getServices(), this.mLogger, iTARefinementStrategy);
            this.mRefinementResult = lBool.getResult();
            refinementEngineStatisticsGenerator = lBool.getRefinementEngineStatistics();
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            int n = new HistogramOfIterable((Iterable)this.mCounterexample.getWord()).getMax();
            String string = "analyzing trace of length " + this.mCounterexample.getLength() + " with TraceHistMax " + n;
            toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), string));
            this.mRefinementResult = new TimeoutRefinementEngineResult((Lazy<IHoareTripleChecker>)new Lazy(() -> null), (Lazy<IPredicateUnifier>)new Lazy(() -> iTARefinementStrategy.getPredicateUnifier(null)));
            throw toolchainCanceledException;
        }
        lBool = this.mRefinementResult.getCounterexampleFeasibility();
        Object object = null;
        if (lBool != Script.LBool.SAT) {
            this.mPathProgramDumpController.reportPathProgram(this.mCounterexample, this.mRefinementResult.somePerfectSequenceFound(), this.getIteration());
        }
        if (lBool != Script.LBool.UNSAT) {
            this.mLogger.info("Counterexample %s feasible", new Object[]{lBool == Script.LBool.SAT ? "is" : "might be"});
            object = this.mRefinementResult.providesIcfgProgramExecution() ? this.mRefinementResult.getIcfgProgramExecution() : TraceCheckUtils.computeSomeIcfgProgramExecutionWithoutValues((Word)this.mCounterexample.getWord());
            if (this.mFaultLocalizationMode != TraceAbstractionPreferenceInitializer.RelevanceAnalysisMode.NONE && lBool == Script.LBool.SAT) {
                INestedWordAutomaton iNestedWordAutomaton = Cfg2Automaton.constructAutomatonWithSPredicates((IUltimateServiceProvider)this.getServices(), this.mIcfg, (IEmptyStackStateFactory)this.mStateFactoryForRefinement, this.mErrorLocs, (boolean)this.mPref.interprocedural(), (PredicateFactory)this.mPredicateFactory);
                FlowSensitiveFaultLocalizer flowSensitiveFaultLocalizer = new FlowSensitiveFaultLocalizer((NestedRun)this.mCounterexample, iNestedWordAutomaton, this.getServices(), this.mCsToolkit, this.mPredicateFactory, this.mCsToolkit.getModifiableGlobalsTable(), this.mRefinementResult.getPredicateUnifier(), this.mFaultLocalizationMode, this.mSimplificationTechnique, this.mIcfg.getCfgSmtToolkit().getSymbolTable(), (IIcfg<IcfgLocation>)this.mIcfg);
                if (!(object instanceof IcfgProgramExecution)) {
                    throw new UnsupportedOperationException("Program execution is not " + String.valueOf(IcfgProgramExecution.class));
                }
                object = ((IcfgProgramExecution)object).addRelevanceInformation(flowSensitiveFaultLocalizer.getRelevanceInformation());
                if (this.mFaultLocalizationAngelic) {
                    object = new IcfgAngelicProgramExecution(object, flowSensitiveFaultLocalizer.getAngelicStatus().booleanValue());
                }
            }
        }
        if (refinementEngineStatisticsGenerator != null) {
            this.mCegarLoopBenchmark.addRefinementEngineStatistics((IStatisticsDataProvider)refinementEngineStatisticsGenerator);
        }
        return new Pair((Object)lBool, object);
    }

    @Override
    protected void constructInterpolantAutomaton() throws AutomataOperationCanceledException {
        this.mInterpolAutomaton = (NestedWordAutomaton)this.mRefinementResult.getInfeasibilityProof();
        if (this.mPref.dumpAutomata()) {
            String string = String.valueOf(new SubtaskIterationIdentifier(this.mTaskIdentifier, this.getIteration())) + "_RawFloydHoareAutomaton";
            super.writeAutomatonToFile(this.mInterpolAutomaton, string);
        }
        assert (BasicCegarLoop.isInterpolantAutomatonOfSingleStateType(this.mInterpolAutomaton));
        assert (this.accepts(this.getServices(), (INwaOutgoingLetterAndTransitionProvider<L, IPredicate>)this.mInterpolAutomaton, (Word<L>)this.mCounterexample.getWord(), false)) : "Interpolant automaton broken!: " + String.valueOf(this.mCounterexample.getWord()) + " not accepted";
        assert (this.checkInterpolantAutomatonInductivity((INestedWordAutomaton<L, IPredicate>)this.mInterpolAutomaton));
    }

    protected static boolean isInterpolantAutomatonOfSingleStateType(INestedWordAutomaton<?, IPredicate> iNestedWordAutomaton) {
        Class<?> clazz = null;
        for (IPredicate iPredicate : iNestedWordAutomaton.getStates()) {
            if (clazz == null) {
                clazz = iPredicate.getClass();
            }
            if (iPredicate.getClass() == clazz) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void finish() {
        List<Integer> list = this.mStrategyFactory.getPathProgramCache().computeSortedHistrogram();
        this.mLogger.info((Object)("Path program histogram: " + String.valueOf(list)));
        int n = HistogramOfIterable.getMaxOfVisualizationArray(list);
        this.mCegarLoopBenchmark.reportPathProgramHistogramMaximum(n);
        this.mCegarLoopBenchmark.stop(CegarLoopStatisticsDefinitions.OverallTime.toString());
    }

    protected final IHoareTripleChecker getHoareTripleChecker() {
        IHoareTripleChecker iHoareTripleChecker = this.mRefinementResult.getHoareTripleChecker();
        if (iHoareTripleChecker != null) {
            return iHoareTripleChecker;
        }
        HoareTripleCheckerCache hoareTripleCheckerCache = TraceAbstractionUtils.extractHoareTriplesfromAutomaton((NestedWordAutomaton)this.mRefinementResult.getInfeasibilityProof());
        return HoareTripleCheckerUtils.constructEfficientHoareTripleCheckerWithCaching((IUltimateServiceProvider)this.getServices(), (HoareTripleCheckerUtils.HoareTripleChecks)this.mPref.getHoareTripleChecks(), (CfgSmtToolkit)this.mCsToolkit, (IPredicateUnifier)this.mRefinementResult.getPredicateUnifier(), (HoareTripleCheckerCache)hoareTripleCheckerCache);
    }

    protected INwaOutgoingLetterAndTransitionProvider<L, IPredicate> enhanceInterpolantAutomaton(TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement, IPredicateUnifier iPredicateUnifier, IHoareTripleChecker iHoareTripleChecker, NestedWordAutomaton<L, IPredicate> nestedWordAutomaton) {
        Object object;
        if (interpolantAutomatonEnhancement == TAPreferences.InterpolantAutomatonEnhancement.NONE) {
            object = nestedWordAutomaton;
        } else {
            AbstractInterpolantAutomaton<L> abstractInterpolantAutomaton = this.constructInterpolantAutomatonForOnDemandEnhancement(nestedWordAutomaton, iPredicateUnifier, iHoareTripleChecker, interpolantAutomatonEnhancement);
            object = abstractInterpolantAutomaton;
            if (this.mStoreFloydHoareAutomata) {
                this.mFloydHoareAutomata.add(new Pair(abstractInterpolantAutomaton, (Object)iPredicateUnifier));
            }
        }
        return object;
    }

    private boolean checkPathProgramRemoval() throws AutomataLibraryException, AutomataOperationCanceledException, AssertionError {
        boolean bl;
        boolean bl2 = bl = this.mRefinementResult.somePerfectSequenceFound() && this.mPref.interpolantAutomatonEnhancement() != TAPreferences.InterpolantAutomatonEnhancement.NONE;
        if (!bl) {
            return true;
        }
        Set set = this.mCounterexample.getWord().asSet();
        PathProgram.PathProgramConstructionResult pathProgramConstructionResult = PathProgram.constructPathProgram((String)("PathprogramSubtractedCheckIteration" + this.getIteration()), (IIcfg)this.mIcfg, (Set)set, Collections.emptySet(), icfgLocation -> true);
        Map map = pathProgramConstructionResult.getOldTransition2NewTransition();
        Map map2 = DataStructureUtils.constructReverseMapping((Map)map);
        Map map3 = pathProgramConstructionResult.getLocationMapping();
        PathProgram pathProgram = pathProgramConstructionResult.getPathProgram();
        IcfgLocation icfgLocation2 = ((ISLPredicate)this.mCounterexample.getStateSequence().get(this.mCounterexample.getStateSequence().size() - 1)).getProgramPoint();
        VpAlphabet vpAlphabet = Cfg2Automaton.extractVpAlphabet((IIcfg)this.mIcfg, (!this.mPref.interprocedural() ? 1 : 0) != 0);
        new VpAlphabet(vpAlphabet, map2);
        INestedWordAutomaton iNestedWordAutomaton = Cfg2Automaton.constructAutomatonWithDebugPredicates((IUltimateServiceProvider)this.getServices(), (IIcfg)pathProgram, (IEmptyStackStateFactory)this.mPredicateFactoryResultChecking, Collections.singleton((IcfgLocation)map3.get(icfgLocation2)), (boolean)this.mPref.interprocedural(), (VpAlphabet)vpAlphabet, (Map)map2);
        assert (iNestedWordAutomaton.getFinalStates().size() == 1) : "incorrect accepting states";
        INestedWordAutomaton iNestedWordAutomaton2 = new Intersect(new AutomataLibraryServices(this.getServices()), (IIntersectionStateFactory)this.mPredicateFactoryResultChecking, (INwaOutgoingLetterAndTransitionProvider)this.mAbstraction, (INwaOutgoingLetterAndTransitionProvider)iNestedWordAutomaton).getResult();
        return new IsEmpty(new AutomataLibraryServices(this.getServices()), (INwaOutgoingLetterAndTransitionProvider)iNestedWordAutomaton2).getResult();
    }

    protected void dumpOrAppendAutomatonForReuseIfEnabled(INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, IPredicateUnifier iPredicateUnifier) {
        if (this.mPref.dumpOnlyReuseAutomata()) {
            IDoubleDeckerAutomaton iDoubleDeckerAutomaton;
            this.mCegarLoopBenchmark.start((Object)CegarLoopStatisticsDefinitions.DumpTime);
            this.mLogger.info((Object)("Dumping reuse automata for " + this.mTaskIdentifier.toString() + " " + String.valueOf(iNwaOutgoingLetterAndTransitionProvider.getClass())));
            String string = String.valueOf(this.mTaskIdentifier) + "-reuse";
            AutomataLibraryServices automataLibraryServices = new AutomataLibraryServices(this.getServices());
            HashRelation hashRelation = iPredicateUnifier.getCoverageRelation().getCopyOfImplicationRelation();
            try {
                iDoubleDeckerAutomaton = new RemoveDeadEnds(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider).getResult();
                if (iDoubleDeckerAutomaton.getStates().isEmpty()) {
                    this.mLogger.warn((Object)"Automaton with emtpy language -- ommited dump");
                    this.mCegarLoopBenchmark.stop((Object)CegarLoopStatisticsDefinitions.DumpTime);
                    return;
                }
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {
                throw new AssertionError((Object)automataOperationCanceledException);
            }
            EpsilonNestedWordAutomaton epsilonNestedWordAutomaton = new EpsilonNestedWordAutomaton((INestedWordAutomaton)iDoubleDeckerAutomaton, hashRelation);
            new AutomatonDefinitionPrinter(automataLibraryServices, "nwa" + this.getIteration(), this.mPref.dumpPath() + File.separator + string, this.mPrintAutomataLabeling, "", !this.mFirstReuseDump, new IAutomaton[]{epsilonNestedWordAutomaton});
            this.mFirstReuseDump = false;
            this.mLogger.info((Object)"Finished dumping");
            this.mCegarLoopBenchmark.stop((Object)CegarLoopStatisticsDefinitions.DumpTime);
        }
    }

    protected void checkEnhancement(INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider2) throws AutomataLibraryException, AssertionError, AutomataOperationCanceledException {
        if (!new Accepts(new AutomataLibraryServices(this.getServices()), iNwaOutgoingLetterAndTransitionProvider2, (NestedWord)this.mCounterexample.getWord(), true, false).getResult().booleanValue()) {
            boolean bl = new Accepts(new AutomataLibraryServices(this.getServices()), iNwaOutgoingLetterAndTransitionProvider, (NestedWord)this.mCounterexample.getWord(), true, false).getResult() == false;
            try {
                this.debugLogBrokenInterpolantAutomaton(iNwaOutgoingLetterAndTransitionProvider, iNwaOutgoingLetterAndTransitionProvider2, this.mCounterexample);
            }
            catch (Error error) {}
            throw new AssertionError((Object)("enhanced interpolant automaton in iteration " + this.getIteration() + " broken: counterexample of length " + this.mCounterexample.getLength() + " not accepted" + (bl ? " (original was already broken)" : " (original is ok)")));
        }
        assert (BasicCegarLoop.isInterpolantAutomatonOfSingleStateType(new RemoveUnreachable(new AutomataLibraryServices(this.getServices()), iNwaOutgoingLetterAndTransitionProvider2).getResult()));
        assert (this.checkInterpolantAutomatonInductivity((INestedWordAutomaton<L, IPredicate>)new RemoveUnreachable(new AutomataLibraryServices(this.getServices()), iNwaOutgoingLetterAndTransitionProvider2).getResult()));
    }

    private void debugLogBrokenInterpolantAutomaton(INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider2, IRun<L, ?> iRun) {
        this.mLogger.fatal((Object)"--");
        this.mLogger.fatal((Object)"enhanced interpolant automaton broken: counterexample not accepted");
        this.mLogger.fatal((Object)"word:");
        for (IIcfgTransition iIcfgTransition : iRun.getWord()) {
            this.mLogger.fatal((Object)iIcfgTransition);
        }
        this.mLogger.fatal((Object)"original automaton:");
        this.mLogger.fatal(iNwaOutgoingLetterAndTransitionProvider);
        this.mLogger.fatal((Object)"enhanced automaton:");
        this.mLogger.fatal(iNwaOutgoingLetterAndTransitionProvider2);
        this.mLogger.fatal((Object)"--");
    }

    protected AbstractInterpolantAutomaton<L> constructInterpolantAutomatonForOnDemandEnhancement(NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, IPredicateUnifier iPredicateUnifier, IHoareTripleChecker iHoareTripleChecker, TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement) {
        return switch (interpolantAutomatonEnhancement) {
            case TAPreferences.InterpolantAutomatonEnhancement.NONE -> throw new IllegalArgumentException("In setting NONE we will not do any enhancement");
            case TAPreferences.InterpolantAutomatonEnhancement.PREDICATE_ABSTRACTION, TAPreferences.InterpolantAutomatonEnhancement.PREDICATE_ABSTRACTION_CONSERVATIVE, TAPreferences.InterpolantAutomatonEnhancement.PREDICATE_ABSTRACTION_CANNIBALIZE -> this.constructInterpolantAutomatonForOnDemandEnhancementPredicateAbstraction(nestedWordAutomaton, iPredicateUnifier, iHoareTripleChecker, interpolantAutomatonEnhancement);
            case TAPreferences.InterpolantAutomatonEnhancement.EAGER, TAPreferences.InterpolantAutomatonEnhancement.EAGER_CONSERVATIVE, TAPreferences.InterpolantAutomatonEnhancement.NO_SECOND_CHANCE -> this.constructInterpolantAutomatonForOnDemandEnhancementEager(nestedWordAutomaton, iPredicateUnifier, iHoareTripleChecker, interpolantAutomatonEnhancement);
            default -> throw new MatchException(null, null);
        };
    }

    private NondeterministicInterpolantAutomaton<L> constructInterpolantAutomatonForOnDemandEnhancementEager(NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, IPredicateUnifier iPredicateUnifier, IHoareTripleChecker iHoareTripleChecker, TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement) {
        boolean bl = interpolantAutomatonEnhancement == TAPreferences.InterpolantAutomatonEnhancement.EAGER_CONSERVATIVE;
        boolean bl2 = interpolantAutomatonEnhancement != TAPreferences.InterpolantAutomatonEnhancement.NO_SECOND_CHANCE;
        return new NondeterministicInterpolantAutomaton<L>(this.getServices(), this.mCsToolkit, iHoareTripleChecker, nestedWordAutomaton, iPredicateUnifier, bl, bl2);
    }

    private DeterministicInterpolantAutomaton<L> constructInterpolantAutomatonForOnDemandEnhancementPredicateAbstraction(NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, IPredicateUnifier iPredicateUnifier, IHoareTripleChecker iHoareTripleChecker, TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement) {
        boolean bl = interpolantAutomatonEnhancement == TAPreferences.InterpolantAutomatonEnhancement.PREDICATE_ABSTRACTION_CONSERVATIVE;
        boolean bl2 = interpolantAutomatonEnhancement == TAPreferences.InterpolantAutomatonEnhancement.PREDICATE_ABSTRACTION_CANNIBALIZE;
        return new DeterministicInterpolantAutomaton<L>(this.getServices(), this.mCsToolkit, iHoareTripleChecker, nestedWordAutomaton, iPredicateUnifier, bl, bl2);
    }

    @Override
    public IElement getArtifact() {
        if (this.mPref.artifact() == TAPreferences.Artifact.ABSTRACTION || this.mPref.artifact() == TAPreferences.Artifact.INTERPOLANT_AUTOMATON || this.mPref.artifact() == TAPreferences.Artifact.NEG_INTERPOLANT_AUTOMATON) {
            if (this.mArtifactAutomaton == null) {
                this.mLogger.warn((Object)"Preferred Artifact not available, visualizing the RCFG instead");
                return this.mIcfg;
            }
            try {
                return this.mArtifactAutomaton.transformToUltimateModel(new AutomataLibraryServices(this.getServices()));
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {
                return null;
            }
        }
        if (this.mPref.artifact() == TAPreferences.Artifact.RCFG) {
            return this.mIcfg;
        }
        throw new IllegalArgumentException();
    }

    protected boolean accepts(IUltimateServiceProvider iUltimateServiceProvider, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, Word<L> word, boolean bl) throws AutomataOperationCanceledException {
        try {
            return new Accepts(new AutomataLibraryServices(iUltimateServiceProvider), iNwaOutgoingLetterAndTransitionProvider, NestedWord.nestedWord(word), bl, false).getResult();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            throw automataOperationCanceledException;
        }
        catch (AutomataLibraryException automataLibraryException) {
            throw new AssertionError((Object)automataLibraryException);
        }
    }

    @Override
    public Set<Pair<AbstractInterpolantAutomaton<L>, IPredicateUnifier>> getFloydHoareAutomata() {
        if (this.mStoreFloydHoareAutomata) {
            return this.mFloydHoareAutomata;
        }
        throw new IllegalStateException("Floyd-Hoare automata have not been stored");
    }

    protected boolean checkInterpolantAutomatonInductivity(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton) {
        return NwaFloydHoareValidityCheck.forInterpolantAutomaton((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mCsToolkit.getManagedScript(), (IHoareTripleChecker)new IncrementalHoareTripleChecker(this.mCsToolkit, false), (IPredicateUnifier)this.mRefinementResult.getPredicateUnifier(), iNestedWordAutomaton, (boolean)true).getResult();
    }

    public IPreconditionProvider getPreconditionProvider() {
        return IPreconditionProvider.constructDefaultPreconditionProvider();
    }

    public IPostconditionProvider getPostconditionProvider() {
        return IPostconditionProvider.constructDefaultPostconditionProvider();
    }

    private class TimeoutRefinementEngineResult
    extends IRefinementEngineResult.BasicRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> {
        public TimeoutRefinementEngineResult(Lazy<IHoareTripleChecker> lazy, Lazy<IPredicateUnifier> lazy2) {
            super(Script.LBool.UNKNOWN, null, null, false, Collections.emptyList(), lazy, lazy2);
        }
    }
}

