/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainExceptionWrapper;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;

public final class Dumper
implements AutoCloseable {
    private final PrintWriter mIterationPW;
    private final ILogger mLogger;

    Dumper(ILogger iLogger, TAPreferences tAPreferences, DebugIdentifier debugIdentifier, int n) {
        File file = new File(tAPreferences.dumpPath() + "/" + String.valueOf(debugIdentifier) + "_iteration" + n + ".txt");
        try {
            this.mIterationPW = new PrintWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            throw new ToolchainExceptionWrapper(Activator.PLUGIN_ID, (Throwable)iOException);
        }
        this.mLogger = iLogger;
    }

    @Override
    public void close() {
        if (this.mIterationPW != null) {
            this.mIterationPW.close();
        }
    }

    private void dumpSsa(Term[] termArray) {
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        try {
            this.mIterationPW.println("===============SSA of potential Counterexample==========");
            int n = 0;
            while (n < termArray.length) {
                this.mIterationPW.println("UnFletedTerm" + n + ": " + String.valueOf(formulaUnLet.unlet(termArray[n])));
                ++n;
            }
            this.mIterationPW.println("");
            this.mIterationPW.println("");
        }
        finally {
            this.mIterationPW.flush();
        }
    }

    private void dumpStateFormulas(IPredicate[] iPredicateArray) {
        try {
            this.mIterationPW.println("===============Interpolated StateFormulas==========");
            int n = 0;
            while (n < iPredicateArray.length) {
                this.mIterationPW.println("Interpolant" + n + ": " + String.valueOf(iPredicateArray[n]));
                ++n;
            }
            this.mIterationPW.println("");
            this.mIterationPW.println("");
        }
        finally {
            this.mIterationPW.flush();
        }
    }

    public void dumpNestedRun(IRun<?, ?> iRun) {
        if (iRun == null || !(iRun instanceof NestedRun)) {
            return;
        }
        List list = ((NestedRun)iRun).getStateSequence();
        NestedWord nestedWord = NestedWord.nestedWord((Word)iRun.getWord());
        int n = 0;
        try {
            String string = "===============Run of potential Counterexample==========";
            this.mIterationPW.println(string);
            int n2 = 0;
            while (n2 < nestedWord.length()) {
                if (iRun instanceof NestedRun) {
                    string = CoreUtil.addIndentation((int)n, (String)("Location" + n2 + ": " + String.valueOf(((ISLPredicate)list.get(n2)).getProgramPoint())));
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug((Object)string);
                    }
                    this.mIterationPW.println(string);
                }
                if (nestedWord.isCallPosition(n2)) {
                    ++n;
                }
                string = CoreUtil.addIndentation((int)n, (String)("Statement" + n2 + ": " + ((CodeBlock)nestedWord.getSymbol(n2)).getPrettyPrintedStatements()));
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)string);
                }
                this.mIterationPW.println(string);
                if (nestedWord.isReturnPosition(n2)) {
                    --n;
                }
                ++n2;
            }
            this.mIterationPW.println("ErrorLocation");
            this.mIterationPW.println("");
            this.mIterationPW.println("");
        }
        finally {
            this.mIterationPW.flush();
        }
    }

    void dumpBackedges(BoogieIcfgLocation boogieIcfgLocation, int n, IPredicate iPredicate, Collection<IPredicate> collection, CodeBlock codeBlock, IPredicate iPredicate2, IPredicate iPredicate3, IPredicate iPredicate4, Script.LBool lBool, int n2, int n3) {
        try {
            this.mIterationPW.println(String.valueOf(boogieIcfgLocation) + " occured once again at position " + n + ". Added backedge");
            this.mIterationPW.println("from:   " + String.valueOf(iPredicate));
            this.mIterationPW.println("labeled with:   " + codeBlock.getPrettyPrintedStatements());
            this.mIterationPW.println("to:   " + String.valueOf(iPredicate2));
            if (collection != null) {
                this.mIterationPW.println("for each linPredStates:   " + String.valueOf(collection));
            }
            if (n3 == -1) {
                this.mIterationPW.println("because ");
            } else {
                assert (lBool == Script.LBool.UNSAT);
                this.mIterationPW.println("because Iteration" + n2 + "_SatProblem" + n3 + " says:");
            }
            this.mIterationPW.println("  " + String.valueOf(iPredicate3));
            this.mIterationPW.println("implies");
            this.mIterationPW.println("  " + String.valueOf(iPredicate4));
            this.mIterationPW.println("");
        }
        finally {
            this.mIterationPW.flush();
        }
    }
}

