/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions;

import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.PreprocessorAnnotation;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.IAnalysis;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefEdgeAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefGraphAnnotationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefMapAnnotationProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefStatementAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.dataflowdag.AssumeFinder;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.dataflowdag.DataflowDAG;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.dataflowdag.TraceCodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.paralleldfg.ParallelDfgGeneratorObserver;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.preferences.ReachingDefinitionsPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.rcfg.ReachDefRCFG;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.trace.ReachDefTrace;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReachingDefinitions
implements IAnalysis {
    private ModelType mCurrentGraphType;
    private IUltimateServiceProvider mServices;

    public ModelType getOutputDefinition() {
        return this.mCurrentGraphType;
    }

    public boolean isGuiRequired() {
        return false;
    }

    public ITool.ModelQuery getModelQuery() {
        return ITool.ModelQuery.LAST;
    }

    public List<String> getDesiredToolIds() {
        return null;
    }

    public void setInputDefinition(ModelType modelType) {
        this.mCurrentGraphType = modelType;
    }

    public List<IObserver> getObservers() {
        if (this.mCurrentGraphType.getCreator().equals(de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.Activator.PLUGIN_ID)) {
            ReachDefGraphAnnotationProvider<ReachDefEdgeAnnotation> reachDefGraphAnnotationProvider = new ReachDefGraphAnnotationProvider<ReachDefEdgeAnnotation>(null);
            ReachDefGraphAnnotationProvider<ReachDefStatementAnnotation> reachDefGraphAnnotationProvider2 = new ReachDefGraphAnnotationProvider<ReachDefStatementAnnotation>(null);
            ILogger iLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
            AssumeFinder assumeFinder = new AssumeFinder(iLogger);
            ArrayList<IObserver> arrayList = new ArrayList<IObserver>();
            arrayList.add((IObserver)new ReachDefRCFG(iLogger, reachDefGraphAnnotationProvider2, reachDefGraphAnnotationProvider));
            arrayList.add((IObserver)assumeFinder);
            if (this.mServices.getPreferenceProvider(this.getPluginID()).getBoolean("View every procedure as a thread, and compute a parallel DFG?")) {
                arrayList.add((IObserver)new ParallelDfgGeneratorObserver(iLogger, this.mServices));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public void init() {
    }

    public String getPluginName() {
        return "Reaching Definitions";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public IPreferenceInitializer getPreferences() {
        return new ReachingDefinitionsPreferenceInitializer();
    }

    public static List<DataflowDAG<TraceCodeBlock>> computeRDForTrace(List<CodeBlock> list, ILogger iLogger, IElement iElement) throws Throwable {
        return ReachingDefinitions.computeRDForTrace(list, iLogger, PreprocessorAnnotation.getAnnotation((IElement)iElement).getSymbolTable());
    }

    public static List<DataflowDAG<TraceCodeBlock>> computeRDForTrace(List<CodeBlock> list, ILogger iLogger, BoogieSymbolTable boogieSymbolTable) throws Throwable {
        ReachDefMapAnnotationProvider<ReachDefEdgeAnnotation> reachDefMapAnnotationProvider = new ReachDefMapAnnotationProvider<ReachDefEdgeAnnotation>();
        ReachDefMapAnnotationProvider<ReachDefStatementAnnotation> reachDefMapAnnotationProvider2 = new ReachDefMapAnnotationProvider<ReachDefStatementAnnotation>();
        ReachDefTrace reachDefTrace = new ReachDefTrace(reachDefMapAnnotationProvider, reachDefMapAnnotationProvider2, iLogger, boogieSymbolTable);
        return reachDefTrace.process(list);
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
    }

    public void finish() {
    }
}

