/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IcfgDuplicator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SmtFreePredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.cfg2automaton.Cfg2Automaton;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.BlockEncoder;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.preferences.BlockEncodingPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.PathProgram;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryResultChecking;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class AcyclicSubgraphMerger {
    public static final String SUBGRAPH_HAS_A_CYCLE = "Subgraph has a cycle";
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final Map<IcfgLocation, UnmodifiableTransFormula> mEndloc2TransFormula;

    public AcyclicSubgraphMerger(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<IcfgLocation> iIcfg, Set<IcfgEdge> set, IcfgLocation icfgLocation2, IcfgEdge icfgEdge, Set<IcfgLocation> set2) {
        Subgraph subgraph;
        Object object;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        Subgraph subgraph2 = new Subgraph(iIcfg, icfgLocation2, set2);
        Object object22 = new BlockEncodingBacktranslator(IcfgEdge.class, Term.class, this.mLogger);
        Object object3 = new IcfgDuplicator(this.mLogger, this.mServices, iIcfg.getCfgSmtToolkit().getManagedScript(), object22).copy(iIcfg, "_ASGM", false);
        Object object4 = object22.getLocationMapping();
        Subgraph subgraph3 = new Subgraph(subgraph2, (IIcfg<IcfgLocation>)object3, (Map<IcfgLocation, IcfgLocation>)object4);
        Map map = object22.getEdgeMapping();
        Object object5 = DataStructureUtils.constructReverseMapping((Map)map);
        Set set3 = this.translate((Set)set, (Map)object5);
        if (icfgEdge == null) {
            object = null;
        } else {
            object = (IcfgEdge)object5.get(icfgEdge);
            Objects.requireNonNull(object);
        }
        object22 = subgraph3.getSubgraphStartLocation().getProcedure();
        object3 = (IcfgLocation)subgraph3.getIcfg().getProcedureEntryNodes().get(object22);
        if (subgraph2.getSubgraphStartLocation() != object3) {
            object4 = new ArrayList(subgraph3.getSubgraphStartLocation().getOutgoingEdges());
            object5 = object4.iterator();
            while (object5.hasNext()) {
                map = (IcfgEdge)object5.next();
                if (map == object || !set3.contains(map)) continue;
                set3.remove(map);
                map.redirectSource((IModifiableExplicitEdgesMultigraph)object3);
                set3.add(map);
            }
            subgraph = new Subgraph(subgraph3, (IcfgLocation)object3);
        } else {
            subgraph = subgraph3;
        }
        object = "InductivityChecksStartingFrom_" + String.valueOf(subgraph.getSubgraphStartLocation());
        object22 = PathProgram.constructPathProgram((String)object, subgraph.getIcfg(), set3, Collections.singleton(subgraph.getSubgraphStartLocation()), icfgLocation -> false);
        object3 = object22.getLocationMapping();
        object4 = DataStructureUtils.constructReverseMapping((Map)object3);
        subgraph3 = new Subgraph(subgraph, (IIcfg<IcfgLocation>)object22.getPathProgram(), (Map<IcfgLocation, IcfgLocation>)object4);
        object22 = this.mServices.registerDefaultPreferenceLayer(this.getClass(), new String[]{BlockEncodingPreferences.PLUGIN_ID});
        object3 = object22.getPreferenceProvider(BlockEncodingPreferences.PLUGIN_ID);
        object3.put("Remove sink states", (Object)false);
        object3.put("Remove infeasible edges", (Object)false);
        object3.put("Minimize states even if more edges are added than removed.", (Object)true);
        object4 = new BlockEncoder(this.mLogger, (IUltimateServiceProvider)object22, subgraph3.getIcfg(), SmtUtils.SimplificationTechnique.NONE);
        object = new Subgraph(subgraph3, (IIcfg<IcfgLocation>)object4.getResult(), object4.getBacktranslator().getLocationMapping());
        if (((Subgraph)object).getSubgraphStartLocation().getOutgoingEdges().size() != subgraph2.getSubgraphEndLocations().size()) {
            throw new AssertionError((Object)"Either subgraph not acyclic or there is a bug");
        }
        this.mEndloc2TransFormula = new HashMap<IcfgLocation, UnmodifiableTransFormula>();
        for (Object object22 : ((Subgraph)object).getSubgraphStartLocation().getOutgoingEdges()) {
            if (!((Subgraph)object).getSubgraphEndLocations().contains(object22.getTarget())) {
                throw new IllegalArgumentException(SUBGRAPH_HAS_A_CYCLE);
            }
            object4 = (IcfgLocation)object22.getTarget();
            map = ((Subgraph)object).getBacktranslation().get(object4);
            object5 = subgraph3.getBacktranslation().get(map);
            IcfgLocation icfgLocation3 = subgraph.getBacktranslation().get(object5);
            this.mEndloc2TransFormula.put(icfgLocation3, object22.getTransformula());
        }
    }

    public UnmodifiableTransFormula getTransFormula(IcfgLocation icfgLocation) {
        return this.mEndloc2TransFormula.get(icfgLocation);
    }

    private <K, V> Set<V> translate(Set<K> set, Map<K, V> map) {
        return set.stream().map(map::get).collect(Collectors.toSet());
    }

    private class Subgraph {
        private final IIcfg<IcfgLocation> mIcfg;
        private final IcfgLocation mSubgraphStartLocation;
        private final Set<IcfgLocation> mSubgraphEndLocations;
        private final Map<IcfgLocation, IcfgLocation> mBacktranslation;
        private final Map<IcfgLocation, IcfgLocation> mForwardTranslation;

        public Subgraph(IIcfg<IcfgLocation> iIcfg, IcfgLocation icfgLocation, Set<IcfgLocation> set) {
            this.mIcfg = iIcfg;
            this.mSubgraphStartLocation = icfgLocation;
            this.mSubgraphEndLocations = set;
            this.mBacktranslation = null;
            this.mForwardTranslation = null;
        }

        public Subgraph(Subgraph subgraph, IIcfg<IcfgLocation> iIcfg, Map<IcfgLocation, IcfgLocation> map) {
            this.mIcfg = iIcfg;
            this.mBacktranslation = map;
            this.mForwardTranslation = DataStructureUtils.constructReverseMapping(map);
            this.mSubgraphStartLocation = this.mForwardTranslation.get(subgraph.getSubgraphStartLocation());
            Objects.requireNonNull(this.mSubgraphStartLocation);
            this.mSubgraphEndLocations = AcyclicSubgraphMerger.this.translate(subgraph.getSubgraphEndLocations(), this.mForwardTranslation);
        }

        public Subgraph(Subgraph subgraph, IcfgLocation icfgLocation) {
            this.mIcfg = subgraph.getIcfg();
            this.mBacktranslation = subgraph.getBacktranslation();
            this.mForwardTranslation = subgraph.getForwardTranslation();
            this.mSubgraphStartLocation = icfgLocation;
            Objects.requireNonNull(this.mSubgraphStartLocation);
            this.mSubgraphEndLocations = subgraph.getSubgraphEndLocations();
        }

        public IIcfg<IcfgLocation> getIcfg() {
            return this.mIcfg;
        }

        public IcfgLocation getSubgraphStartLocation() {
            return this.mSubgraphStartLocation;
        }

        public Set<IcfgLocation> getSubgraphEndLocations() {
            return this.mSubgraphEndLocations;
        }

        public Map<IcfgLocation, IcfgLocation> getBacktranslation() {
            return this.mBacktranslation;
        }

        public Map<IcfgLocation, IcfgLocation> getForwardTranslation() {
            return this.mForwardTranslation;
        }

        public String toString() {
            VpAlphabet vpAlphabet = Cfg2Automaton.extractVpAlphabet(this.mIcfg, (boolean)false);
            INestedWordAutomaton iNestedWordAutomaton = Cfg2Automaton.constructAutomatonWithDebugPredicates((IUltimateServiceProvider)AcyclicSubgraphMerger.this.mServices, this.mIcfg, (IEmptyStackStateFactory)new PredicateFactoryResultChecking(new SmtFreePredicateFactory()), Collections.emptySet(), (boolean)true, (VpAlphabet)vpAlphabet, null);
            return iNestedWordAutomaton.toString();
        }
    }
}

