/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;

public final class TraceAbstractionUtils {
    private TraceAbstractionUtils() {
    }

    public static <LCSP extends IPredicate, LCS> PartitionBackedSetOfPairs<IPredicate> computePartition(INestedWordAutomaton<?, IPredicate> iNestedWordAutomaton, ILogger iLogger, Function<LCSP, LCS> function) {
        IPredicate iPredicate2;
        iLogger.debug((Object)"Start computation of initial partition.");
        Set set = iNestedWordAutomaton.getStates();
        HashRelation hashRelation = new HashRelation();
        for (IPredicate iPredicate2 : set) {
            IPredicate iPredicate3 = iPredicate2;
            hashRelation.addPair(function.apply(iPredicate3), (Object)iPredicate2);
        }
        iPredicate2 = new ArrayList();
        for (Iterator iterator : hashRelation.getDomain()) {
            HashSet hashSet = new HashSet(hashRelation.getImage(iterator));
            iPredicate2.add(hashSet);
        }
        iLogger.debug((Object)"Finished computation of initial partition.");
        return new PartitionBackedSetOfPairs((Collection)iPredicate2);
    }

    public static <L> String prettyPrintTracePredicates(NestedWord<L> nestedWord, TracePredicates tracePredicates) {
        if (!nestedWord.getPendingReturns().isEmpty()) {
            throw new UnsupportedOperationException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        while (n2 < nestedWord.length()) {
            stringBuilder.append("{ ");
            stringBuilder.append(tracePredicates.getPredicate(n2).getFormula());
            stringBuilder.append(" }");
            stringBuilder.append(System.lineSeparator());
            if (nestedWord.isCallPosition(n2)) {
                ++n;
            }
            stringBuilder.append("\t".repeat(n));
            stringBuilder.append(nestedWord.getSymbol(n2));
            stringBuilder.append(System.lineSeparator());
            if (nestedWord.isReturnPosition(n2)) {
                --n;
            }
            stringBuilder.append("\t".repeat(n));
            ++n2;
        }
        stringBuilder.append("{ ");
        stringBuilder.append(tracePredicates.getPostcondition().getFormula());
        stringBuilder.append(" }");
        stringBuilder.append(System.lineSeparator());
        return stringBuilder.toString();
    }

    public static <L> HoareTripleCheckerCache extractHoareTriplesfromAutomaton(NestedWordAutomaton<L, IPredicate> nestedWordAutomaton) {
        HoareTripleCheckerCache hoareTripleCheckerCache = new HoareTripleCheckerCache();
        if (nestedWordAutomaton == null) {
            return hoareTripleCheckerCache;
        }
        for (IPredicate iPredicate : nestedWordAutomaton.getStates()) {
            for (OutgoingInternalTransition outgoingInternalTransition : nestedWordAutomaton.internalSuccessors((Object)iPredicate)) {
                hoareTripleCheckerCache.putInternal(iPredicate, (IInternalAction)outgoingInternalTransition.getLetter(), (IPredicate)outgoingInternalTransition.getSucc(), IncrementalPlicationChecker.Validity.VALID);
            }
            for (OutgoingInternalTransition outgoingInternalTransition : nestedWordAutomaton.callSuccessors((Object)iPredicate)) {
                hoareTripleCheckerCache.putCall(iPredicate, (ICallAction)outgoingInternalTransition.getLetter(), (IPredicate)outgoingInternalTransition.getSucc(), IncrementalPlicationChecker.Validity.VALID);
            }
            for (OutgoingInternalTransition outgoingInternalTransition : nestedWordAutomaton.returnSuccessors((Object)iPredicate)) {
                hoareTripleCheckerCache.putReturn(iPredicate, (IPredicate)outgoingInternalTransition.getHierPred(), (IReturnAction)outgoingInternalTransition.getLetter(), (IPredicate)outgoingInternalTransition.getSucc(), IncrementalPlicationChecker.Validity.VALID);
            }
        }
        return hoareTripleCheckerCache;
    }
}

