/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.MonolithicImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Set;

public class InclusionInPreChecker
implements IHoareTripleChecker {
    private static final boolean EXPENSIVE_PQE_FOR_WP_RESULTS = true;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final MonolithicImplicationChecker mMic;
    private final PredicateTransformer<Term, IPredicate, TransFormula> mPt;
    private final PredicateFactory mPf;
    private final CfgSmtToolkit mCsToolkit;

    public InclusionInPreChecker(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, MonolithicImplicationChecker monolithicImplicationChecker, PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer, PredicateFactory predicateFactory, CfgSmtToolkit cfgSmtToolkit) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mMic = monolithicImplicationChecker;
        this.mPt = predicateTransformer;
        this.mPf = predicateFactory;
        this.mCsToolkit = cfgSmtToolkit;
    }

    public IncrementalPlicationChecker.Validity checkInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
        IPredicate iPredicate3 = this.mPf.not((IPredicate)this.mPf.newPredicate(this.getWpInternal(iInternalAction, iPredicate2)));
        IncrementalPlicationChecker.Validity validity = this.checkImplication(iPredicate, iPredicate3);
        return validity;
    }

    public IncrementalPlicationChecker.Validity checkCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
        IPredicate iPredicate3 = this.mPf.not((IPredicate)this.mPf.newPredicate(this.getWpCall(iCallAction, iPredicate2)));
        IncrementalPlicationChecker.Validity validity = this.checkImplication(iPredicate, iPredicate3);
        return validity;
    }

    public IncrementalPlicationChecker.Validity checkReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        IPredicate iPredicate4 = this.mPf.not((IPredicate)this.mPf.newPredicate(this.getWpReturn(iPredicate2, iReturnAction, iPredicate3)));
        IncrementalPlicationChecker.Validity validity = this.checkImplication(iPredicate, iPredicate4);
        return validity;
    }

    public void releaseLock() {
    }

    public HoareTripleCheckerStatisticsGenerator getStatistics() {
        return null;
    }

    private IncrementalPlicationChecker.Validity checkImplication(IPredicate iPredicate, IPredicate iPredicate2) {
        return this.mMic.checkImplication(iPredicate, false, iPredicate2, false);
    }

    private Term getWpInternal(IInternalAction iInternalAction, IPredicate iPredicate) {
        Term term;
        Term term2 = term = (Term)this.mPt.weakestPrecondition((IAbstractPredicate)this.mPf.not(iPredicate), (ITransitionRelation)iInternalAction.getTransformula());
        term = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mCsToolkit.getManagedScript(), (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term2);
        return term;
    }

    private Term getWpCall(ICallAction iCallAction, IPredicate iPredicate) {
        Term term;
        UnmodifiableTransFormula unmodifiableTransFormula = this.mCsToolkit.getOldVarsAssignmentCache().getGlobalVarsAssignment(iCallAction.getSucceedingProcedure());
        UnmodifiableTransFormula unmodifiableTransFormula2 = this.mCsToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(iCallAction.getSucceedingProcedure());
        Set set = this.mCsToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(iCallAction.getSucceedingProcedure());
        Term term2 = term = (Term)this.mPt.weakestPreconditionCall((IAbstractPredicate)this.mPf.not(iPredicate), (ITransitionRelation)iCallAction.getTransformula(), (ITransitionRelation)unmodifiableTransFormula, (ITransitionRelation)unmodifiableTransFormula2, set);
        term = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mCsToolkit.getManagedScript(), (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term2);
        return term;
    }

    private Term getWpReturn(IPredicate iPredicate, IReturnAction iReturnAction, IPredicate iPredicate2) {
        Term term;
        UnmodifiableTransFormula unmodifiableTransFormula = iReturnAction.getAssignmentOfReturn();
        UnmodifiableTransFormula unmodifiableTransFormula2 = iReturnAction.getLocalVarsAssignmentOfCall();
        UnmodifiableTransFormula unmodifiableTransFormula3 = this.mCsToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(iReturnAction.getSucceedingProcedure());
        Set set = this.mCsToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(iReturnAction.getSucceedingProcedure());
        Term term2 = term = (Term)this.mPt.weakestPreconditionReturn((IAbstractPredicate)this.mPf.not(iPredicate2), (IAbstractPredicate)iPredicate, (ITransitionRelation)unmodifiableTransFormula, (ITransitionRelation)unmodifiableTransFormula2, (ITransitionRelation)unmodifiableTransFormula3, set);
        term = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mCsToolkit.getManagedScript(), (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term2);
        return term;
    }
}

