/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckSpWp;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.BlockEncoder;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.preferences.BlockEncodingPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public final class LargeBlockEncodingIcfgTransformer {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final PredicateFactory mPredicateFactory;
    private final IPredicateUnifier mPredicateUnifier;
    private Map<IcfgLocation, IcfgLocation> mLbeBacktranslation;
    private IIcfg<IcfgLocation> mInputIcfg;

    public LargeBlockEncodingIcfgTransformer(IUltimateServiceProvider iUltimateServiceProvider, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mPredicateFactory = predicateFactory;
        this.mPredicateUnifier = iPredicateUnifier;
    }

    public IIcfg<IcfgLocation> transform(IIcfg<IcfgLocation> iIcfg) {
        this.mInputIcfg = iIcfg;
        IUltimateServiceProvider iUltimateServiceProvider = this.mServices.registerPreferenceLayer(this.getClass(), new String[]{BlockEncodingPreferences.PLUGIN_ID});
        IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(BlockEncodingPreferences.PLUGIN_ID);
        iPreferenceProvider.put("Create interprocedural compositions", (Object)false);
        iPreferenceProvider.put("Minimize states using LBE with the strategy", (Object)BlockEncodingPreferences.MinimizeStates.MULTI);
        iPreferenceProvider.put("Remove infeasible edges", (Object)false);
        iPreferenceProvider.put("Remove sink states", (Object)false);
        BlockEncoder blockEncoder = new BlockEncoder(this.mLogger, iUltimateServiceProvider, iIcfg, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        IIcfg iIcfg2 = blockEncoder.getResult();
        assert (!iIcfg2.getInitialNodes().isEmpty()) : "LBE ICFG is emtpy";
        this.mLbeBacktranslation = blockEncoder.getBacktranslator().getLocationMapping();
        return iIcfg2;
    }

    public Map<IcfgLocation, IPredicate> transform(Map<IcfgLocation, IPredicate> map) {
        Map<IcfgLocation, IPredicate> map2 = this.computeIntermediateInvariants(this.mInputIcfg, map, this.mLbeBacktranslation, this.mPredicateUnifier, this.mInputIcfg.getCfgSmtToolkit());
        this.mLbeBacktranslation = null;
        this.mInputIcfg = null;
        return map2;
    }

    private Map<IcfgLocation, IPredicate> computeIntermediateInvariants(IIcfg<IcfgLocation> iIcfg, Map<IcfgLocation, IPredicate> map, Map<IcfgLocation, IcfgLocation> map2, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit) {
        Object object;
        HashMap<IcfgLocation, IPredicate> hashMap = new HashMap<IcfgLocation, IPredicate>();
        for (Map.Entry<IcfgLocation, IPredicate> object22 : map.entrySet()) {
            hashMap.put(map2.get(object22.getKey()), object22.getValue());
        }
        for (IcfgLocation icfgLocation : map.keySet()) {
            object = map2.get(icfgLocation);
            if (object.getOutgoingEdges().isEmpty()) continue;
            this.tryToAddInvariantsUsingInterpolation((IcfgLocation)object, hashMap, iPredicateUnifier, cfgSmtToolkit);
        }
        Set<IcfgLocation> set = LargeBlockEncodingIcfgTransformer.extractAllIcfgLocations(iIcfg);
        this.mLogger.info((Object)("path program has " + set.size() + " locations"));
        this.mLogger.info((Object)(map.size() + " invariants obtained by synthesis"));
        this.mLogger.info((Object)(hashMap.size() - map.size() + " invariants obtained by interpolation"));
        int n = 0;
        object = new ArrayDeque();
        for (IcfgLocation icfgLocation : set) {
            if (hashMap.containsKey(icfgLocation)) continue;
            ((ArrayDeque)object).add(icfgLocation);
        }
        int n2 = 0;
        while (!((ArrayDeque)object).isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)((ArrayDeque)object).removeFirst();
            if (LargeBlockEncodingIcfgTransformer.allPredecessorsHaveInvariants(icfgLocation, hashMap)) {
                n2 = 0;
                IPredicate iPredicate = this.computeInvariantUsingSp(icfgLocation, hashMap, cfgSmtToolkit.getManagedScript(), iPredicateUnifier);
                hashMap.put(icfgLocation, iPredicate);
                ++n;
            } else {
                ++n2;
                ((ArrayDeque)object).add(icfgLocation);
            }
            if (n2 > ((ArrayDeque)object).size()) {
                throw new AssertionError((Object)"No Progress! Cycle or unreachable locations in Icfg.");
            }
        }
        this.mLogger.info((Object)("remaining " + n + " invariants computed via SP"));
        return hashMap;
    }

    private void tryToAddInvariantsUsingInterpolation(IcfgLocation icfgLocation, Map<IcfgLocation, IPredicate> map, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit) {
        NestedRun nestedRun = LargeBlockEncodingIcfgTransformer.extractRunOfBranchlessLocs(icfgLocation, map.keySet());
        if (nestedRun == null) {
            return;
        }
        IPredicate iPredicate = map.get(nestedRun.getStateAtPosition(0));
        IPredicate iPredicate2 = map.get(nestedRun.getStateAtPosition(nestedRun.getLength() - 1));
        IPredicate[] iPredicateArray = this.computeInterpolantsAlongRun(nestedRun, iPredicate, iPredicate2, iPredicateUnifier, cfgSmtToolkit);
        int n = 1;
        while (n < nestedRun.getLength() - 1) {
            map.put((IcfgLocation)nestedRun.getStateAtPosition(n), iPredicateArray[n - 1]);
            ++n;
        }
    }

    private static Set<IcfgLocation> extractAllIcfgLocations(IIcfg<IcfgLocation> iIcfg) {
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(iIcfg);
        while (icfgLocationIterator.hasNext()) {
            hashSet.add(icfgLocationIterator.next());
        }
        return hashSet;
    }

    private IPredicate computeInvariantUsingSp(IcfgLocation icfgLocation, Map<IcfgLocation, IPredicate> map, ManagedScript managedScript, IPredicateUnifier iPredicateUnifier) {
        IcfgEdge icfgEdge2;
        PredicateTransformer predicateTransformer = new PredicateTransformer(managedScript, (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, managedScript));
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (IcfgEdge icfgEdge2 : icfgLocation.getIncomingEdges()) {
            IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge2.getSource();
            IPredicate iPredicate = map.get(icfgLocation2);
            Term term = (Term)predicateTransformer.strongestPostcondition((IAbstractPredicate)iPredicate, (ITransitionRelation)icfgEdge2.getTransformula());
            arrayList.add(term);
        }
        icfgEdge2 = SmtUtils.or((Script)managedScript.getScript(), arrayList);
        IPredicate iPredicate = iPredicateUnifier.getOrConstructPredicate((Term)icfgEdge2);
        return iPredicate;
    }

    private static boolean allPredecessorsHaveInvariants(IcfgLocation icfgLocation, Map<IcfgLocation, IPredicate> map) {
        for (IcfgLocation icfgLocation2 : icfgLocation.getIncomingNodes()) {
            if (map.containsKey(icfgLocation2)) continue;
            return false;
        }
        return true;
    }

    private IPredicate[] computeInterpolantsAlongRun(NestedRun<IAction, IcfgLocation> nestedRun, IPredicate iPredicate, IPredicate iPredicate2, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit) {
        SortedMap sortedMap = Collections.emptySortedMap();
        ITraceCheckPreferences.UnsatCores unsatCores = ITraceCheckPreferences.UnsatCores.CONJUNCT_LEVEL;
        InterpolationTechnique interpolationTechnique = InterpolationTechnique.ForwardPredicates;
        ManagedScript managedScript = cfgSmtToolkit.getManagedScript();
        SmtUtils.SimplificationTechnique simplificationTechnique = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
        Counterexample counterexample = new Counterexample((Word)nestedRun.getWord(), nestedRun.getStateSequence());
        TraceCheckSpWp traceCheckSpWp = new TraceCheckSpWp(iPredicate, iPredicate2, sortedMap, counterexample, cfgSmtToolkit, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, unsatCores, true, this.mServices, false, this.mPredicateFactory, iPredicateUnifier, interpolationTechnique, managedScript, simplificationTechnique, false);
        return traceCheckSpWp.getInterpolants();
    }

    private static <T extends IAction> NestedRun<T, IcfgLocation> extractRunOfBranchlessLocs(IcfgLocation icfgLocation, Set<IcfgLocation> set) {
        NestedRun nestedRun = new NestedRun((Object)icfgLocation);
        IcfgLocation icfgLocation2 = icfgLocation;
        while (true) {
            if (icfgLocation2.getOutgoingEdges().isEmpty()) {
                throw new AssertionError((Object)"no outgoing edge");
            }
            if (icfgLocation2.getOutgoingEdges().size() == 1) {
                IcfgEdge icfgEdge = (IcfgEdge)icfgLocation2.getOutgoingEdges().get(0);
                NestedRun nestedRun2 = new NestedRun((Object)((IcfgLocation)icfgEdge.getSource()), (Object)icfgEdge, -2, (Object)((IcfgLocation)icfgEdge.getTarget()));
                nestedRun = nestedRun.concatenate(nestedRun2);
                icfgLocation2 = (IcfgLocation)icfgEdge.getTarget();
                if (set.contains(icfgLocation2)) {
                    return nestedRun;
                }
                if (icfgLocation2.getIncomingEdges().size() <= 1) continue;
                return null;
            }
            if (icfgLocation2.getOutgoingEdges().size() > 1) break;
        }
        return null;
    }
}

