/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences;

import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmptyHeuristic;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.PetriNetUnfolder;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.LoopAccelerators;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationPositions;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareProofSettings;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractionTermClassifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.PartialOrderMode;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.PartialOrderReductionFacade;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.IndependenceSettings;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SemanticIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;

public final class TAPreferences {
    private static final boolean SEPARATE_VIOLATION_CHECK = true;
    private final boolean mInterprocedural;
    private final int mMaxIterations;
    private final int mWatchIteration;
    private final Artifact mArtifact;
    private final InterpolationTechnique mInterpolation;
    private final TraceAbstractionPreferenceInitializer.InterpolantAutomaton mInterpolantAutomaton;
    private final boolean mDumpAutomata;
    private final AutomatonDefinitionPrinter.Format mAutomataFormat;
    private final String mDumpPath;
    private final InterpolantAutomatonEnhancement mDeterminiation;
    private final TraceAbstractionPreferenceInitializer.Minimization mMinimize;
    private final Concurrency mAutomataTypeConcurrency;
    private final HoareTripleCheckerUtils.HoareTripleChecks mHoareTripleChecks;
    @ReflectionUtil.Reflected(excluded=true)
    private final IPreferenceProvider mPrefs;
    private final HoareAnnotationPositions mHoareAnnotationPositions;
    private final boolean mDumpOnlyReuseAutomata;
    private final int mLimitTraceHistogram;
    private final int mErrorLocTimeLimit;
    private final int mLimitPathProgramCount;
    private final boolean mCollectInterpolantStatistics;
    private final boolean mHeuristicEmptinessCheck;
    private final IsEmptyHeuristic.AStarHeuristic mHeuristicEmptinessCheckAStarHeuristic;
    private final Integer mHeuristicEmptinessCheckAStarHeuristicRandomSeed;
    private final SMTFeatureExtractionTermClassifier.ScoringMethod mHeuristicEmptinessCheckSmtFeatureScoringMethod;
    private final boolean mSMTFeatureExtraction;
    private final String mSMTFeatureExtractionDumpPath;
    private final boolean mOverrideInterpolantAutomaton;
    private final TraceAbstractionPreferenceInitializer.McrInterpolantMethod mMcrInterpolantMethod;
    private final IndependenceSettings[] mPorIndependenceSettings;
    private final IndependenceSettings mLbeIndependenceSettings;
    private final int mThreadLimit;
    private final boolean mParallelCegarLoop;
    private final boolean mConsiderOnlyActiveCounterexamplesInIsEmptyParallel;
    private final boolean mMinimizeAbstractionPerWorker;
    private final int mSearchLoopBound;

    public TAPreferences(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mPrefs = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mInterprocedural = this.mPrefs.getBoolean("Interprocedural analysis (Nested Interpolants)");
        this.mMaxIterations = this.mPrefs.getInt("Limit iterations");
        this.mWatchIteration = this.mPrefs.getInt("Number of iteration whose artifact is visualized");
        this.mArtifact = (Artifact)this.mPrefs.getEnum("Kind of artifact that is visualized", Artifact.class);
        this.mHoareAnnotationPositions = (HoareAnnotationPositions)this.mPrefs.getEnum("Positions where we compute the Hoare Annotation", HoareAnnotationPositions.class);
        this.mInterpolation = (InterpolationTechnique)this.mPrefs.getEnum("Compute Interpolants along a Counterexample", InterpolationTechnique.class);
        this.mInterpolantAutomaton = (TraceAbstractionPreferenceInitializer.InterpolantAutomaton)this.mPrefs.getEnum("Interpolant automaton", TraceAbstractionPreferenceInitializer.InterpolantAutomaton.class);
        this.mDumpAutomata = this.mPrefs.getBoolean("Dump automata to files");
        this.mAutomataFormat = (AutomatonDefinitionPrinter.Format)this.mPrefs.getEnum("Output format of dumped automata", AutomatonDefinitionPrinter.Format.class);
        this.mDumpPath = this.mPrefs.getString("Dump automata to the following directory");
        this.mDumpOnlyReuseAutomata = this.mPrefs.getBoolean("Dump only reuse-automata");
        this.mDeterminiation = (InterpolantAutomatonEnhancement)this.mPrefs.getEnum("Interpolant automaton enhancement", InterpolantAutomatonEnhancement.class);
        this.mHoareTripleChecks = (HoareTripleCheckerUtils.HoareTripleChecks)this.mPrefs.getEnum("Hoare triple checks", HoareTripleCheckerUtils.HoareTripleChecks.class);
        this.mMinimize = (TraceAbstractionPreferenceInitializer.Minimization)this.mPrefs.getEnum("Minimization of abstraction", TraceAbstractionPreferenceInitializer.Minimization.class);
        this.mAutomataTypeConcurrency = (Concurrency)this.mPrefs.getEnum("Automaton type used in concurrency analysis", Concurrency.class);
        this.mLimitTraceHistogram = this.mPrefs.getInt("Limit trace histogram size");
        this.mErrorLocTimeLimit = this.mPrefs.getInt("Limit analysis time");
        this.mLimitPathProgramCount = this.mPrefs.getInt("Limit path program analysis attempts");
        this.mCollectInterpolantStatistics = this.mPrefs.getBoolean("Compute statistics for interpolant sequences");
        if (this.artifact() == Artifact.NEG_INTERPOLANT_AUTOMATON) {
            throw new IllegalArgumentException("Show negated interpolantautomaton not possible when using difference.");
        }
        if (this.mWatchIteration == 0 && (this.artifact() == Artifact.NEG_INTERPOLANT_AUTOMATON || this.artifact() == Artifact.INTERPOLANT_AUTOMATON)) {
            throw new IllegalArgumentException("There is no interpolantautomaton in iteration 0.");
        }
        this.mHeuristicEmptinessCheck = this.mPrefs.getBoolean("Use heuristic emptiness check");
        this.mHeuristicEmptinessCheckAStarHeuristic = (IsEmptyHeuristic.AStarHeuristic)this.mPrefs.getEnum("AStar heuristic to use during heuristic emptiness check", IsEmptyHeuristic.AStarHeuristic.class);
        this.mHeuristicEmptinessCheckSmtFeatureScoringMethod = (SMTFeatureExtractionTermClassifier.ScoringMethod)this.mPrefs.getEnum("Scoring method to use during heuristic emptiness check", SMTFeatureExtractionTermClassifier.ScoringMethod.class);
        this.mHeuristicEmptinessCheckAStarHeuristicRandomSeed = this.mPrefs.getInt("AStar random heuristic seed");
        this.mSMTFeatureExtraction = this.mPrefs.getBoolean("Extract SMT features during analysis");
        this.mSMTFeatureExtractionDumpPath = this.mPrefs.getString("SMT feature Extraction Dump Path.");
        this.mOverrideInterpolantAutomaton = this.mPrefs.getBoolean("Override the interpolant automaton setting of the refinement strategy");
        this.mMcrInterpolantMethod = (TraceAbstractionPreferenceInitializer.McrInterpolantMethod)this.mPrefs.getEnum("Method to provide additional interpolants for the MCR automaton", TraceAbstractionPreferenceInitializer.McrInterpolantMethod.class);
        this.mPorIndependenceSettings = new IndependenceSettings[this.getNumberOfIndependenceRelations()];
        this.mLbeIndependenceSettings = new IndependenceSettings((IndependenceSettings.IndependenceType)this.mPrefs.getEnum("Independence relation used for large block encoding in concurrent analysis", IndependenceSettings.IndependenceType.class), IndependenceSettings.AbstractionType.NONE, false, this.mPrefs.getBoolean("Use semi-commutativity for large block encoding in concurrent analysis"), IndependenceSettings.DEFAULT_SOLVER, 1000L);
        this.mParallelCegarLoop = this.mPrefs.getBoolean("Use CEGAR loop for Parallel Trace Abstraction");
        this.mThreadLimit = this.mPrefs.getInt("Threadlimit for Parallel CEGAR");
        this.mConsiderOnlyActiveCounterexamplesInIsEmptyParallel = this.mPrefs.getBoolean("Consider only active in Search Strategy");
        this.mMinimizeAbstractionPerWorker = this.mPrefs.getBoolean("Minimize Abstraction every time a worker is done");
        this.mSearchLoopBound = this.mPrefs.getInt("search loop bound");
    }

    public boolean interprocedural() {
        return this.mInterprocedural;
    }

    public boolean stopAfterFirstViolation() {
        return this.mPrefs.getBoolean("Stop after first violation was found");
    }

    public TraceAbstractionPreferenceInitializer.OrderOfErrorLocations getOrderOfErrorLocations() {
        return (TraceAbstractionPreferenceInitializer.OrderOfErrorLocations)this.mPrefs.getEnum("Order of the error locations to be checked", TraceAbstractionPreferenceInitializer.OrderOfErrorLocations.class);
    }

    public boolean readInitialProof() {
        return this.mPrefs.getBoolean("Read initial proof assertions from file if available");
    }

    public TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuse getFloydHoareAutomataReuse() {
        return (TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuse)this.mPrefs.getEnum("Reuse of Floyd-Hoare automata", TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuse.class);
    }

    public TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuseEnhancement getFloydHoareAutomataReuseEnhancement() {
        return (TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuseEnhancement)this.mPrefs.getEnum("Enhance during reuse of Floyd-Hoare automata", TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuseEnhancement.class);
    }

    public SolverBuilder.SolverMode solverMode() {
        return (SolverBuilder.SolverMode)this.mPrefs.getEnum("SMT solver", SolverBuilder.SolverMode.class);
    }

    public String commandExternalSolver() {
        return this.mPrefs.getString("Command for external solver");
    }

    public Logics logicForExternalSolver() {
        return Logics.valueOf((String)this.mPrefs.getString("Logic for external solver"));
    }

    public boolean dumpSmtScriptToFile() {
        return this.mPrefs.getBoolean("Dump SMT script to file");
    }

    public boolean compressDumpedSmtScript() {
        return this.mPrefs.getBoolean("Compress dumped SMT script");
    }

    public String pathOfDumpedScript() {
        return this.mPrefs.getString("To the following directory");
    }

    public int maxIterations() {
        return this.mMaxIterations;
    }

    public int watchIteration() {
        return this.mWatchIteration;
    }

    public Artifact artifact() {
        return this.mArtifact;
    }

    public boolean useSeparateSolverForTracechecks() {
        return this.mPrefs.getBoolean("Use separate solver for trace checks");
    }

    public InterpolationTechnique interpolation() {
        return this.mInterpolation;
    }

    public TraceAbstractionPreferenceInitializer.InterpolantAutomaton interpolantAutomaton() {
        return this.mInterpolantAutomaton;
    }

    public boolean dumpAutomata() {
        return this.mDumpAutomata && !this.mDumpOnlyReuseAutomata;
    }

    public AutomatonDefinitionPrinter.Format getAutomataFormat() {
        return this.mAutomataFormat;
    }

    public String dumpPath() {
        return this.mDumpPath;
    }

    public boolean dumpOnlyReuseAutomata() {
        return this.mDumpAutomata && this.mDumpOnlyReuseAutomata;
    }

    public InterpolantAutomatonEnhancement interpolantAutomatonEnhancement() {
        return this.mDeterminiation;
    }

    public HoareTripleCheckerUtils.HoareTripleChecks getHoareTripleChecks() {
        return this.mHoareTripleChecks;
    }

    public boolean differenceSenwa() {
        return this.mPrefs.getBoolean("DifferenceSenwa operation instead classical Difference");
    }

    public TraceAbstractionPreferenceInitializer.Minimization getMinimization() {
        return this.mMinimize;
    }

    public Concurrency getAutomataTypeConcurrency() {
        return this.mAutomataTypeConcurrency;
    }

    public HoareAnnotationPositions getHoareAnnotationPositions() {
        return this.mHoareAnnotationPositions;
    }

    public boolean computeProcedureContracts() {
        return this.mPrefs.getBoolean("Compute procedure contracts");
    }

    public static boolean separateViolationCheck() {
        return true;
    }

    public boolean cutOffRequiresSameTransition() {
        return this.mPrefs.getBoolean("cut-off requires same transition");
    }

    public boolean unfoldingToNet() {
        return this.mPrefs.getBoolean("Use backfolding");
    }

    public PetriNetUnfolder.EventOrderEnum eventOrder() {
        return (PetriNetUnfolder.EventOrderEnum)this.mPrefs.getEnum("Order on configurations for Petri net unfoldings", PetriNetUnfolder.EventOrderEnum.class);
    }

    public LooperCheck looperCheck() {
        return (LooperCheck)this.mPrefs.getEnum("Looper check in Petri net analysis", LooperCheck.class);
    }

    public boolean applyOneShotLbe() {
        return this.mPrefs.getBoolean("Apply one-shot large block encoding in concurrent analysis");
    }

    public boolean applyOneShotPOR() {
        return this.mPrefs.getBoolean("Apply one-shot Partial Order Reduction to input program");
    }

    public PartialOrderMode getPartialOrderMode() {
        return (PartialOrderMode)this.mPrefs.getEnum("Partial Order Reduction in concurrent analysis", PartialOrderMode.class);
    }

    public boolean dumpIndependenceScript() {
        return this.mPrefs.getBoolean("Dump SMT script used for independence checks");
    }

    public String independenceScriptDumpPath() {
        return this.mPrefs.getString("Dump independence script to the following directory");
    }

    public PartialOrderReductionFacade.OrderType getDfsOrderType() {
        return (PartialOrderReductionFacade.OrderType)this.mPrefs.getEnum("DFS Order used in POR", PartialOrderReductionFacade.OrderType.class);
    }

    public long getDfsOrderSeed() {
        return this.mPrefs.getInt("Random seed used by POR DFS order");
    }

    public TraceAbstractionPreferenceInitializer.CoinflipMode useCoinflip() {
        return (TraceAbstractionPreferenceInitializer.CoinflipMode)this.mPrefs.getEnum("Coinflip budget determination mode", TraceAbstractionPreferenceInitializer.CoinflipMode.class);
    }

    public double getCoinflipProbability(int n) {
        int n2 = this.mPrefs.getInt("Coinflip probability value");
        int n3 = this.mPrefs.getInt("Coinflip probability increment");
        int n4 = Integer.min(100, n2 + n * n3);
        return (double)n4 / 100.0;
    }

    public int coinflipSeed() {
        return this.mPrefs.getInt("Coinflip random seed");
    }

    public int getNumberOfIndependenceRelations() {
        return this.mPrefs.getInt("Number of independence relations to use for POR");
    }

    public IndependenceSettings porIndependenceSettings(int n) {
        if (n < 0 || n >= this.getNumberOfIndependenceRelations()) {
            throw new IllegalArgumentException("Index out of range: " + n + " not between 0 and " + this.getNumberOfIndependenceRelations());
        }
        if (this.mPorIndependenceSettings[n] == null) {
            this.mPorIndependenceSettings[n] = new IndependenceSettings((IndependenceSettings.IndependenceType)this.mPrefs.getEnum(TAPreferences.getLabel("Independence relation used for POR in concurrent analysis", n), (Enum)IndependenceSettings.DEFAULT_INDEPENDENCE_TYPE, IndependenceSettings.IndependenceType.class), (IndependenceSettings.AbstractionType)this.mPrefs.getEnum(TAPreferences.getLabel("Abstraction used for commutativity in POR", n), (Enum)IndependenceSettings.DEFAULT_ABSTRACTION_TYPE, IndependenceSettings.AbstractionType.class), this.mPrefs.getBoolean(TAPreferences.getLabel("Use conditional POR in concurrent analysis", n), true), this.mPrefs.getBoolean(TAPreferences.getLabel("Use semi-commutativity for POR in concurrent analysis", n), true), (SolverBuilder.ExternalSolver)this.mPrefs.getEnum(TAPreferences.getLabel("SMT solver used for commutativity in POR", n), (Enum)IndependenceSettings.DEFAULT_SOLVER, SolverBuilder.ExternalSolver.class), this.mPrefs.getLong(TAPreferences.getLabel("SMT solver timeout for commutativity in POR (in ms)", n), 1000L));
        }
        return this.mPorIndependenceSettings[n];
    }

    private static String getLabel(String string, int n) {
        return TraceAbstractionPreferenceInitializer.getSuffixedLabel(string, n);
    }

    public IndependenceSettings lbeIndependenceSettings() {
        return this.mLbeIndependenceSettings;
    }

    public SmtUtils.SimplificationTechnique getSimplificationTechnique() {
        return (SmtUtils.SimplificationTechnique)this.mPrefs.getEnum("Simplification technique", SmtUtils.SimplificationTechnique.class);
    }

    public boolean fakeNonIncrementalSolver() {
        return this.mPrefs.getBoolean("Fake non-incremental script");
    }

    public TraceAbstractionPreferenceInitializer.RefinementStrategy getRefinementStrategy() {
        return (TraceAbstractionPreferenceInitializer.RefinementStrategy)this.mPrefs.getEnum("Trace refinement strategy", TraceAbstractionPreferenceInitializer.RefinementStrategy.class);
    }

    public TraceAbstractionPreferenceInitializer.RefinementStrategy getMcrRefinementStrategy() {
        return (TraceAbstractionPreferenceInitializer.RefinementStrategy)this.mPrefs.getEnum("Trace refinement strategy used in MCR", TraceAbstractionPreferenceInitializer.RefinementStrategy.class);
    }

    public TraceAbstractionPreferenceInitializer.RefinementStrategy getAcceleratedInterpolationRefinementStrategy() {
        return (TraceAbstractionPreferenceInitializer.RefinementStrategy)this.mPrefs.getEnum("Trace refinement strategy used in Accelerated Interpolation", TraceAbstractionPreferenceInitializer.RefinementStrategy.class);
    }

    public TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist getRefinementStrategyExceptionSpecification() {
        return (TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist)this.mPrefs.getEnum("Trace refinement exception blacklist", TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist.class);
    }

    public boolean hasLimitTraceHistogram() {
        return this.getLimitTraceHistogram() > 0;
    }

    public int getLimitTraceHistogram() {
        return this.mLimitTraceHistogram;
    }

    public boolean hasErrorLocTimeLimit() {
        return this.mErrorLocTimeLimit > 0;
    }

    public LoopAccelerators getLoopAccelerationTechnique() {
        return (LoopAccelerators)this.mPrefs.getEnum("Loop acceleration method that is used by accelerated interpolation", LoopAccelerators.class);
    }

    public int getErrorLocTimeLimit() {
        return this.mErrorLocTimeLimit;
    }

    public boolean hasLimitPathProgramCount() {
        return this.mLimitPathProgramCount > 0;
    }

    public int getLimitPathProgramCount() {
        return this.mLimitPathProgramCount;
    }

    public boolean collectInterpolantStatistics() {
        return this.mCollectInterpolantStatistics;
    }

    public boolean useHeuristicEmptinessCheck() {
        return this.mHeuristicEmptinessCheck;
    }

    public SMTFeatureExtractionTermClassifier.ScoringMethod getHeuristicEmptinessCheckScoringMethod() {
        return this.mHeuristicEmptinessCheckSmtFeatureScoringMethod;
    }

    public IsEmptyHeuristic.AStarHeuristic getHeuristicEmptinessCheckAStarHeuristic() {
        return this.mHeuristicEmptinessCheckAStarHeuristic;
    }

    public Integer getHeuristicEmptinessCheckAStarHeuristicRandomSeed() {
        return this.mHeuristicEmptinessCheckAStarHeuristicRandomSeed;
    }

    public boolean useSMTFeatureExtraction() {
        return this.mSMTFeatureExtraction;
    }

    public String getSMTFeatureExtractionDumpPath() {
        return this.mSMTFeatureExtractionDumpPath;
    }

    public boolean overrideInterpolantAutomaton() {
        return this.mOverrideInterpolantAutomaton;
    }

    public TraceAbstractionPreferenceInitializer.McrInterpolantMethod getMcrInterpolantMethod() {
        return this.mMcrInterpolantMethod;
    }

    public boolean useConditionalCommutativityChecker() {
        return this.getSymbolicRelationMode() != SemanticIndependenceRelation.IndependenceConditions.NONE;
    }

    public SemanticIndependenceRelation.IndependenceConditions getSymbolicRelationMode() {
        return (SemanticIndependenceRelation.IndependenceConditions)this.mPrefs.getEnum("Commutativity condition synthesis", SemanticIndependenceRelation.IndependenceConditions.class);
    }

    public TraceAbstractionPreferenceInitializer.RefinementStrategy getConditionalCommutativityRefinementStrategy() {
        return (TraceAbstractionPreferenceInitializer.RefinementStrategy)this.mPrefs.getEnum("Refinement strategy for commutativity condition synthesis", TraceAbstractionPreferenceInitializer.RefinementStrategy.class);
    }

    public int conditionalCommutativityThreshold() {
        return this.mPrefs.getInt("Path program threshold for commutativity condition synthesis");
    }

    public int conditionalCommutativityRetries() {
        return this.mPrefs.getInt("Maximum retries for commutativity condition synthesis");
    }

    public HoareProofSettings getHoareSettings() {
        return new HoareProofSettings(this.getHoareAnnotationPositions(), this.getSimplificationTechnique());
    }

    public int getThreadLimit() {
        return this.mThreadLimit;
    }

    public boolean isParallelCegarLoop() {
        return this.mParallelCegarLoop;
    }

    public boolean minimizeAbstractionPerWorker() {
        return this.mMinimizeAbstractionPerWorker;
    }

    public boolean considerOnlyActiveCounterexamplesInIsEmptyParallel() {
        return this.mConsiderOnlyActiveCounterexamplesInIsEmptyParallel;
    }

    public int getSearchLoopBound() {
        return this.mSearchLoopBound;
    }

    public static enum Artifact {
        ABSTRACTION,
        INTERPOLANT_AUTOMATON,
        NEG_INTERPOLANT_AUTOMATON,
        RCFG;

    }

    public static enum Concurrency {
        FINITE_AUTOMATA,
        PETRI_NET,
        PARTIAL_ORDER_FA;

    }

    public static enum InterpolantAutomatonEnhancement {
        NONE,
        EAGER,
        EAGER_CONSERVATIVE,
        NO_SECOND_CHANCE,
        PREDICATE_ABSTRACTION,
        PREDICATE_ABSTRACTION_CONSERVATIVE,
        PREDICATE_ABSTRACTION_CANNIBALIZE;

    }

    public static enum LooperCheck {
        SYNTACTIC,
        SEMANTIC;

    }
}

