/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;

public class ComputeFreeVariables
extends NonRecursive {
    static final TermVariable[] NOFREEVARS = new TermVariable[0];

    public void transform(Term term) {
        this.enqueueTerm(term);
        this.run();
    }

    public void enqueueTerm(Term term) {
        this.enqueueWalker(nonRecursive -> this.walkTerm(term));
    }

    public void walkTerm(Term term) {
        if (term.mFreeVars != null) {
            return;
        }
        if (term instanceof ConstantTerm) {
            term.mFreeVars = NOFREEVARS;
        } else if (term instanceof TermVariable) {
            term.mFreeVars = new TermVariable[]{(TermVariable)term};
        } else if (term instanceof ApplicationTerm) {
            this.walkApplicationTerm((ApplicationTerm)term);
        } else if (term instanceof LetTerm) {
            this.walkLetTerm((LetTerm)term);
        } else if (term instanceof AnnotatedTerm) {
            this.walkAnnotatedTerm((AnnotatedTerm)term);
        } else if (term instanceof LambdaTerm) {
            this.walkLambdaTerm((LambdaTerm)term);
        } else if (term instanceof QuantifiedFormula) {
            this.walkQuantifiedFormula((QuantifiedFormula)term);
        } else if (term instanceof MatchTerm) {
            this.walkMatchTerm((MatchTerm)term);
        } else {
            throw new AssertionError((Object)"Unknown Term");
        }
    }

    public void walkApplicationTerm(ApplicationTerm applicationTerm) {
        Term[] termArray;
        boolean bl = false;
        Term[] termArray2 = applicationTerm.getParameters();
        int n = termArray2.length;
        int n2 = 0;
        while (n2 < n) {
            termArray = termArray2[n2];
            if (termArray.mFreeVars == null) {
                if (!bl) {
                    this.enqueueTerm(applicationTerm);
                    bl = true;
                }
                this.enqueueTerm((Term)termArray);
            }
            ++n2;
        }
        if (bl) {
            return;
        }
        termArray = applicationTerm.getParameters();
        if (termArray.length <= 1) {
            applicationTerm.mFreeVars = termArray.length == 1 ? termArray[0].mFreeVars : NOFREEVARS;
        } else {
            Object object;
            n2 = 0;
            n = -1;
            int n3 = 0;
            while (n3 < termArray.length) {
                object = termArray[n3].mFreeVars;
                if (((TermVariable[])object).length > n2) {
                    n2 = ((TermVariable[])object).length;
                    n = n3;
                }
                ++n3;
            }
            if (n < 0) {
                applicationTerm.mFreeVars = NOFREEVARS;
            } else {
                ArrayList<TermVariable> arrayList = null;
                object = Arrays.asList(termArray[n].mFreeVars);
                int n4 = 0;
                while (n4 < termArray.length) {
                    if (n4 != n) {
                        TermVariable[] termVariableArray;
                        TermVariable[] termVariableArray2 = termVariableArray = termArray[n4].getFreeVars();
                        int n5 = termVariableArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            TermVariable termVariable = termVariableArray2[n6];
                            if (!object.contains(termVariable)) {
                                if (arrayList == null) {
                                    arrayList = new ArrayList<TermVariable>();
                                    arrayList.addAll((Collection<TermVariable>)object);
                                }
                                if (!arrayList.contains(termVariable)) {
                                    arrayList.add(termVariable);
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                applicationTerm.mFreeVars = arrayList == null ? termArray[n].mFreeVars : arrayList.toArray(new TermVariable[arrayList.size()]);
            }
        }
    }

    public void walkLetTerm(LetTerm letTerm) {
        Term term;
        Term[] termArray;
        boolean bl = false;
        Object object = termArray = letTerm.getValues();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            term = object[n2];
            if (term.mFreeVars == null) {
                if (!bl) {
                    this.enqueueTerm(letTerm);
                    bl = true;
                }
                this.enqueueTerm(term);
            }
            ++n2;
        }
        term = letTerm.getSubTerm();
        if (term.mFreeVars == null) {
            if (!bl) {
                this.enqueueTerm(letTerm);
                bl = true;
            }
            this.enqueueTerm(term);
        }
        if (bl) {
            return;
        }
        TermVariable[] termVariableArray = letTerm.getVariables();
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        linkedHashSet.addAll(Arrays.asList(term.mFreeVars));
        linkedHashSet.removeAll(Arrays.asList(termVariableArray));
        Term[] termArray2 = termArray;
        int n3 = termArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = termArray2[n4];
            linkedHashSet.addAll(Arrays.asList(object.mFreeVars));
            ++n4;
        }
        letTerm.mFreeVars = linkedHashSet.isEmpty() ? NOFREEVARS : linkedHashSet.toArray(new TermVariable[linkedHashSet.size()]);
    }

    public void walkLambdaTerm(LambdaTerm lambdaTerm) {
        Term term = lambdaTerm.getSubterm();
        if (term.mFreeVars == null) {
            this.enqueueTerm(lambdaTerm);
            this.enqueueTerm(term);
            return;
        }
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        linkedHashSet.addAll(Arrays.asList(term.mFreeVars));
        linkedHashSet.removeAll(Arrays.asList(lambdaTerm.getVariables()));
        lambdaTerm.mFreeVars = linkedHashSet.isEmpty() ? NOFREEVARS : linkedHashSet.toArray(new TermVariable[linkedHashSet.size()]);
    }

    public void walkQuantifiedFormula(QuantifiedFormula quantifiedFormula) {
        Term term = quantifiedFormula.getSubformula();
        if (term.mFreeVars == null) {
            this.enqueueTerm(quantifiedFormula);
            this.enqueueTerm(term);
            return;
        }
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        linkedHashSet.addAll(Arrays.asList(term.mFreeVars));
        linkedHashSet.removeAll(Arrays.asList(quantifiedFormula.getVariables()));
        quantifiedFormula.mFreeVars = linkedHashSet.isEmpty() ? NOFREEVARS : linkedHashSet.toArray(new TermVariable[linkedHashSet.size()]);
    }

    public void walkAnnotatedTerm(AnnotatedTerm annotatedTerm) {
        Annotation annotation;
        boolean bl = false;
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        Term term = annotatedTerm.getSubterm();
        if (term.mFreeVars == null) {
            if (!bl) {
                this.enqueueTerm(annotatedTerm);
                bl = true;
            }
            this.enqueueTerm(term);
        } else {
            linkedHashSet.addAll(Arrays.asList(term.mFreeVars));
        }
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        Annotation[] annotationArray = annotatedTerm.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            annotation = annotationArray[n2];
            if (annotation.getValue() != null) {
                arrayDeque.add(annotation.getValue());
            }
            ++n2;
        }
        while (!arrayDeque.isEmpty()) {
            annotation = arrayDeque.removeLast();
            if (annotation instanceof Term) {
                Term term2 = (Term)((Object)annotation);
                if (term2.mFreeVars == null) {
                    if (!bl) {
                        this.enqueueTerm(annotatedTerm);
                        bl = true;
                    }
                    this.enqueueTerm(term2);
                    continue;
                }
                if (bl) continue;
                linkedHashSet.addAll(Arrays.asList(((Term)((Object)annotation)).mFreeVars));
                continue;
            }
            if (!(annotation instanceof Object[])) continue;
            Object[] objectArray = (Object[])annotation;
            int n3 = objectArray.length;
            n = 0;
            while (n < n3) {
                Object object = objectArray[n];
                arrayDeque.add(object);
                ++n;
            }
        }
        if (!bl) {
            annotatedTerm.mFreeVars = linkedHashSet.isEmpty() ? NOFREEVARS : (linkedHashSet.size() == term.mFreeVars.length ? term.mFreeVars : linkedHashSet.toArray(new TermVariable[linkedHashSet.size()]));
        }
    }

    public void walkMatchTerm(MatchTerm matchTerm) {
        Term term;
        boolean bl = false;
        Term[] termArray = matchTerm.getCases();
        Object object = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            term = object[n2];
            if (term.mFreeVars == null) {
                if (!bl) {
                    this.enqueueTerm(matchTerm);
                    bl = true;
                }
                this.enqueueTerm(term);
            }
            ++n2;
        }
        term = matchTerm.getDataTerm();
        if (term.mFreeVars == null) {
            if (!bl) {
                this.enqueueTerm(matchTerm);
                bl = true;
            }
            this.enqueueTerm(term);
        }
        if (bl) {
            return;
        }
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        n = 0;
        while (n < termArray.length) {
            object = new LinkedHashSet();
            ((AbstractCollection)object).addAll(Arrays.asList(termArray[n].mFreeVars));
            ((AbstractSet)object).removeAll(Arrays.asList(matchTerm.getVariables()[n]));
            linkedHashSet.addAll((Collection<TermVariable>)object);
            ++n;
        }
        linkedHashSet.addAll(Arrays.asList(term.mFreeVars));
        matchTerm.mFreeVars = linkedHashSet.isEmpty() ? NOFREEVARS : (linkedHashSet.size() == term.mFreeVars.length ? term.mFreeVars : linkedHashSet.toArray(new TermVariable[linkedHashSet.size()]));
    }
}

