/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;

public class UndoableWrapperScript
extends WrapperScript {
    private int mDirtyStackLevels = 0;

    public UndoableWrapperScript(Script script) {
        super(script);
        this.push(1);
    }

    public void push(int n) throws SMTLIBException {
        assert (n > 0);
        super.push(n);
        this.mDirtyStackLevels += n;
    }

    public void pop(int n) throws SMTLIBException {
        assert (n > 0);
        super.pop(n);
        this.mDirtyStackLevels -= n;
        if (this.mDirtyStackLevels < 0) {
            throw new AssertionError((Object)"You removed more stack levels than tracked by UndoableWrapperScript");
        }
    }

    public void resetAssertions() {
        throw new UnsupportedOperationException(String.valueOf(UndoableWrapperScript.class) + " cannot restore anymore because it does not know what was on the stack before its creation");
    }

    public void reset() {
        throw new UnsupportedOperationException(String.valueOf(UndoableWrapperScript.class) + " cannot restore anymore because it does not know what was on the stack before its creation");
    }

    public int restore() {
        int n = this.mDirtyStackLevels;
        this.pop(this.mDirtyStackLevels);
        return n;
    }
}

