/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.UnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.HashSet;

public class TranslationConstrainer {
    private final ManagedScript mMgdScript;
    private final Script mScript;
    private FunctionSymbol mIntand;
    public final ConstraintsForBitwiseOperations mMode;
    private final HashSet<Term> mConstraintSet;
    private final HashSet<Term> mTvConstraintSet;
    private final HashSet<Term> mBvandConstraintSet;

    public TranslationConstrainer(ManagedScript managedScript, ConstraintsForBitwiseOperations constraintsForBitwiseOperations) {
        this.mMgdScript = managedScript;
        this.mScript = managedScript.getScript();
        this.mMode = constraintsForBitwiseOperations;
        this.mConstraintSet = new HashSet();
        this.mBvandConstraintSet = new HashSet();
        this.mTvConstraintSet = new HashSet();
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        Sort[] sortArray = new Sort[]{sort, sort};
        if (this.mIntand == null) {
            if (this.mScript.getFunctionSymbol("intand") == null) {
                this.mScript.declareFun("intand", sortArray, sort);
            }
            this.mIntand = this.mScript.getFunctionSymbol("intand");
        }
    }

    public HashSet<Term> getConstraints() {
        return this.mConstraintSet;
    }

    public HashSet<Term> getBvandConstraints() {
        return this.mBvandConstraintSet;
    }

    public HashSet<Term> getTvConstraints() {
        return this.mTvConstraintSet;
    }

    public FunctionSymbol getIntAndFunctionSymbol() {
        return this.mIntand;
    }

    private Term getLowerVarBounds(Term term, Term term2) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        Term term3 = term2;
        Term term4 = this.mScript.term("<=", new Term[]{Rational.ZERO.toTerm(sort), term3});
        return term4;
    }

    private Term getUpperVarBounds(Term term, Term term2) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        int n = Integer.valueOf(term.getSort().getIndices()[0]);
        Term term3 = term2;
        Rational rational = Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(n), (BigInteger)BigInteger.ONE);
        Rational rational2 = rational.sub(Rational.ONE);
        Term term4 = this.mScript.term("<", new Term[]{term3, SmtUtils.rational2Term(this.mScript, rational, sort)});
        this.mScript.term("<=", new Term[]{term3, SmtUtils.rational2Term(this.mScript, rational2, sort)});
        return term4;
    }

    public void varConstraint(Term term, Term term2) {
        this.mConstraintSet.add(this.getLowerVarBounds(term, term2));
        this.mConstraintSet.add(this.getUpperVarBounds(term, term2));
    }

    public Term getTvConstraint(TermVariable termVariable, Term term) {
        Term term2 = this.getLowerVarBounds((Term)termVariable, term);
        Term term3 = this.getUpperVarBounds((Term)termVariable, term);
        this.mTvConstraintSet.add(term2);
        this.mTvConstraintSet.add(term3);
        return this.mScript.term("and", new Term[]{term2, term3});
    }

    public Term getSelectConstraint(Term term, Term term2) {
        Term term3 = this.getLowerVarBounds(term, term2);
        Term term4 = this.getUpperVarBounds(term, term2);
        return this.mScript.term("and", new Term[]{term3, term4});
    }

    public boolean bvandConstraint(Term term, int n) {
        if (this.mMode.equals((Object)ConstraintsForBitwiseOperations.NONE)) {
            return true;
        }
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        if (!SmtSortUtils.isIntSort(term.getSort())) {
            throw new UnsupportedOperationException("Cannot create Constraints vor non-Int Sort Terms");
        }
        if (term instanceof ApplicationTerm) {
            Term term2;
            Term term3;
            Object object;
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            Term term4 = applicationTerm.getParameters()[0];
            Term term5 = applicationTerm.getParameters()[1];
            Rational rational = Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(n), (BigInteger)BigInteger.ONE);
            Term term6 = this.mScript.term("true", new Term[0]);
            switch (this.mMode) {
                case SUM: {
                    object = this.mScript.term("<=", new Term[]{Rational.ZERO.toTerm(sort), applicationTerm});
                    term3 = this.mScript.term("<", new Term[]{applicationTerm, SmtUtils.rational2Term(this.mScript, rational, sort)});
                    this.mBvandConstraintSet.add((Term)object);
                    this.mBvandConstraintSet.add(term3);
                    term2 = this.bvandSUMConstraints(n, term4, term5);
                    break;
                }
                case BITWISE: {
                    object = this.mScript.term("<=", new Term[]{Rational.ZERO.toTerm(sort), applicationTerm});
                    term3 = this.mScript.term("<", new Term[]{applicationTerm, SmtUtils.rational2Term(this.mScript, rational, sort)});
                    this.mConstraintSet.add((Term)object);
                    this.mConstraintSet.add(term3);
                    this.mBvandConstraintSet.add((Term)object);
                    this.mBvandConstraintSet.add(term3);
                    term2 = this.bvandBITWISEConstraints(n, term4, term5);
                    break;
                }
                case LAZY: {
                    Term term7 = this.mScript.term("<=", new Term[]{Rational.ZERO.toTerm(sort), applicationTerm});
                    Term term8 = this.mScript.term("<", new Term[]{applicationTerm, SmtUtils.rational2Term(this.mScript, rational, sort)});
                    term6 = this.bvandLAZYConstraints(n, term4, term5);
                    this.mConstraintSet.add(term7);
                    this.mConstraintSet.add(term8);
                    this.mConstraintSet.add(term6);
                    this.mBvandConstraintSet.add(term7);
                    this.mBvandConstraintSet.add(term8);
                    this.mBvandConstraintSet.add(term6);
                    return true;
                }
                case NONE: {
                    throw new UnsupportedOperationException("Deal with this mode at the beginning of this method");
                }
                default: {
                    throw new UnsupportedOperationException("Set Mode for bvand Constraints");
                }
            }
            object = new UnfTransformer(this.mScript);
            term3 = object.transform(term2);
            this.mConstraintSet.add(term3);
            this.mBvandConstraintSet.add(term3);
            return false;
        }
        throw new AssertionError((Object)"method must be called on IntAnd");
    }

    private Term bvandSUMConstraints(int n, Term term, Term term2) {
        Term term3 = this.bvandSUMforReplacement(n, term, term2);
        if (n == 1) {
            return SmtUtils.binaryEquality(this.mScript, this.mScript.term(this.mIntand.getName(), new Term[]{term, term2}), term3);
        }
        return SmtUtils.binaryEquality(this.mScript, this.mScript.term(this.mIntand.getName(), new Term[]{term, term2}), term3);
    }

    public Term bvandSUMforReplacement(int n, Term term, Term term2) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        BigInteger bigInteger = BigInteger.valueOf(2L);
        Term[] termArray = new Term[n];
        int n2 = 0;
        while (n2 < n) {
            Term term3;
            Term term4 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)bigInteger.pow(n2), (BigInteger)BigInteger.ONE), sort);
            Term term5 = SmtUtils.rational2Term(this.mScript, Rational.ONE, sort);
            Term term6 = SmtUtils.rational2Term(this.mScript, Rational.ZERO, sort);
            Term term7 = this.mScript.term("ite", new Term[]{this.mScript.term("=", new Term[]{this.isel(n2, term), this.isel(n2, term2), term5}), term5, term6});
            termArray[n2] = term3 = this.mScript.term("*", new Term[]{term4, term7});
            ++n2;
        }
        if (n == 1) {
            return termArray[0];
        }
        return this.mScript.term("+", termArray);
    }

    private Term bvandBITWISEConstraints(int n, Term term, Term term2) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        Term[] termArray = new Term[n];
        int n2 = 0;
        while (n2 < n) {
            Term term3;
            Term term4 = SmtUtils.rational2Term(this.mScript, Rational.ONE, sort);
            Term term5 = SmtUtils.rational2Term(this.mScript, Rational.ZERO, sort);
            Term term6 = this.mScript.term("ite", new Term[]{this.mScript.term("=", new Term[]{this.isel(n2, term), this.isel(n2, term2), term4}), term4, term5});
            termArray[n2] = term3 = this.mScript.term("=", new Term[]{this.isel(n2, this.mScript.term(this.mIntand.getName(), new Term[]{term, term2})), term6});
            ++n2;
        }
        return SmtUtils.and(this.mScript, termArray);
    }

    private Term bvandLAZYConstraints(int n, Term term, Term term2) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        Term term3 = SmtUtils.rational2Term(this.mScript, Rational.ZERO, sort);
        Term term4 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(n), (BigInteger)BigInteger.ONE), sort);
        Term[] termArray = new Term[8];
        Term term5 = this.mScript.term(this.mIntand.getName(), new Term[]{term, term2});
        termArray[0] = this.mScript.term("<=", new Term[]{term5, term});
        termArray[1] = this.mScript.term("<=", new Term[]{term5, term2});
        termArray[2] = this.mScript.term("=>", new Term[]{this.mScript.term("=", new Term[]{term, term2}), this.mScript.term("=", new Term[]{term5, term})});
        termArray[3] = this.mScript.term("=", new Term[]{term5, this.mScript.term(this.mIntand.getName(), new Term[]{term2, term})});
        termArray[4] = this.mScript.term("=>", new Term[]{this.mScript.term("=", new Term[]{term, term3}), this.mScript.term("=", new Term[]{term5, term3})});
        termArray[5] = this.mScript.term("=>", new Term[]{this.mScript.term("=", new Term[]{term3, term2}), this.mScript.term("=", new Term[]{term5, term3})});
        termArray[6] = this.mScript.term("=>", new Term[]{this.mScript.term("=", new Term[]{term, term4}), this.mScript.term("=", new Term[]{term5, term2})});
        termArray[7] = this.mScript.term("=>", new Term[]{this.mScript.term("=", new Term[]{term4, term2}), this.mScript.term("=", new Term[]{term5, term})});
        return this.mScript.term("and", termArray);
    }

    private Term isel(int n, Term term) {
        Sort sort = SmtSortUtils.getIntSort(this.mScript);
        Term term2 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L), (BigInteger)BigInteger.ONE), sort);
        Term term3 = SmtUtils.rational2Term(this.mScript, Rational.valueOf((BigInteger)BigInteger.valueOf(2L).pow(n), (BigInteger)BigInteger.ONE), sort);
        return this.mScript.term("mod", new Term[]{this.mScript.term("div", new Term[]{term, term3}), term2});
    }

    public static enum ConstraintsForBitwiseOperations {
        SUM,
        BITWISE,
        LAZY,
        NONE;

    }
}

