/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ITermProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SupportingTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Case
implements ITermProvider {
    protected final SolvedBinaryRelation mSolvedBinaryRelation;
    protected final Set<SupportingTerm> mSupportingTerms;
    protected final MultiCaseSolvedBinaryRelation.Xnf mXnf;

    public Case(SolvedBinaryRelation solvedBinaryRelation, Set<SupportingTerm> set, MultiCaseSolvedBinaryRelation.Xnf xnf) {
        this.mSolvedBinaryRelation = solvedBinaryRelation;
        this.mSupportingTerms = set;
        this.mXnf = xnf;
    }

    public SolvedBinaryRelation getSolvedBinaryRelation() {
        return this.mSolvedBinaryRelation;
    }

    public Set<SupportingTerm> getSupportingTerms() {
        return Collections.unmodifiableSet(this.mSupportingTerms);
    }

    public Set<TermVariable> getAuxiliaryVariables() {
        return this.mSupportingTerms.stream().flatMap(supportingTerm -> supportingTerm.getNewAuxiliaryVariables().stream()).collect(Collectors.toSet());
    }

    public Stream<MultiCaseSolvedBinaryRelation.IntricateOperation> streamOfIntricateOperations() {
        if (this.mSolvedBinaryRelation != null && this.mSolvedBinaryRelation.getIntricateOperation() != null) {
            return Stream.concat(this.mSolvedBinaryRelation.getIntricateOperation().stream(), this.getSupportingTerms().stream().map(supportingTerm -> supportingTerm.getIntricateOperation()));
        }
        return this.getSupportingTerms().stream().map(supportingTerm -> supportingTerm.getIntricateOperation());
    }

    @Override
    public Term toTerm(Script script) {
        Collection collection = this.mSupportingTerms.stream().map(supportingTerm -> supportingTerm.getTerm()).collect(Collectors.toList());
        if (this.mSolvedBinaryRelation != null) {
            collection.add(this.mSolvedBinaryRelation.toTerm(script));
        }
        return switch (this.mXnf) {
            case MultiCaseSolvedBinaryRelation.Xnf.CNF -> SmtUtils.or(script, collection);
            case MultiCaseSolvedBinaryRelation.Xnf.DNF -> SmtUtils.and(script, collection);
            default -> throw new MatchException(null, null);
        };
    }

    public String toString() {
        String string = switch (this.mXnf) {
            case MultiCaseSolvedBinaryRelation.Xnf.CNF -> " \\/ ";
            case MultiCaseSolvedBinaryRelation.Xnf.DNF -> " /\\ ";
            default -> throw new MatchException(null, null);
        };
        Object object = this.mSolvedBinaryRelation == null ? "{" : "{" + this.mSolvedBinaryRelation.toString();
        for (SupportingTerm supportingTerm : this.mSupportingTerms) {
            object = object == "{" ? (String)object + supportingTerm.toString() : (String)object + string + supportingTerm.toString();
        }
        object = (String)object + "}";
        return object;
    }
}

