/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;

public class FenvLibraryModel
implements ILibraryModel {
    public static final BigInteger FE_DOWNWARD = BigInteger.valueOf(1024L);
    public static final BigInteger FE_TONEAREST = BigInteger.ZERO;
    public static final BigInteger FE_TOWARDZERO = BigInteger.valueOf(3072L);
    public static final BigInteger FE_UPWARD = BigInteger.valueOf(2048L);
    private final FunctionModelHelper mHelper;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final ExpressionTranslation mExpressionTranslation;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;

    public FenvLibraryModel(FunctionModelHelper functionModelHelper, ExpressionResultTransformer expressionResultTransformer, ExpressionTranslation expressionTranslation, AuxVarInfoBuilder auxVarInfoBuilder) {
        this.mHelper = functionModelHelper;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mExpressionTranslation = expressionTranslation;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        return List.of(new ILibraryModel.FunctionModel("fegetround", this::handleBuiltinFegetround), new ILibraryModel.FunctionModel("fesetround", this::handleBuiltinFesetround));
    }

    @Override
    public Collection<String> getUnsupportedFunctions() {
        return List.of("feclearexcept", "fegetexceptflag", "feraiseexcept", "fesetexceptflag", "fetestexcept", "fegetenv", "feholdexcept", "fesetenv", "feupdateenv");
    }

    private Result handleBuiltinFegetround(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 0, string, iASTInitializerClauseArray);
        RValue rValue = this.mExpressionTranslation.constructBuiltinFegetround(iLocation);
        return new ExpressionResultBuilder().setLrValue(rValue).build();
    }

    private Result handleBuiltinFesetround(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.convertIfNecessary(iLocation, expressionResult, new CPrimitive(CPrimitive.CPrimitives.INT));
        return this.mExpressionTranslation.constructBuiltinFesetround(iLocation, expressionResult2, this.mAuxVarInfoBuilder);
    }

    @Override
    public Collection<ILibraryModel.ConstantModel> getConstantModels() {
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        return List.of(new ILibraryModel.ConstantModel("FE_DOWNWARD", iLocation -> this.mHelper.constructIntegerLiteral(iLocation, FE_DOWNWARD, cPrimitive)), new ILibraryModel.ConstantModel("FE_TONEAREST", iLocation -> this.mHelper.constructIntegerLiteral(iLocation, FE_TONEAREST, cPrimitive)), new ILibraryModel.ConstantModel("FE_TOWARDZERO", iLocation -> this.mHelper.constructIntegerLiteral(iLocation, FE_TOWARDZERO, cPrimitive)), new ILibraryModel.ConstantModel("FE_UPWARD", iLocation -> this.mHelper.constructIntegerLiteral(iLocation, FE_UPWARD, cPrimitive)));
    }
}

