/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa;

import de.uni_freiburg.informatik.ultimate.lib.sifa.IWorklistWithInputs;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BinaryOperator;

public class FifoWorklist<W, I>
implements IWorklistWithInputs<W, I> {
    private final BinaryOperator<I> mMergeFunction;
    private final Map<W, I> mWorklist = new LinkedHashMap<W, I>();
    private Map.Entry<W, I> mRemovedEntry;

    public FifoWorklist(BinaryOperator<I> binaryOperator) {
        this.mMergeFunction = binaryOperator;
    }

    @Override
    public void add(W w, I i) {
        this.mWorklist.merge(w, i, this.mMergeFunction);
    }

    @Override
    public boolean advance() {
        if (this.mWorklist.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<W, I>> iterator = this.mWorklist.entrySet().iterator();
        this.mRemovedEntry = iterator.next();
        iterator.remove();
        return true;
    }

    private void ensureAdvanced() {
        if (this.mRemovedEntry == null) {
            throw new IllegalStateException("Never called advance() on this worklist.");
        }
    }

    @Override
    public W getWork() {
        this.ensureAdvanced();
        return this.mRemovedEntry.getKey();
    }

    @Override
    public I getInput() {
        this.ensureAdvanced();
        return this.mRemovedEntry.getValue();
    }

    public String toString() {
        return this.mWorklist.toString();
    }
}

