/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomatonCache;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class NestedWordAutomatonOnDemandStateAndLetter<LETTER, STATE>
implements INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> {
    protected final AutomataLibraryServices mServices;
    protected final NestedWordAutomatonCache<LETTER, STATE> mCache;
    protected final Set<LETTER> mInternalAlphabet;
    protected final Set<LETTER> mCallAlphabet;
    protected final Set<LETTER> mReturnAlphabet;
    private final VpAlphabet<LETTER> mVpAlphabet;
    protected boolean mInitialStateHaveBeenConstructed;
    private final Set<STATE> mInternalSuccessorsConstruted;
    private final Set<STATE> mCallSuccessorsConstruted;
    private final HashRelation<STATE, STATE> mReturnSuccessorsConstruted;

    public NestedWordAutomatonOnDemandStateAndLetter(AutomataLibraryServices automataLibraryServices, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory) {
        this.mServices = automataLibraryServices;
        this.mInternalSuccessorsConstruted = new HashSet<STATE>();
        this.mCallSuccessorsConstruted = new HashSet<STATE>();
        this.mReturnSuccessorsConstruted = new HashRelation();
        this.mInternalAlphabet = new HashSet<LETTER>();
        this.mCallAlphabet = new HashSet<LETTER>();
        this.mReturnAlphabet = new HashSet<LETTER>();
        this.mVpAlphabet = new VpAlphabet<LETTER>(this.mInternalAlphabet, this.mCallAlphabet, this.mReturnAlphabet);
        this.mCache = new NestedWordAutomatonCache<LETTER, STATE>(this.mServices, this.mVpAlphabet, iEmptyStackStateFactory);
    }

    protected abstract void constructInitialStates() throws AutomataOperationCanceledException;

    protected abstract void constructInternalSuccessors(STATE var1);

    protected abstract void constructCallSuccessors(STATE var1);

    protected abstract void constructReturnSuccessors(STATE var1, STATE var2);

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mVpAlphabet;
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mCache.getEmptyStackState();
    }

    @Override
    public int size() {
        return this.mCache.size();
    }

    @Override
    public Collection<STATE> getInitialStates() {
        if (!this.mInitialStateHaveBeenConstructed) {
            throw new AssertionError((Object)"initial states not constructed");
        }
        return this.mCache.getInitialStates();
    }

    @Override
    public Set<LETTER> lettersInternal(STATE STATE) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<LETTER> lettersCall(STATE STATE) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE, STATE STATE2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        if (!this.mInternalSuccessorsConstruted.contains(STATE)) {
            this.constructInternalSuccessors(STATE);
            this.mInternalSuccessorsConstruted.add(STATE);
        }
        return this.mCache.internalSuccessors(STATE);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE) {
        if (!this.mCallSuccessorsConstruted.contains(STATE)) {
            this.constructCallSuccessors(STATE);
            this.mCallSuccessorsConstruted.add(STATE);
        }
        return this.mCache.callSuccessors(STATE);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE STATE, STATE STATE2) {
        if (!this.mReturnSuccessorsConstruted.containsPair(STATE, STATE2)) {
            this.constructReturnSuccessors(STATE, STATE2);
            this.mReturnSuccessorsConstruted.addPair(STATE, STATE2);
        }
        return this.mCache.returnSuccessorsGivenHier(STATE, STATE2);
    }

    @Override
    public String sizeInformation() {
        return this.mCache.sizeInformation();
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mCache.isInitial(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mCache.isFinal(STATE);
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mCache.getStateFactory();
    }
}

