/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.Horn3Array;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.Horn3Clause;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.IntArray;

final class Solver {
    public static final char NONE = '\u0000';
    public static final char TRUE = '\u0001';
    public static final char FALSE = '\u0002';
    private final AutomataLibraryServices mServices;
    private final int mNumVars;
    private final Horn3Array mClauses;
    private final IntArray[] mOccur;
    private final char[] mAssign;
    private final IntArray mOp;
    private final Horn3Clause mClause;

    Solver(AutomataLibraryServices automataLibraryServices, Horn3Array horn3Array) {
        this.mServices = automataLibraryServices;
        this.mClauses = horn3Array;
        this.mClause = new Horn3Clause(-1, -1, -1);
        int n = 2;
        for (Horn3Clause horn3Clause : horn3Array) {
            assert (horn3Clause.mX >= 0);
            assert (horn3Clause.mY >= 0);
            assert (horn3Clause.mZ >= 0);
            n = Math.max(n, horn3Clause.mX + 1);
            n = Math.max(n, horn3Clause.mY + 1);
            n = Math.max(n, horn3Clause.mZ + 1);
        }
        this.mNumVars = n;
        this.mAssign = new char[this.mNumVars];
        this.mOp = new IntArray();
        this.mOccur = new IntArray[this.mNumVars];
        int n2 = 0;
        while (n2 < this.mNumVars) {
            this.mOccur[n2] = new IntArray();
            ++n2;
        }
        n2 = 0;
        while (n2 < horn3Array.size()) {
            horn3Array.get(n2, this.mClause);
            this.mOccur[this.mClause.mX].add(n2);
            this.mOccur[this.mClause.mY].add(n2);
            this.mOccur[this.mClause.mZ].add(n2);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.mNumVars) {
            this.mAssign[n2] = '\u0000';
            ++n2;
        }
        this.mAssign[1] = '\u0001';
        this.mAssign[0] = 2;
    }

    private void setVar(int n, char c) {
        assert (c != '\u0000');
        assert (this.mAssign[n] == '\u0000');
        this.mOp.add(n);
        this.mAssign[n] = c;
    }

    private Sat check(Horn3Clause horn3Clause) {
        if (this.mAssign[horn3Clause.mX] == '\u0001' && this.mAssign[horn3Clause.mY] == '\u0001' && this.mAssign[horn3Clause.mZ] == '\u0002') {
            return Sat.UNSATISFIABLE;
        }
        if (this.mAssign[horn3Clause.mX] == '\u0000' && this.mAssign[horn3Clause.mY] == '\u0001' && this.mAssign[horn3Clause.mZ] == '\u0002') {
            this.setVar(horn3Clause.mX, '\u0002');
        } else if (this.mAssign[horn3Clause.mX] == '\u0001' && this.mAssign[horn3Clause.mY] == '\u0000' && this.mAssign[horn3Clause.mZ] == '\u0002') {
            this.setVar(horn3Clause.mY, '\u0002');
        } else if (this.mAssign[horn3Clause.mX] == '\u0001' && this.mAssign[horn3Clause.mY] == '\u0001' && this.mAssign[horn3Clause.mZ] == '\u0000') {
            this.setVar(horn3Clause.mZ, '\u0001');
        }
        return Sat.OK;
    }

    private Sat propagate() {
        int n = 0;
        while (n < this.mOp.size()) {
            for (int n2 : this.mOccur[this.mOp.get(n)]) {
                if (this.check(this.mClauses.get(n2, this.mClause)) != Sat.UNSATISFIABLE) continue;
                return Sat.UNSATISFIABLE;
            }
            ++n;
        }
        return Sat.OK;
    }

    private Sat setAndPropagate(int n, char c) {
        assert (this.mOp.size() == 0);
        this.setVar(n, c);
        if (this.propagate() == Sat.UNSATISFIABLE) {
            for (int n2 : this.mOp) {
                this.mAssign[n2] = '\u0000';
            }
            this.mOp.clear();
            return Sat.UNSATISFIABLE;
        }
        this.mOp.clear();
        return Sat.OK;
    }

    char[] solve() {
        assert (this.mOp.size() == 0);
        for (Horn3Clause horn3Clause : this.mClauses) {
            if (this.check(horn3Clause) != Sat.UNSATISFIABLE) continue;
            return null;
        }
        if (this.propagate() == Sat.UNSATISFIABLE) {
            return null;
        }
        this.mOp.clear();
        int n = 0;
        while (n < this.mNumVars) {
            if (this.mAssign[n] == '\u0000' && this.setAndPropagate(n, '\u0001') == Sat.UNSATISFIABLE && this.setAndPropagate(n, '\u0002') == Sat.UNSATISFIABLE) assert (false);
            ++n;
        }
        for (Horn3Clause horn3Clause : this.mClauses) {
            assert (this.mAssign[horn3Clause.mX] == '\u0002' || this.mAssign[horn3Clause.mY] == '\u0002' || this.mAssign[horn3Clause.mZ] == '\u0001');
        }
        return this.mAssign;
    }

    private void checkTimeout() throws AutomataOperationCanceledException {
        if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
            throw new AutomataOperationCanceledException(this.getClass());
        }
    }

    private static enum Sat {
        OK,
        UNSATISFIABLE;

    }
}

