/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IPersistentSetChoice;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.FilteredIterable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public final class PersistentSetReduction<L, S>
implements INwaOutgoingLetterAndTransitionProvider<L, S> {
    private final INwaOutgoingLetterAndTransitionProvider<L, S> mOperand;
    private final IPersistentSetChoice<L, S> mPersistentSets;

    public PersistentSetReduction(INwaOutgoingLetterAndTransitionProvider<L, S> iNwaOutgoingLetterAndTransitionProvider, IPersistentSetChoice<L, S> iPersistentSetChoice) {
        assert (NestedWordAutomataUtils.isFiniteAutomaton(iNwaOutgoingLetterAndTransitionProvider)) : "Only finite automata are supported";
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mPersistentSets = iPersistentSetChoice;
    }

    @Override
    public IStateFactory<S> getStateFactory() {
        return this.mOperand.getStateFactory();
    }

    @Override
    public VpAlphabet<L> getVpAlphabet() {
        return this.mOperand.getVpAlphabet();
    }

    @Override
    public S getEmptyStackState() {
        return (S)this.mOperand.getEmptyStackState();
    }

    @Override
    public Iterable<S> getInitialStates() {
        return this.mOperand.getInitialStates();
    }

    @Override
    public boolean isInitial(S s) {
        return this.mOperand.isInitial(s);
    }

    @Override
    public boolean isFinal(S s) {
        return this.mOperand.isFinal(s);
    }

    @Override
    public int size() {
        return this.mOperand.size();
    }

    @Override
    public String sizeInformation() {
        return this.mOperand.sizeInformation();
    }

    @Override
    public Set<L> lettersInternal(S s) {
        Set<L> set = this.mOperand.lettersInternal(s);
        Set<L> set2 = this.mPersistentSets.persistentSet(s);
        if (set2 == null) {
            return set;
        }
        return DataStructureUtils.difference(set, set2);
    }

    @Override
    public Iterable<OutgoingInternalTransition<L, S>> internalSuccessors(S s) {
        Set set = this.mPersistentSets.persistentSet(s);
        if (set == null) {
            return this.mOperand.internalSuccessors(s);
        }
        return new FilteredIterable(this.mOperand.internalSuccessors(s), outgoingInternalTransition -> set.contains(outgoingInternalTransition.getLetter()));
    }

    @Override
    public Iterable<OutgoingInternalTransition<L, S>> internalSuccessors(S s, L l) {
        Set<L> set = this.mPersistentSets.persistentSet(s);
        if (set == null || set.contains(l)) {
            return this.mOperand.internalSuccessors(s, l);
        }
        return Collections.emptyList();
    }

    @Override
    public Iterable<OutgoingCallTransition<L, S>> callSuccessors(S s, L l) {
        return this.mOperand.callSuccessors(s, l);
    }

    @Override
    public Iterable<OutgoingReturnTransition<L, S>> returnSuccessors(S s, S s2, L l) {
        return this.mOperand.returnSuccessors(s, s2, l);
    }

    public static <L, S> IDfsOrder<L, S> ensureCompatibility(IPersistentSetChoice<L, S> iPersistentSetChoice, IDfsOrder<L, S> iDfsOrder) {
        return new CompatibleDfsOrder<L, S>(iPersistentSetChoice, iDfsOrder);
    }

    private static class CompatibleDfsOrder<L, S>
    implements IDfsOrder<L, S> {
        private final IPersistentSetChoice<L, S> mPersistent;
        private final IDfsOrder<L, S> mUnderlying;

        public CompatibleDfsOrder(IPersistentSetChoice<L, S> iPersistentSetChoice, IDfsOrder<L, S> iDfsOrder) {
            this.mPersistent = iPersistentSetChoice;
            this.mUnderlying = iDfsOrder;
        }

        @Override
        public Comparator<L> getOrder(S s) {
            Set<L> set = this.mPersistent.persistentSet(s);
            Comparator<L> comparator = this.mUnderlying.getOrder(s);
            return (object, object2) -> {
                if (set != null && set.contains(object) && !set.contains(object2)) {
                    if (this.mPersistent.ensuresCompatibility(this.mUnderlying) && comparator.compare(object, object2) >= 0) {
                        throw new IllegalStateException("Guarantee of compatibility failed");
                    }
                    return -1;
                }
                if (set != null && set.contains(object2) && !set.contains(object)) {
                    if (this.mPersistent.ensuresCompatibility(this.mUnderlying) && comparator.compare(object, object2) <= 0) {
                        throw new IllegalStateException("Guarantee of compatibility failed");
                    }
                    return 1;
                }
                return comparator.compare(object, object2);
            };
        }

        @Override
        public boolean isPositional() {
            return this.mUnderlying.isPositional() || !this.mPersistent.ensuresCompatibility(this.mUnderlying);
        }
    }
}

