/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.petruchio;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.UnaryNetOperation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.Accepts;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.PetriNet2FiniteAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.petruchio.PetruchioWrapper;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import petruchio.cov.Backward;
import petruchio.cov.SimpleList;
import petruchio.interfaces.petrinet.PetriNet;
import petruchio.interfaces.petrinet.Place;
import petruchio.interfaces.petrinet.Transition;

public final class EmptinessPetruchio<LETTER, PLACE>
extends UnaryNetOperation<LETTER, PLACE, IPetriNet2FiniteAutomatonStateFactory<PLACE>> {
    private final PetruchioWrapper<LETTER, PLACE> mPetruchio;
    private final BoundedPetriNet<LETTER, PLACE> mBoundedNet;
    private final NestedRun<LETTER, PLACE> mAcceptedRun;

    public EmptinessPetruchio(AutomataLibraryServices automataLibraryServices, BoundedPetriNet<LETTER, PLACE> boundedPetriNet) {
        super(automataLibraryServices);
        this.mBoundedNet = boundedPetriNet;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mPetruchio = new PetruchioWrapper<LETTER, PLACE>(this.mServices, boundedPetriNet);
        this.mAcceptedRun = this.constructAcceptingRun();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private NestedRun<LETTER, PLACE> constructAcceptingRun() {
        SimpleList simpleList2;
        Object object2;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Net has " + this.mBoundedNet.getPlaces().size() + " Places"));
            this.mLogger.debug((Object)("Net has " + this.mBoundedNet.getTransitions().size() + " Transitions"));
        }
        Integer n = 1;
        ArrayList arrayList = new ArrayList(1);
        Collection collection = this.mPetruchio.getNet().getPlaces();
        IdentityHashMap<Place, Integer> identityHashMap = new IdentityHashMap<Place, Integer>(collection.size());
        for (Object object2 : collection) {
            identityHashMap.put((Place)object2, n);
        }
        arrayList.add(identityHashMap);
        object2 = new ArrayList();
        for (SimpleList simpleList2 : this.mBoundedNet.getAcceptingPlaces()) {
            Place place = this.mPetruchio.getpBounded2pPetruchio().get(simpleList2);
            IdentityHashMap<Place, Integer> identityHashMap2 = new IdentityHashMap<Place, Integer>();
            identityHashMap2.put(place, n);
            object2.add(identityHashMap2);
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Check coverability of " + String.valueOf(this.mBoundedNet.getAcceptingPlaces())));
        }
        if (this.mLogger.isWarnEnabled()) {
            this.mLogger.warn(object2);
        }
        simpleList2 = Backward.checkCoverability((PetriNet)this.mPetruchio.getNet(), (Collection)object2);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"done");
        }
        if (simpleList2 == null) {
            return null;
        }
        return this.tracePetruchio2run((SimpleList<Transition>)simpleList2);
    }

    private NestedRun<LETTER, PLACE> tracePetruchio2run(SimpleList<Transition> simpleList) {
        NestedRun<LETTER, Object> nestedRun = new NestedRun<LETTER, Object>(null);
        if (simpleList.getLength() == 1 && simpleList.iterator().next() == null) {
            return nestedRun;
        }
        for (Transition transition : simpleList) {
            LETTER LETTER = this.mPetruchio.gettPetruchio2tBounded().get(transition).getSymbol();
            NestedRun<LETTER, Object> nestedRun2 = new NestedRun<LETTER, Object>(null, LETTER, -2, null);
            nestedRun = nestedRun.concatenate(nestedRun2);
        }
        return nestedRun;
    }

    @Override
    protected IPetriNet<LETTER, PLACE> getOperand() {
        return this.mBoundedNet;
    }

    @Override
    public NestedRun<LETTER, PLACE> getResult() {
        return this.mAcceptedRun;
    }

    @Override
    public boolean checkResult(IPetriNet2FiniteAutomatonStateFactory<PLACE> iPetriNet2FiniteAutomatonStateFactory) throws AutomataLibraryException {
        NestedRun nestedRun;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Testing correctness of " + this.getOperationName()));
        }
        boolean bl = this.mAcceptedRun == null ? (nestedRun = new IsEmpty(this.mServices, new PetriNet2FiniteAutomaton<LETTER, PLACE>(this.mServices, iPetriNet2FiniteAutomatonStateFactory, this.mBoundedNet).getResult()).getNestedRun()) == null : new Accepts<LETTER, PLACE>(this.mServices, this.mBoundedNet, this.mAcceptedRun.getWord()).getResult();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        return bl;
    }
}

