/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeRun;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IsEmpty<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final ITreeAutomatonBU<LETTER, STATE> mTreeAutomaton;
    protected final TreeRun<LETTER, STATE> mResultTreeRun;

    public IsEmpty(AutomataLibraryServices automataLibraryServices, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU) {
        super(automataLibraryServices);
        this.mTreeAutomaton = iTreeAutomatonBU;
        this.mResultTreeRun = this.computeResult();
    }

    @Override
    public String startMessage() {
        return "Starting emptiness check";
    }

    @Override
    public String exitMessage() {
        return "Exit emptiness check";
    }

    private TreeRun<LETTER, STATE> computeResult() {
        LinkedList<TreeAutomatonRule<List<STATE>, STATE>> linkedList = new LinkedList<TreeAutomatonRule<List<STATE>, STATE>>();
        HashMap hashMap = new HashMap();
        HashMap<Iterator<List<STATE>>, STATE> hashMap2 = new HashMap<Iterator<List<STATE>>, STATE>();
        for (List<STATE> object : this.mTreeAutomaton.getSourceCombinations()) {
            for (TreeAutomatonRule<List<STATE>, STATE> treeAutomatonRule : this.mTreeAutomaton.getSuccessors(object)) {
                for (Object object22 : treeAutomatonRule.getSource()) {
                    Collection<TreeAutomatonRule<List<STATE>, STATE>> collection;
                    if (hashMap.containsKey(object22)) {
                        collection = (Collection)hashMap.get(object22);
                    } else {
                        collection = new LinkedList();
                        hashMap.put(object22, collection);
                    }
                    collection.add(treeAutomatonRule);
                }
                if (!treeAutomatonRule.getSource().isEmpty()) continue;
                linkedList.add(treeAutomatonRule);
            }
        }
        while (!linkedList.isEmpty()) {
            Object object22;
            TreeAutomatonRule treeAutomatonRule = (TreeAutomatonRule)linkedList.poll();
            Iterator<List<STATE>> iterator = treeAutomatonRule.getDest();
            if (hashMap2.containsKey(iterator)) continue;
            LinkedList linkedList2 = new LinkedList();
            boolean bl = true;
            for (Object object22 : treeAutomatonRule.getSource()) {
                if (!hashMap2.containsKey(object22)) {
                    bl = false;
                    break;
                }
                linkedList2.add((TreeRun)hashMap2.get(object22));
            }
            if (!bl) continue;
            object22 = new TreeRun(iterator, treeAutomatonRule.getLetter(), linkedList2);
            hashMap2.put(iterator, object22);
            if (this.mTreeAutomaton.isFinalState(iterator)) {
                return object22;
            }
            if (!hashMap.containsKey(iterator)) continue;
            linkedList.addAll((Collection)hashMap.get(iterator));
        }
        return null;
    }

    @Override
    public Boolean getResult() {
        if (this.mResultTreeRun == null) {
            return true;
        }
        return false;
    }

    public TreeRun<LETTER, STATE> getTreeRun() {
        return this.mResultTreeRun;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

