/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.OccurrenceCounter;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.LogicSimplifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.TermCompiler;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.BooleanVarAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ClauseDeletionHook;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ILiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.NoopProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofConstants;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DTReverseTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprHelpers;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedEqualityAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprQuantifiedPredicateAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.util.Pair;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LASharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.DestructiveEqualityReasoning;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantAuxEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ArrayMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.TermUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Clausifier {
    public static final int AUX_AXIOM_ADDED = 16;
    public static final int NEG_AUX_AXIOMS_ADDED = 8;
    public static final int POS_AUX_AXIOMS_ADDED = 4;
    public static final int NEG_AXIOMS_ADDED = 2;
    public static final int POS_AXIOMS_ADDED = 1;
    private final FormulaUnLet mUnlet = new FormulaUnLet();
    private final TermCompiler mCompiler = new TermCompiler();
    private final OccurrenceCounter mOccCounter = new OccurrenceCounter();
    private final Deque<Operation> mTodoStack = new ArrayDeque<Operation>();
    private final Theory mTheory;
    private final DPLLEngine mEngine;
    private CClosure mCClosure;
    private LinArSolve mLASolver;
    private ArrayTheory mArrayTheory;
    private DataTypeTheory mDataTypeTheory;
    private EprTheory mEprTheory;
    private QuantifierTheory mQuantTheory;
    private boolean mIsRunning = false;
    private boolean mIsEprEnabled;
    private QuantifierTheory.InstantiationMethod mInstantiationMethod;
    private boolean mIsUnknownTermDawgsEnabled;
    private boolean mPropagateUnknownTerms;
    private boolean mPropagateUnknownAux;
    private final ScopedHashMap<Term, Term> mAnonAuxTerms = new ScopedHashMap();
    private final ScopedHashMap<Term, ILiteral> mLiterals = new ScopedHashMap();
    private final ScopedHashMap<Term, CCTerm> mCCTerms = new ScopedHashMap();
    private final ScopedHashMap<Term, LASharedTerm> mLATerms = new ScopedHashMap();
    private final ScopedHashMap<Term, Integer> mTermDataFlags = new ScopedHashMap();
    final ScopedArrayList<Term> mUnshareCC = new ScopedArrayList();
    final ScopedHashMap<Polynomial, EqualityProxy> mEqualities = new ScopedHashMap();
    private final HashMap<Sort, Boolean> mInfinityMap = new HashMap();
    private int mStackLevel = 0;
    private int mNumFailedPushes = 0;
    private boolean mWarnedInconsistent = false;
    private static int mSkolemCounter = 0;
    private final LogProxy mLogger;
    private final IProofTracker mTracker;
    private final LogicSimplifier mUtils;
    static final ILiteral mTRUE = new TrueLiteral();
    static final ILiteral mFALSE = new FalseLiteral();

    private Term rewriteBooleanSubterms(Term term, SourceAnnotation sourceAnnotation) {
        return new BooleanSubtermReplacer(sourceAnnotation).transform(term);
    }

    public CCTerm createCCTerm(Term term, SourceAnnotation sourceAnnotation) {
        CCTerm cCTerm = new CCTermBuilder(sourceAnnotation).convert(term);
        if (!this.mIsRunning) {
            this.run();
        }
        return cCTerm;
    }

    private void buildCCTerm(final Term term, final SourceAnnotation sourceAnnotation) {
        this.pushOperation(new Operation(){

            @Override
            public void perform() {
                new CCTermBuilder(sourceAnnotation).convert(term);
            }
        });
    }

    public int getTermFlags(Term term) {
        Integer n = (Integer)this.mTermDataFlags.get((Object)term);
        return n == null ? 0 : n;
    }

    public void setTermFlags(Term term, int n) {
        this.mTermDataFlags.put((Object)term, (Object)n);
    }

    public void share(CCTerm cCTerm, LASharedTerm lASharedTerm) {
        this.getLASolver().addSharedTerm(lASharedTerm);
        this.getCClosure().addSharedTerm(cCTerm);
    }

    public void shareLATerm(Term term, LASharedTerm lASharedTerm) {
        assert (!this.mLATerms.containsKey((Object)term));
        this.mLATerms.put((Object)term, (Object)lASharedTerm);
        CCTerm cCTerm = this.getCCTerm(term);
        if (cCTerm != null) {
            this.share(cCTerm, lASharedTerm);
        }
    }

    public void shareCCTerm(Term term, CCTerm cCTerm) {
        assert (!this.mCCTerms.containsKey((Object)term));
        this.mCCTerms.put((Object)term, (Object)cCTerm);
        LASharedTerm lASharedTerm = this.getLATerm(term);
        if (lASharedTerm != null) {
            this.share(cCTerm, lASharedTerm);
        }
    }

    public void addTermAxioms(Term term, SourceAnnotation sourceAnnotation) {
        int n = this.getTermFlags(term);
        if ((n & 0x10) == 0) {
            Object object;
            this.setTermFlags(term, n | 0x10);
            if (term instanceof ApplicationTerm) {
                String string;
                FunctionSymbol functionSymbol;
                CCTerm cCTerm = this.getCCTerm(term);
                if (cCTerm == null && (Clausifier.needCCTerm(term) || term.getSort().isArraySort())) {
                    object = new CCTermBuilder(sourceAnnotation);
                    cCTerm = ((CCTermBuilder)object).convert(term);
                }
                if ((functionSymbol = (object = (ApplicationTerm)term).getFunction()).isIntern()) {
                    if (functionSymbol.getName().equals("div")) {
                        this.addDivideAxioms((ApplicationTerm)object, sourceAnnotation);
                    } else if (functionSymbol.getName().equals("mod")) {
                        this.addModuloAxioms((ApplicationTerm)object, sourceAnnotation);
                    } else if (functionSymbol.getName().equals("to_int")) {
                        this.addToIntAxioms((ApplicationTerm)object, sourceAnnotation);
                    } else if (functionSymbol.getName().equals("ite") && functionSymbol.getReturnSort() != this.mTheory.getBooleanSort()) {
                        this.pushOperation(new AddTermITEAxiom(term, sourceAnnotation));
                    } else if (functionSymbol.getName().equals("store")) {
                        this.addStoreAxiom((ApplicationTerm)object, sourceAnnotation);
                    } else if (functionSymbol.getName().equals("@diff")) {
                        this.addDiffAxiom((ApplicationTerm)object, sourceAnnotation);
                        this.mArrayTheory.notifyDiff((CCAppTerm)cCTerm);
                    } else if (functionSymbol.getName().equals("bv2nat")) {
                        this.addBv2NatAxioms((ApplicationTerm)object, cCTerm, sourceAnnotation);
                    } else if (functionSymbol.getName().equals("nat2bv")) {
                        this.addNat2BvAxiom((ApplicationTerm)object, cCTerm, sourceAnnotation);
                    }
                }
                if (term.getSort().isBitVecSort()) {
                    this.addBitvectorAxiom(term, cCTerm, sourceAnnotation);
                }
                if (term.getSort().isArraySort()) {
                    assert (cCTerm != null);
                    string = object.getFunction().getName();
                    boolean bl = string.equals("store");
                    boolean bl2 = string.equals("const");
                    this.mArrayTheory.notifyArray(this.getCCTerm(term), bl, bl2);
                }
                if (functionSymbol.isConstructor()) {
                    String[] stringArray;
                    string = (DataType)functionSymbol.getReturnSort().getSortSymbol();
                    DataType.Constructor constructor = string.getConstructor(functionSymbol.getName());
                    this.mCClosure.addSharedTerm(cCTerm);
                    String[] stringArray2 = constructor.getSelectors();
                    int n2 = stringArray2.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String string2 = stringArray2[n3];
                        stringArray = this.mTheory.getFunction(string2, new Sort[]{functionSymbol.getReturnSort()});
                        this.mCClosure.insertReverseTrigger((FunctionSymbol)stringArray, cCTerm, 0, new DTReverseTrigger(this.mDataTypeTheory, this, (FunctionSymbol)stringArray, cCTerm));
                        ++n3;
                    }
                    stringArray2 = string.getConstructors();
                    n2 = stringArray2.length;
                    n3 = 0;
                    while (n3 < n2) {
                        String string3 = stringArray2[n3];
                        stringArray = new String[]{string3.getName()};
                        FunctionSymbol functionSymbol2 = this.mTheory.getFunctionWithResult("is", stringArray, null, new Sort[]{functionSymbol.getReturnSort()});
                        this.mCClosure.insertReverseTrigger(functionSymbol2, cCTerm, 0, new DTReverseTrigger(this.mDataTypeTheory, this, functionSymbol2, cCTerm));
                        ++n3;
                    }
                }
            }
            if (term.getSort().isNumericSort()) {
                boolean bl = term instanceof ConstantTerm;
                if (term instanceof ApplicationTerm && (((String)(object = ((ApplicationTerm)term).getFunction().getName())).equals("+") || ((String)object).equals("-") || ((String)object).equals("*") || ((String)object).equals("to_real"))) {
                    bl = true;
                }
                if (bl) {
                    object = this.createMutableAffinTerm(new Polynomial(term), sourceAnnotation);
                    assert (((MutableAffineTerm)object).getConstant().mEps == 0);
                    if (!this.mLATerms.containsKey((Object)term)) {
                        this.shareLATerm(term, new LASharedTerm(term, ((MutableAffineTerm)object).getSummands(), ((MutableAffineTerm)object).getConstant().mReal));
                    }
                }
            }
            if (!(term.getSort() != term.getTheory().getBooleanSort() || term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().startsWith("@AUX") || term == term.getTheory().mTrue || term == term.getTheory().mFalse)) {
                this.addExcludedMiddleAxiom(term, sourceAnnotation);
            }
            if (term instanceof MatchTerm) {
                this.addMatchAxiom((MatchTerm)term, sourceAnnotation);
            }
        }
        if (!this.mIsRunning) {
            this.run();
        }
    }

    private void addNat2BvAxiom(ApplicationTerm applicationTerm, CCTerm cCTerm, SourceAnnotation sourceAnnotation) {
        assert (applicationTerm.getFunction().getName() == "nat2bv");
        Term term = applicationTerm.getParameters()[0];
        if (TermUtils.isApplication("bv2nat", term) && ((ApplicationTerm)term).getParameters()[0].getSort() == applicationTerm.getSort()) {
            Term term2 = ((ApplicationTerm)term).getParameters()[0];
            Term term3 = this.mTheory.term("=", new Term[]{applicationTerm, term2});
            this.buildClause(this.mTracker.tautology(term3, ProofConstants.TAUT_BV2NAT2BV), sourceAnnotation);
        } else {
            int n = Integer.valueOf(applicationTerm.getSort().getIndices()[0]);
            Rational rational = Rational.valueOf((BigInteger)BigInteger.ONE.shiftLeft(n), (BigInteger)BigInteger.ONE);
            Term term4 = this.normalizeMod(applicationTerm.getParameters()[0], rational);
            Term term5 = this.mTheory.term("=", new Term[]{applicationTerm, this.mTheory.term(applicationTerm.getFunction(), new Term[]{term4})});
            this.buildClause(this.mTracker.tautology(term5, ProofConstants.TAUT_NAT2BV), sourceAnnotation);
        }
    }

    private Term normalizeMod(Term term, Rational rational) {
        Term term2 = this.mTheory.rational(rational, this.mTheory.getSort("Int", new Sort[0]));
        SMTAffineTerm sMTAffineTerm = new SMTAffineTerm(term);
        sMTAffineTerm.mod(rational);
        Term term3 = this.mTheory.term("div", new Term[]{sMTAffineTerm.toTerm(this.mTheory.getSort("Int", new Sort[0])), term2});
        sMTAffineTerm.add(rational.negate(), term3);
        return sMTAffineTerm.toTerm(term2.getSort());
    }

    private void addBv2NatAxioms(ApplicationTerm applicationTerm, CCTerm cCTerm, SourceAnnotation sourceAnnotation) {
        assert (applicationTerm.getFunction().getName() == "bv2nat");
        int n = Integer.valueOf(applicationTerm.getParameters()[0].getSort().getIndices()[0]);
        Rational rational = Rational.valueOf((BigInteger)BigInteger.ONE.shiftLeft(n), (BigInteger)BigInteger.ONE);
        Term term = applicationTerm.getParameters()[0];
        if (TermUtils.isApplication("nat2bv", term)) {
            Term term2 = this.normalizeMod(((ApplicationTerm)term).getParameters()[0], rational);
            Term term3 = this.mTheory.term("=", new Term[]{applicationTerm, term2});
            this.buildClause(this.mTracker.tautology(term3, ProofConstants.TAUT_NAT2BV), sourceAnnotation);
        } else {
            Sort sort = this.mTheory.getSort("Int", new Sort[0]);
            Polynomial polynomial = new Polynomial();
            polynomial.add(Rational.MONE, (Term)applicationTerm);
            Polynomial polynomial2 = new Polynomial((Term)applicationTerm);
            polynomial2.add(rational.sub(Rational.ONE).negate());
            Term term4 = Rational.ZERO.toTerm(sort);
            Term term5 = this.mTheory.term("<=", new Term[]{polynomial.toTerm(sort), term4});
            Term term6 = this.mTheory.term("<=", new Term[]{polynomial2.toTerm(sort), term4});
            this.buildClause(this.mTracker.tautology(term5, ProofConstants.TAUT_BV2NATLOW), sourceAnnotation);
            this.buildClause(this.mTracker.tautology(term6, ProofConstants.TAUT_BV2NATHIGH), sourceAnnotation);
        }
    }

    private void addBitvectorAxiom(Term term, CCTerm cCTerm, SourceAnnotation sourceAnnotation) {
        if (TermUtils.isApplication("nat2bv", term)) {
            Term term2 = ((ApplicationTerm)term).getParameters()[0];
            if (TermUtils.isApplication("bv2nat", term2) && ((ApplicationTerm)term2).getParameters()[0].getSort() == term.getSort()) {
                return;
            }
            this.buildCCTerm(term.getTheory().term("bv2nat", new Term[]{term}), sourceAnnotation);
        } else {
            Term term3 = term.getTheory().term("bv2nat", new Term[]{term});
            this.buildCCTerm(term.getTheory().term("nat2bv", term.getSort().getIndices(), null, new Term[]{term3}), sourceAnnotation);
        }
    }

    public LinVar getLinVar(Term term) {
        assert (term.getSort().isNumericSort());
        assert (term == SMTAffineTerm.create(term).getSummands().keySet().iterator().next());
        LASharedTerm lASharedTerm = this.getLATerm(term);
        assert (lASharedTerm != null);
        assert (lASharedTerm.getSummands().size() == 1 && lASharedTerm.getOffset() == Rational.ZERO && lASharedTerm.getSummands().values().iterator().next() == Rational.ONE);
        return lASharedTerm.getSummands().keySet().iterator().next();
    }

    private boolean isMonomial(Term term) {
        Polynomial polynomial = new Polynomial(term);
        if (polynomial.getSummands().size() != 1) {
            return false;
        }
        Map.Entry<Map<Term, Integer>, Rational> entry = polynomial.getSummands().entrySet().iterator().next();
        return !entry.getKey().isEmpty() && entry.getValue() == Rational.ONE;
    }

    public LinVar createLinVar(Term term, SourceAnnotation sourceAnnotation) {
        LASharedTerm lASharedTerm;
        int n;
        assert (term.getSort().isNumericSort());
        assert (this.isMonomial(term));
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("*")) {
            Term[] termArray = ((ApplicationTerm)term).getParameters();
            int n2 = termArray.length;
            n = 0;
            while (n < n2) {
                lASharedTerm = termArray[n];
                this.addTermAxioms((Term)lASharedTerm, sourceAnnotation);
                ++n;
            }
        } else {
            this.addTermAxioms(term, sourceAnnotation);
        }
        lASharedTerm = this.getLATerm(term);
        if (lASharedTerm == null) {
            n = term.getSort().getName().equals("Int");
            LinVar linVar = this.getLASolver().addVar(term, n != 0, this.getStackLevel());
            lASharedTerm = new LASharedTerm(term, Collections.singletonMap(linVar, Rational.ONE), Rational.ZERO);
            this.shareLATerm(term, lASharedTerm);
        }
        assert (lASharedTerm.getSummands().size() == 1 && lASharedTerm.getOffset() == Rational.ZERO && lASharedTerm.getSummands().values().iterator().next() == Rational.ONE);
        return lASharedTerm.getSummands().keySet().iterator().next();
    }

    private Term createMonomial(Map<Term, Integer> map) {
        Polynomial polynomial = new Polynomial();
        polynomial.add(Rational.ONE, map);
        return polynomial.toTerm(polynomial.isAllIntSummands() ? this.mTheory.getSort("Int", new Sort[0]) : this.mTheory.getSort("Real", new Sort[0]));
    }

    public MutableAffineTerm createMutableAffinTerm(Polynomial polynomial, SourceAnnotation sourceAnnotation) {
        MutableAffineTerm mutableAffineTerm = new MutableAffineTerm();
        for (Map.Entry<Map<Term, Integer>, Rational> entry : polynomial.getSummands().entrySet()) {
            Rational rational = entry.getValue();
            if (entry.getKey().isEmpty()) {
                mutableAffineTerm.add(rational);
                continue;
            }
            Term term = this.createMonomial(entry.getKey());
            LinVar linVar = this.createLinVar(term, sourceAnnotation);
            mutableAffineTerm.add(rational, linVar);
        }
        return mutableAffineTerm;
    }

    public MutableAffineTerm toMutableAffineTerm(Polynomial polynomial) {
        MutableAffineTerm mutableAffineTerm = new MutableAffineTerm();
        for (Map.Entry<Map<Term, Integer>, Rational> entry : polynomial.getSummands().entrySet()) {
            Rational rational = entry.getValue();
            if (entry.getKey().isEmpty()) {
                mutableAffineTerm.add(rational);
                continue;
            }
            Term term = this.createMonomial(entry.getKey());
            LASharedTerm lASharedTerm = this.getLATerm(term);
            if (lASharedTerm == null) {
                return null;
            }
            assert (lASharedTerm.getSummands().size() == 1 && lASharedTerm.getOffset() == Rational.ZERO && lASharedTerm.getSummands().values().iterator().next() == Rational.ONE);
            mutableAffineTerm.add(rational, lASharedTerm.getSummands().keySet().iterator().next());
        }
        return mutableAffineTerm;
    }

    public CCTerm getCCTerm(Term term) {
        return (CCTerm)this.mCCTerms.get((Object)term);
    }

    public LASharedTerm getLATerm(Term term) {
        return (LASharedTerm)this.mLATerms.get((Object)term);
    }

    public ILiteral getILiteral(Term term) {
        return (ILiteral)this.mLiterals.get((Object)term);
    }

    public void setLiteral(Term term, ILiteral iLiteral) {
        this.mLiterals.put((Object)term, (Object)iLiteral);
    }

    public static boolean needCCTerm(Term term) {
        block33: {
            if (!(term instanceof ApplicationTerm)) break block33;
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            if (functionSymbol.isConstructor() || functionSymbol.isSelector()) {
                return true;
            }
            if (applicationTerm.getParameters().length == 0) {
                return false;
            }
            if (!functionSymbol.isIntern()) {
                return true;
            }
            if (functionSymbol.getName().startsWith("@AUX")) {
                return true;
            }
            if (functionSymbol.getName().startsWith("@skolem.")) {
                return true;
            }
            switch (functionSymbol.getName()) {
                case "bv2nat": 
                case "nat2bv": 
                case "select": 
                case "is": 
                case "@EQ": 
                case "@diff": 
                case "const": 
                case "store": {
                    return true;
                }
                case "/": 
                case "div": 
                case "mod": {
                    Polynomial polynomial = new Polynomial(applicationTerm.getParameters()[1]);
                    return !polynomial.isConstant() || polynomial.isZero();
                }
            }
            return false;
        }
        return false;
    }

    private Pair<Term, Annotation> convertQuantifiedSubformula(boolean bl, QuantifiedFormula quantifiedFormula) {
        Annotation annotation;
        QuantifiedFormula quantifiedFormula2;
        Term term;
        FormulaUnLet formulaUnLet;
        TermVariable[] termVariableArray = quantifiedFormula.getVariables();
        Term[] termArray = new Term[termVariableArray.length];
        if (bl == (quantifiedFormula.getQuantifier() == 0)) {
            formulaUnLet = quantifiedFormula.getFreeVars();
            term = new Term[((TermVariable[])formulaUnLet).length];
            quantifiedFormula2 = new Sort[((TermVariable[])formulaUnLet).length];
            int n = 0;
            while (n < ((TermVariable[])formulaUnLet).length) {
                term[n] = formulaUnLet[n];
                quantifiedFormula2[n] = formulaUnLet[n].getSort();
                ++n;
            }
            Term[] termArray2 = new ProofRules(this.mTheory).getSkolemVars(termVariableArray, quantifiedFormula.getSubformula(), quantifiedFormula.getQuantifier() == 1);
            int n2 = 0;
            while (n2 < termVariableArray.length) {
                String string = "@skolem." + termVariableArray[n2].getName() + "." + mSkolemCounter++;
                FunctionSymbol functionSymbol = this.mTheory.declareInternalFunction(string, (Sort[])quantifiedFormula2, (TermVariable[])formulaUnLet, termArray2[n2], 64);
                termArray[n2] = this.mTheory.term(functionSymbol, (Term[])term);
                ++n2;
            }
            if (this.mEprTheory != null) {
                this.mEprTheory.addSkolemConstants(termArray);
            }
            annotation = quantifiedFormula.getQuantifier() == 0 ? ProofConstants.getTautExistsNeg(termArray) : ProofConstants.getTautForallPos(termArray);
        } else {
            int n = 0;
            while (n < termVariableArray.length) {
                termArray[n] = this.mTheory.createFreshTermVariable(termVariableArray[n].getName(), termVariableArray[n].getSort());
                ++n;
            }
            annotation = quantifiedFormula.getQuantifier() == 0 ? ProofConstants.getTautExistsPos(termArray) : ProofConstants.getTautForallNeg(termArray);
        }
        formulaUnLet = new FormulaUnLet();
        formulaUnLet.addSubstitutions(new ArrayMap<TermVariable, Term>(termVariableArray, termArray));
        term = formulaUnLet.unlet(quantifiedFormula.getSubformula());
        quantifiedFormula2 = quantifiedFormula;
        if (!bl) {
            term = this.mTheory.term("not", new Term[]{term});
        } else {
            quantifiedFormula2 = this.mTheory.term("not", new Term[]{quantifiedFormula2});
        }
        return new Pair<Term, Annotation>(term, annotation);
    }

    public Clausifier(Theory theory, DPLLEngine dPLLEngine, SMTInterpol.ProofMode proofMode) {
        this.mTheory = theory;
        this.mEngine = dPLLEngine;
        this.mLogger = dPLLEngine.getLogger();
        this.mTracker = proofMode == SMTInterpol.ProofMode.NONE || proofMode == SMTInterpol.ProofMode.CLAUSES ? new NoopProofTracker() : new ProofTracker(theory);
        this.mUtils = new LogicSimplifier(this.mTracker);
        this.mCompiler.setProofTracker(this.mTracker);
    }

    public void setAssignmentProduction(boolean bl) {
        this.mCompiler.setAssignmentProduction(bl);
    }

    void pushOperation(Operation operation) {
        this.mTodoStack.push(operation);
    }

    private static boolean isNotTerm(Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName() == "not";
    }

    private Term removeDoubleNot(Term term) {
        while (Clausifier.isNotTerm(term) && Clausifier.isNotTerm(((ApplicationTerm)term).getParameters()[0])) {
            term = ((ApplicationTerm)((ApplicationTerm)term).getParameters()[0]).getParameters()[0];
        }
        return term;
    }

    private static Term toPositive(Term term) {
        if (Clausifier.isNotTerm(term)) {
            return ((ApplicationTerm)term).getParameters()[0];
        }
        return term;
    }

    public void buildAuxClause(ILiteral iLiteral, Term term, SourceAnnotation sourceAnnotation) {
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mTracker.getProvedTerm(term);
        assert (applicationTerm.getFunction().getName() == "or");
        assert (applicationTerm.getParameters()[0] == iLiteral.getSMTFormula(applicationTerm.getTheory()));
        BuildClause buildClause = new BuildClause(term, sourceAnnotation);
        Term[] termArray = applicationTerm.getParameters();
        this.pushOperation(buildClause);
        buildClause.addLiteral(iLiteral);
        int n = termArray.length - 1;
        while (n >= 1) {
            buildClause.collectLiteral(termArray[n]);
            --n;
        }
    }

    public void buildTautology(Theory theory, Term[] termArray, Annotation annotation, SourceAnnotation sourceAnnotation) {
        BuildClause buildClause = new BuildClause(this.mTracker.tautology(theory.term("or", termArray), annotation), sourceAnnotation);
        this.pushOperation(buildClause);
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            buildClause.collectLiteral(term);
            ++n2;
        }
    }

    public void buildClause(Term term, SourceAnnotation sourceAnnotation) {
        BuildClause buildClause = new BuildClause(term, sourceAnnotation);
        this.pushOperation(buildClause);
        buildClause.collectLiteral(this.mTracker.getProvedTerm(term));
    }

    public void buildClause(Annotation annotation, SourceAnnotation sourceAnnotation, Term ... termArray) {
        Theory theory = termArray[0].getTheory();
        Term term = termArray.length == 1 ? termArray[0] : theory.term("or", termArray);
        Term term2 = this.mTracker.tautology(term, annotation);
        BuildClause buildClause = new BuildClause(term2, sourceAnnotation);
        this.pushOperation(buildClause);
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term3 = termArray2[n2];
            buildClause.collectLiteral(term3);
            ++n2;
        }
    }

    public void buildClauseWithTautology(Term term, SourceAnnotation sourceAnnotation, Term[] termArray, Annotation annotation) {
        Theory theory = term.getTheory();
        Term term2 = this.mTracker.tautology(theory.term("or", termArray), annotation);
        BuildClause buildClause = new BuildClause(term, sourceAnnotation);
        this.pushOperation(buildClause);
        buildClause.addResolution(term2, this.mTracker.getProvedTerm(term));
        int n = 1;
        while (n < termArray.length) {
            buildClause.collectLiteral(termArray[n]);
            ++n;
        }
    }

    public void addAuxAxioms(Term term, boolean bl, SourceAnnotation sourceAnnotation) {
        int n;
        assert (term == Clausifier.toPositive(term));
        int n2 = this.getTermFlags(term);
        int n3 = n = bl ? 4 : 8;
        if ((n2 & n) != 0) {
            return;
        }
        this.setTermFlags(term, n2 | n);
        ILiteral iLiteral = this.getILiteral(term);
        assert (iLiteral != null);
        iLiteral = bl ? iLiteral.negate() : iLiteral;
        this.createDefiningClausesForLiteral(iLiteral, term, bl, sourceAnnotation);
    }

    public void addAuxAxiomsQuant(Term term, Term term2, SourceAnnotation sourceAnnotation) {
        int n = this.getTermFlags(term);
        if ((n & 0xC) == 12) {
            return;
        }
        this.setTermFlags(term, n | 0xC);
        QuantAuxEquality quantAuxEquality = this.mQuantTheory.createAuxLiteral(term2, term, sourceAnnotation);
        ILiteral iLiteral = this.mQuantTheory.createAuxFalseLiteral(quantAuxEquality, sourceAnnotation);
        this.createDefiningClausesForLiteral(iLiteral, term, true, sourceAnnotation);
        this.createDefiningClausesForLiteral(quantAuxEquality, term, false, sourceAnnotation);
    }

    private void createDefiningClausesForLiteral(ILiteral iLiteral, Term term, boolean bl, SourceAnnotation sourceAnnotation) {
        Theory theory = term.getTheory();
        Term term2 = iLiteral.getSMTFormula(theory);
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            Term[] termArray = applicationTerm.getParameters();
            if (applicationTerm.getFunction() == theory.mOr) {
                if (bl) {
                    Term[] termArray2 = new Term[termArray.length + 1];
                    termArray2[0] = term2;
                    System.arraycopy(termArray, 0, termArray2, 1, termArray.length);
                    Term term3 = this.mTracker.tautology(theory.term("or", termArray2), ProofConstants.TAUT_OR_NEG);
                    this.buildAuxClause(iLiteral, term3, sourceAnnotation);
                } else {
                    Term[] termArray3 = termArray = applicationTerm.getParameters();
                    int n = termArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Term term4 = termArray3[n2];
                        Term term5 = theory.term("or", new Term[]{term2, theory.term("not", new Term[]{term4})});
                        Term term6 = this.mTracker.tautology(term5, ProofConstants.TAUT_OR_POS);
                        this.buildAuxClause(iLiteral, term6, sourceAnnotation);
                        ++n2;
                    }
                }
            } else if (applicationTerm.getFunction() == theory.mImplies) {
                if (bl) {
                    Term[] termArray4 = new Term[termArray.length + 1];
                    termArray4[0] = term2;
                    int n = 0;
                    while (n < termArray.length - 1) {
                        termArray4[n + 1] = theory.term("not", new Term[]{termArray[n]});
                        ++n;
                    }
                    termArray4[termArray.length] = termArray[termArray.length - 1];
                    Term term7 = this.mTracker.tautology(theory.term("or", termArray4), ProofConstants.TAUT_IMP_NEG);
                    this.buildAuxClause(iLiteral, term7, sourceAnnotation);
                } else {
                    termArray = applicationTerm.getParameters();
                    int n = 0;
                    while (n < termArray.length) {
                        Term term8 = n < termArray.length - 1 ? termArray[n] : theory.term("not", new Term[]{termArray[n]});
                        Term term9 = theory.term("or", new Term[]{term2, term8});
                        Term term10 = this.mTracker.tautology(term9, ProofConstants.TAUT_IMP_POS);
                        this.buildAuxClause(iLiteral, term10, sourceAnnotation);
                        ++n;
                    }
                }
            } else if (applicationTerm.getFunction() == theory.mAnd) {
                if (bl) {
                    Term[] termArray5 = termArray;
                    int n = termArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Term term11 = termArray5[n3];
                        Term term12 = theory.term("or", new Term[]{term2, term11});
                        Term term13 = this.mTracker.tautology(term12, ProofConstants.TAUT_AND_NEG);
                        this.buildAuxClause(iLiteral, term13, sourceAnnotation);
                        ++n3;
                    }
                } else {
                    Term[] termArray6 = new Term[termArray.length + 1];
                    termArray6[0] = term2;
                    int n = 0;
                    while (n < termArray.length) {
                        termArray6[n + 1] = theory.term("not", new Term[]{termArray[n]});
                        ++n;
                    }
                    Term term14 = this.mTracker.tautology(theory.term("or", termArray6), ProofConstants.TAUT_AND_POS);
                    this.buildAuxClause(iLiteral, term14, sourceAnnotation);
                }
            } else if (applicationTerm.getFunction().getName().equals("ite")) {
                Term term15 = termArray[0];
                Term term16 = termArray[1];
                Term term17 = termArray[2];
                if (bl) {
                    Term term18 = theory.term("or", new Term[]{term2, theory.term("not", new Term[]{term15}), term16});
                    term18 = this.mTracker.tautology(term18, ProofConstants.TAUT_ITE_NEG_1);
                    this.buildAuxClause(iLiteral, term18, sourceAnnotation);
                    term18 = theory.term("or", new Term[]{term2, term15, term17});
                    term18 = this.mTracker.tautology(term18, ProofConstants.TAUT_ITE_NEG_2);
                    this.buildAuxClause(iLiteral, term18, sourceAnnotation);
                    term18 = theory.term("or", new Term[]{term2, term16, term17});
                    term18 = this.mTracker.tautology(term18, ProofConstants.TAUT_ITE_NEG_RED);
                    this.buildAuxClause(iLiteral, term18, sourceAnnotation);
                } else {
                    term16 = theory.term("not", new Term[]{term16});
                    term17 = theory.term("not", new Term[]{term17});
                    Term term19 = theory.term("or", new Term[]{term2, theory.term("not", new Term[]{term15}), term16});
                    term19 = this.mTracker.tautology(term19, ProofConstants.TAUT_ITE_POS_1);
                    this.buildAuxClause(iLiteral, term19, sourceAnnotation);
                    term19 = theory.term("or", new Term[]{term2, term15, term17});
                    term19 = this.mTracker.tautology(term19, ProofConstants.TAUT_ITE_POS_2);
                    this.buildAuxClause(iLiteral, term19, sourceAnnotation);
                    term19 = theory.term("or", new Term[]{term2, term16, term17});
                    term19 = this.mTracker.tautology(term19, ProofConstants.TAUT_ITE_POS_RED);
                    this.buildAuxClause(iLiteral, term19, sourceAnnotation);
                }
            } else if (applicationTerm.getFunction().getName().equals("xor")) {
                assert (applicationTerm.getParameters().length == 2);
                Term term20 = applicationTerm.getParameters()[0];
                Term term21 = applicationTerm.getParameters()[1];
                assert (term20.getSort() == theory.getBooleanSort());
                assert (term21.getSort() == theory.getBooleanSort());
                if (bl) {
                    Term term22 = theory.term("or", new Term[]{term2, term20, term21});
                    term22 = this.mTracker.tautology(term22, ProofConstants.TAUT_XOR_NEG_1);
                    this.buildAuxClause(iLiteral, term22, sourceAnnotation);
                    term22 = theory.term("or", new Term[]{term2, theory.term("not", new Term[]{term20}), theory.term("not", new Term[]{term21})});
                    term22 = this.mTracker.tautology(term22, ProofConstants.TAUT_XOR_NEG_2);
                    this.buildAuxClause(iLiteral, term22, sourceAnnotation);
                } else {
                    Term term23 = theory.term("or", new Term[]{term2, term20, theory.term("not", new Term[]{term21})});
                    term23 = this.mTracker.tautology(term23, ProofConstants.TAUT_XOR_POS_1);
                    this.buildAuxClause(iLiteral, term23, sourceAnnotation);
                    term23 = theory.term("or", new Term[]{term2, theory.term("not", new Term[]{term20}), term21});
                    term23 = this.mTracker.tautology(term23, ProofConstants.TAUT_XOR_POS_2);
                    this.buildAuxClause(iLiteral, term23, sourceAnnotation);
                }
            } else {
                assert (iLiteral instanceof QuantEquality);
                if (bl) {
                    Term term24 = theory.term("or", new Term[]{term2, term});
                    term24 = this.mTracker.tautology(term24, ProofConstants.TAUT_EXCLUDED_MIDDLE_2);
                    this.buildAuxClause(iLiteral, term24, sourceAnnotation);
                } else {
                    Term term25 = theory.term("or", new Term[]{term2, theory.term("not", new Term[]{term})});
                    term25 = this.mTracker.tautology(term25, ProofConstants.TAUT_EXCLUDED_MIDDLE_1);
                    this.buildAuxClause(iLiteral, term25, sourceAnnotation);
                }
            }
        } else if (term instanceof MatchTerm) {
            Theory theory2 = term.getTheory();
            MatchTerm matchTerm = (MatchTerm)term;
            Term term26 = matchTerm.getDataTerm();
            LinkedHashMap<DataType.Constructor, Term> linkedHashMap = new LinkedHashMap<DataType.Constructor, Term>();
            DataType.Constructor[] constructorArray = matchTerm.getConstructors();
            int n = 0;
            while (n < constructorArray.length) {
                DataType.Constructor constructor = constructorArray[n];
                if (!linkedHashMap.containsKey(constructor)) {
                    Term term27;
                    FunctionSymbol functionSymbol;
                    Annotation annotation;
                    ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
                    arrayDeque.add(term2);
                    LinkedHashMap<TermVariable, Term> linkedHashMap2 = new LinkedHashMap<TermVariable, Term>();
                    if (constructor == null) {
                        arrayDeque.addAll(linkedHashMap.values());
                        linkedHashMap2.put(matchTerm.getVariables()[n][0], term26);
                        annotation = ProofConstants.TAUT_MATCH_DEFAULT;
                    } else {
                        functionSymbol = theory2.getFunctionWithResult("is", new String[]{constructor.getName()}, null, new Sort[]{term26.getSort()});
                        term27 = theory2.term(functionSymbol, new Term[]{term26});
                        linkedHashMap.put(constructor, term27);
                        arrayDeque.add(theory2.term("not", new Term[]{term27}));
                        int n4 = 0;
                        String[] stringArray = constructor.getSelectors();
                        int n5 = stringArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String string = stringArray[n6];
                            Term term28 = theory2.term(theory2.getFunctionSymbol(string), new Term[]{term26});
                            linkedHashMap2.put(matchTerm.getVariables()[n][n4++], term28);
                            ++n6;
                        }
                        annotation = ProofConstants.TAUT_MATCH_CASE;
                    }
                    functionSymbol = new FormulaUnLet();
                    functionSymbol.addSubstitutions(linkedHashMap2);
                    term27 = functionSymbol.unlet(matchTerm.getCases()[n]);
                    if (bl) {
                        arrayDeque.add(term27);
                    } else {
                        arrayDeque.add(theory2.term("not", new Term[]{term27}));
                    }
                    Term term29 = this.mTracker.tautology(theory2.term("or", arrayDeque.toArray(new Term[arrayDeque.size()])), annotation);
                    this.buildAuxClause(iLiteral, term29, sourceAnnotation);
                    if (constructor == null) break;
                }
                ++n;
            }
        } else {
            assert (iLiteral instanceof QuantEquality);
            if (bl) {
                Term term30 = theory.term("or", new Term[]{term2, term});
                term30 = this.mTracker.tautology(term30, ProofConstants.TAUT_EXCLUDED_MIDDLE_2);
                this.buildAuxClause(iLiteral, term30, sourceAnnotation);
            } else {
                Term term31 = theory.term("or", new Term[]{term2, theory.term("not", new Term[]{term})});
                term31 = this.mTracker.tautology(term31, ProofConstants.TAUT_EXCLUDED_MIDDLE_1);
                this.buildAuxClause(iLiteral, term31, sourceAnnotation);
            }
        }
    }

    public void addStoreAxiom(ApplicationTerm applicationTerm, SourceAnnotation sourceAnnotation) {
        Theory theory = applicationTerm.getTheory();
        Term term = applicationTerm.getParameters()[1];
        Term term2 = applicationTerm.getParameters()[2];
        Term term3 = theory.term("=", new Term[]{theory.term("select", new Term[]{applicationTerm, term}), term2});
        Term term4 = this.mTracker.modusPonens(this.mTracker.tautology(term3, ProofConstants.TAUT_ARRAY_STORE), this.mUtils.convertBinaryEq(this.mTracker.reflexivity(term3)));
        this.buildClause(term4, sourceAnnotation);
        if (!this.isStablyInfinite(term2.getSort())) {
            Term term5 = applicationTerm.getParameters()[0];
            Term term6 = this.mTheory.term("select", new Term[]{term5, term});
            this.buildCCTerm(term6, sourceAnnotation);
        }
    }

    public void addDiffAxiom(ApplicationTerm applicationTerm, SourceAnnotation sourceAnnotation) {
        Theory theory = applicationTerm.getTheory();
        Term term = applicationTerm.getParameters()[0];
        Term term2 = applicationTerm.getParameters()[1];
        Term[] termArray = new Term[]{theory.term("=", new Term[]{term, term2}), theory.term("not", new Term[]{theory.term("=", new Term[]{theory.term("select", new Term[]{term, applicationTerm}), theory.term("select", new Term[]{term2, applicationTerm})})})};
        this.buildTautology(theory, termArray, ProofConstants.TAUT_ARRAY_DIFF, sourceAnnotation);
    }

    public void addDivideAxioms(ApplicationTerm applicationTerm, SourceAnnotation sourceAnnotation) {
        Term term;
        Theory theory = applicationTerm.getTheory();
        Term[] termArray = applicationTerm.getParameters();
        Polynomial polynomial = new Polynomial(termArray[1]);
        if (polynomial.isZero()) {
            return;
        }
        Term term2 = Rational.ZERO.toTerm(applicationTerm.getSort());
        Polynomial polynomial2 = new Polynomial(termArray[0]);
        polynomial2.mul(Rational.MONE);
        Polynomial polynomial3 = new Polynomial((Term)applicationTerm);
        polynomial3.mul(polynomial);
        polynomial2.add(Rational.ONE, polynomial3);
        Term term3 = theory.term("<=", new Term[]{this.mCompiler.unifyPolynomial(polynomial2, applicationTerm.getSort()), term2});
        Annotation annotation = new Annotation(":divLow", (Object)applicationTerm);
        if (polynomial.isConstant()) {
            this.buildClause(annotation, sourceAnnotation, term3);
        } else {
            term = theory.term("=", new Term[]{termArray[1], term2});
            this.buildClause(annotation, sourceAnnotation, term, term3);
        }
        term = new Annotation(":divHigh", (Object)applicationTerm);
        if (polynomial.isConstant()) {
            polynomial2.add(polynomial.getConstant().abs());
            Term term4 = theory.term("not", new Term[]{theory.term("<=", new Term[]{this.mCompiler.unifyPolynomial(polynomial2, applicationTerm.getSort()), term2})});
            this.buildClause((Annotation)term, sourceAnnotation, term4);
        } else {
            Polynomial polynomial4 = new Polynomial(termArray[1]);
            polynomial4.add(Rational.ONE);
            Term term5 = theory.term("not", new Term[]{theory.term("<=", new Term[]{this.mCompiler.unifyPolynomial(polynomial4, applicationTerm.getSort()), term2})});
            polynomial2.add(Rational.MONE, polynomial);
            Term term6 = theory.term("not", new Term[]{theory.term("<=", new Term[]{this.mCompiler.unifyPolynomial(polynomial2, applicationTerm.getSort()), term2})});
            this.buildClause((Annotation)term, sourceAnnotation, term5, term6);
            Term term7 = theory.term("<=", new Term[]{termArray[1], term2});
            polynomial2.add(Rational.TWO, polynomial);
            Term term8 = theory.term("not", new Term[]{theory.term("<=", new Term[]{this.mCompiler.unifyPolynomial(polynomial2, applicationTerm.getSort()), term2})});
            this.buildClause((Annotation)term, sourceAnnotation, term7, term8);
        }
    }

    public void addModuloAxioms(ApplicationTerm applicationTerm, SourceAnnotation sourceAnnotation) {
        Theory theory = applicationTerm.getTheory();
        Term[] termArray = applicationTerm.getParameters();
        Term term = theory.term("div", new Term[]{termArray[0], termArray[1]});
        Polynomial polynomial = new Polynomial(termArray[1]);
        if (polynomial.isZero()) {
            return;
        }
        assert (!polynomial.isConstant());
        Term term2 = Rational.ZERO.toTerm(term.getSort());
        Term term3 = theory.term("=", new Term[]{termArray[1], term2});
        Polynomial polynomial2 = new Polynomial(termArray[0]);
        Polynomial polynomial3 = new Polynomial(term);
        polynomial3.mul(polynomial);
        polynomial2.add(Rational.MONE, polynomial3);
        Term term4 = theory.term("=", new Term[]{applicationTerm, this.mCompiler.unifyPolynomial(polynomial2, term.getSort())});
        this.buildClause(ProofConstants.TAUT_MODULO, sourceAnnotation, term3, term4);
    }

    public void addToIntAxioms(ApplicationTerm applicationTerm, SourceAnnotation sourceAnnotation) {
        Theory theory = applicationTerm.getTheory();
        Term term = applicationTerm.getParameters()[0];
        Term term2 = Rational.ZERO.toTerm(term.getSort());
        Polynomial polynomial = new Polynomial(term);
        polynomial.mul(Rational.MONE);
        polynomial.add(Rational.ONE, (Term)applicationTerm);
        Term term3 = theory.term("<=", new Term[]{this.mCompiler.unifyPolynomial(polynomial, term.getSort()), term2});
        this.buildClause(this.mTracker.tautology(term3, new Annotation(":toIntLow", (Object)applicationTerm)), sourceAnnotation);
        polynomial.add(Rational.ONE);
        term3 = theory.term("not", new Term[]{theory.term("<=", new Term[]{this.mCompiler.unifyPolynomial(polynomial, term.getSort()), term2})});
        this.buildClause(this.mTracker.tautology(term3, new Annotation(":toIntHigh", (Object)applicationTerm)), sourceAnnotation);
    }

    public void addExcludedMiddleAxiom(Term term, SourceAnnotation sourceAnnotation) {
        Theory theory = term.getTheory();
        EqualityProxy equalityProxy = this.createEqualityProxy(term, (Term)theory.mTrue, sourceAnnotation);
        EqualityProxy equalityProxy2 = this.createEqualityProxy(term, (Term)theory.mFalse, sourceAnnotation);
        assert (equalityProxy != EqualityProxy.getTrueProxy());
        assert (equalityProxy != EqualityProxy.getFalseProxy());
        assert (equalityProxy2 != EqualityProxy.getTrueProxy());
        assert (equalityProxy2 != EqualityProxy.getFalseProxy());
        DPLLAtom dPLLAtom = equalityProxy.getLiteral(sourceAnnotation);
        DPLLAtom dPLLAtom2 = equalityProxy2.getLiteral(sourceAnnotation);
        Term term2 = theory.term("or", new Term[]{dPLLAtom.getSMTFormula(theory), theory.term("not", new Term[]{term})});
        term2 = this.mTracker.tautology(term2, ProofConstants.TAUT_EXCLUDED_MIDDLE_1);
        this.buildAuxClause(dPLLAtom, term2, sourceAnnotation);
        term2 = theory.term("or", new Term[]{dPLLAtom2.getSMTFormula(theory), term});
        term2 = this.mTracker.tautology(term2, ProofConstants.TAUT_EXCLUDED_MIDDLE_2);
        this.buildAuxClause(dPLLAtom2, term2, sourceAnnotation);
    }

    public void addMatchAxiom(MatchTerm matchTerm, SourceAnnotation sourceAnnotation) {
        Theory theory = matchTerm.getTheory();
        Term term = matchTerm.getDataTerm();
        LinkedHashMap<DataType.Constructor, Term> linkedHashMap = new LinkedHashMap<DataType.Constructor, Term>();
        DataType.Constructor[] constructorArray = matchTerm.getConstructors();
        int n = 0;
        while (n < constructorArray.length) {
            DataType.Constructor constructor = constructorArray[n];
            if (!linkedHashMap.containsKey(constructor)) {
                Term term2;
                FunctionSymbol functionSymbol;
                Annotation annotation;
                LinkedHashMap<TermVariable, Term> linkedHashMap2 = new LinkedHashMap<TermVariable, Term>();
                ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
                if (constructor == null) {
                    arrayDeque.addAll(linkedHashMap.values());
                    linkedHashMap2.put(matchTerm.getVariables()[n][0], term);
                    annotation = ProofConstants.TAUT_MATCH_DEFAULT;
                } else {
                    functionSymbol = theory.getFunctionWithResult("is", new String[]{constructor.getName()}, null, new Sort[]{term.getSort()});
                    term2 = theory.term(functionSymbol, new Term[]{term});
                    linkedHashMap.put(constructorArray[n], term2);
                    arrayDeque.add(theory.term("not", new Term[]{term2}));
                    int n2 = 0;
                    String[] stringArray = constructor.getSelectors();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string = stringArray[n4];
                        Term term3 = theory.term(string, new Term[]{term});
                        linkedHashMap2.put(matchTerm.getVariables()[n][n2++], term3);
                        ++n4;
                    }
                    annotation = ProofConstants.TAUT_MATCH_CASE;
                }
                functionSymbol = new FormulaUnLet();
                functionSymbol.addSubstitutions(linkedHashMap2);
                term2 = this.mTheory.term("=", new Term[]{matchTerm, functionSymbol.unlet(matchTerm.getCases()[n])});
                arrayDeque.add(term2);
                this.buildTautology(theory, arrayDeque.toArray(new Term[arrayDeque.size()]), annotation, sourceAnnotation);
                if (constructor == null) break;
            }
            ++n;
        }
    }

    public EqualityProxy createEqualityProxy(Term term, Term term2, SourceAnnotation sourceAnnotation) {
        Polynomial polynomial = new Polynomial(term);
        polynomial.add(Rational.MONE, term2);
        if (polynomial.isConstant()) {
            if (polynomial.getConstant().equals((Object)Rational.ZERO)) {
                return EqualityProxy.getTrueProxy();
            }
            return EqualityProxy.getFalseProxy();
        }
        polynomial.mul(polynomial.getGcd().inverse());
        Sort sort = term.getSort();
        if (this.mTheory.getLogic().isIRA() && sort.getName().equals("Real") && polynomial.isAllIntSummands()) {
            sort = this.getTheory().getSort("Int", new Sort[0]);
        }
        if (sort.getName().equals("Int") && !polynomial.getConstant().isIntegral()) {
            return EqualityProxy.getFalseProxy();
        }
        this.addTermAxioms(term, sourceAnnotation);
        this.addTermAxioms(term2, sourceAnnotation);
        EqualityProxy equalityProxy = (EqualityProxy)this.mEqualities.get((Object)polynomial);
        if (equalityProxy != null) {
            return equalityProxy;
        }
        polynomial.mul(Rational.MONE);
        equalityProxy = (EqualityProxy)this.mEqualities.get((Object)polynomial);
        if (equalityProxy != null) {
            return equalityProxy;
        }
        equalityProxy = new EqualityProxy(this, term, term2);
        this.mEqualities.put((Object)polynomial, (Object)equalityProxy);
        return equalityProxy;
    }

    public static Term checkAndGetTrivialEquality(Term term, Term term2, Theory theory) {
        Polynomial polynomial = new Polynomial(term);
        polynomial.add(Rational.MONE, term2);
        if (polynomial.isConstant()) {
            if (polynomial.getConstant().equals((Object)Rational.ZERO)) {
                return theory.mTrue;
            }
            return theory.mFalse;
        }
        polynomial.mul(polynomial.getGcd().inverse());
        Sort sort = term.getSort();
        if (theory.getLogic().isIRA() && sort.getName().equals("Real") && polynomial.isAllIntSummands()) {
            sort = theory.getSort("Int", new Sort[0]);
        }
        if (sort.getName().equals("Int") && !polynomial.getConstant().isIntegral()) {
            return theory.mFalse;
        }
        return null;
    }

    public Term createQuantAuxTerm(Term term, SourceAnnotation sourceAnnotation) {
        Term term2 = (Term)this.mAnonAuxTerms.get((Object)term);
        if (term2 == null) {
            assert (this.mTheory.getLogic().isQuantified()) : "quantified variables in quantifier-free theory";
            TermVariable[] termVariableArray = new TermVariable[term.getFreeVars().length];
            Term[] termArray = new Term[termVariableArray.length];
            int n = 0;
            while (n < termVariableArray.length) {
                termVariableArray[n] = term.getFreeVars()[n];
                termArray[n] = termVariableArray[n];
                ++n;
            }
            FunctionSymbol functionSymbol = this.mTheory.createFreshAuxFunction(termVariableArray, term);
            term2 = this.mTheory.term(functionSymbol, termArray);
            this.addAuxAxiomsQuant(term, term2, sourceAnnotation);
            this.mAnonAuxTerms.put((Object)term, (Object)term2);
        }
        return term2;
    }

    public ILiteral createAnonLiteral(Term term, SourceAnnotation sourceAnnotation) {
        ILiteral iLiteral = this.getILiteral(term);
        if (iLiteral == null) {
            if (term.getFreeVars().length > 0) {
                Term term2 = this.createQuantAuxTerm(term, sourceAnnotation);
                iLiteral = this.mQuantTheory.createAuxLiteral(term2, term, sourceAnnotation);
            } else {
                iLiteral = new NamedAtom(term, this.mStackLevel);
                this.mEngine.addAtom((NamedAtom)iLiteral);
            }
            this.setLiteral(term, iLiteral);
        }
        assert (iLiteral != null);
        return iLiteral;
    }

    ILiteral getLiteralTseitin(Term term, SourceAnnotation sourceAnnotation) {
        Term term2 = Clausifier.toPositive(term);
        boolean bl = term == term2;
        ILiteral iLiteral = this.createAnonLiteral(term2, sourceAnnotation);
        if (term2.getFreeVars().length == 0) {
            this.addAuxAxioms(term2, true, sourceAnnotation);
            this.addAuxAxioms(term2, false, sourceAnnotation);
        }
        return bl ? iLiteral : iLiteral.negate();
    }

    void addClause(Literal[] literalArray, ClauseDeletionHook clauseDeletionHook, ProofNode proofNode) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("Added Ground Clause: %s", Arrays.toString(literalArray));
        }
        if (this.mEprTheory != null) {
            this.mEprTheory.addConstants(EprHelpers.collectAppearingConstants(literalArray, this.mTheory));
        }
        this.mEngine.addFormulaClause(literalArray, proofNode, clauseDeletionHook);
    }

    void addUnshareCC(Term term) {
        this.mUnshareCC.add(term);
    }

    private void setupCClosure() {
        if (this.mCClosure == null) {
            this.mCClosure = new CClosure(this);
            this.mEngine.addTheory(this.mCClosure);
            SourceAnnotation sourceAnnotation = SourceAnnotation.EMPTY_SOURCE_ANNOT;
            DPLLAtom dPLLAtom = this.createEqualityProxy((Term)this.mTheory.mTrue, (Term)this.mTheory.mFalse, sourceAnnotation).getLiteral(sourceAnnotation);
            Term term = this.mTheory.term("=", new Term[]{this.mTheory.mTrue, this.mTheory.mFalse});
            Term term2 = this.mTracker.tautology(this.mTheory.not(term), ProofConstants.TAUT_TRUE_NOT_FALSE);
            BuildClause buildClause = new BuildClause(term2, sourceAnnotation);
            buildClause.mCurrentLits.add(this.mTheory.not(term));
            Term term3 = this.mTracker.intern(term, dPLLAtom.getSMTFormula(this.mTheory));
            buildClause.addLiteral(dPLLAtom.negate(), term, term3, false);
            buildClause.perform();
        }
    }

    private void setupLinArithmetic() {
        if (this.mLASolver == null) {
            this.mLASolver = new LinArSolve(this);
            this.mEngine.addTheory(this.mLASolver);
        }
    }

    private void setupArrayTheory() {
        if (this.mArrayTheory == null) {
            this.mArrayTheory = new ArrayTheory(this, this.mCClosure);
            this.mEngine.addTheory(this.mArrayTheory);
        }
    }

    private void setupDataTypeTheory() {
        if (this.mDataTypeTheory == null) {
            this.mDataTypeTheory = new DataTypeTheory(this, this.mTheory, this.mCClosure);
            this.mEngine.addTheory(this.mDataTypeTheory);
        }
    }

    private void setupEprTheory() {
        if (this.mEprTheory == null) {
            this.mEprTheory = new EprTheory(this.mTheory, this.mEngine, this.mCClosure, this);
            this.mEngine.addTheory(this.mEprTheory);
        }
    }

    private void setupQuantifiers() {
        if (this.mQuantTheory == null) {
            this.mQuantTheory = new QuantifierTheory(this.mTheory, this.mEngine, this, this.mInstantiationMethod, this.mIsUnknownTermDawgsEnabled, this.mPropagateUnknownTerms, this.mPropagateUnknownAux);
            this.mEngine.addTheory(this.mQuantTheory);
        }
    }

    public void setQuantifierOptions(boolean bl, QuantifierTheory.InstantiationMethod instantiationMethod, boolean bl2, boolean bl3, boolean bl4) {
        this.mIsEprEnabled = bl;
        this.mInstantiationMethod = instantiationMethod;
        this.mIsUnknownTermDawgsEnabled = bl2;
        this.mPropagateUnknownTerms = bl3;
        this.mPropagateUnknownAux = bl4;
    }

    private boolean isBasicStablyInfinite(Sort sort) {
        assert (sort == sort.getRealSort() && !sort.isSortVariable());
        assert (!sort.getSortSymbol().isDatatype() && !sort.isArraySort());
        if (sort.equals(sort.getTheory().getBooleanSort()) || sort.isBitVecSort()) {
            return false;
        }
        if (!sort.isInternal()) {
            return this.mQuantTheory == null;
        }
        assert (sort.isNumericSort());
        return true;
    }

    public boolean isSingleton(Sort sort) {
        if ((sort = sort.getRealSort()).isArraySort()) {
            return this.isSingleton(sort.getArguments()[1]);
        }
        if (sort.getSortSymbol().isDatatype()) {
            DataType.Constructor[] constructorArray = ((DataType)sort.getSortSymbol()).getConstructors();
            if (constructorArray.length != 1) {
                return false;
            }
            Sort[] sortArray = sort.getArguments();
            Sort[] sortArray2 = constructorArray[0].getArgumentSorts();
            int n = sortArray2.length;
            int n2 = 0;
            while (n2 < n) {
                Sort sort2 = sortArray2[n2];
                if (sortArray.length != 0) {
                    sort2 = sort2.mapSort(sortArray);
                }
                if (!this.isSingleton(sort2)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public boolean isStablyInfinite(Sort sort) {
        if (!(sort = sort.getRealSort()).getSortSymbol().isDatatype() && !sort.isArraySort()) {
            return this.isBasicStablyInfinite(sort);
        }
        Boolean bl = this.mInfinityMap.get(sort);
        if (bl != null) {
            return bl;
        }
        ArrayDeque<Sort> arrayDeque = new ArrayDeque<Sort>();
        LinkedHashSet<Sort> linkedHashSet = new LinkedHashSet<Sort>();
        arrayDeque.push(sort);
        block0: while (!arrayDeque.isEmpty()) {
            Object object;
            Sort sort2 = (Sort)arrayDeque.pop();
            assert (sort2.getSortSymbol().isDatatype() || sort2.isArraySort());
            if (this.mInfinityMap.get(sort2) != null) continue;
            LinkedHashSet<Sort> linkedHashSet2 = new LinkedHashSet<Sort>();
            if (sort2.getSortSymbol().isDatatype()) {
                object = sort2.getArguments();
                DataType.Constructor[] constructorArray = ((DataType)sort2.getSortSymbol()).getConstructors();
                int n = constructorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DataType.Constructor constructor = constructorArray[n2];
                    Sort[] sortArray = constructor.getArgumentSorts();
                    int n3 = sortArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Sort sort3 = sortArray[n4];
                        if (((Object)object).length > 0) {
                            sort3 = sort3.mapSort((Sort[])object);
                        }
                        linkedHashSet2.add(sort3.getRealSort());
                        ++n4;
                    }
                    ++n2;
                }
            } else {
                object = sort2.getArguments();
                if (!this.isSingleton(object[1])) {
                    linkedHashSet2.addAll(Arrays.asList(object));
                }
            }
            linkedHashSet.add(sort2);
            object = linkedHashSet2.iterator();
            while (object.hasNext()) {
                Boolean bl2;
                Sort sort4 = (Sort)object.next();
                Boolean bl3 = linkedHashSet.contains(sort4) ? Boolean.TRUE : (bl2 = sort4.getSortSymbol().isDatatype() || sort4.isArraySort() ? this.mInfinityMap.get(sort4) : Boolean.valueOf(this.isBasicStablyInfinite(sort4)));
                if (bl2 == null) continue;
                object.remove();
                if (!bl2.booleanValue()) continue;
                this.mInfinityMap.put(sort2, true);
                linkedHashSet.remove(sort2);
                continue block0;
            }
            if (!linkedHashSet2.isEmpty()) {
                arrayDeque.push(sort2);
                for (Sort sort5 : linkedHashSet2) {
                    arrayDeque.push(sort5);
                }
                continue;
            }
            this.mInfinityMap.put(sort2, false);
            linkedHashSet.remove(sort2);
        }
        return this.mInfinityMap.get(sort);
    }

    public void setLogic(Logics logics) {
        if (logics.isUF() || logics.isArray() || logics.isArithmetic() || logics.isQuantified() || logics.isDatatype() || logics.isBitVector()) {
            this.setupCClosure();
        }
        if (logics.isArray()) {
            this.setupArrayTheory();
        }
        if (logics.isDatatype()) {
            this.setupDataTypeTheory();
        }
        if (logics.isArithmetic() || logics.isBitVector()) {
            this.setupLinArithmetic();
        }
        if (logics.isQuantified()) {
            if (this.mIsEprEnabled) {
                this.setupEprTheory();
            } else {
                this.setupQuantifiers();
            }
        }
    }

    public Iterable<BooleanVarAtom> getBooleanVars() {
        final Iterator iterator = this.mLiterals.values().iterator();
        return () -> new Iterator<BooleanVarAtom>(){
            private BooleanVarAtom mNext = this.computeNext();

            private final BooleanVarAtom computeNext() {
                while (iterator.hasNext()) {
                    ILiteral iLiteral = (ILiteral)iterator.next();
                    if (!(iLiteral instanceof BooleanVarAtom)) continue;
                    return (BooleanVarAtom)iLiteral;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.mNext != null;
            }

            @Override
            public BooleanVarAtom next() {
                BooleanVarAtom booleanVarAtom = this.mNext;
                if (booleanVarAtom == null) {
                    throw new NoSuchElementException();
                }
                this.mNext = this.computeNext();
                return booleanVarAtom;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private final void run() {
        try {
            this.mIsRunning = true;
            while (!this.mTodoStack.isEmpty()) {
                if (this.mEngine.isTerminationRequested()) {
                    return;
                }
                Operation operation = this.mTodoStack.pop();
                operation.perform();
            }
        }
        finally {
            this.mTodoStack.clear();
            this.mIsRunning = false;
        }
    }

    public DPLLEngine getEngine() {
        return this.mEngine;
    }

    public ArrayTheory getArrayTheory() {
        return this.mArrayTheory;
    }

    public CClosure getCClosure() {
        return this.mCClosure;
    }

    public LinArSolve getLASolver() {
        return this.mLASolver;
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    public int getStackLevel() {
        return this.mStackLevel;
    }

    public void addFormula(Term term) {
        Object object;
        Term term2;
        Term term3;
        assert (this.mTodoStack.isEmpty());
        if (this.mEngine.inconsistent() && !this.mWarnedInconsistent) {
            this.mLogger.info("Already inconsistent.");
            this.mWarnedInconsistent = true;
            return;
        }
        SourceAnnotation sourceAnnotation = SourceAnnotation.EMPTY_SOURCE_ANNOT;
        if (this.mEngine.isProofGenerationEnabled() && term instanceof AnnotatedTerm) {
            term3 = (AnnotatedTerm)term;
            Term term4 = term2 = term3.getAnnotations();
            int n = ((Annotation[])term4).length;
            int n2 = 0;
            while (n2 < n) {
                object = term4[n2];
                if (object.getKey().equals(":named")) {
                    String string = ((String)object.getValue()).intern();
                    sourceAnnotation = new SourceAnnotation(string, null);
                    break;
                }
                ++n2;
            }
        }
        term3 = this.mUnlet.unlet(term);
        try {
            term2 = this.mCompiler.transform(this.removeDoubleNot(term3));
        }
        finally {
            this.mCompiler.reset();
        }
        term2 = this.mTracker.modusPonens(this.mTracker.asserted(term3), term2);
        term3 = null;
        this.mOccCounter.count(this.mTracker.getProvedTerm(term2));
        object = this.mCompiler.getNames();
        if (object != null) {
            for (Map.Entry entry : object.entrySet()) {
                this.trackAssignment((Term)entry.getKey(), (Set)entry.getValue(), sourceAnnotation);
            }
        }
        this.pushOperation(new AddAsAxiom(term2, sourceAnnotation));
        this.run();
        this.mOccCounter.reset(term2);
        term2 = null;
    }

    public void push() {
        if (this.mEngine.inconsistent()) {
            if (!this.mWarnedInconsistent) {
                this.mLogger.info("Already inconsistent.");
                this.mWarnedInconsistent = true;
            }
            ++this.mNumFailedPushes;
        } else {
            this.mEngine.push();
            ++this.mStackLevel;
            this.mEqualities.beginScope();
            this.mTermDataFlags.beginScope();
            this.mLiterals.beginScope();
            this.mAnonAuxTerms.beginScope();
            this.mLATerms.beginScope();
            this.mCCTerms.beginScope();
        }
    }

    public void pop(int n) {
        if (n <= this.mNumFailedPushes) {
            this.mNumFailedPushes -= n;
            return;
        }
        this.mWarnedInconsistent = false;
        this.mNumFailedPushes = 0;
        this.mEngine.pop(n -= this.mNumFailedPushes);
        int n2 = 0;
        while (n2 < n) {
            this.mCCTerms.endScope();
            for (Term term : this.mLATerms.undoMap().keySet()) {
                CCTerm cCTerm = this.getCCTerm(term);
                if (cCTerm == null) continue;
                cCTerm.unshare();
            }
            this.mLATerms.endScope();
            this.mLiterals.endScope();
            this.mAnonAuxTerms.endScope();
            this.mTermDataFlags.endScope();
            this.mEqualities.endScope();
            ++n2;
        }
        this.mStackLevel -= n;
        this.mInfinityMap.clear();
    }

    private ProofNode getProofNewSource(Term term, SourceAnnotation sourceAnnotation) {
        SourceAnnotation sourceAnnotation2 = term == null ? sourceAnnotation : new SourceAnnotation(sourceAnnotation, term);
        return new LeafNode(-1, sourceAnnotation2);
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    private void trackAssignment(Term term, Set<String> set, SourceAnnotation sourceAnnotation) {
        EqualityProxy equalityProxy;
        ApplicationTerm object3;
        Object object;
        boolean bl;
        Term term2 = Clausifier.toPositive(term);
        boolean bl2 = bl = term2 == term;
        ILiteral iLiteral = term2 instanceof ApplicationTerm ? ((object = (object3 = (ApplicationTerm)term2).getFunction()).getName().equals("<=") ? this.createLeq0(object3, sourceAnnotation) : (object.getName().equals("=") && object3.getParameters()[0].getSort() != this.mTheory.getBooleanSort() ? ((equalityProxy = this.createEqualityProxy(object3.getParameters()[0], object3.getParameters()[1], sourceAnnotation)) == EqualityProxy.getTrueProxy() ? new DPLLAtom.TrueAtom() : (equalityProxy == EqualityProxy.getFalseProxy() ? new DPLLAtom.TrueAtom().negate() : equalityProxy.getLiteral(sourceAnnotation))) : ((!object.isIntern() || object.getName().equals("select")) && object.getReturnSort() == this.mTheory.getBooleanSort() ? this.createBooleanLit(object3, sourceAnnotation) : (object3 == this.mTheory.mTrue ? new DPLLAtom.TrueAtom() : (object3 == this.mTheory.mFalse ? new DPLLAtom.TrueAtom().negate() : this.getLiteralTseitin(term2, sourceAnnotation)))))) : this.getLiteralTseitin(term2, sourceAnnotation);
        assert (iLiteral instanceof Literal);
        if (!bl) {
            iLiteral = iLiteral.negate();
        }
        for (String string : set) {
            this.mEngine.trackAssignment(string, (Literal)iLiteral);
        }
    }

    private Literal createLeq0(ApplicationTerm applicationTerm, SourceAnnotation sourceAnnotation) {
        Literal literal = (Literal)this.getILiteral((Term)applicationTerm);
        if (literal == null) {
            assert (((ConstantTerm)applicationTerm.getParameters()[1]).getValue() == Rational.ZERO);
            Polynomial polynomial = new Polynomial(applicationTerm.getParameters()[0]);
            MutableAffineTerm mutableAffineTerm = this.createMutableAffinTerm(polynomial, sourceAnnotation);
            literal = this.mLASolver.generateConstraint(mutableAffineTerm, false);
            this.setLiteral((Term)applicationTerm, literal);
            this.setTermFlags((Term)applicationTerm, this.getTermFlags((Term)applicationTerm) | 4 | 8);
        }
        return literal;
    }

    private ILiteral createBooleanLit(ApplicationTerm applicationTerm, SourceAnnotation sourceAnnotation) {
        ILiteral iLiteral = this.getILiteral((Term)applicationTerm);
        if (iLiteral == null) {
            if (applicationTerm.getParameters().length == 0) {
                BooleanVarAtom booleanVarAtom = new BooleanVarAtom((Term)applicationTerm, this.mStackLevel);
                this.mEngine.addAtom(booleanVarAtom);
                iLiteral = booleanVarAtom;
            } else if (applicationTerm.getFreeVars().length > 0 && !this.mIsEprEnabled) {
                iLiteral = this.mQuantTheory.getQuantEquality((Term)applicationTerm, (Term)this.mTheory.mTrue, sourceAnnotation);
            } else if (this.mEprTheory != null || EprTheory.isQuantifiedEprAtom((Term)applicationTerm)) {
                assert (!applicationTerm.getFunction().getName().equals("not")) : "do something for the negated case!";
                EprAtom eprAtom = this.mEprTheory.getEprAtom(applicationTerm, 0, this.mStackLevel, sourceAnnotation);
                iLiteral = eprAtom;
                if (eprAtom instanceof EprGroundPredicateAtom) {
                    this.mEprTheory.addAtomToDPLLEngine(eprAtom);
                }
            } else {
                EqualityProxy equalityProxy = this.createEqualityProxy((Term)applicationTerm, (Term)this.mTheory.mTrue, sourceAnnotation);
                assert (equalityProxy != EqualityProxy.getTrueProxy());
                assert (equalityProxy != EqualityProxy.getFalseProxy());
                iLiteral = equalityProxy.getLiteral(sourceAnnotation);
            }
            this.setLiteral((Term)applicationTerm, iLiteral);
            this.setTermFlags((Term)applicationTerm, this.getTermFlags((Term)applicationTerm) | 4 | 8);
        }
        return iLiteral;
    }

    public IProofTracker getTracker() {
        return this.mTracker;
    }

    public LogicSimplifier getSimplifier() {
        return this.mUtils;
    }

    public Literal getCreateLiteral(Term term, SourceAnnotation sourceAnnotation) {
        Literal literal;
        Term term2;
        Term term3 = this.mUnlet.unlet(term);
        try {
            term2 = this.mCompiler.transform(term3);
        }
        finally {
            this.mCompiler.reset();
        }
        term3 = null;
        this.mOccCounter.count(term2);
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mTracker.getProvedTerm(term2);
        boolean bl = false;
        FunctionSymbol functionSymbol = applicationTerm.getFunction();
        if (functionSymbol == this.mTheory.mNot) {
            applicationTerm = (ApplicationTerm)applicationTerm.getParameters()[0];
            functionSymbol = applicationTerm.getFunction();
            bl = true;
        }
        if (!functionSymbol.isIntern() || functionSymbol.getName().equals("select")) {
            ILiteral iLiteral = this.createBooleanLit(applicationTerm, sourceAnnotation);
            assert (iLiteral instanceof Literal);
            literal = (Literal)iLiteral;
        } else if (applicationTerm == this.mTheory.mTrue) {
            literal = new DPLLAtom.TrueAtom();
        } else if (applicationTerm == this.mTheory.mFalse) {
            literal = new DPLLAtom.TrueAtom().negate();
        } else if (functionSymbol.getName().equals("xor")) {
            ILiteral iLiteral = this.getLiteralTseitin((Term)applicationTerm, sourceAnnotation);
            assert (iLiteral instanceof Literal);
            literal = (Literal)iLiteral;
        } else if (functionSymbol.getName().equals("=")) {
            EqualityProxy equalityProxy = this.createEqualityProxy(applicationTerm.getParameters()[0], applicationTerm.getParameters()[1], sourceAnnotation);
            literal = equalityProxy == EqualityProxy.getFalseProxy() ? new DPLLAtom.TrueAtom().negate() : (equalityProxy == EqualityProxy.getTrueProxy() ? new DPLLAtom.TrueAtom() : equalityProxy.getLiteral(sourceAnnotation));
        } else if (functionSymbol.getName().equals("<=")) {
            literal = this.createLeq0(applicationTerm, sourceAnnotation);
        } else {
            ILiteral iLiteral = this.getLiteralTseitin((Term)applicationTerm, sourceAnnotation);
            assert (iLiteral instanceof Literal);
            literal = (Literal)iLiteral;
        }
        this.run();
        this.mOccCounter.reset(term2);
        term2 = null;
        return bl ? literal.negate() : literal;
    }

    public EprTheory getEprTheory() {
        return this.mEprTheory;
    }

    public QuantifierTheory getQuantifierTheory() {
        return this.mQuantTheory;
    }

    public TermCompiler getTermCompiler() {
        return this.mCompiler;
    }

    private class AddAsAxiom
    implements Operation {
        private final Term mAxiom;
        private final SourceAnnotation mSource;

        public AddAsAxiom(Term term, SourceAnnotation sourceAnnotation) {
            assert (term.getSort().getName() == "Bool");
            this.mAxiom = term;
            this.mSource = sourceAnnotation;
        }

        @Override
        public void perform() {
            int n;
            int n2;
            Term term = Clausifier.this.mTracker.getProvedTerm(this.mAxiom);
            boolean bl = true;
            while (Clausifier.isNotTerm(term)) {
                term = Clausifier.toPositive(term);
                boolean bl2 = bl = !bl;
            }
            int n3 = Clausifier.this.getTermFlags(term);
            if (bl) {
                n2 = 1;
                n = 4;
            } else {
                n2 = 2;
                n = 8;
            }
            if ((n3 & n2) != 0) {
                return;
            }
            Clausifier.this.setTermFlags(term, n3 | n2);
            ILiteral iLiteral = Clausifier.this.getILiteral(term);
            if (iLiteral != null) {
                if ((n3 & n) == 0) {
                    Clausifier.this.addAuxAxioms(term, bl, this.mSource);
                }
                Clausifier.this.buildClause(this.mAxiom, this.mSource);
                return;
            }
            Theory theory = this.mAxiom.getTheory();
            if (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                if (!bl && applicationTerm.getFunction() == theory.mOr) {
                    Clausifier.this.setTermFlags(term, n3 | n2 | n);
                    Term[] termArray = applicationTerm.getParameters();
                    int n4 = termArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Term term2 = termArray[n5];
                        Term term3 = Clausifier.this.mTracker.resolveBinaryTautology(this.mAxiom, theory.term("not", new Term[]{term2}), ProofConstants.TAUT_OR_POS);
                        Clausifier.this.pushOperation(new AddAsAxiom(term3, this.mSource));
                        ++n5;
                    }
                    return;
                }
                if (bl && applicationTerm.getFunction() == theory.mAnd) {
                    Clausifier.this.setTermFlags(term, n3 | n2 | n);
                    Term[] termArray = applicationTerm.getParameters();
                    int n6 = termArray.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Term term4 = termArray[n7];
                        Term term5 = Clausifier.this.mTracker.resolveBinaryTautology(this.mAxiom, term4, ProofConstants.TAUT_AND_NEG);
                        Clausifier.this.pushOperation(new AddAsAxiom(term5, this.mSource));
                        ++n7;
                    }
                    return;
                }
                if (!bl && applicationTerm.getFunction() == theory.mImplies) {
                    Clausifier.this.setTermFlags(term, n3 | n2 | n);
                    Term[] termArray = applicationTerm.getParameters();
                    int n8 = 0;
                    while (n8 < termArray.length) {
                        Term term6 = n8 < termArray.length - 1 ? termArray[n8] : theory.term("not", new Term[]{termArray[n8]});
                        Term term7 = Clausifier.this.mTracker.resolveBinaryTautology(this.mAxiom, term6, ProofConstants.TAUT_IMP_POS);
                        Clausifier.this.pushOperation(new AddAsAxiom(term7, this.mSource));
                        ++n8;
                    }
                    return;
                }
                if (applicationTerm.getFunction().getName().equals("xor") && applicationTerm.getParameters()[0].getSort() == theory.getBooleanSort()) {
                    Clausifier.this.setTermFlags(term, n3 | n2 | n);
                    Term term8 = applicationTerm.getParameters()[0];
                    Term term9 = applicationTerm.getParameters()[1];
                    if (bl) {
                        Term term10 = theory.term("not", new Term[]{term});
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{term10, term8, term9}, ProofConstants.TAUT_XOR_NEG_1);
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{term10, theory.term("not", new Term[]{term8}), theory.term("not", new Term[]{term9})}, ProofConstants.TAUT_XOR_NEG_2);
                    } else {
                        Term term11 = term;
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{term11, term8, theory.term("not", new Term[]{term9})}, ProofConstants.TAUT_XOR_POS_1);
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{term11, theory.term("not", new Term[]{term8}), term9}, ProofConstants.TAUT_XOR_POS_2);
                    }
                    return;
                }
                if (applicationTerm.getFunction().getName().equals("ite")) {
                    Clausifier.this.setTermFlags(term, n3 | n2 | n);
                    assert (applicationTerm.getFunction().getReturnSort() == theory.getBooleanSort());
                    Term term12 = applicationTerm.getParameters()[0];
                    Term term13 = applicationTerm.getParameters()[1];
                    Term term14 = applicationTerm.getParameters()[2];
                    if (bl) {
                        Term term15 = theory.term("not", new Term[]{term});
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{term15, theory.term("not", new Term[]{term12}), term13}, ProofConstants.TAUT_ITE_NEG_1);
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{term15, term12, term14}, ProofConstants.TAUT_ITE_NEG_2);
                    } else {
                        Term term16 = term;
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{term16, theory.term("not", new Term[]{term12}), theory.term("not", new Term[]{term13})}, ProofConstants.TAUT_ITE_POS_1);
                        Clausifier.this.buildClauseWithTautology(this.mAxiom, this.mSource, new Term[]{term16, term12, theory.term("not", new Term[]{term14})}, ProofConstants.TAUT_ITE_POS_2);
                    }
                    return;
                }
            } else if (term instanceof QuantifiedFormula) {
                QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
                Pair<Term, Annotation> pair = Clausifier.this.convertQuantifiedSubformula(bl, quantifiedFormula);
                Annotation annotation = pair.getSecond();
                Term term17 = Clausifier.this.mTracker.resolveBinaryTautology(this.mAxiom, pair.getFirst(), annotation);
                Term term18 = Clausifier.this.mCompiler.transform(Clausifier.this.mTracker.getProvedTerm(term17));
                Term term19 = Clausifier.this.mTracker.modusPonens(term17, term18);
                Clausifier.this.pushOperation(new AddAsAxiom(term19, this.mSource));
                return;
            }
            Clausifier.this.buildClause(this.mAxiom, this.mSource);
        }
    }

    private class AddTermITEAxiom
    implements Operation {
        private final SourceAnnotation mSource;
        private Term mMinValue = null;
        private Rational mMaxSubMin = null;
        private final Set<Term> visited = new HashSet<Term>();
        boolean mIsNotConstant = false;
        private final Term mTermITE;

        public AddTermITEAxiom(Term term, SourceAnnotation sourceAnnotation) {
            this.mTermITE = term;
            this.mSource = sourceAnnotation;
        }

        @Override
        public void perform() {
            Clausifier.this.pushOperation(new CollectConditions(new LinkedHashSet<Term>(), this.mTermITE));
            Clausifier.this.pushOperation(new AddBoundAxioms());
            Clausifier.this.pushOperation(new CheckBounds(this.mTermITE));
        }

        private class AddBoundAxioms
        implements Operation {
            @Override
            public void perform() {
                if (!AddTermITEAxiom.this.mIsNotConstant && AddTermITEAxiom.this.mMinValue != null) {
                    Sort sort = AddTermITEAxiom.this.mTermITE.getSort();
                    Theory theory = sort.getTheory();
                    Term term = Rational.ZERO.toTerm(sort);
                    Polynomial polynomial = new Polynomial(AddTermITEAxiom.this.mMinValue);
                    polynomial.add(Rational.MONE, AddTermITEAxiom.this.mTermITE);
                    Term term2 = theory.term("<=", new Term[]{((AddTermITEAxiom)AddTermITEAxiom.this).Clausifier.this.mCompiler.unifyPolynomial(polynomial, sort), term});
                    Clausifier.this.buildClause(((AddTermITEAxiom)AddTermITEAxiom.this).Clausifier.this.mTracker.tautology(term2, ProofConstants.TAUT_TERM_ITE_BOUND), AddTermITEAxiom.this.mSource);
                    polynomial.add(AddTermITEAxiom.this.mMaxSubMin);
                    polynomial.mul(Rational.MONE);
                    Term term3 = theory.term("<=", new Term[]{((AddTermITEAxiom)AddTermITEAxiom.this).Clausifier.this.mCompiler.unifyPolynomial(polynomial, sort), term});
                    Clausifier.this.buildClause(((AddTermITEAxiom)AddTermITEAxiom.this).Clausifier.this.mTracker.tautology(term3, ProofConstants.TAUT_TERM_ITE_BOUND), AddTermITEAxiom.this.mSource);
                }
            }
        }

        private class CheckBounds
        implements Operation {
            private final Term mTerm;

            public CheckBounds(Term term) {
                this.mTerm = term;
            }

            @Override
            public void perform() {
                Object object;
                if (AddTermITEAxiom.this.mIsNotConstant || !AddTermITEAxiom.this.visited.add(this.mTerm)) {
                    return;
                }
                if (this.mTerm instanceof ApplicationTerm && (object = (ApplicationTerm)this.mTerm).getFunction().getName().equals("ite")) {
                    Term term = object.getParameters()[1];
                    Term term2 = object.getParameters()[2];
                    Clausifier.this.pushOperation(new CheckBounds(term));
                    Clausifier.this.pushOperation(new CheckBounds(term2));
                    return;
                }
                if (AddTermITEAxiom.this.mMinValue == null) {
                    AddTermITEAxiom.this.mMinValue = this.mTerm;
                    AddTermITEAxiom.this.mMaxSubMin = Rational.ZERO;
                    return;
                }
                object = new Polynomial(this.mTerm);
                ((Polynomial)object).add(Rational.MONE, AddTermITEAxiom.this.mMinValue);
                if (!((Polynomial)object).isConstant()) {
                    AddTermITEAxiom.this.mIsNotConstant = true;
                    return;
                }
                if (((Polynomial)object).getConstant().signum() < 0) {
                    AddTermITEAxiom.this.mMinValue = this.mTerm;
                    AddTermITEAxiom.this.mMaxSubMin = AddTermITEAxiom.this.mMaxSubMin.sub(((Polynomial)object).getConstant());
                } else if (((Polynomial)object).getConstant().compareTo(AddTermITEAxiom.this.mMaxSubMin) > 0) {
                    AddTermITEAxiom.this.mMaxSubMin = ((Polynomial)object).getConstant();
                }
            }
        }

        private class CollectConditions
        implements Operation {
            private final LinkedHashSet<Term> mConds;
            private final Term mTerm;

            public CollectConditions(LinkedHashSet<Term> linkedHashSet, Term term) {
                this.mConds = linkedHashSet;
                this.mTerm = term;
            }

            @Override
            public void perform() {
                ApplicationTerm applicationTerm;
                if (this.mTerm instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)this.mTerm).getFunction().getName().equals("ite") && (applicationTerm.mTmpCtr <= 1 || this.mConds.size() == 0)) {
                    Term term = applicationTerm.getParameters()[1];
                    Term term2 = applicationTerm.getParameters()[2];
                    Term term3 = applicationTerm.getParameters()[0];
                    boolean bl = false;
                    while (Clausifier.isNotTerm(term3)) {
                        term3 = ((ApplicationTerm)term3).getParameters()[0];
                        boolean bl2 = bl = !bl;
                    }
                    Term term4 = term3.getTheory().term("not", new Term[]{term3});
                    if (this.mConds.contains(term3)) {
                        Clausifier.this.pushOperation(new CollectConditions(this.mConds, bl ? term : term2));
                    } else if (this.mConds.contains(term4)) {
                        Clausifier.this.pushOperation(new CollectConditions(this.mConds, bl ? term2 : term));
                    } else {
                        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>(this.mConds);
                        this.mConds.add(bl ? term3 : term4);
                        linkedHashSet.add(bl ? term4 : term3);
                        Clausifier.this.pushOperation(new CollectConditions(this.mConds, term));
                        Clausifier.this.pushOperation(new CollectConditions(linkedHashSet, term2));
                    }
                    return;
                }
                applicationTerm = this.mTerm.getTheory();
                Term[] termArray = new Term[this.mConds.size() + 1];
                int n = this.mConds.size();
                for (Term term : this.mConds) {
                    termArray[--n] = term;
                }
                termArray[this.mConds.size()] = applicationTerm.term("=", new Term[]{AddTermITEAxiom.this.mTermITE, this.mTerm});
                Clausifier.this.buildTautology((Theory)applicationTerm, termArray, ProofConstants.TAUT_TERM_ITE, AddTermITEAxiom.this.mSource);
            }
        }
    }

    class BooleanSubtermReplacer
    extends TermTransformer {
        private final SourceAnnotation mSource;

        public BooleanSubtermReplacer(SourceAnnotation sourceAnnotation) {
            this.mSource = sourceAnnotation;
        }

        public void convert(Term term) {
            if (term.getSort().getName() == "Bool" && this.shouldReplaceTerm(term)) {
                Term term2 = Clausifier.this.createQuantAuxTerm(term, this.mSource);
                this.setResult(Clausifier.this.mTracker.buildRewrite(term, term2, ProofConstants.RW_AUX_INTRO));
                return;
            }
            if (!(term instanceof ApplicationTerm)) {
                this.setResult(Clausifier.this.mTracker.reflexivity(term));
                return;
            }
            super.convert(term);
        }

        public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
            this.setResult(Clausifier.this.mTracker.congruence(Clausifier.this.mTracker.reflexivity((Term)applicationTerm), termArray));
        }

        boolean shouldReplaceTerm(Term term) {
            return term.getFreeVars().length != 0 && !(term instanceof TermVariable) && (!Clausifier.needCCTerm(term) || term instanceof QuantifiedFormula || term instanceof MatchTerm);
        }
    }

    private class BuildClause
    implements Operation {
        private final Term mClause;
        private Term mProof;
        private boolean mIsTrue = false;
        private final LinkedHashSet<Term> mCurrentLits = new LinkedHashSet();
        private final LinkedHashSet<Literal> mLits = new LinkedHashSet();
        private final LinkedHashSet<QuantLiteral> mQuantLits = new LinkedHashSet();
        private final SourceAnnotation mSource;

        public BuildClause(Term term, SourceAnnotation sourceAnnotation) {
            this.mClause = term;
            this.mSource = sourceAnnotation;
            this.mProof = Clausifier.this.mTracker.getClauseProof(term);
        }

        public SourceAnnotation getSource() {
            return this.mSource;
        }

        public void collectLiteral(Term term) {
            while (Clausifier.isNotTerm(term) && Clausifier.isNotTerm(((ApplicationTerm)term).getParameters()[0])) {
                Term term2 = ((ApplicationTerm)term).getParameters()[0];
                term = ((ApplicationTerm)term2).getParameters()[0];
            }
            if (this.mCurrentLits.add(term)) {
                Clausifier.this.pushOperation(new CollectLiteral(term, this));
            }
        }

        public void addLiteral(ILiteral iLiteral) {
            if (iLiteral instanceof Literal) assert (((Literal)iLiteral).getAtom().getAssertionStackLevel() <= Clausifier.this.mEngine.getAssertionStackLevel());
            if (iLiteral == mTRUE) {
                this.mIsTrue = true;
            } else {
                if (iLiteral == mFALSE) {
                    return;
                }
                if (iLiteral instanceof Literal && this.mLits.add((Literal)iLiteral)) {
                    this.mIsTrue |= this.mLits.contains(((Literal)iLiteral).negate());
                } else if (iLiteral instanceof QuantLiteral && this.mQuantLits.add((QuantLiteral)iLiteral)) {
                    this.mIsTrue |= this.mQuantLits.contains(((QuantLiteral)iLiteral).negate());
                } else {
                    return;
                }
            }
        }

        public void addResolution(Term term, Term term2) {
            if (Clausifier.this.mTracker instanceof ProofTracker && term != null) {
                this.mProof = ((ProofTracker)Clausifier.this.mTracker).resolve(term2, this.mProof, Clausifier.this.mTracker.getClauseProof(term));
            }
        }

        public void addLiteral(ILiteral iLiteral, Term term, Term term2, boolean bl) {
            Term term3;
            Theory theory = term2.getTheory();
            Term term4 = bl ? term : theory.term("not", new Term[]{term});
            Term term5 = term3 = bl ? term2 : Clausifier.this.mTracker.congruence(Clausifier.this.mTracker.reflexivity(term4), new Term[]{term2});
            assert (this.mCurrentLits.contains(term4));
            this.mCurrentLits.remove(term4);
            this.addResolution(Clausifier.this.mTracker.rewriteToClause(term4, term3), term4);
            if (iLiteral == mFALSE && Clausifier.this.mTracker instanceof ProofTracker) {
                Term term6 = Clausifier.this.mTracker.getProvedTerm(term2);
                assert (!(bl ? term6 != theory.mFalse : term6 != theory.mTrue));
                Term term7 = bl ? theory.term("not", new Term[]{term6}) : term6;
                Annotation annotation = bl ? ProofConstants.TAUT_FALSE_NEG : ProofConstants.TAUT_TRUE_POS;
                this.addResolution(Clausifier.this.mTracker.tautology(term7, annotation), Clausifier.this.mTracker.getProvedTerm(term3));
            }
            this.addLiteral(iLiteral);
        }

        private Term buildQuantifierProof(Literal[] literalArray, QuantLiteral[] quantLiteralArray) {
            Term term;
            Term term2;
            Theory theory = Clausifier.this.mTheory;
            if (literalArray.length + quantLiteralArray.length > 1) {
                ILiteral iLiteral;
                term2 = new Term[literalArray.length + quantLiteralArray.length];
                int n = 0;
                ILiteral[] iLiteralArray = literalArray;
                int n2 = literalArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    iLiteral = iLiteralArray[n3];
                    term2[n++] = ((Literal)iLiteral).getSMTFormula(theory);
                    ++n3;
                }
                iLiteralArray = quantLiteralArray;
                n2 = quantLiteralArray.length;
                n3 = 0;
                while (n3 < n2) {
                    iLiteral = iLiteralArray[n3];
                    term2[n++] = ((QuantLiteral)iLiteral).getSMTFormula(theory);
                    ++n3;
                }
                term = theory.term("or", (Term[])term2);
                if (Clausifier.this.mTracker instanceof ProofTracker) {
                    n = 0;
                    while (n < ((Term)term2).length) {
                        iLiteral = Clausifier.this.mTracker.tautology(theory.term("or", new Term[]{term, theory.term("not", new Term[]{term2[n]})}), ProofConstants.TAUT_OR_POS);
                        this.addResolution((Term)iLiteral, term2[n]);
                        ++n;
                    }
                }
            } else {
                assert (literalArray.length == 0 && quantLiteralArray.length == 1) : "quantLits must not be empty";
                term = quantLiteralArray[0].getSMTFormula(theory);
            }
            term2 = theory.annotatedTerm(new Annotation[]{new Annotation(":proof", (Object)this.mProof)}, term);
            term2 = Clausifier.this.mTracker.allIntro(term2, term.getFreeVars());
            return term2;
        }

        @Override
        public void perform() {
            Term term;
            Annotation annotation;
            if (this.mIsTrue) {
                return;
            }
            Theory theory = this.mClause.getTheory();
            boolean bl = true;
            Annotation annotation2 = this.mLits.toArray(new Literal[this.mLits.size()]);
            QuantLiteral[] quantLiteralArray = this.mQuantLits.toArray(new QuantLiteral[this.mQuantLits.size()]);
            if (Clausifier.this.mIsEprEnabled) {
                annotation = annotation2;
                int n = ((Literal[])annotation).length;
                int n2 = 0;
                while (n2 < n) {
                    term = annotation[n2];
                    if (term.getAtom() instanceof EprQuantifiedPredicateAtom || term.getAtom() instanceof EprQuantifiedEqualityAtom) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            } else if (!this.mQuantLits.isEmpty()) {
                bl = false;
            }
            if (bl) {
                Clausifier.this.addClause((Literal[])annotation2, null, Clausifier.this.getProofNewSource(this.mProof, this.mSource));
            } else if (Clausifier.this.mIsEprEnabled) {
                term = Clausifier.this.mEprTheory.addEprClause((Literal[])annotation2, null, null);
                if (term != null) {
                    Clausifier.this.addClause((Literal[])term, null, Clausifier.this.getProofNewSource(this.mProof, this.mSource));
                }
            } else {
                term = this.buildQuantifierProof((Literal[])annotation2, quantLiteralArray);
                TermVariable[] termVariableArray = ((QuantifiedFormula)Clausifier.this.mTracker.getProvedTerm(term)).getVariables();
                DestructiveEqualityReasoning.DERResult dERResult = Clausifier.this.mQuantTheory.performDestructiveEqualityReasoning(termVariableArray, (Literal[])annotation2, quantLiteralArray, this.mSource);
                if (dERResult == null) {
                    Clausifier.this.mQuantTheory.addQuantClause(termVariableArray, (Literal[])annotation2, quantLiteralArray, this.mSource, term);
                } else if (!dERResult.isTriviallyTrue()) {
                    QuantLiteral[] quantLiteralArray2;
                    Literal[] literalArray;
                    annotation = ProofConstants.getTautForallNeg(dERResult.getSubs());
                    Term term2 = dERResult.getSubstituted();
                    Term term3 = Clausifier.this.mTracker.resolveBinaryTautology(term, term2, annotation);
                    Term term4 = dERResult.getSimplified();
                    Term term5 = Clausifier.this.mTracker.modusPonens(term3, term4);
                    Term term6 = Clausifier.this.mTracker.getProvedTerm(term5);
                    this.mProof = Clausifier.this.mTracker.getClauseProof(term5);
                    if (term6 instanceof ApplicationTerm) {
                        literalArray = (Literal[])term6;
                        if (literalArray.getFunction().getName().equals("or")) {
                            quantLiteralArray2 = ((ApplicationTerm)term6).getParameters();
                            Term[] termArray = new Term[quantLiteralArray2.length + 1];
                            termArray[0] = theory.term("not", new Term[]{term6});
                            int n = 0;
                            while (n < quantLiteralArray2.length) {
                                termArray[n + 1] = quantLiteralArray2[n];
                                ++n;
                            }
                            Term term7 = Clausifier.this.mTracker.tautology(theory.term("or", termArray), ProofConstants.TAUT_OR_NEG);
                            this.addResolution(term7, term6);
                        } else if (literalArray.getFunction().getName().equals("false")) {
                            quantLiteralArray2 = theory.term("not", new Term[]{literalArray});
                            Term term8 = Clausifier.this.mTracker.tautology((Term)quantLiteralArray2, ProofConstants.TAUT_FALSE_NEG);
                            this.addResolution(term8, term6);
                        }
                    }
                    literalArray = dERResult.getGroundLits();
                    quantLiteralArray2 = dERResult.getQuantLits();
                    if (quantLiteralArray2.length == 0) {
                        Clausifier.this.addClause(literalArray, null, Clausifier.this.getProofNewSource(this.mProof, this.mSource));
                    } else {
                        term5 = this.buildQuantifierProof(literalArray, quantLiteralArray2);
                        termVariableArray = ((QuantifiedFormula)Clausifier.this.mTracker.getProvedTerm(term5)).getVariables();
                        Clausifier.this.mQuantTheory.addQuantClause(termVariableArray, literalArray, quantLiteralArray2, this.mSource, term5);
                    }
                }
            }
        }

        public String toString() {
            return "BC" + String.valueOf(Clausifier.this.mTracker.getProvedTerm(this.mClause));
        }
    }

    public class CCTermBuilder {
        private final SourceAnnotation mSource;
        private final ArrayDeque<Operation> mOps = new ArrayDeque();
        private final ArrayDeque<CCTerm> mConverted = new ArrayDeque();

        public CCTermBuilder(SourceAnnotation sourceAnnotation) {
            this.mSource = sourceAnnotation;
        }

        public CCTerm convert(Term term) {
            this.mOps.push(new BuildCCTerm(term));
            while (!this.mOps.isEmpty()) {
                this.mOps.pop().perform();
            }
            CCTerm cCTerm = this.mConverted.pop();
            assert (this.mConverted.isEmpty());
            return cCTerm;
        }

        private class BuildCCAppTerm
        implements Operation {
            private final boolean mIsFunc;

            public BuildCCAppTerm(boolean bl) {
                this.mIsFunc = bl;
            }

            @Override
            public void perform() {
                CCTerm cCTerm = CCTermBuilder.this.mConverted.pop();
                CCTerm cCTerm2 = CCTermBuilder.this.mConverted.pop();
                CCTermBuilder.this.mConverted.push(((CCTermBuilder)CCTermBuilder.this).Clausifier.this.mCClosure.createAppTerm(this.mIsFunc, cCTerm2, cCTerm, CCTermBuilder.this.mSource));
            }
        }

        private class BuildCCTerm
        implements Operation {
            private final Term mTerm;

            public BuildCCTerm(Term term) {
                this.mTerm = term;
            }

            @Override
            public void perform() {
                CCTerm cCTerm = Clausifier.this.getCCTerm(this.mTerm);
                if (cCTerm != null) {
                    CCTermBuilder.this.mConverted.push(cCTerm);
                } else if (Clausifier.needCCTerm(this.mTerm)) {
                    FunctionSymbol functionSymbol = ((ApplicationTerm)this.mTerm).getFunction();
                    if (functionSymbol.isIntern() && functionSymbol.getName() == "select") {
                        ((CCTermBuilder)CCTermBuilder.this).Clausifier.this.mArrayTheory.cleanCaches();
                    }
                    CCTermBuilder.this.mOps.push(new SaveCCTerm(this.mTerm));
                    ApplicationTerm applicationTerm = (ApplicationTerm)this.mTerm;
                    Term[] termArray = applicationTerm.getParameters();
                    int n = termArray.length - 1;
                    while (n >= 0) {
                        CCTermBuilder.this.mOps.push(new BuildCCAppTerm(n != termArray.length - 1));
                        CCTermBuilder.this.mOps.push(new BuildCCTerm(termArray[n]));
                        --n;
                    }
                    CCTermBuilder.this.mConverted.push(((CCTermBuilder)CCTermBuilder.this).Clausifier.this.mCClosure.getFuncTerm(functionSymbol));
                } else {
                    cCTerm = ((CCTermBuilder)CCTermBuilder.this).Clausifier.this.mCClosure.createAnonTerm(this.mTerm);
                    ((CCTermBuilder)CCTermBuilder.this).Clausifier.this.mCClosure.addTerm(cCTerm, this.mTerm);
                    Clausifier.this.shareCCTerm(this.mTerm, cCTerm);
                    Clausifier.this.addTermAxioms(this.mTerm, CCTermBuilder.this.mSource);
                    CCTermBuilder.this.mConverted.push(cCTerm);
                }
            }
        }

        private class SaveCCTerm
        implements Operation {
            private final Term mTerm;

            public SaveCCTerm(Term term) {
                this.mTerm = term;
            }

            @Override
            public void perform() {
                CCTerm cCTerm = CCTermBuilder.this.mConverted.peek();
                ((CCTermBuilder)CCTermBuilder.this).Clausifier.this.mCClosure.addTerm(cCTerm, this.mTerm);
                Clausifier.this.shareCCTerm(this.mTerm, cCTerm);
                Clausifier.this.addTermAxioms(this.mTerm, CCTermBuilder.this.mSource);
            }
        }
    }

    private class CollectLiteral
    implements Operation {
        private final Term mLiteral;
        private final BuildClause mClauseBuilder;

        public CollectLiteral(Term term, BuildClause buildClause) {
            assert (term.getSort() == Clausifier.this.mTheory.getBooleanSort());
            this.mLiteral = term;
            this.mClauseBuilder = buildClause;
        }

        @Override
        public void perform() {
            Theory theory = this.mLiteral.getTheory();
            Term term = this.mLiteral;
            boolean bl = false;
            boolean bl2 = true;
            while (Clausifier.isNotTerm(term)) {
                bl2 = !bl2;
                term = ((ApplicationTerm)term).getParameters()[0];
            }
            if (term instanceof ApplicationTerm) {
                ILiteral iLiteral;
                if (Clausifier.this.mIsEprEnabled && EprTheory.isQuantifiedEprAtom(term)) {
                    EprAtom eprAtom = Clausifier.this.mEprTheory.getEprAtom((ApplicationTerm)term, 0, Clausifier.this.mStackLevel, this.mClauseBuilder.getSource());
                    this.mClauseBuilder.addLiteral(bl2 ? eprAtom : eprAtom.negate(), term, Clausifier.this.mTracker.reflexivity(term), bl2);
                    return;
                }
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                if (this.mLiteral.mTmpCtr <= 1 && (bl2 ? applicationTerm.getFunction() == theory.mOr || applicationTerm.getFunction() == theory.mImplies : applicationTerm.getFunction() == theory.mAnd)) {
                    Annotation annotation = applicationTerm.getFunction() == theory.mOr ? ProofConstants.TAUT_OR_NEG : (applicationTerm.getFunction() == theory.mImplies ? ProofConstants.TAUT_IMP_NEG : ProofConstants.TAUT_AND_POS);
                    Term[] termArray = applicationTerm.getParameters();
                    Term[] termArray2 = new Term[termArray.length + 1];
                    termArray2[0] = bl2 ? theory.term("not", new Term[]{term}) : term;
                    int n = 0;
                    while (n < termArray.length) {
                        Term term2 = termArray[n];
                        if (applicationTerm.getFunction() == theory.mAnd || applicationTerm.getFunction() == theory.mImplies && n < termArray.length - 1) {
                            term2 = theory.term("not", new Term[]{term2});
                        }
                        termArray2[n + 1] = term2;
                        ++n;
                    }
                    Term term3 = Clausifier.this.mTracker.tautology(theory.term("or", termArray2), annotation);
                    this.mClauseBuilder.mCurrentLits.remove(this.mLiteral);
                    this.mClauseBuilder.addResolution(term3, this.mLiteral);
                    int n2 = termArray.length - 1;
                    while (n2 >= 0) {
                        this.mClauseBuilder.collectLiteral(termArray2[n2 + 1]);
                        --n2;
                    }
                    return;
                }
                if (term.getFreeVars().length > 0) {
                    bl = true;
                }
                Term term4 = Clausifier.this.mTracker.reflexivity((Term)applicationTerm);
                if (applicationTerm.getFunction().getName().equals("true")) {
                    iLiteral = mTRUE;
                } else if (applicationTerm.getFunction().getName().equals("false")) {
                    iLiteral = mFALSE;
                } else if (applicationTerm.getFunction().getName().equals("=")) {
                    assert (applicationTerm.getParameters()[0].getSort() != Clausifier.this.mTheory.getBooleanSort());
                    Term term5 = applicationTerm.getParameters()[0];
                    Term term6 = applicationTerm.getParameters()[1];
                    if (bl) {
                        Term term7 = Clausifier.checkAndGetTrivialEquality(term5, term6, Clausifier.this.mTheory);
                        if (term7 == Clausifier.this.mTheory.mTrue) {
                            iLiteral = mTRUE;
                        } else if (term7 == Clausifier.this.mTheory.mFalse) {
                            iLiteral = mFALSE;
                        } else {
                            Term term8 = Clausifier.this.rewriteBooleanSubterms(term5, this.mClauseBuilder.getSource());
                            Term term9 = Clausifier.this.rewriteBooleanSubterms(term6, this.mClauseBuilder.getSource());
                            term4 = Clausifier.this.mTracker.congruence(term4, new Term[]{term8, term9});
                            iLiteral = Clausifier.this.mQuantTheory.getQuantEquality(Clausifier.this.mTracker.getProvedTerm(term8), Clausifier.this.mTracker.getProvedTerm(term9), this.mClauseBuilder.getSource());
                        }
                    } else {
                        EqualityProxy equalityProxy = Clausifier.this.createEqualityProxy(term5, term6, this.mClauseBuilder.getSource());
                        iLiteral = equalityProxy == EqualityProxy.getTrueProxy() ? mTRUE : (equalityProxy == EqualityProxy.getFalseProxy() ? mFALSE : equalityProxy.getLiteral(this.mClauseBuilder.getSource()));
                    }
                } else if (applicationTerm.getFunction().getName().equals("<=")) {
                    if (bl) {
                        Term term10 = applicationTerm.getParameters()[0];
                        Term term11 = applicationTerm.getParameters()[1];
                        Term term12 = Clausifier.this.rewriteBooleanSubterms(term10, this.mClauseBuilder.getSource());
                        term4 = Clausifier.this.mTracker.congruence(term4, new Term[]{term12, Clausifier.this.mTracker.reflexivity(term11)});
                        iLiteral = Clausifier.this.mQuantTheory.getQuantInequality(bl2, Clausifier.this.mTracker.getProvedTerm(term12), this.mClauseBuilder.getSource());
                    } else {
                        iLiteral = Clausifier.this.createLeq0(applicationTerm, this.mClauseBuilder.getSource());
                    }
                } else if (!applicationTerm.getFunction().isInterpreted() || Clausifier.needCCTerm((Term)applicationTerm)) {
                    if (bl) {
                        term4 = Clausifier.this.rewriteBooleanSubterms((Term)applicationTerm, this.mClauseBuilder.getSource());
                    }
                    iLiteral = Clausifier.this.createBooleanLit((ApplicationTerm)Clausifier.this.mTracker.getProvedTerm(term4), this.mClauseBuilder.getSource());
                } else {
                    iLiteral = Clausifier.this.createAnonLiteral(term, this.mClauseBuilder.getSource());
                    if (term.getFreeVars().length == 0) {
                        if (bl2) {
                            Clausifier.this.addAuxAxioms(term, true, this.mClauseBuilder.getSource());
                        } else {
                            Clausifier.this.addAuxAxioms(term, false, this.mClauseBuilder.getSource());
                        }
                    }
                }
                term4 = Clausifier.this.mTracker.transitivity(term4, Clausifier.this.mTracker.intern(Clausifier.this.mTracker.getProvedTerm(term4), iLiteral.getSMTFormula(theory)));
                this.mClauseBuilder.addLiteral(bl2 ? iLiteral : iLiteral.negate(), (Term)applicationTerm, term4, bl2);
            } else {
                if (term instanceof QuantifiedFormula) {
                    QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
                    Pair<Term, Annotation> pair = Clausifier.this.convertQuantifiedSubformula(bl2, quantifiedFormula);
                    Term term13 = pair.getFirst();
                    Term term14 = bl2 ? term : theory.term("not", new Term[]{term});
                    Term term15 = bl2 ? theory.term("not", new Term[]{term}) : term;
                    Term term16 = Clausifier.this.mTracker.tautology(theory.term("or", new Term[]{term15, term13}), pair.getSecond());
                    this.mClauseBuilder.mCurrentLits.remove(this.mLiteral);
                    this.mClauseBuilder.addResolution(term16, term14);
                    Term term17 = Clausifier.this.mCompiler.transform(term13);
                    this.mClauseBuilder.addResolution(Clausifier.this.mTracker.rewriteToClause(term13, term17), term13);
                    Term term18 = Clausifier.this.mTracker.getProvedTerm(term17);
                    this.mClauseBuilder.collectLiteral(term18);
                    return;
                }
                if (term instanceof TermVariable) {
                    assert (term.getSort().equals(theory.getBooleanSort()));
                    ApplicationTerm applicationTerm = bl2 ? Clausifier.this.mTheory.mFalse : Clausifier.this.mTheory.mTrue;
                    QuantLiteral quantLiteral = Clausifier.this.mQuantTheory.getQuantEquality(term, (Term)applicationTerm, this.mClauseBuilder.getSource());
                    Term term19 = Clausifier.this.mTracker.intern(term, (bl2 ? quantLiteral.negate() : quantLiteral).getSMTFormula(theory));
                    this.mClauseBuilder.addLiteral(quantLiteral.negate(), term, term19, bl2);
                } else if (term instanceof MatchTerm) {
                    ILiteral iLiteral = Clausifier.this.createAnonLiteral(term, this.mClauseBuilder.getSource());
                    if (term.getFreeVars().length == 0) {
                        if (bl2) {
                            Clausifier.this.addAuxAxioms(term, true, this.mClauseBuilder.getSource());
                        } else {
                            Clausifier.this.addAuxAxioms(term, false, this.mClauseBuilder.getSource());
                        }
                    }
                    Term term20 = Clausifier.this.mTracker.intern(term, iLiteral.getSMTFormula(theory));
                    this.mClauseBuilder.addLiteral(bl2 ? iLiteral : iLiteral.negate(), term, term20, bl2);
                } else {
                    throw new SMTLIBException("Cannot handle literal " + String.valueOf(this.mLiteral));
                }
            }
        }

        public String toString() {
            return "Collect" + this.mLiteral.toString();
        }
    }

    private static class FalseLiteral
    implements ILiteral {
        private FalseLiteral() {
        }

        @Override
        public ILiteral getAtom() {
            return this;
        }

        @Override
        public ILiteral negate() {
            return mTRUE;
        }

        @Override
        public boolean isGround() {
            return true;
        }

        @Override
        public Term getSMTFormula(Theory theory) {
            return theory.mFalse;
        }
    }

    private static interface Operation {
        public void perform();
    }

    private static class TrueLiteral
    implements ILiteral {
        private TrueLiteral() {
        }

        @Override
        public ILiteral getAtom() {
            return this;
        }

        @Override
        public ILiteral negate() {
            return mFALSE;
        }

        @Override
        public boolean isGround() {
            return true;
        }

        @Override
        public Term getSMTFormula(Theory theory) {
            return theory.mTrue;
        }
    }
}

