/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import java.util.Map;

public class InterpolatorAffineTerm {
    final SMTAffineTerm mAffine = new SMTAffineTerm();
    int mEpsilon;

    public InterpolatorAffineTerm() {
        this.mEpsilon = 0;
    }

    public InterpolatorAffineTerm(InterpolatorAffineTerm interpolatorAffineTerm) {
        this.mAffine.add(interpolatorAffineTerm.mAffine);
        this.mEpsilon = interpolatorAffineTerm.mEpsilon;
    }

    public InterpolatorAffineTerm(SMTAffineTerm sMTAffineTerm) {
        this.mAffine.add(sMTAffineTerm);
        this.mEpsilon = 0;
    }

    public void add(Rational rational) {
        this.mAffine.add(rational);
    }

    public void add(InfinitesimalNumber infinitesimalNumber) {
        this.mAffine.add(infinitesimalNumber.mReal);
        this.mEpsilon += infinitesimalNumber.mEps;
    }

    public void add(Rational rational, Term term) {
        this.mAffine.add(rational, term);
    }

    public void add(Rational rational, InterpolatorAffineTerm interpolatorAffineTerm) {
        this.mAffine.add(rational, interpolatorAffineTerm.mAffine);
        this.mEpsilon += rational.signum() * interpolatorAffineTerm.mEpsilon;
    }

    public void mul(Rational rational) {
        this.mAffine.mul(rational);
        this.mEpsilon *= rational.signum();
    }

    public void negate() {
        this.mAffine.negate();
        this.mEpsilon = -this.mEpsilon;
    }

    public boolean isConstant() {
        return this.mAffine.isConstant();
    }

    public InfinitesimalNumber getConstant() {
        return new InfinitesimalNumber(this.mAffine.getConstant(), this.mEpsilon);
    }

    public Map<Term, Rational> getSummands() {
        return this.mAffine.getSummands();
    }

    public Rational getGcd() {
        return this.mAffine.getGcd();
    }

    public String toString() {
        return this.mAffine.toString() + (this.mEpsilon == 0 ? "" : (this.mEpsilon < 0 ? " - eps" : " + eps"));
    }

    public Term toSMTLib(Theory theory, boolean bl) {
        assert (this.mEpsilon == 0);
        Sort sort = bl ? theory.getSort("Int", new Sort[0]) : theory.getSort("Real", new Sort[0]);
        return this.mAffine.toTerm(sort);
    }

    public boolean isInt() {
        for (Term term : this.getSummands().keySet()) {
            if (term.getSort().getName().equals("Int")) continue;
            return false;
        }
        return true;
    }

    public Term toLeq0(Theory theory) {
        assert (this.mEpsilon >= 0);
        if (this.isConstant()) {
            return this.getConstant().compareTo(InfinitesimalNumber.ZERO) <= 0 ? theory.mTrue : theory.mFalse;
        }
        SMTAffineTerm sMTAffineTerm = new SMTAffineTerm();
        SMTAffineTerm sMTAffineTerm2 = new SMTAffineTerm();
        Sort sort = this.isInt() ? theory.getSort("Int", new Sort[0]) : theory.getSort("Real", new Sort[0]);
        for (Map.Entry<Term, Rational> entry : this.getSummands().entrySet()) {
            Rational rational = entry.getValue();
            if (rational.signum() < 0) {
                sMTAffineTerm2.add(rational.negate(), entry.getKey());
                continue;
            }
            sMTAffineTerm.add(rational, entry.getKey());
        }
        sMTAffineTerm2.add(this.mAffine.getConstant().negate());
        return theory.term(this.mEpsilon == 0 ? "<=" : "<", new Term[]{sMTAffineTerm.toTerm(sort), sMTAffineTerm2.toTerm(sort)});
    }

    public int hashCode() {
        return this.mAffine.hashCode() + 1021 * this.mEpsilon;
    }
}

