/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ConstantTermNormalizer
extends TermTransformer {
    protected void convert(Term term) {
        if (term instanceof ConstantTerm) {
            ConstantTerm constantTerm = (ConstantTerm)term;
            Term term2 = ConstantTermNormalizer.convertConstantTerm(term, constantTerm);
            this.setResult(term2);
        } else {
            super.convert(term);
        }
    }

    private static Term convertConstantTerm(Term term, ConstantTerm constantTerm) {
        if (!constantTerm.getSort().isNumericSort()) {
            return constantTerm;
        }
        if (constantTerm.getValue() instanceof BigInteger) {
            Rational rational = Rational.valueOf((BigInteger)((BigInteger)constantTerm.getValue()), (BigInteger)BigInteger.ONE);
            return rational.toTerm(term.getSort());
        }
        if (constantTerm.getValue() instanceof BigDecimal) {
            Rational rational;
            BigDecimal bigDecimal = (BigDecimal)constantTerm.getValue();
            if (bigDecimal.scale() <= 0) {
                BigInteger bigInteger = bigDecimal.toBigInteger();
                rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
            } else {
                BigInteger bigInteger = bigDecimal.unscaledValue();
                BigInteger bigInteger2 = BigInteger.TEN.pow(bigDecimal.scale());
                rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)bigInteger2);
            }
            return rational.toTerm(term.getSort());
        }
        if (constantTerm.getValue() instanceof Rational) {
            return constantTerm;
        }
        throw new AssertionError((Object)"Value has to be either BigInteger, Decimal, or Rational");
    }
}

