/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.EQAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class CCProofGenerator {
    final CCAnnotation mAnnot;
    final CCAnnotation.RuleKind mRule;
    final IndexedPath[] mIndexedPaths;
    private HashMap<SymmetricPair<CCTerm>, Term> mAuxLiterals;
    private HashMap<SymmetricPair<CCTerm>, Literal> mEqualityLiterals;
    private HashMap<SymmetricPair<CCTerm>, ProofInfo> mPathProofMap;
    private LinkedHashSet<SymmetricPair<CCTerm>> mAllEqualities;
    private LinkedHashSet<SymmetricPair<CCTerm>> mTrivialDisequalities;
    private ProofRules mProofRules;

    public CCProofGenerator(CCAnnotation cCAnnotation) {
        this.mAnnot = cCAnnotation;
        this.mRule = cCAnnotation.mRule;
        this.mIndexedPaths = new IndexedPath[cCAnnotation.getPaths().length];
        int n = 0;
        while (n < this.mIndexedPaths.length) {
            this.mIndexedPaths[n] = new IndexedPath(cCAnnotation.getWeakIndices()[n], cCAnnotation.getPaths()[n]);
            ++n;
        }
    }

    public Term toTerm(Clause clause, ProofRules proofRules) {
        SymmetricPair<CCTerm> symmetricPair;
        this.mProofRules = proofRules;
        this.mAllEqualities = new LinkedHashSet();
        this.mTrivialDisequalities = new LinkedHashSet();
        this.mAuxLiterals = new HashMap();
        this.collectClauseLiterals(clause);
        this.collectStrongEqualities();
        ProofInfo proofInfo = this.findMainPaths();
        if (this.mAnnot.mDiseq != null) {
            symmetricPair = this.mAnnot.mDiseq;
            if (!this.isDisequalityLiteral(symmetricPair)) {
                assert (this.isTrivialDisequality(symmetricPair));
                this.mTrivialDisequalities.add(symmetricPair);
                this.addAuxEquality(symmetricPair);
            }
            proofInfo.mLemmaDiseq = symmetricPair;
            this.mPathProofMap.put(symmetricPair, proofInfo);
        } else assert (this.mAnnot.mRule == CCAnnotation.RuleKind.DT_CASES || this.mAnnot.mRule == CCAnnotation.RuleKind.DT_UNIQUE || this.mAnnot.mRule == CCAnnotation.RuleKind.DT_DISJOINT || this.mAnnot.mRule == CCAnnotation.RuleKind.DT_CYCLE) : "Rule needs a disequality";
        this.determineAllNumParents(proofInfo);
        symmetricPair = this.determineProofOrder(proofInfo);
        return this.buildProofTerm(clause, proofRules, (ArrayList<ProofInfo>)((Object)symmetricPair));
    }

    private void collectClauseLiterals(Clause clause) {
        this.mEqualityLiterals = new HashMap();
        int n = 0;
        while (n < clause.getSize()) {
            Literal literal = clause.getLiteral(n);
            CCEquality cCEquality = (CCEquality)literal.getAtom();
            SymmetricPair<CCTerm> symmetricPair = new SymmetricPair<CCTerm>(cCEquality.getLhs(), cCEquality.getRhs());
            this.mEqualityLiterals.put(symmetricPair, literal);
            if (literal.getSign() < 0) {
                this.mAllEqualities.add(symmetricPair);
            }
            ++n;
        }
    }

    private void collectStrongEqualities() {
        this.mPathProofMap = new HashMap();
        int n = this.mIndexedPaths.length - 1;
        while (n >= 0) {
            CCTerm[] cCTermArray;
            SymmetricPair<CCTerm> symmetricPair;
            IndexedPath indexedPath = this.mIndexedPaths[n];
            if (indexedPath.getIndex() == null && (this.mRule != CCAnnotation.RuleKind.WEAKEQ_EXT && this.mRule != CCAnnotation.RuleKind.CONST_WEAKEQ || n > 0) && this.mAllEqualities.add(symmetricPair = new SymmetricPair<CCTerm>((cCTermArray = indexedPath.getPath())[0], cCTermArray[cCTermArray.length - 1])) && !this.mPathProofMap.containsKey(symmetricPair)) {
                if (cCTermArray.length == 2) {
                    var5_5 = this.findCongruencePaths(cCTermArray[0], cCTermArray[1]);
                    this.mPathProofMap.put(symmetricPair, var5_5);
                } else {
                    var5_5 = new ProofInfo();
                    var5_5.mLemmaDiseq = symmetricPair;
                    var5_5.mProofPaths = new IndexedPath[]{indexedPath};
                    var5_5.collectStrongPath(indexedPath);
                    this.mPathProofMap.put(symmetricPair, var5_5);
                }
            }
            --n;
        }
    }

    private ProofInfo findMainPaths() {
        ProofInfo proofInfo = new ProofInfo();
        switch (this.mRule) {
            case TRANS: 
            case CONG: {
                return this.mPathProofMap.get(this.mIndexedPaths[0].getPathEnds());
            }
            case READ_OVER_WEAKEQ: {
                CCTerm cCTerm;
                SymmetricPair<CCTerm> symmetricPair = this.mAnnot.mDiseq;
                assert (ArrayTheory.isSelectTerm(symmetricPair.getFirst()) && ArrayTheory.isSelectTerm(symmetricPair.getSecond()));
                CCTerm cCTerm2 = ArrayTheory.getIndexFromSelect((CCAppTerm)symmetricPair.getFirst());
                if (cCTerm2 != (cCTerm = ArrayTheory.getIndexFromSelect((CCAppTerm)symmetricPair.getSecond()))) {
                    proofInfo.collectEquality(new SymmetricPair<CCTerm>(cCTerm2, cCTerm));
                }
                assert (this.mIndexedPaths[0].getIndex() != null);
                proofInfo.collectWeakPath(this.mIndexedPaths[0]);
                proofInfo.mProofPaths = new IndexedPath[]{this.mIndexedPaths[0]};
                break;
            }
            case READ_CONST_WEAKEQ: {
                assert (this.mIndexedPaths[0].getIndex() != null);
                proofInfo.collectWeakPath(this.mIndexedPaths[0]);
                proofInfo.mProofPaths = new IndexedPath[]{this.mIndexedPaths[0]};
                break;
            }
            case CONST_WEAKEQ: {
                assert (this.mIndexedPaths[0].getIndex() == null);
                proofInfo.collectWeakPath(this.mIndexedPaths[0]);
                proofInfo.mProofPaths = new IndexedPath[]{this.mIndexedPaths[0]};
                break;
            }
            case WEAKEQ_EXT: {
                ArrayList<IndexedPath> arrayList = new ArrayList<IndexedPath>();
                assert (this.mIndexedPaths[0].getIndex() == null);
                proofInfo.collectWeakPath(this.mIndexedPaths[0]);
                arrayList.add(this.mIndexedPaths[0]);
                int n = 0;
                while (n < this.mIndexedPaths.length) {
                    if (this.mIndexedPaths[n].getIndex() != null) {
                        proofInfo.collectWeakPath(this.mIndexedPaths[n]);
                        arrayList.add(this.mIndexedPaths[n]);
                    }
                    ++n;
                }
                proofInfo.mProofPaths = arrayList.toArray(new IndexedPath[arrayList.size()]);
                break;
            }
            case DT_PROJECT: 
            case DT_TESTER: 
            case DT_CONSTRUCTOR: 
            case DT_CASES: 
            case DT_UNIQUE: 
            case DT_DISJOINT: 
            case DT_INJECTIVE: 
            case DT_CYCLE: {
                SymmetricPair<CCTerm>[] symmetricPairArray = this.mAnnot.mDTLemma.getReason();
                int n = symmetricPairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SymmetricPair<CCTerm> symmetricPair = symmetricPairArray[n2];
                    proofInfo.collectEquality(symmetricPair);
                    ++n2;
                }
                proofInfo.mProofPaths = new IndexedPath[0];
            }
        }
        return proofInfo;
    }

    private void determineAllNumParents(ProofInfo proofInfo) {
        ArrayDeque<ProofInfo> arrayDeque = new ArrayDeque<ProofInfo>();
        arrayDeque.add(proofInfo);
        while (!arrayDeque.isEmpty()) {
            ProofInfo proofInfo2 = (ProofInfo)arrayDeque.removeFirst();
            if (proofInfo2.getNumParents() == 0) {
                arrayDeque.addAll(proofInfo2.mSubProofs);
            }
            proofInfo2.increaseNumParents();
        }
    }

    private ArrayList<ProofInfo> determineProofOrder(ProofInfo proofInfo) {
        ArrayList<ProofInfo> arrayList = new ArrayList<ProofInfo>();
        ArrayDeque<ProofInfo> arrayDeque = new ArrayDeque<ProofInfo>();
        arrayDeque.add(proofInfo);
        while (!arrayDeque.isEmpty()) {
            ProofInfo proofInfo2 = (ProofInfo)arrayDeque.removeFirst();
            proofInfo2.increaseVisitedParentsCounter();
            if (!proofInfo2.haveVisitedAllParents()) continue;
            arrayList.add(proofInfo2);
            arrayDeque.addAll(proofInfo2.getSubProofs());
        }
        return arrayList;
    }

    private Term addAuxEquality(SymmetricPair<CCTerm> symmetricPair) {
        if (!this.mAuxLiterals.containsKey(symmetricPair)) {
            Theory theory = this.mProofRules.getTheory();
            Term term = symmetricPair.getFirst().getFlatTerm();
            Term term2 = symmetricPair.getSecond().getFlatTerm();
            if (term2.getSort().isNumericSort() && term2 instanceof ConstantTerm && ((ConstantTerm)term2).getValue().equals(Rational.ZERO)) {
                Term term3 = term2;
                term2 = term;
                term = term3;
            }
            this.mAuxLiterals.put(symmetricPair, theory.term("=", new Term[]{term, term2}));
        }
        return this.mAuxLiterals.get(symmetricPair);
    }

    private Term buildLemma(ProofRules proofRules, CCAnnotation.RuleKind ruleKind, ProofInfo proofInfo, Term term) {
        Object[] objectArray;
        Object[] objectArray2;
        Theory theory = proofRules.getTheory();
        LinkedHashSet<ProofLiteral> linkedHashSet = new LinkedHashSet<ProofLiteral>(proofInfo.getLiterals().size() + (term != null ? 1 : 0));
        if (term != null) {
            linkedHashSet.add(new ProofLiteral(term, true));
        }
        for (ProofLiteral proofLiteralArray2 : proofInfo.getLiterals()) {
            linkedHashSet.add(proofLiteralArray2);
        }
        assert (linkedHashSet.size() == proofInfo.getLiterals().size() + (term != null ? 1 : 0));
        ProofLiteral[] proofLiteralArray = linkedHashSet.toArray(new ProofLiteral[linkedHashSet.size()]);
        if (ruleKind == CCAnnotation.RuleKind.CONG) {
            assert (proofInfo.getPaths().length == 1);
            objectArray2 = proofInfo.getPaths()[0].getPath();
            Term[] symmetricPair = new Term[objectArray2.length];
            int objectArray3 = 0;
            while (objectArray3 < objectArray2.length) {
                symmetricPair[objectArray3] = ((CCTerm)objectArray2[objectArray3]).getFlatTerm();
                ++objectArray3;
            }
            ruleKind = symmetricPair.length == 2 ? CCAnnotation.RuleKind.CONG : CCAnnotation.RuleKind.TRANS;
            objectArray = symmetricPair;
        } else {
            Object object;
            objectArray2 = proofInfo.getPaths();
            SymmetricPair<CCTerm> symmetricPair = proofInfo.getDiseq();
            Object[] objectArray3 = new Object[]{};
            if (this.mAnnot.mDTLemma != null && this.mAnnot.mDTLemma.getAnnotation() != null) {
                objectArray3 = this.mAnnot.mDTLemma.getAnnotation();
            }
            objectArray = new Object[2 * objectArray2.length + (symmetricPair == null ? 0 : 1) + objectArray3.length];
            int n = 0;
            if (symmetricPair != null) {
                object = theory.term("=", new Term[]{symmetricPair.getFirst().getFlatTerm(), symmetricPair.getSecond().getFlatTerm()});
                objectArray[n++] = object;
            }
            Object[] objectArray4 = objectArray3;
            int n2 = objectArray3.length;
            int n3 = 0;
            while (n3 < n2) {
                object = objectArray4[n3];
                objectArray[n++] = object;
                ++n3;
            }
            objectArray4 = objectArray2;
            n2 = objectArray2.length;
            n3 = 0;
            while (n3 < n2) {
                object = objectArray4[n3];
                CCTerm cCTerm = ((IndexedPath)object).getIndex();
                CCTerm[] cCTermArray = ((IndexedPath)object).getPath();
                Term[] termArray = new Term[cCTermArray.length];
                int n4 = 0;
                while (n4 < cCTermArray.length) {
                    termArray[n4] = cCTermArray[n4].getFlatTerm();
                    ++n4;
                }
                if (cCTerm == null) {
                    objectArray[n++] = ":subpath";
                    objectArray[n++] = termArray;
                } else {
                    objectArray[n++] = ":weakpath";
                    objectArray[n++] = new Object[]{cCTerm.getFlatTerm(), termArray};
                }
                ++n3;
            }
        }
        objectArray2 = new Annotation[]{new Annotation(ruleKind.getKind(), (Object)objectArray)};
        return proofRules.oracle(proofLiteralArray, (Annotation[])objectArray2);
    }

    /*
     * WARNING - void declaration
     */
    private Term buildProofTerm(Clause clause, ProofRules proofRules, ArrayList<ProofInfo> arrayList) {
        ProofLiteral[] proofLiteralArray;
        Term term;
        void symmetricPair;
        Theory theory = proofRules.getTheory();
        ProofInfo proofInfo = arrayList.get(0);
        assert (proofInfo.getDiseq() == this.mAnnot.getDiseq());
        Term term2 = proofInfo.getDiseq() == null ? null : (this.isDisequalityLiteral(proofInfo.getDiseq()) ? this.mEqualityLiterals.get(proofInfo.getDiseq()).getSMTFormula(theory) : this.mAuxLiterals.get(proofInfo.getDiseq()));
        Term term3 = this.buildLemma(proofRules, this.mRule, proofInfo, term2);
        boolean n = true;
        while (symmetricPair < arrayList.size()) {
            ProofInfo proofInfo2 = arrayList.get((int)symmetricPair);
            assert (this.mAuxLiterals.containsKey(proofInfo2.getDiseq()));
            term = this.mAuxLiterals.get(proofInfo2.getDiseq());
            proofLiteralArray = this.buildLemma(proofRules, CCAnnotation.RuleKind.CONG, proofInfo2, term);
            term3 = proofRules.resolutionRule(term, (Term)proofLiteralArray, term3);
            ++symmetricPair;
        }
        for (SymmetricPair symmetricPair2 : this.mTrivialDisequalities) {
            term = this.mAuxLiterals.get(symmetricPair2);
            proofLiteralArray = new ProofLiteral[]{new ProofLiteral(term, false)};
            Term term4 = proofRules.oracle(proofLiteralArray, EQAnnotation.getAnnotation());
            term3 = proofRules.resolutionRule(term, term3, term4);
        }
        return term3;
    }

    private boolean isEqualityLiteral(SymmetricPair<CCTerm> symmetricPair) {
        return this.mEqualityLiterals.containsKey(symmetricPair) && this.mEqualityLiterals.get(symmetricPair).getSign() < 0;
    }

    private boolean isDisequalityLiteral(SymmetricPair<CCTerm> symmetricPair) {
        return this.mEqualityLiterals.containsKey(symmetricPair) && this.mEqualityLiterals.get(symmetricPair).getSign() > 0;
    }

    private boolean isTrivialDisequality(SymmetricPair<CCTerm> symmetricPair) {
        CCTerm cCTerm = symmetricPair.getFirst();
        CCTerm cCTerm2 = symmetricPair.getSecond();
        Polynomial polynomial = new Polynomial(cCTerm.getFlatTerm());
        polynomial.add(Rational.MONE, cCTerm2.getFlatTerm());
        if (polynomial.isConstant()) {
            return polynomial.getConstant() != Rational.ZERO;
        }
        return polynomial.isAllIntSummands() && !polynomial.getConstant().div(polynomial.getGcd()).isIntegral();
    }

    private ProofInfo findCongruencePaths(CCTerm cCTerm, CCTerm cCTerm2) {
        ProofInfo proofInfo = new ProofInfo();
        proofInfo.mLemmaDiseq = new SymmetricPair<CCTerm>(cCTerm, cCTerm2);
        proofInfo.mProofPaths = new IndexedPath[]{new IndexedPath(null, new CCTerm[]{cCTerm, cCTerm2})};
        while (cCTerm != cCTerm2) {
            if (!(cCTerm instanceof CCAppTerm) || !(cCTerm2 instanceof CCAppTerm)) {
                return null;
            }
            CCTerm cCTerm3 = ((CCAppTerm)cCTerm).getArg();
            CCTerm cCTerm4 = ((CCAppTerm)cCTerm2).getArg();
            SymmetricPair<CCTerm> symmetricPair = new SymmetricPair<CCTerm>(cCTerm3, cCTerm4);
            if (cCTerm3 != cCTerm4) {
                if (this.isEqualityLiteral(symmetricPair)) {
                    proofInfo.addLiteral(this.mEqualityLiterals.get(symmetricPair));
                } else if (this.mPathProofMap.containsKey(symmetricPair)) {
                    proofInfo.addSubProof(this.mPathProofMap.get(symmetricPair));
                } else {
                    return null;
                }
            }
            cCTerm = ((CCAppTerm)cCTerm).getFunc();
            cCTerm2 = ((CCAppTerm)cCTerm2).getFunc();
        }
        return proofInfo;
    }

    private SelectEdge findSelectPath(SymmetricPair<CCTerm> symmetricPair, CCTerm cCTerm) {
        CCTerm cCTerm2;
        CCTerm object2;
        if (ArrayTheory.isConstTerm(symmetricPair.getFirst()) && this.isSelect(object2 = ArrayTheory.getValueFromConst((CCAppTerm)symmetricPair.getFirst()), symmetricPair.getSecond(), cCTerm)) {
            return new SelectEdge(object2, object2);
        }
        if (ArrayTheory.isConstTerm(symmetricPair.getSecond()) && this.isSelect(cCTerm2 = ArrayTheory.getValueFromConst((CCAppTerm)symmetricPair.getSecond()), symmetricPair.getFirst(), cCTerm)) {
            return new SelectEdge(cCTerm2, cCTerm2);
        }
        for (SymmetricPair symmetricPair2 : this.mAllEqualities) {
            CCTerm cCTerm3;
            CCTerm cCTerm4 = (CCTerm)symmetricPair2.getFirst();
            if (this.isGoodSelectStep(cCTerm4, cCTerm3 = (CCTerm)symmetricPair2.getSecond(), symmetricPair, cCTerm)) {
                return new SelectEdge(cCTerm4, cCTerm3);
            }
            if (!this.isGoodSelectStep(cCTerm3, cCTerm4, symmetricPair, cCTerm)) continue;
            return new SelectEdge(cCTerm3, cCTerm4);
        }
        return null;
    }

    private boolean isGoodSelectStep(CCTerm cCTerm, CCTerm cCTerm2, SymmetricPair<CCTerm> symmetricPair, CCTerm cCTerm3) {
        return !(!this.isSelect(cCTerm, symmetricPair.getFirst(), cCTerm3) && !this.isConst(symmetricPair.getFirst(), cCTerm) || !this.isSelect(cCTerm2, symmetricPair.getSecond(), cCTerm3) && !this.isConst(symmetricPair.getSecond(), cCTerm2));
    }

    private boolean isSelect(CCTerm cCTerm, CCTerm cCTerm2, CCTerm cCTerm3) {
        if (!ArrayTheory.isSelectTerm(cCTerm) || ArrayTheory.getArrayFromSelect((CCAppTerm)cCTerm) != cCTerm2) {
            return false;
        }
        CCTerm cCTerm4 = ArrayTheory.getIndexFromSelect((CCAppTerm)cCTerm);
        return cCTerm4 == cCTerm3 || this.mAllEqualities.contains(new SymmetricPair<CCTerm>(cCTerm3, cCTerm4));
    }

    private boolean isConst(CCTerm cCTerm, CCTerm cCTerm2) {
        return ArrayTheory.isConstTerm(cCTerm) && ArrayTheory.getValueFromConst((CCAppTerm)cCTerm) == cCTerm2;
    }

    private static class IndexedPath {
        private final CCTerm mIndex;
        private final CCTerm[] mPath;

        public IndexedPath(CCTerm cCTerm, CCTerm[] cCTermArray) {
            this.mIndex = cCTerm;
            this.mPath = cCTermArray;
        }

        public CCTerm getIndex() {
            return this.mIndex;
        }

        public CCTerm[] getPath() {
            return this.mPath;
        }

        public SymmetricPair<CCTerm> getPathEnds() {
            return new SymmetricPair<CCTerm>(this.mPath[0], this.mPath[this.mPath.length - 1]);
        }

        public String toString() {
            return String.valueOf(this.mIndex) + ": " + Arrays.toString(this.mPath);
        }
    }

    private class ProofInfo {
        private SymmetricPair<CCTerm> mLemmaDiseq = null;
        private final Collection<ProofLiteral> mProofLiterals = new LinkedHashSet<ProofLiteral>();
        private IndexedPath[] mProofPaths;
        private final Set<ProofInfo> mSubProofs = new LinkedHashSet<ProofInfo>();
        private int mNumParents = 0;
        private int mNumVisitedParents = 0;

        public SymmetricPair<CCTerm> getDiseq() {
            return this.mLemmaDiseq;
        }

        public Collection<ProofLiteral> getLiterals() {
            return this.mProofLiterals;
        }

        public IndexedPath[] getPaths() {
            return this.mProofPaths;
        }

        public Collection<ProofInfo> getSubProofs() {
            return this.mSubProofs;
        }

        public int getNumParents() {
            return this.mNumParents;
        }

        public void increaseNumParents() {
            ++this.mNumParents;
        }

        public void increaseVisitedParentsCounter() {
            ++this.mNumVisitedParents;
        }

        public boolean haveVisitedAllParents() {
            return this.mNumParents == this.mNumVisitedParents;
        }

        private void addLiteral(Literal literal) {
            Theory theory = CCProofGenerator.this.mProofRules.getTheory();
            this.mProofLiterals.add(new ProofLiteral(literal.getAtom().getSMTFormula(theory), literal.getSign() > 0));
        }

        private void addAuxLiteral(SymmetricPair<CCTerm> symmetricPair, boolean bl) {
            Term term = CCProofGenerator.this.addAuxEquality(symmetricPair);
            this.mProofLiterals.add(new ProofLiteral(term, bl));
        }

        private void addSubProof(ProofInfo proofInfo) {
            this.mSubProofs.add(proofInfo);
            this.addAuxLiteral(proofInfo.getDiseq(), false);
        }

        private boolean collectEquality(SymmetricPair<CCTerm> symmetricPair) {
            if (CCProofGenerator.this.isEqualityLiteral(symmetricPair)) {
                this.addLiteral(CCProofGenerator.this.mEqualityLiterals.get(symmetricPair));
                return true;
            }
            if (CCProofGenerator.this.mPathProofMap.containsKey(symmetricPair)) {
                this.addSubProof(CCProofGenerator.this.mPathProofMap.get(symmetricPair));
                return true;
            }
            ProofInfo proofInfo = CCProofGenerator.this.findCongruencePaths(symmetricPair.getFirst(), symmetricPair.getSecond());
            if (proofInfo == null) {
                return false;
            }
            CCProofGenerator.this.mPathProofMap.put(symmetricPair, proofInfo);
            this.addSubProof(proofInfo);
            return true;
        }

        private void collectStrongPath(IndexedPath indexedPath) {
            assert (indexedPath.getIndex() == null);
            CCTerm[] cCTermArray = indexedPath.getPath();
            int n = 0;
            while (n < cCTermArray.length - 1) {
                CCTerm cCTerm = cCTermArray[n];
                CCTerm cCTerm2 = cCTermArray[n + 1];
                SymmetricPair<CCTerm> symmetricPair = new SymmetricPair<CCTerm>(cCTerm, cCTerm2);
                if (!this.collectEquality(symmetricPair)) {
                    throw new IllegalArgumentException("Cannot explain term pair " + symmetricPair.toString());
                }
                ++n;
            }
        }

        private void collectSelectIndexEquality(CCTerm cCTerm, CCTerm cCTerm2) {
            CCTerm cCTerm3;
            if (ArrayTheory.isSelectTerm(cCTerm) && (cCTerm3 = ArrayTheory.getIndexFromSelect((CCAppTerm)cCTerm)) != cCTerm2 && !this.collectEquality(new SymmetricPair<CCTerm>(cCTerm2, cCTerm3))) {
                throw new AssertionError((Object)("Cannot find select index equality " + String.valueOf(cCTerm2) + " = " + String.valueOf(cCTerm3)));
            }
        }

        /*
         * Exception decompiling
         */
        private void collectWeakPath(IndexedPath var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:760)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public String toString() {
            return "Proof[" + String.valueOf(this.mLemmaDiseq) + "]";
        }
    }

    private static class SelectEdge {
        private final CCTerm mLeft;
        private final CCTerm mRight;

        public SelectEdge(CCTerm cCTerm, CCTerm cCTerm2) {
            this.mLeft = cCTerm;
            this.mRight = cCTerm2;
        }

        public SymmetricPair<CCTerm> toSymmetricPair() {
            return new SymmetricPair<CCTerm>(this.mLeft, this.mRight);
        }

        public CCTerm getLeft() {
            return this.mLeft;
        }

        public CCTerm getRight() {
            return this.mRight;
        }

        public String toString() {
            return String.valueOf(this.mLeft) + " <-> " + String.valueOf(this.mRight);
        }
    }
}

