/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.source.smtparser;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.ExceptionThrowingParseEnvironment;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.UltimateEliminator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.UltimateInterpolator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.IntBlastingWrapper;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationConstrainer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.mso.MSODScript;
import de.uni_freiburg.informatik.ultimate.mso.MSODSolver;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.ParseEnvironment;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.SmtInterpolLogProxyWrapper;
import de.uni_freiburg.informatik.ultimate.source.smtparser.Activator;
import de.uni_freiburg.informatik.ultimate.source.smtparser.ResultReportingWrapperScript;
import de.uni_freiburg.informatik.ultimate.source.smtparser.SmtParserPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.source.smtparser.chc.HCGBuilderHelper;
import de.uni_freiburg.informatik.ultimate.source.smtparser.chc.HornClauseParserScript;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SmtParser
implements ISource {
    protected String[] mFileTypes = new String[]{"smt2"};
    protected ILogger mLogger;
    protected List<String> mFileNames = new ArrayList<String>();
    protected Unit mPreludeUnit;
    private IUltimateServiceProvider mServices;
    private IElement mOutput;

    public String getPluginID() {
        return this.getClass().getPackage().getName();
    }

    public void init() {
        this.mFileNames = new ArrayList<String>();
    }

    public String getPluginName() {
        return "SmtParser";
    }

    public String[] getTokens() {
        return null;
    }

    public IElement parseAST(File[] fileArray) throws Exception {
        if (fileArray.length == 1) {
            return this.parseAST(fileArray[0]);
        }
        throw new UnsupportedOperationException("Cannot parse more than one file");
    }

    private IElement parseAST(File file) throws IOException {
        this.processFile(file);
        return this.mOutput;
    }

    public File[] parseable(File[] fileArray) {
        List<File> list = Arrays.stream(fileArray).filter(this::parseable).collect(Collectors.toList());
        return list.toArray(new File[list.size()]);
    }

    private boolean parseable(File file) {
        String[] stringArray = this.getFileTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (file.getName().endsWith(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String[] getFileTypes() {
        return this.mFileTypes;
    }

    public ModelType getOutputDefinition() {
        return new ModelType(Activator.PLUGIN_ID, ModelType.Type.OTHER, this.mFileNames);
    }

    public IPreferenceInitializer getPreferences() {
        return new SmtParserPreferenceInitializer();
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public void finish() {
    }

    private void processFile(File file) throws IOException {
        SolverBuilder.SolverSettings solverSettings;
        Object object;
        String string = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Directory");
        SmtParserPreferenceInitializer.SmtParserMode smtParserMode = (SmtParserPreferenceInitializer.SmtParserMode)this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("SmtParser Mode", SmtParserPreferenceInitializer.SmtParserMode.class);
        MSODSolver.MSODLogic mSODLogic = (MSODSolver.MSODLogic)this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("MSOD logic", MSODSolver.MSODLogic.class);
        boolean bl = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Remove only unused declarations from SMT file (experimental)");
        SmtInterpolLogProxyWrapper smtInterpolLogProxyWrapper = new SmtInterpolLogProxyWrapper(this.mLogger);
        if (bl) {
            this.runFilterUnusedDeclarationsMode(file, string, (LogProxy)smtInterpolLogProxyWrapper);
            return;
        }
        Object object2 = switch (smtParserMode) {
            case SmtParserPreferenceInitializer.SmtParserMode.GenericSmtSolver -> {
                this.mLogger.info((Object)"Running solver on smt file");
                object = new HCGBuilderHelper.ConstructAndInitializeBackendSmtSolver(this.mServices, "smtParserBackendSolver");
                yield ((HCGBuilderHelper.ConstructAndInitializeBackendSmtSolver)object).getScript().getScript();
            }
            case SmtParserPreferenceInitializer.SmtParserMode.MSODSolver -> {
                this.mLogger.info((Object)"Running our experimental MSO solver on input file using ...");
                yield new ResultReportingWrapperScript((Script)new MSODScript(this.mServices, this.mLogger, mSODLogic), this.mServices);
            }
            case SmtParserPreferenceInitializer.SmtParserMode.UltimateEliminator -> {
                this.mLogger.info((Object)"Running UltimateEliminator on input file");
                object = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Command for external solver");
                solverSettings = SolverBuilder.constructSolverSettings();
                solverSettings = ((String)object).isEmpty() ? solverSettings.setSolverMode(SolverBuilder.SolverMode.Internal_SMTInterpol) : solverSettings.setSolverMode(SolverBuilder.SolverMode.External_DefaultMode).setUseExternalSolver(true, (String)object, null);
                String var10_10 = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Dump smtlib scripts to");
                if (!var10_10.isEmpty()) {
                    solverSettings = solverSettings.setDumpSmtScriptToFile(true, var10_10, "UltimateEliminatorBackEndSolverInput.smt2", false);
                }
                Script var11_12 = SolverBuilder.buildScript((IUltimateServiceProvider)this.mServices, (SolverBuilder.SolverSettings)solverSettings);
                yield new UltimateEliminator(this.mServices, this.mLogger, var11_12);
            }
            case SmtParserPreferenceInitializer.SmtParserMode.UltimateInterpolator -> {
                this.mLogger.info((Object)"Running UltimateInterpolator on input file");
                object = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Command for external solver");
                solverSettings = SolverBuilder.constructSolverSettings();
                solverSettings = ((String)object).isEmpty() ? solverSettings.setSolverMode(SolverBuilder.SolverMode.Internal_SMTInterpol) : solverSettings.setSolverMode(SolverBuilder.SolverMode.External_DefaultMode).setUseExternalSolver(true, (String)object, null);
                String var10_10 = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Dump smtlib scripts to");
                if (!var10_10.isEmpty()) {
                    solverSettings = solverSettings.setDumpSmtScriptToFile(true, var10_10, "UltimateInterpolatorBackEndSolverInput.smt2", false);
                }
                Script var11_12 = SolverBuilder.buildScript((IUltimateServiceProvider)this.mServices, (SolverBuilder.SolverSettings)solverSettings);
                yield new UltimateInterpolator(this.mServices, this.mLogger, var11_12);
            }
            case SmtParserPreferenceInitializer.SmtParserMode.IntBlastingWrapper -> {
                this.mLogger.info((Object)"Expecting script with bitvectors, will translate to integers");
                object = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Command for external solver");
                solverSettings = SolverBuilder.constructSolverSettings();
                solverSettings = ((String)object).isEmpty() ? solverSettings.setSolverMode(SolverBuilder.SolverMode.Internal_SMTInterpol) : solverSettings.setSolverMode(SolverBuilder.SolverMode.External_DefaultMode).setUseExternalSolver(true, (String)object, null);
                String var10_10 = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Dump smtlib scripts to");
                if (!var10_10.isEmpty()) {
                    solverSettings = solverSettings.setDumpSmtScriptToFile(true, var10_10, "IntBlastingWrapperBackEndSolverInput.smt2", false);
                }
                Script var11_12 = (IntBlastingWrapper.IntBlastingMode)this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("IntBlasting translation mode", IntBlastingWrapper.IntBlastingMode.class);
                TranslationConstrainer.ConstraintsForBitwiseOperations var12_14 = (TranslationConstrainer.ConstraintsForBitwiseOperations)this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("IntBlasting constraints for bitwise operations", TranslationConstrainer.ConstraintsForBitwiseOperations.class);
                Script var13_15 = SolverBuilder.buildScript((IUltimateServiceProvider)this.mServices, (SolverBuilder.SolverSettings)solverSettings);
                yield new IntBlastingWrapper(this.mServices, this.mLogger, var13_15, (IntBlastingWrapper.IntBlastingMode)var11_12, var12_14, file.getAbsolutePath());
            }
            case SmtParserPreferenceInitializer.SmtParserMode.UltimateTreeAutomizer -> {
                this.mLogger.info((Object)"Parsing .smt2 file as a set of Horn Clauses");
                object = new HCGBuilderHelper.ConstructAndInitializeBackendSmtSolver(this.mServices, "smtParserBackendSolver");
                yield new HornClauseParserScript(this.mServices, this.mLogger, file.getName(), ((HCGBuilderHelper.ConstructAndInitializeBackendSmtSolver)object).getScript(), ((HCGBuilderHelper.ConstructAndInitializeBackendSmtSolver)object).getLogicForExternalSolver());
            }
            default -> throw new AssertionError((Object)("unknown value " + String.valueOf((Object)smtParserMode)));
        };
        object = new OptionMap((LogProxy)smtInterpolLogProxyWrapper, true);
        if (smtParserMode == SmtParserPreferenceInitializer.SmtParserMode.UltimateTreeAutomizer || smtParserMode == SmtParserPreferenceInitializer.SmtParserMode.UltimateEliminator) {
            object.set(":continue-on-error", (Object)false);
            object.set(":print-success", (Object)false);
        }
        solverSettings = new ExceptionThrowingParseEnvironment(object2, (OptionMap)object);
        try {
            try {
                solverSettings.parseScript(file.getAbsolutePath());
                this.mLogger.info((Object)("Successfully executed SMT file " + file.getAbsolutePath()));
                if (smtParserMode == SmtParserPreferenceInitializer.SmtParserMode.UltimateTreeAutomizer) {
                    this.mOutput = ((HornClauseParserScript)((Object)object2)).getHornClauses();
                }
            }
            catch (SMTLIBException sMTLIBException) {
                this.mLogger.info((Object)("Failed while executing SMT file " + file.getAbsolutePath()));
                this.mLogger.info((Object)("SMTLIBException " + sMTLIBException.getMessage()));
                throw sMTLIBException;
            }
        }
        finally {
            object2.exit();
        }
    }

    private void runFilterUnusedDeclarationsMode(File file, String string, LogProxy logProxy) throws IOException {
        CollectNamesScript collectNamesScript = new CollectNamesScript();
        OptionMap optionMap = new OptionMap(logProxy, true);
        ParseEnvironment parseEnvironment = new ParseEnvironment((Script)collectNamesScript, optionMap);
        try {
            parseEnvironment.parseScript(file.getAbsolutePath());
            this.mLogger.info((Object)("Successfully read SMT file " + file.getAbsolutePath()));
        }
        catch (SMTLIBException sMTLIBException) {
            this.mLogger.info((Object)("Failed while reading SMT file " + file.getAbsolutePath()));
            this.mLogger.info((Object)("SMTLIBException " + sMTLIBException.getMessage()));
            parseEnvironment.printError(sMTLIBException.getMessage());
        }
        Object object = string == null || string.isEmpty() ? file.getName() : string + File.separator + file.getName();
        ParseEnvironment parseEnvironment2 = new ParseEnvironment((Script)new FilteredLoggingScript((String)object, true, collectNamesScript.getNames()), optionMap);
        try {
            parseEnvironment2.parseScript(file.getAbsolutePath());
            this.mLogger.info((Object)("Successfully wrote SMT file " + (String)object));
        }
        catch (SMTLIBException sMTLIBException) {
            this.mLogger.fatal((Object)("Failed while writing SMT file " + (String)object), (Throwable)sMTLIBException);
        }
    }

    private static class CollectNamesScript
    extends NoopScript {
        Set<String> mNames = new HashSet<String>();

        private CollectNamesScript() {
        }

        public Term term(String string, String[] stringArray, Sort sort, Term ... termArray) throws SMTLIBException {
            this.mNames.add(string);
            return super.term(string, stringArray, sort, termArray);
        }

        public Set<String> getNames() {
            return this.mNames;
        }
    }

    private static class FilteredLoggingScript
    extends LoggingScript {
        private final Set<String> mAllowedNames;

        public FilteredLoggingScript(String string, boolean bl, Set<String> set) throws IOException {
            super(string, bl);
            this.mAllowedNames = set;
        }

        public void declareFun(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
            if (this.mAllowedNames.contains(string)) {
                super.declareFun(string, sortArray, sort);
            }
        }

        public void defineFun(String string, TermVariable[] termVariableArray, Sort sort, Term term) throws SMTLIBException {
            if (this.mAllowedNames.contains(string)) {
                super.defineFun(string, termVariableArray, sort, term);
            }
        }
    }
}

