/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.LoggingHelper;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.ITermProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalTermUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.TVBool;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public abstract class NonrelationalState<STATE extends NonrelationalState<STATE, V>, V extends INonrelationalValue<V>>
implements IAbstractState<STATE> {
    private static final String MSG_NULL = "NULL";
    private static final String MSG_BOT = "BOT";
    private static final String MSG_TOP = "TOP";
    private static int sId;
    private final int mId;
    private final Set<IProgramVarOrConst> mVariables;
    private final Map<IProgramVarOrConst, V> mValueMap;
    private final Map<IProgramVarOrConst, BooleanValue> mBooleanValuesMap;
    private TVBool mIsBottom;
    private final ILogger mLogger;

    protected NonrelationalState(ILogger iLogger, boolean bl) {
        this(iLogger, Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap(), bl);
    }

    protected NonrelationalState(ILogger iLogger, Set<IProgramVarOrConst> set, Map<IProgramVarOrConst, V> map, Map<IProgramVarOrConst, BooleanValue> map2, boolean bl) {
        this(iLogger, set, map, map2, bl ? TVBool.FIXED : TVBool.UNCHECKED);
    }

    protected NonrelationalState(ILogger iLogger, Set<IProgramVarOrConst> set, Map<IProgramVarOrConst, V> map, Map<IProgramVarOrConst, BooleanValue> map2, TVBool tVBool) {
        this.mVariables = new HashSet<IProgramVarOrConst>(set);
        this.mValueMap = new HashMap<IProgramVarOrConst, V>(map);
        this.mBooleanValuesMap = new HashMap<IProgramVarOrConst, BooleanValue>(map2);
        this.mId = ++sId;
        this.mLogger = iLogger;
        this.mIsBottom = tVBool;
    }

    public ImmutableSet<IProgramVarOrConst> getVariables() {
        return ImmutableSet.of(this.mVariables);
    }

    public V getValue(IProgramVarOrConst iProgramVarOrConst) {
        INonrelationalValue iNonrelationalValue = (INonrelationalValue)this.getVar2ValueNonrelational().get(iProgramVarOrConst);
        if (iNonrelationalValue == null) {
            throw new AssertionError((Object)("There is no value of variable " + String.valueOf(iProgramVarOrConst) + "."));
        }
        return (V)iNonrelationalValue;
    }

    public BooleanValue getBooleanValue(IProgramVarOrConst iProgramVarOrConst) {
        BooleanValue booleanValue = this.getVar2ValueBoolean().get(iProgramVarOrConst);
        if (booleanValue == null) {
            throw new AssertionError((Object)("There is no value of variable " + String.valueOf(iProgramVarOrConst) + "."));
        }
        return booleanValue;
    }

    public STATE setValue(IProgramVarOrConst iProgramVarOrConst, V v) {
        if (this.getValue(iProgramVarOrConst).isAbstractionEqual(v)) {
            return this.getThis();
        }
        STATE STATE = this.createCopy();
        this.setValueInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConst, v);
        return STATE;
    }

    public STATE setValues(IProgramVarOrConst[] iProgramVarOrConstArray, V[] VArray) {
        assert (iProgramVarOrConstArray != null);
        assert (VArray != null);
        assert (iProgramVarOrConstArray.length == VArray.length);
        return (STATE)this.setMixedValues(iProgramVarOrConstArray, (INonrelationalValue[])VArray, new IProgramVarOrConst[0], new BooleanValue[0], new IProgramVarOrConst[0], this.getArray(0));
    }

    public STATE setBooleanValue(IProgramVarOrConst iProgramVarOrConst, BooleanValue booleanValue) {
        assert (iProgramVarOrConst != null);
        assert (booleanValue != null);
        if (this.getBooleanValue(iProgramVarOrConst).isEqualTo(booleanValue)) {
            return this.getThis();
        }
        STATE STATE = this.createCopy();
        this.setValueInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConst, booleanValue);
        return STATE;
    }

    protected NonrelationalState<STATE, V> setBooleanValues(IProgramVarOrConst[] iProgramVarOrConstArray, BooleanValue[] booleanValueArray) {
        assert (iProgramVarOrConstArray != null);
        assert (booleanValueArray != null);
        assert (iProgramVarOrConstArray.length == booleanValueArray.length);
        return this.setMixedValues(new IProgramVarOrConst[0], this.getArray(0), iProgramVarOrConstArray, booleanValueArray, new IProgramVarOrConst[0], this.getArray(0));
    }

    protected NonrelationalState<STATE, V> setArrayValue(IProgramVarOrConst iProgramVarOrConst, V v) {
        assert (iProgramVarOrConst != null);
        assert (v != null);
        STATE STATE = this.createCopy();
        this.setValueInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConst, v);
        return STATE;
    }

    protected NonrelationalState<STATE, V> setArrayValues(IProgramVarOrConst[] iProgramVarOrConstArray, V[] VArray) {
        assert (iProgramVarOrConstArray != null);
        assert (VArray != null);
        assert (iProgramVarOrConstArray.length == VArray.length);
        return this.setMixedValues(new IProgramVarOrConst[0], this.getArray(0), new IProgramVarOrConst[0], new BooleanValue[0], iProgramVarOrConstArray, (INonrelationalValue[])VArray);
    }

    public STATE setMixedValues(IProgramVarOrConst[] iProgramVarOrConstArray, V[] VArray, IProgramVarOrConst[] iProgramVarOrConstArray2, BooleanValue[] booleanValueArray, IProgramVarOrConst[] iProgramVarOrConstArray3, V[] VArray2) {
        assert (iProgramVarOrConstArray != null);
        assert (VArray != null);
        assert (iProgramVarOrConstArray2 != null);
        assert (booleanValueArray != null);
        assert (iProgramVarOrConstArray.length == VArray.length);
        assert (iProgramVarOrConstArray2.length == booleanValueArray.length);
        STATE STATE = this.createCopy();
        int n = 0;
        while (n < iProgramVarOrConstArray.length) {
            this.setValueInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConstArray[n], VArray[n]);
            ++n;
        }
        n = 0;
        while (n < iProgramVarOrConstArray2.length) {
            this.setValueInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConstArray2[n], booleanValueArray[n]);
            ++n;
        }
        n = 0;
        while (n < iProgramVarOrConstArray3.length) {
            this.setValueInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConstArray3[n], VArray2[n]);
            ++n;
        }
        return STATE;
    }

    private void setValueInternally(NonrelationalState<STATE, V> nonrelationalState, IProgramVarOrConst iProgramVarOrConst, V v) {
        assert (nonrelationalState != null);
        assert (iProgramVarOrConst != null);
        assert (v != null);
        nonrelationalState.resetBottomPreserving();
        nonrelationalState.mVariables.add(iProgramVarOrConst);
        nonrelationalState.getVar2ValueNonrelational().put(iProgramVarOrConst, v);
        if (v.isBottom()) {
            nonrelationalState.mIsBottom = TVBool.FIXED;
        }
    }

    private void setValueInternally(NonrelationalState<STATE, V> nonrelationalState, IProgramVarOrConst iProgramVarOrConst, BooleanValue booleanValue) {
        assert (nonrelationalState != null);
        assert (iProgramVarOrConst != null);
        assert (nonrelationalState.mVariables.contains(iProgramVarOrConst)) : "Variable unknown";
        assert (nonrelationalState.getVar2ValueBoolean().get(iProgramVarOrConst) != null) : "Boolean variable not in boolean values map";
        nonrelationalState.resetBottomPreserving();
        nonrelationalState.getVar2ValueBoolean().put(iProgramVarOrConst, booleanValue);
        if (booleanValue.isBottom()) {
            nonrelationalState.mIsBottom = TVBool.FIXED;
        }
    }

    public VariableType getVariableType(IProgramVarOrConst iProgramVarOrConst) {
        if (!this.containsVariable(iProgramVarOrConst)) {
            throw new UnsupportedOperationException("The variable " + String.valueOf(iProgramVarOrConst) + " does not exist in the current state.");
        }
        if (this.getVar2ValueBoolean().containsKey(iProgramVarOrConst)) {
            return VariableType.BOOLEAN;
        }
        if (this.getVar2ValueNonrelational().containsKey(iProgramVarOrConst)) {
            return VariableType.VARIABLE;
        }
        throw new UnsupportedOperationException("The variable " + String.valueOf(iProgramVarOrConst) + " exists but was not found in the variable sets.");
    }

    private void addVariableInternally(NonrelationalState<STATE, V> nonrelationalState, IProgramVarOrConst iProgramVarOrConst2) {
        assert (nonrelationalState != null);
        assert (iProgramVarOrConst2 != null);
        if (!nonrelationalState.mVariables.add(iProgramVarOrConst2)) {
            throw new UnsupportedOperationException("Variable names must be disjoint. Variable " + String.valueOf(iProgramVarOrConst2) + " is already present.");
        }
        nonrelationalState.resetBottomPreserving();
        Consumer<IProgramVarOrConst> consumer = iProgramVarOrConst -> {
            V v = nonrelationalState.getVar2ValueNonrelational().put((IProgramVarOrConst)iProgramVarOrConst, this.createTopValue());
        };
        Consumer<IProgramVarOrConst> consumer2 = iProgramVarOrConst -> {
            BooleanValue booleanValue = nonrelationalState.getVar2ValueBoolean().put((IProgramVarOrConst)iProgramVarOrConst, BooleanValue.TOP);
        };
        TypeUtils.consumeVariable(consumer, consumer2, null, iProgramVarOrConst2);
    }

    public STATE patch(STATE STATE) {
        assert (STATE != null);
        STATE STATE2 = this.createCopy();
        Consumer<IProgramVarOrConst> consumer = iProgramVarOrConst -> this.setValueInternally((NonrelationalState<STATE, V>)STATE2, (IProgramVarOrConst)iProgramVarOrConst, (V)((INonrelationalValue)STATE.getVar2ValueNonrelational().get(iProgramVarOrConst)));
        Consumer<IProgramVarOrConst> consumer2 = iProgramVarOrConst -> this.setValueInternally((NonrelationalState<STATE, V>)STATE2, (IProgramVarOrConst)iProgramVarOrConst, STATE.getVar2ValueBoolean().get(iProgramVarOrConst));
        for (IProgramVarOrConst iProgramVarOrConst2 : ((NonrelationalState)STATE).getVariables()) {
            if (!((NonrelationalState)STATE2).containsVariable(iProgramVarOrConst2)) {
                this.addVariableInternally((NonrelationalState<STATE, V>)STATE2, iProgramVarOrConst2);
            }
            TypeUtils.consumeVariable(consumer, consumer2, null, iProgramVarOrConst2);
        }
        return STATE2;
    }

    public IAbstractState.SubsetResult isSubsetOf(STATE STATE) {
        ITermProvider iTermProvider;
        ITermProvider iTermProvider2;
        if (this.isBottom() && ((NonrelationalState)STATE).isBottom()) {
            return IAbstractState.SubsetResult.EQUAL;
        }
        if (this.isBottom()) {
            return IAbstractState.SubsetResult.STRICT;
        }
        if (((NonrelationalState)STATE).isBottom()) {
            return IAbstractState.SubsetResult.NONE;
        }
        if (this.isEqualTo(STATE)) {
            return IAbstractState.SubsetResult.EQUAL;
        }
        for (Map.Entry<IProgramVarOrConst, V> entry : this.getVar2ValueNonrelational().entrySet()) {
            iTermProvider2 = (INonrelationalValue)entry.getValue();
            iTermProvider = (INonrelationalValue)((NonrelationalState)STATE).getVar2ValueNonrelational().get(entry.getKey());
            if (iTermProvider == null || iTermProvider2.isContainedIn(iTermProvider)) continue;
            return IAbstractState.SubsetResult.NONE;
        }
        for (Map.Entry<IProgramVarOrConst, Object> entry : this.getVar2ValueBoolean().entrySet()) {
            iTermProvider2 = (BooleanValue)entry.getValue();
            iTermProvider = ((NonrelationalState)STATE).getVar2ValueBoolean().get(entry.getKey());
            if (iTermProvider == null || ((BooleanValue)iTermProvider2).isContainedIn((BooleanValue)iTermProvider)) continue;
            return IAbstractState.SubsetResult.NONE;
        }
        return IAbstractState.SubsetResult.STRICT;
    }

    public STATE removeVariable(IProgramVarOrConst iProgramVarOrConst) {
        assert (iProgramVarOrConst != null);
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>(this.mVariables);
        hashSet.remove(iProgramVarOrConst);
        HashMap<IProgramVarOrConst, V> hashMap = new HashMap<IProgramVarOrConst, V>(this.getVar2ValueNonrelational());
        hashMap.remove(iProgramVarOrConst);
        HashMap<IProgramVarOrConst, BooleanValue> hashMap2 = new HashMap<IProgramVarOrConst, BooleanValue>(this.getVar2ValueBoolean());
        hashMap2.remove(iProgramVarOrConst);
        return this.createState(this.mLogger, hashSet, hashMap, hashMap2, this.mIsBottom == TVBool.FIXED);
    }

    public STATE addVariable(IProgramVarOrConst iProgramVarOrConst) {
        assert (iProgramVarOrConst != null);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Adding boogievar " + String.valueOf(LoggingHelper.getHashCodeString(iProgramVarOrConst)) + " " + String.valueOf(iProgramVarOrConst)));
        }
        STATE STATE = this.createCopy();
        this.addVariableInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConst);
        return STATE;
    }

    public STATE addVariables(Collection<IProgramVarOrConst> collection) {
        assert (collection != null);
        if (collection.isEmpty()) {
            return this.getThis();
        }
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>(this.mVariables);
        HashMap<IProgramVarOrConst, V> hashMap = new HashMap<IProgramVarOrConst, V>(this.getVar2ValueNonrelational());
        HashMap<IProgramVarOrConst, BooleanValue> hashMap2 = new HashMap<IProgramVarOrConst, BooleanValue>(this.getVar2ValueBoolean());
        Consumer<IProgramVarOrConst> consumer = iProgramVarOrConst -> {
            V v = hashMap.put((IProgramVarOrConst)iProgramVarOrConst, this.createTopValue());
        };
        Consumer<IProgramVarOrConst> consumer2 = iProgramVarOrConst -> {
            BooleanValue booleanValue = hashMap2.put((IProgramVarOrConst)iProgramVarOrConst, BooleanValue.TOP);
        };
        for (IProgramVarOrConst iProgramVarOrConst2 : collection) {
            if (!hashSet.add(iProgramVarOrConst2)) {
                throw new UnsupportedOperationException("Variable names must be disjoint. The variable " + String.valueOf(iProgramVarOrConst2) + " is already present.");
            }
            TypeUtils.consumeVariable(consumer, consumer2, null, iProgramVarOrConst2);
        }
        return this.createState(this.mLogger, hashSet, hashMap, hashMap2, this.mIsBottom == TVBool.FIXED);
    }

    public STATE removeVariables(Collection<IProgramVarOrConst> collection) {
        assert (collection != null);
        if (this.isEmpty()) {
            return this.getThis();
        }
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>(this.mVariables);
        HashMap<IProgramVarOrConst, V> hashMap = new HashMap<IProgramVarOrConst, V>(this.getVar2ValueNonrelational());
        HashMap<IProgramVarOrConst, BooleanValue> hashMap2 = new HashMap<IProgramVarOrConst, BooleanValue>(this.getVar2ValueBoolean());
        for (IProgramVarOrConst iProgramVarOrConst : collection) {
            hashSet.remove(iProgramVarOrConst);
            hashMap.remove(iProgramVarOrConst);
            hashMap2.remove(iProgramVarOrConst);
        }
        return this.createState(this.mLogger, hashSet, hashMap, hashMap2, this.mIsBottom == TVBool.FIXED);
    }

    public STATE renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> map) {
        STATE STATE;
        if (map == null || map.isEmpty()) {
            return this.getThis();
        }
        STATE STATE2 = STATE = this.createCopy();
        boolean bl = false;
        for (Map.Entry<IProgramVarOrConst, IProgramVarOrConst> entry : map.entrySet()) {
            ITermProvider iTermProvider;
            IProgramVarOrConst iProgramVarOrConst = entry.getKey();
            IProgramVarOrConst iProgramVarOrConst2 = entry.getValue();
            if (iProgramVarOrConst2 == null) {
                throw new IllegalArgumentException("Cannot rename " + String.valueOf(iProgramVarOrConst) + " to null");
            }
            if (iProgramVarOrConst == iProgramVarOrConst2 || !((NonrelationalState)STATE2).mVariables.remove(iProgramVarOrConst)) continue;
            this.addVariableInternally((NonrelationalState<STATE, V>)STATE2, iProgramVarOrConst2);
            bl = true;
            if (((NonrelationalState)STATE2).mValueMap.containsKey(iProgramVarOrConst)) {
                assert (!((NonrelationalState)STATE2).mBooleanValuesMap.containsKey(iProgramVarOrConst));
                iTermProvider = (INonrelationalValue)((NonrelationalState)STATE2).mValueMap.remove(iProgramVarOrConst);
                ((NonrelationalState)STATE2).mValueMap.put(iProgramVarOrConst2, (INonrelationalValue)iTermProvider);
                continue;
            }
            if (((NonrelationalState)STATE2).mBooleanValuesMap.containsKey(iProgramVarOrConst)) {
                iTermProvider = ((NonrelationalState)STATE2).mBooleanValuesMap.remove(iProgramVarOrConst);
                ((NonrelationalState)STATE2).mBooleanValuesMap.put(iProgramVarOrConst2, (BooleanValue)iTermProvider);
                continue;
            }
            throw new AssertionError((Object)"If var is known in this state is has to be either a number value or a boolean value");
        }
        if (bl) {
            return STATE;
        }
        return this.getThis();
    }

    public boolean containsVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.mVariables.contains(iProgramVarOrConst);
    }

    public boolean isEmpty() {
        return this.mVariables.isEmpty();
    }

    public boolean isBottom() {
        switch (this.mIsBottom) {
            case FALSE: {
                return false;
            }
            case TRUE: 
            case FIXED: {
                return true;
            }
            case UNCHECKED: {
                boolean bl = this.getVar2ValueNonrelational().entrySet().stream().anyMatch(entry -> ((INonrelationalValue)entry.getValue()).isBottom()) || this.getVar2ValueBoolean().entrySet().stream().anyMatch(entry -> ((BooleanValue)entry.getValue()).isBottom());
                this.mIsBottom = bl ? TVBool.TRUE : TVBool.FALSE;
                return this.isBottom();
            }
        }
        throw new UnsupportedOperationException("Unknown LBool " + String.valueOf((Object)this.mIsBottom));
    }

    protected TVBool getBottomFlag() {
        return this.mIsBottom;
    }

    protected void resetBottomPreserving() {
        if (this.mIsBottom == TVBool.FIXED) {
            return;
        }
        this.mIsBottom = TVBool.UNCHECKED;
    }

    public boolean isEqualTo(STATE STATE) {
        ITermProvider iTermProvider;
        if (!this.hasSameVariables((NonrelationalState<STATE, V>)STATE)) {
            return false;
        }
        for (Map.Entry<IProgramVarOrConst, V> entry : this.getVar2ValueNonrelational().entrySet()) {
            iTermProvider = (INonrelationalValue)((NonrelationalState)STATE).getVar2ValueNonrelational().get(entry.getKey());
            if (((INonrelationalValue)this.getVar2ValueNonrelational().get(entry.getKey())).isAbstractionEqual(iTermProvider)) continue;
            return false;
        }
        for (Map.Entry<IProgramVarOrConst, Object> entry : this.getVar2ValueBoolean().entrySet()) {
            iTermProvider = ((NonrelationalState)STATE).getVar2ValueBoolean().get(entry.getKey());
            if (this.getVar2ValueBoolean().get(entry.getKey()).isEqualTo((BooleanValue)iTermProvider)) continue;
            return false;
        }
        return true;
    }

    public String toLogString() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        if (this.isBottom()) {
            stringBuilder.append("BOTTOM ");
            if (this.getBottomFlag() == TVBool.FIXED) {
                stringBuilder.append("(FIXED) ");
            }
        }
        for (IProgramVarOrConst iProgramVarOrConst : this.mVariables) {
            String string = iProgramVarOrConst.getGloballyUniqueId();
            String string2 = this.getValueAsString(iProgramVarOrConst);
            if (MSG_TOP.equals(string2)) {
                stringBuilder2.append(string).append(", ");
                continue;
            }
            if (MSG_BOT.equals(string2)) {
                stringBuilder3.append(string).append(", ");
                continue;
            }
            stringBuilder.append(string).append(" = ").append(string2).append("; ");
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append("TOP: ").append((CharSequence)stringBuilder2.delete(stringBuilder2.length() - 2, stringBuilder2.length())).append(" ");
        }
        if (stringBuilder3.length() > 0) {
            stringBuilder.append("BOT: ").append((CharSequence)stringBuilder3.delete(stringBuilder3.length() - 2, stringBuilder3.length())).append(" ");
        }
        return stringBuilder.toString();
    }

    private String getValueAsString(IProgramVarOrConst iProgramVarOrConst) {
        INonrelationalValue iNonrelationalValue = (INonrelationalValue)this.getVar2ValueNonrelational().get(iProgramVarOrConst);
        if (iNonrelationalValue != null) {
            if (iNonrelationalValue.isTop()) {
                return MSG_TOP;
            }
            if (iNonrelationalValue.isBottom()) {
                return MSG_BOT;
            }
            return iNonrelationalValue.toString();
        }
        BooleanValue booleanValue = this.getVar2ValueBoolean().get(iProgramVarOrConst);
        if (booleanValue != null) {
            if (booleanValue == BooleanValue.TOP) {
                return MSG_TOP;
            }
            if (booleanValue == BooleanValue.BOTTOM) {
                return MSG_BOT;
            }
            return booleanValue.toString();
        }
        return MSG_NULL;
    }

    public String toString() {
        return this.toLogString();
    }

    public int hashCode() {
        return this.mId;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return ((NonrelationalState)object).mId == this.mId;
    }

    protected abstract STATE getThis();

    protected abstract STATE createCopy();

    protected abstract STATE createState(ILogger var1, Set<IProgramVarOrConst> var2, Map<IProgramVarOrConst, V> var3, Map<IProgramVarOrConst, BooleanValue> var4, boolean var5);

    protected abstract V createBottomValue();

    protected abstract V createTopValue();

    protected abstract V[] getArray(int var1);

    public boolean hasSameVariables(NonrelationalState<STATE, V> nonrelationalState) {
        if (nonrelationalState == null) {
            return false;
        }
        if (!this.getClass().isInstance(nonrelationalState)) {
            return false;
        }
        return this.mVariables.equals(nonrelationalState.mVariables);
    }

    public STATE intersect(STATE STATE) {
        assert (STATE != null);
        assert (this.hasSameVariables((NonrelationalState<STATE, V>)STATE));
        if (STATE == this) {
            return this.getThis();
        }
        if (this.isBottom()) {
            return this.getThis();
        }
        if (((NonrelationalState)STATE).isBottom()) {
            return STATE;
        }
        STATE STATE2 = this.createCopy();
        for (Map.Entry<IProgramVarOrConst, V> entry : this.getVar2ValueNonrelational().entrySet()) {
            this.setValueInternally((NonrelationalState<STATE, V>)STATE2, entry.getKey(), (V)((INonrelationalValue)entry.getValue()).intersect((INonrelationalValue)((NonrelationalState)STATE).getVar2ValueNonrelational().get(entry.getKey())));
        }
        for (Map.Entry<IProgramVarOrConst, Object> entry : this.getVar2ValueBoolean().entrySet()) {
            this.setValueInternally((NonrelationalState<STATE, V>)STATE2, entry.getKey(), ((BooleanValue)entry.getValue()).intersect(((NonrelationalState)STATE).getVar2ValueBoolean().get(entry.getKey())));
        }
        return STATE2;
    }

    public STATE union(STATE STATE) {
        assert (STATE != null);
        assert (this.hasSameVariables((NonrelationalState<STATE, V>)STATE));
        if (STATE == this) {
            return this.getThis();
        }
        if (this.isBottom()) {
            return STATE;
        }
        if (((NonrelationalState)STATE).isBottom()) {
            return this.getThis();
        }
        STATE STATE2 = this.createCopy();
        Consumer<IProgramVarOrConst> consumer = iProgramVarOrConst -> this.setValueInternally((NonrelationalState<STATE, V>)STATE2, (IProgramVarOrConst)iProgramVarOrConst, (V)((INonrelationalValue)this.getVar2ValueNonrelational().get(iProgramVarOrConst)).merge((INonrelationalValue)STATE.getVar2ValueNonrelational().get(iProgramVarOrConst)));
        Consumer<IProgramVarOrConst> consumer2 = iProgramVarOrConst -> this.setValueInternally((NonrelationalState<STATE, V>)STATE2, (IProgramVarOrConst)iProgramVarOrConst, this.getVar2ValueBoolean().get(iProgramVarOrConst).merge(STATE.getVar2ValueBoolean().get(iProgramVarOrConst)));
        for (IProgramVarOrConst iProgramVarOrConst2 : this.mVariables) {
            TypeUtils.consumeVariable(consumer, consumer2, null, iProgramVarOrConst2);
        }
        return STATE2;
    }

    public STATE compact() {
        if (this.isBottom()) {
            return this.createState(this.mLogger, Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap(), true);
        }
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        for (Map.Entry<IProgramVarOrConst, V> entry2 : this.getVar2ValueNonrelational().entrySet()) {
            if (!((INonrelationalValue)entry2.getValue()).isTop()) continue;
            hashSet.add(entry2.getKey());
        }
        for (Map.Entry<IProgramVarOrConst, Object> entry : this.getVar2ValueBoolean().entrySet()) {
            if (entry.getValue() != BooleanValue.TOP) continue;
            hashSet.add(entry.getKey());
        }
        if (hashSet.isEmpty()) {
            return this.getThis();
        }
        STATE STATE = this.createCopy();
        return (STATE)((NonrelationalState)STATE).removeVariables(hashSet);
    }

    public Term getTerm(Script script) {
        Sort sort;
        Term term;
        IProgramVarOrConst iProgramVarOrConst;
        if (this.isBottom()) {
            return script.term("false", new Term[0]);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>(this.getVar2ValueNonrelational().size() + this.getVar2ValueBoolean().size());
        for (Map.Entry<IProgramVarOrConst, V> entry : this.getVar2ValueNonrelational().entrySet()) {
            iProgramVarOrConst = entry.getKey();
            term = NonrelationalTermUtils.getTermVar(iProgramVarOrConst);
            assert (term != null) : "Error during TermVar creation";
            sort = term.getSort().getRealSort();
            if (!sort.isNumericSort()) continue;
            arrayList.add(((INonrelationalValue)entry.getValue()).getTerm(script, sort, term));
        }
        for (Map.Entry<IProgramVarOrConst, Object> entry : this.getVar2ValueBoolean().entrySet()) {
            iProgramVarOrConst = entry.getKey();
            term = NonrelationalTermUtils.getTermVar(iProgramVarOrConst);
            assert (term != null) : "Error during TermVar creation";
            sort = term.getSort().getRealSort();
            arrayList.add(((BooleanValue)entry.getValue()).getTerm(script, sort, term));
        }
        return SmtUtils.and((Script)script, (Term[])arrayList.toArray(new Term[arrayList.size()]));
    }

    public STATE bottomState() {
        STATE STATE = this.createCopy();
        ((NonrelationalState)STATE).resetBottomPreserving();
        for (Map.Entry<IProgramVarOrConst, V> entry : ((NonrelationalState)STATE).getVar2ValueNonrelational().entrySet()) {
            entry.setValue(this.createBottomValue());
        }
        for (Map.Entry<IProgramVarOrConst, Object> entry : ((NonrelationalState)STATE).getVar2ValueBoolean().entrySet()) {
            entry.setValue(BooleanValue.BOTTOM);
        }
        return STATE;
    }

    public STATE setVarsToTop(List<IProgramVarOrConst> list, List<IProgramVarOrConst> list2, List<IProgramVarOrConst> list3) {
        STATE STATE = this.createCopy();
        for (IProgramVarOrConst iProgramVarOrConst : list) {
            this.setValueInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConst, this.createTopValue());
        }
        for (IProgramVarOrConst iProgramVarOrConst : list2) {
            this.setValueInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConst, BooleanValue.TOP);
        }
        for (IProgramVarOrConst iProgramVarOrConst : list3) {
            this.setValueInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConst, this.createTopValue());
        }
        return STATE;
    }

    protected STATE setVarsToBottom(List<IProgramVarOrConst> list, List<IProgramVarOrConst> list2, List<IProgramVarOrConst> list3) {
        STATE STATE = this.createCopy();
        for (IProgramVarOrConst iProgramVarOrConst : list) {
            this.setValueInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConst, this.createBottomValue());
        }
        for (IProgramVarOrConst iProgramVarOrConst : list2) {
            this.setValueInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConst, BooleanValue.BOTTOM);
        }
        for (IProgramVarOrConst iProgramVarOrConst : list3) {
            this.setValueInternally((NonrelationalState<STATE, V>)STATE, iProgramVarOrConst, this.createBottomValue());
        }
        return STATE;
    }

    protected Map<IProgramVarOrConst, BooleanValue> getVar2ValueBoolean() {
        return this.mBooleanValuesMap;
    }

    protected Map<IProgramVarOrConst, V> getVar2ValueNonrelational() {
        return this.mValueMap;
    }

    protected ILogger getLogger() {
        return this.mLogger;
    }

    public static enum VariableType {
        VARIABLE,
        BOOLEAN,
        ARRAY;

    }
}

