/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class Boogie2SmtSymbolTableTmpVars
implements IBoogieSymbolTableVariableProvider {
    private final Boogie2SmtSymbolTable mBoogie2SmtSymbolTable;
    private final Map<String, IProgramVar> mTempVars;

    public Boogie2SmtSymbolTableTmpVars(Boogie2SmtSymbolTable boogie2SmtSymbolTable) {
        this.mBoogie2SmtSymbolTable = boogie2SmtSymbolTable;
        this.mTempVars = new HashMap<String, IProgramVar>();
    }

    public void addTemporaryVariable(IProgramVar iProgramVar) {
        if (this.mTempVars.put(iProgramVar.getGloballyUniqueId(), iProgramVar) != null) {
            throw new UnsupportedOperationException("Temporary variable " + iProgramVar.getGloballyUniqueId() + " already present.");
        }
    }

    public void addTemporaryVariables(Collection<IProgramVar> collection) {
        if (collection.stream().anyMatch(iProgramVar -> this.mTempVars.containsKey(iProgramVar.getGloballyUniqueId()))) {
            throw new UnsupportedOperationException("Some variable is already present.");
        }
        this.mTempVars.putAll(collection.stream().collect(Collectors.toMap(iProgramVar -> iProgramVar.getGloballyUniqueId(), iProgramVar -> iProgramVar)));
    }

    public void removeTemporaryVariable(IProgramVar iProgramVar) {
        if (this.mTempVars.remove(iProgramVar.getGloballyUniqueId()) == null) {
            throw new UnsupportedOperationException("Variable " + iProgramVar.getGloballyUniqueId() + " not present in temporary variables.");
        }
    }

    public void clearTemporaryVariables() {
        this.mTempVars.clear();
    }

    public IProgramVar getBoogieVar(String string, DeclarationInformation declarationInformation, boolean bl) {
        if (this.mTempVars.containsKey(string)) {
            return this.mTempVars.get(string);
        }
        return this.mBoogie2SmtSymbolTable.getBoogieVar(string, declarationInformation, bl);
    }

    public IProgramVar getBoogieVar(String string, String string2, boolean bl) {
        if (this.mTempVars.containsKey(string)) {
            return this.mTempVars.get(string);
        }
        return this.mBoogie2SmtSymbolTable.getBoogieVar(string, string2, bl);
    }

    public ProgramConst getBoogieConst(String string) {
        return this.mBoogie2SmtSymbolTable.getBoogieConst(string);
    }

    public int getNumberOfTempVars() {
        return this.mTempVars.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Temp Vars: ");
        stringBuilder.append(this.mTempVars.entrySet().stream().map(entry -> (String)entry.getKey() + " :: " + ((IProgramVar)entry.getValue()).getGloballyUniqueId()).collect(Collectors.joining(", ")));
        return stringBuilder.toString();
    }
}

