/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.MappedTerm2Expression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman.Boogie2SmtSymbolTableTmpVars;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman.PoormanAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman.util.AssumptionBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman.util.TermConjunctEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PoormanCachedPostOperation<BACKING extends IAbstractState<BACKING>> {
    private final Set<IProgramVarOrConst> mAddedVariables;
    private final Map<TermVariable, String> mAlternateOldNames;
    private final IAbstractDomain<BACKING, IcfgEdge> mBackingDomain;
    private final Boogie2SMT mBoogie2Smt;
    private final Boogie2SmtSymbolTableTmpVars mBoogie2SmtSymbolTable;
    private final Map<String, IProgramVar> mFreshVarsCache = new HashMap<String, IProgramVar>();
    private final CodeBlock mHavocPostCodeBlock;
    private final Set<IProgramVarOrConst> mInAuxVars;
    private final ILogger mLogger;
    private final ManagedScript mManagedScript;
    private final MappedTerm2Expression mMappedTerm2Expression;
    private final Set<IProgramVarOrConst> mNewAuxVars;
    private final Set<IProgramVarOrConst> mNewOutVars;
    private final Map<TermVariable, IProgramVarOrConst> mOldTermVarMapping;
    private final Map<IProgramVarOrConst, IProgramVarOrConst> mOutVarRenaming;
    private final Map<IProgramVarOrConst, IProgramVarOrConst> mRenamedInVars;
    private final IUltimateServiceProvider mServices;
    private final UnmodifiableTransFormula mTransformula;
    private final Set<TermVariable> mVariableRetainmentSet;
    private final TermConjunctEvaluator<BACKING> mEvaluator;

    protected PoormanCachedPostOperation(UnmodifiableTransFormula unmodifiableTransFormula, IUltimateServiceProvider iUltimateServiceProvider, Boogie2SMT boogie2SMT, ManagedScript managedScript, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider, CodeBlockFactory codeBlockFactory, IAbstractDomain<BACKING, IcfgEdge> iAbstractDomain) {
        this.mTransformula = unmodifiableTransFormula;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mBackingDomain = iAbstractDomain;
        this.mBoogie2Smt = boogie2SMT;
        assert (iBoogieSymbolTableVariableProvider instanceof Boogie2SmtSymbolTableTmpVars);
        this.mBoogie2SmtSymbolTable = (Boogie2SmtSymbolTableTmpVars)iBoogieSymbolTableVariableProvider;
        this.mManagedScript = managedScript;
        this.mMappedTerm2Expression = new MappedTerm2Expression(this.mBoogie2Smt.getTypeSortTranslator(), this.mBoogie2Smt.getBoogie2SmtSymbolTable(), this.mManagedScript);
        this.mRenamedInVars = new HashMap<IProgramVarOrConst, IProgramVarOrConst>();
        this.mNewOutVars = new HashSet<IProgramVarOrConst>();
        this.mNewAuxVars = new HashSet<IProgramVarOrConst>();
        this.mOutVarRenaming = new HashMap<IProgramVarOrConst, IProgramVarOrConst>();
        this.mAddedVariables = new HashSet<IProgramVarOrConst>();
        this.mInAuxVars = new HashSet<IProgramVarOrConst>();
        this.mVariableRetainmentSet = new HashSet<TermVariable>();
        this.mOldTermVarMapping = new HashMap<TermVariable, IProgramVarOrConst>();
        this.mAlternateOldNames = new HashMap<TermVariable, String>();
        for (Map.Entry havocStatement2 : this.mTransformula.getOutVars().entrySet()) {
            if (havocStatement2.getKey() instanceof ProgramOldVar) {
                String string = "old~~".concat(((TermVariable)havocStatement2.getValue()).getName().replace("old(", "").replace(")", ""));
                this.mAlternateOldNames.put((TermVariable)havocStatement2.getValue(), string);
                IProgramVar iProgramVar = this.getCachedFreshProgramVar((TermVariable)havocStatement2.getValue(), string);
                this.mOldTermVarMapping.put((TermVariable)havocStatement2.getValue(), (IProgramVarOrConst)iProgramVar);
                continue;
            }
            this.mVariableRetainmentSet.add((TermVariable)havocStatement2.getValue());
        }
        this.mVariableRetainmentSet.addAll(this.mTransformula.getInVars().values());
        this.mVariableRetainmentSet.addAll(this.mTransformula.getAuxVars());
        this.obtainVariableMappingFromTransformula();
        HavocStatement havocStatement = this.constructBoogieHavocStatementOfUnmappedOutVars();
        this.mHavocPostCodeBlock = havocStatement == null ? null : AssumptionBuilder.constructCodeBlock(codeBlockFactory, new Statement[]{havocStatement});
        this.mEvaluator = new TermConjunctEvaluator<BACKING>(this.mLogger, unmodifiableTransFormula.getFormula(), this.mBackingDomain, this.mVariableRetainmentSet, this.mAlternateOldNames, this.mMappedTerm2Expression, codeBlockFactory, this.mBoogie2Smt.getScript());
    }

    private HavocStatement constructBoogieHavocStatementOfUnmappedOutVars() {
        TermVariable termVariable2;
        Set set = this.mTransformula.getInVars().entrySet().stream().filter(entry -> !this.mTransformula.getOutVars().containsKey(entry.getKey())).map(entry -> (TermVariable)entry.getValue()).collect(Collectors.toSet());
        assert (set != null);
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(this.mTransformula.getFormula().getFreeVars()));
        set.addAll(this.mTransformula.getOutVars().entrySet().stream().filter(entry -> !hashSet.contains(entry.getValue())).map(Map.Entry::getValue).collect(Collectors.toSet()));
        if (set.isEmpty()) {
            return null;
        }
        ArrayList<VariableLHS> arrayList = new ArrayList<VariableLHS>();
        for (TermVariable termVariable2 : set) {
            arrayList.add(new VariableLHS(null, this.mBoogie2Smt.getTypeSortTranslator().getType(termVariable2.getSort()), termVariable2.getName(), new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION, null)));
        }
        termVariable2 = new HavocStatement(null, arrayList.toArray(new VariableLHS[arrayList.size()]));
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("The following variables are havoced by this transformula: " + String.valueOf(arrayList)));
        }
        return termVariable2;
    }

    protected Map<TermVariable, String> getAlternateOldNames() {
        return this.mAlternateOldNames;
    }

    private IProgramVar getCachedFreshProgramVar(TermVariable termVariable) {
        return this.getCachedFreshProgramVar(termVariable, termVariable.getName());
    }

    private IProgramVar getCachedFreshProgramVar(TermVariable termVariable, String string) {
        if (this.mFreshVarsCache.containsKey(string)) {
            return this.mFreshVarsCache.get(string);
        }
        MockupProgramVar mockupProgramVar = new MockupProgramVar(termVariable, string, this.mManagedScript);
        this.mFreshVarsCache.put(string, mockupProgramVar);
        return mockupProgramVar;
    }

    protected Set<TermVariable> getVariableRetainmentSet() {
        return this.mVariableRetainmentSet;
    }

    private void obtainVariableMappingFromTransformula() {
        Object object;
        assert (this.mRenamedInVars.isEmpty());
        assert (this.mNewOutVars.isEmpty());
        assert (this.mNewAuxVars.isEmpty());
        assert (this.mOutVarRenaming.isEmpty());
        assert (this.mAddedVariables.isEmpty());
        assert (this.mInAuxVars.isEmpty());
        this.mRenamedInVars.putAll(this.mTransformula.getInVars().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            if (this.mOldTermVarMapping.containsKey(entry.getValue())) {
                return this.mOldTermVarMapping.get(entry.getValue());
            }
            return this.getCachedFreshProgramVar((TermVariable)entry.getValue());
        })));
        for (Map.Entry termVariable : this.mTransformula.getOutVars().entrySet()) {
            if (!this.mRenamedInVars.values().stream().anyMatch(iProgramVarOrConst -> iProgramVarOrConst.getGloballyUniqueId().equals(((TermVariable)termVariable.getValue()).getName()))) {
                if (this.mOldTermVarMapping.containsKey(termVariable.getValue())) {
                    object = this.mOldTermVarMapping.get(termVariable.getValue());
                } else {
                    object = this.getCachedFreshProgramVar((TermVariable)termVariable.getValue());
                    this.mNewOutVars.add((IProgramVarOrConst)object);
                }
                this.mOutVarRenaming.put((IProgramVarOrConst)object, (IProgramVarOrConst)termVariable.getKey());
                continue;
            }
            object = this.mRenamedInVars.entrySet().stream().filter(entry2 -> ((IProgramVarOrConst)entry2.getValue()).getGloballyUniqueId().equals(((TermVariable)termVariable.getValue()).getName())).findFirst().orElseGet(() -> {
                throw new UnsupportedOperationException();
            });
            this.mOutVarRenaming.put((IProgramVarOrConst)object.getValue(), (IProgramVarOrConst)object.getKey());
        }
        for (TermVariable termVariable : this.mTransformula.getAuxVars()) {
            if (this.mRenamedInVars.values().stream().anyMatch(iProgramVarOrConst -> iProgramVarOrConst.getGloballyUniqueId().equals(termVariable.getName())) || this.mNewOutVars.stream().anyMatch(iProgramVarOrConst -> iProgramVarOrConst.getGloballyUniqueId().equals(termVariable.getName()))) continue;
            object = this.getCachedFreshProgramVar(termVariable);
            this.mNewAuxVars.add((IProgramVarOrConst)object);
        }
        this.mAddedVariables.addAll(Stream.concat(this.mNewOutVars.stream(), this.mNewAuxVars.stream()).collect(Collectors.toSet()));
        this.mInAuxVars.addAll(this.mRenamedInVars.values().stream().filter(iProgramVarOrConst -> !this.mTransformula.getOutVars().values().stream().anyMatch(termVariable -> termVariable.getName().equals(iProgramVarOrConst.getGloballyUniqueId()))).collect(Collectors.toSet()));
        for (TermVariable termVariable : this.mTransformula.getOutVars().values()) {
            if (!this.mOldTermVarMapping.containsKey(termVariable)) continue;
            this.mInAuxVars.remove(this.mOldTermVarMapping.get(termVariable));
        }
        this.mInAuxVars.addAll(this.mNewAuxVars);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"   Will rename the following variables in the pre state:");
            this.mRenamedInVars.entrySet().stream().forEach(entry -> this.mLogger.debug((Object)("     " + ((IProgramVarOrConst)entry.getKey()).getGloballyUniqueId() + " (" + ((IProgramVarOrConst)entry.getKey()).hashCode() + ") --> " + ((IProgramVarOrConst)entry.getValue()).getGloballyUniqueId() + " (" + ((IProgramVarOrConst)entry.getValue()).hashCode() + ")")));
            this.mLogger.debug((Object)("   Will add the following variables to the pre state: " + String.valueOf(this.mAddedVariables)));
            this.mLogger.debug((Object)("   Will remove the following variables from the post state(s): " + String.valueOf(this.mInAuxVars)));
            this.mLogger.debug((Object)"   Will rename the following variables in the post state(s):");
            this.mOutVarRenaming.entrySet().stream().forEach(entry -> this.mLogger.debug((Object)("     " + ((IProgramVarOrConst)entry.getKey()).getGloballyUniqueId() + " (" + ((IProgramVarOrConst)entry.getKey()).hashCode() + ") --> " + ((IProgramVarOrConst)entry.getValue()).getGloballyUniqueId() + " (" + ((IProgramVarOrConst)entry.getValue()).hashCode() + ")")));
        }
    }

    protected PoormanAbstractState<BACKING> prepareState(PoormanAbstractState<BACKING> poormanAbstractState) {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>(this.mRenamedInVars.values());
        hashSet.addAll(this.mNewOutVars);
        hashSet.addAll(this.mNewAuxVars);
        this.mBoogie2SmtSymbolTable.addTemporaryVariables(hashSet.stream().map(iProgramVarOrConst -> (IProgramVar)iProgramVarOrConst).collect(Collectors.toSet()));
        return poormanAbstractState.renameVariables((Map)this.mRenamedInVars).addVariables(this.mAddedVariables);
    }

    protected Collection<BACKING> applyPost(PoormanAbstractState<BACKING> poormanAbstractState) {
        return this.mEvaluator.computePost(poormanAbstractState);
    }

    protected Collection<PoormanAbstractState<BACKING>> restoreOriginalStateVariables(Collection<BACKING> collection) {
        Object object2;
        Collection<Object> collection2 = new HashSet();
        if (this.mHavocPostCodeBlock != null) {
            for (Object object2 : collection) {
                if (object2.isBottom()) continue;
                Collection collection3 = this.mBackingDomain.getPostOperator().apply((IAbstractState)object2, (Object)this.mHavocPostCodeBlock);
                this.mLogger.debug((Object)("Post-havoc states: " + String.valueOf(collection3)));
                if (collection3.size() != 1) {
                    throw new UnsupportedOperationException("The number of states after the application of a havoc statement should be one, but is something else here.");
                }
                collection2.addAll(collection3);
            }
        }
        if (this.mHavocPostCodeBlock == null || collection2.isEmpty()) {
            collection2 = collection;
        }
        this.mBoogie2SmtSymbolTable.clearTemporaryVariables();
        object2 = new ArrayList();
        for (IAbstractState iAbstractState : collection2) {
            Set set = iAbstractState.getVariables().stream().filter(iProgramVarOrConst -> this.mOutVarRenaming.values().stream().anyMatch(iProgramVarOrConst2 -> iProgramVarOrConst.getGloballyUniqueId().equals(iProgramVarOrConst2.getGloballyUniqueId()))).collect(Collectors.toSet());
            IAbstractState iAbstractState2 = iAbstractState.removeVariables(set).removeVariables(this.mInAuxVars).renameVariables(this.mOutVarRenaming);
            object2.add(new PoormanAbstractState<IAbstractState>(this.mServices, this.mBackingDomain, iAbstractState2));
        }
        return object2;
    }

    private static final class MockupProgramVar
    implements IProgramVar {
        private static final long serialVersionUID = 4924620166368141045L;
        private final String mName;
        private final TermVariable mTerm;
        private final TermVariable mVar;

        private MockupProgramVar(TermVariable termVariable, String string, ManagedScript managedScript) {
            this.mVar = termVariable;
            this.mName = string;
            this.mTerm = managedScript.variable(this.mName, this.mVar.getSort());
        }

        public ApplicationTerm getDefaultConstant() {
            return null;
        }

        public String getGloballyUniqueId() {
            return this.mName;
        }

        public ApplicationTerm getPrimedConstant() {
            return null;
        }

        public String getProcedure() {
            return null;
        }

        public Term getTerm() {
            return this.getTermVariable();
        }

        public TermVariable getTermVariable() {
            return this.mTerm;
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean isOldvar() {
            return false;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            throw new IOException("Unserializable object: " + this.getClass().getSimpleName());
        }

        public String toString() {
            return this.getGloballyUniqueId();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new IOException("Unserializable object: " + this.getClass().getSimpleName());
        }
    }
}

