/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.ITerm2ExpressionSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PredicateUtils {
    public static long computeDagSizeOfPredicate(IPredicate iPredicate, FormulaSize formulaSize) {
        switch (formulaSize) {
            case DAGSIZE: {
                return new DAGSize().size(iPredicate.getFormula());
            }
            case TREESIZE: {
                return new DAGSize().treesize(iPredicate.getFormula());
            }
        }
        throw new AssertionError((Object)("unknown " + String.valueOf((Object)formulaSize)));
    }

    public static long[] computeDagSizeOfPredicates(List<IPredicate> list, FormulaSize formulaSize) {
        long[] lArray = new long[list.size()];
        int n = 0;
        while (n < list.size()) {
            lArray[n] = PredicateUtils.computeDagSizeOfPredicate(list.get(n), formulaSize);
            ++n;
        }
        return lArray;
    }

    public static Term computeClosedFormula(Term term, Set<IProgramVar> set, ManagedScript managedScript) {
        IProgramVar iProgramVar2;
        HashMap<TermVariable, ApplicationTerm> hashMap = new HashMap<TermVariable, ApplicationTerm>();
        for (IProgramVar iProgramVar2 : set) {
            hashMap.put(iProgramVar2.getTermVariable(), iProgramVar2.getDefaultConstant());
        }
        iProgramVar2 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term);
        assert (iProgramVar2.getFreeVars().length == 0);
        return iProgramVar2;
    }

    public static Term formulaWithIndexedVars(IPredicate iPredicate, Set<IProgramVar> set, int n, int n2, int n3, Set<IProgramNonOldVar> set2, int n4, int n5, Map<String, Term> map, Script script, Set<IProgramNonOldVar> set3) {
        Term term = iPredicate.getFormula();
        if (iPredicate.getVars() == null) {
            return term;
        }
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        for (IProgramVar object22 : iPredicate.getVars()) {
            IProgramNonOldVar iProgramNonOldVar;
            Object n6 = set.contains(object22) ? PredicateUtils.getIndexedConstant(object22, n, map, script) : (object22.isOldvar() ? (set3.contains(iProgramNonOldVar = ((IProgramOldVar)object22).getNonOldVar()) ? (n3 == Integer.MIN_VALUE ? object22.getDefaultConstant() : PredicateUtils.getIndexedConstant(((IProgramOldVar)object22).getNonOldVar(), n3, map, script)) : PredicateUtils.getIndexedConstant(iProgramNonOldVar, n5, map, script)) : (object22.isGlobal() ? (set2 != null && set2.contains(object22) ? PredicateUtils.getIndexedConstant(object22, n4, map, script) : PredicateUtils.getIndexedConstant(object22, n5, map, script)) : PredicateUtils.getIndexedConstant(object22, n2, map, script)));
            TermVariable termVariable = object22.getTermVariable();
            hashMap.put(termVariable, (Term)n6);
        }
        TermVariable[] termVariableArray = new TermVariable[hashMap.size()];
        Term[] termArray = new Term[hashMap.size()];
        int n6 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            termVariableArray[n6] = (TermVariable)entry.getKey();
            termArray[n6] = (Term)entry.getValue();
            ++n6;
        }
        Term term2 = script.let(termVariableArray, termArray, term);
        return term2;
    }

    public static Term formulaWithIndexedVars(UnmodifiableTransFormula unmodifiableTransFormula, int n, int n2, Set<IProgramVar> set, Map<String, Term> map, Script script) {
        Term[] termArray;
        TermVariable[] termVariableArray;
        Object object;
        Object object2;
        assert (set != null && set.isEmpty());
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(Arrays.asList(unmodifiableTransFormula.getFormula().getFreeVars()));
        Term term = unmodifiableTransFormula.getFormula();
        HashMap<TermVariable, IProgramVar> hashMap = new HashMap<TermVariable, IProgramVar>();
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getInVars().keySet()) {
            object2 = unmodifiableTransFormula.getInVars().get(iProgramVar);
            hashMap.put((TermVariable)object2, iProgramVar);
            object = iProgramVar.isOldvar() ? iProgramVar.getDefaultConstant() : PredicateUtils.getIndexedConstant(iProgramVar, n, map, script);
            termVariableArray = new TermVariable[]{object2};
            termArray = new Term[]{object};
            term = script.let(termVariableArray, termArray, term);
            hashSet.remove(object2);
        }
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getOutVars().keySet()) {
            object2 = unmodifiableTransFormula.getOutVars().get(iProgramVar);
            hashMap.put((TermVariable)object2, iProgramVar);
            if (unmodifiableTransFormula.getInVars().get(iProgramVar) == object2) continue;
            set.add(iProgramVar);
            object = iProgramVar.isOldvar() && !unmodifiableTransFormula.getAssignedVars().contains(iProgramVar) ? iProgramVar.getDefaultConstant() : PredicateUtils.getIndexedConstant(iProgramVar, n2, map, script);
            termVariableArray = new TermVariable[]{object2};
            termArray = new Term[]{object};
            term = script.let(termVariableArray, termArray, term);
            hashSet.remove(object2);
        }
        for (TermVariable termVariable : hashSet) {
            object2 = unmodifiableTransFormula.getAuxVars().contains(termVariable) ? script.term(ProgramVarUtils.generateConstantIdentifierForAuxVar(termVariable), new Term[0]) : ((IProgramVar)hashMap.get(termVariable)).getDefaultConstant();
            object = new Term[]{termVariable};
            termVariableArray = new Term[]{object2};
            term = script.let((TermVariable[])object, (Term[])termVariableArray, term);
        }
        return term;
    }

    public static Term getIndexedConstant(IProgramVar iProgramVar, int n, Map<String, Term> map, Script script) {
        return PredicateUtils.getIndexedConstant(iProgramVar.getGloballyUniqueId(), iProgramVar.getTermVariable().getSort(), n, map, script);
    }

    public static Term getIndexedConstant(String string, Sort sort, int n, Map<String, Term> map, Script script) {
        String string2 = String.valueOf(n);
        String string3 = string + "_" + string2;
        Term term = map.get(string3);
        if (term == null) {
            Sort[] sortArray = new Sort[]{};
            script.declareFun(string3, sortArray, sort);
            Term[] termArray = new Term[]{};
            term = script.term(string3, termArray);
            map.put(string3, term);
        }
        return term;
    }

    public static Script.LBool isInductiveHelper(Script script, IPredicate iPredicate, IPredicate iPredicate2, UnmodifiableTransFormula unmodifiableTransFormula, Set<IProgramNonOldVar> set, Set<IProgramNonOldVar> set2) {
        IProgramNonOldVar iProgramNonOldVar2;
        script.push(1);
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Object object = new HashSet();
        HashSet<IProgramNonOldVar> hashSet = new HashSet<IProgramNonOldVar>();
        PredicateUtils.findNonModifiablesGlobals(iPredicate.getVars(), set, Collections.emptySet(), object, hashSet);
        PredicateUtils.findNonModifiablesGlobals(unmodifiableTransFormula.getInVars().keySet(), set, Collections.emptySet(), object, hashSet);
        PredicateUtils.findNonModifiablesGlobals(unmodifiableTransFormula.getOutVars().keySet(), set2, unmodifiableTransFormula.getAssignedVars(), object, hashSet);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            iProgramNonOldVar2 = (IProgramNonOldVar)iterator.next();
            arrayList.add(ModifiableGlobalsTable.constructConstantOldVarEquality(iProgramNonOldVar2, false, script));
        }
        for (IProgramNonOldVar iProgramNonOldVar2 : hashSet) {
            arrayList.add(ModifiableGlobalsTable.constructConstantOldVarEquality(iProgramNonOldVar2, true, script));
        }
        object = iPredicate.getClosedFormula();
        assert (object != null);
        arrayList.add((Term)object);
        object = unmodifiableTransFormula.getClosedFormula();
        assert (object != null);
        arrayList.add((Term)object);
        object = new HashSet();
        hashSet = new HashSet();
        PredicateUtils.findNonModifiablesGlobals(iPredicate2.getVars(), set2, unmodifiableTransFormula.getAssignedVars(), (Set<IProgramNonOldVar>)object, hashSet);
        iterator = object.iterator();
        while (iterator.hasNext()) {
            iProgramNonOldVar2 = (IProgramNonOldVar)iterator.next();
            arrayList.add(ModifiableGlobalsTable.constructConstantOldVarEquality(iProgramNonOldVar2, false, script));
        }
        for (IProgramNonOldVar iProgramNonOldVar2 : hashSet) {
            arrayList.add(ModifiableGlobalsTable.constructConstantOldVarEquality(iProgramNonOldVar2, true, script));
        }
        object = PredicateUtils.rename(script, iPredicate2, unmodifiableTransFormula.getAssignedVars());
        arrayList.add(SmtUtils.not((Script)script, (Term)object));
        script.assertTerm(SmtUtils.and((Script)script, arrayList));
        object = script.checkSat();
        script.pop(1);
        return object;
    }

    private static void findNonModifiablesGlobals(Set<IProgramVar> set, Set<IProgramNonOldVar> set2, Set<IProgramVar> set3, Set<IProgramNonOldVar> set4, Set<IProgramNonOldVar> set5) {
        for (IProgramVar iProgramVar : set) {
            IProgramNonOldVar iProgramNonOldVar;
            if (!(iProgramVar instanceof IProgramOldVar) || set2.contains(iProgramNonOldVar = ((IProgramOldVar)iProgramVar).getNonOldVar())) continue;
            if (set3.contains(iProgramVar)) {
                set5.add(iProgramNonOldVar);
                continue;
            }
            set4.add(iProgramNonOldVar);
        }
    }

    private static Term rename(Script script, IPredicate iPredicate, Set<IProgramVar> set) {
        IProgramVar iProgramVar2;
        HashMap<TermVariable, ApplicationTerm> hashMap = new HashMap<TermVariable, ApplicationTerm>();
        for (IProgramVar iProgramVar2 : iPredicate.getVars()) {
            ApplicationTerm applicationTerm = set.contains(iProgramVar2) ? iProgramVar2.getPrimedConstant() : iProgramVar2.getDefaultConstant();
            hashMap.put(iProgramVar2.getTermVariable(), applicationTerm);
        }
        iProgramVar2 = PureSubstitution.apply((Script)script, hashMap, (Term)iPredicate.getFormula());
        assert (iProgramVar2.getFreeVars().length == 0) : "there are free vars";
        return iProgramVar2;
    }

    public static IcfgLocation getLocation(IPredicate iPredicate) {
        if (iPredicate instanceof ISLPredicate) {
            return ((ISLPredicate)iPredicate).getProgramPoint();
        }
        throw new IllegalArgumentException("predicate does not offer program point: " + String.valueOf(iPredicate));
    }

    public static IcfgLocation getSingleLocation(IPredicate iPredicate) {
        if (iPredicate instanceof ISLPredicate) {
            return ((ISLPredicate)iPredicate).getProgramPoint();
        }
        if (iPredicate instanceof IMLPredicate) {
            IcfgLocation[] icfgLocationArray = ((IMLPredicate)iPredicate).getProgramPoints();
            if (icfgLocationArray.length > 1) {
                throw new IllegalArgumentException("predicate has more than one program point: " + String.valueOf(iPredicate));
            }
            if (icfgLocationArray.length != 0) {
                return icfgLocationArray[0];
            }
        }
        throw new IllegalArgumentException("predicate does not offer program point: " + String.valueOf(iPredicate));
    }

    public static Set<IcfgLocation> getLocations(IPredicate iPredicate) {
        if (iPredicate instanceof ISLPredicate) {
            return Set.of(((ISLPredicate)iPredicate).getProgramPoint());
        }
        if (iPredicate instanceof IMLPredicate) {
            return Set.of(((IMLPredicate)iPredicate).getProgramPoints());
        }
        throw new UnsupportedOperationException("Unsupported type " + String.valueOf(iPredicate.getClass()));
    }

    public static Stream<IcfgLocation> streamLocations(IPredicate iPredicate) {
        if (iPredicate instanceof ISLPredicate) {
            return Stream.of(((ISLPredicate)iPredicate).getProgramPoint());
        }
        if (iPredicate instanceof IMLPredicate) {
            return Arrays.stream(((IMLPredicate)iPredicate).getProgramPoints());
        }
        throw new UnsupportedOperationException("Unsupported type " + String.valueOf(iPredicate.getClass()));
    }

    private static Term eliminateVars(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, IPredicate iPredicate, Predicate<IProgramVar> predicate) {
        List list = iPredicate.getVars().stream().filter(predicate).map(IProgramVar::getTermVariable).collect(Collectors.toList());
        Term term = SmtUtils.quantifier((Script)managedScript.getScript(), (int)0, list, (Term)iPredicate.getFormula());
        return PartialQuantifierElimination.eliminateLight((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)term);
    }

    public static Term eliminateOldVars(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, IPredicate iPredicate) {
        return PredicateUtils.eliminateVars(iUltimateServiceProvider, managedScript, iPredicate, IProgramVar::isOldvar);
    }

    public static Term eliminateLocalVars(IPredicate iPredicate, IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit) {
        ITerm2ExpressionSymbolTable iTerm2ExpressionSymbolTable = (ITerm2ExpressionSymbolTable)((Object)cfgSmtToolkit.getSymbolTable());
        return PredicateUtils.eliminateVars(iUltimateServiceProvider, cfgSmtToolkit.getManagedScript(), iPredicate, iProgramVar -> iTerm2ExpressionSymbolTable.getDeclarationInformation((IProgramVar)iProgramVar).getStorageClass().equals((Object)DeclarationInformation.StorageClass.LOCAL));
    }

    public static IPredicate computeInitialPredicateForProcedure(ModifiableGlobalsTable modifiableGlobalsTable, Script script, String string, BasicPredicateFactory basicPredicateFactory) {
        List<Term> list = modifiableGlobalsTable.getModifiedBoogieVars(string).stream().map(iProgramNonOldVar -> SmtUtils.equality((Script)script, (Term[])new Term[]{iProgramNonOldVar.getTermVariable(), iProgramNonOldVar.getOldVar().getTermVariable()})).collect(Collectors.toList());
        return basicPredicateFactory.andT(list);
    }

    public static enum FormulaSize {
        TREESIZE,
        DAGSIZE;

    }
}

