/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DoubleDeckerVisitor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.MLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SPredicate;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationFragments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class HoareAnnotationExtractor<LETTER extends IAction>
extends DoubleDeckerVisitor<LETTER, IPredicate> {
    Set<DoubleDecker<IPredicate>> mReportedDoubleDeckers = new HashSet<DoubleDecker<IPredicate>>();
    private final HoareAnnotationFragments<LETTER> mHoareAnnotation;

    public HoareAnnotationExtractor(IUltimateServiceProvider iUltimateServiceProvider, INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton, HoareAnnotationFragments<LETTER> hoareAnnotationFragments) {
        super(new AutomataLibraryServices(iUltimateServiceProvider));
        this.mTraversedNwa = iNestedWordAutomaton;
        this.mHoareAnnotation = hoareAnnotationFragments;
        try {
            this.traverseDoubleDeckerGraph();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            this.mLogger.warn((Object)"Computation of Hoare annotation canceled.");
        }
    }

    private void addContext(DoubleDecker<IPredicate> doubleDecker) {
        if (!this.mReportedDoubleDeckers.contains(doubleDecker)) {
            IPredicate iPredicate = (IPredicate)doubleDecker.getUp();
            IPredicate iPredicate2 = (IPredicate)doubleDecker.getDown();
            this.mHoareAnnotation.addDoubleDecker(iPredicate2, iPredicate, (IPredicate)this.mTraversedNwa.getEmptyStackState());
            this.mReportedDoubleDeckers.add(doubleDecker);
        }
    }

    protected Collection<IPredicate> getInitialStates() {
        IPredicate iPredicate;
        Set set = this.mTraversedNwa.getInitialStates();
        if (set.size() == 1 && !((iPredicate = (IPredicate)set.iterator().next()) instanceof SPredicate) && !(iPredicate instanceof MLPredicate)) {
            throw new AssertionError((Object)"No State Automaton would be ok");
        }
        return set;
    }

    protected Collection<IPredicate> visitAndGetInternalSuccessors(DoubleDecker<IPredicate> doubleDecker) {
        this.addContext(doubleDecker);
        IPredicate iPredicate = (IPredicate)doubleDecker.getUp();
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>();
        for (OutgoingInternalTransition outgoingInternalTransition : this.mTraversedNwa.internalSuccessors((Object)iPredicate)) {
            IPredicate iPredicate2 = (IPredicate)outgoingInternalTransition.getSucc();
            arrayList.add(iPredicate2);
        }
        return arrayList;
    }

    protected Collection<IPredicate> visitAndGetCallSuccessors(DoubleDecker<IPredicate> doubleDecker) {
        this.addContext(doubleDecker);
        IPredicate iPredicate = (IPredicate)doubleDecker.getUp();
        Set set = this.mTraversedNwa.lettersCall((Object)iPredicate);
        if (set.size() > 1) {
            throw new UnsupportedOperationException("Several outgoing calls not supported");
        }
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>();
        for (IAction iAction : set) {
            Iterator iterator = this.mTraversedNwa.callSuccessors((Object)iPredicate, (Object)iAction).iterator();
            OutgoingCallTransition outgoingCallTransition = (OutgoingCallTransition)iterator.next();
            if (iterator.hasNext()) {
                throw new UnsupportedOperationException("Several outgoing calls not supported");
            }
            IPredicate iPredicate2 = (IPredicate)outgoingCallTransition.getSucc();
            this.mHoareAnnotation.addContextEntryPair(iPredicate, iPredicate2);
            arrayList.add(iPredicate2);
        }
        return arrayList;
    }

    protected Collection<IPredicate> visitAndGetReturnSuccessors(DoubleDecker<IPredicate> doubleDecker) {
        this.addContext(doubleDecker);
        IPredicate iPredicate = (IPredicate)doubleDecker.getUp();
        IPredicate iPredicate2 = (IPredicate)doubleDecker.getDown();
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>();
        if (iPredicate2 == this.mTraversedNwa.getEmptyStackState()) {
            return arrayList;
        }
        for (OutgoingReturnTransition outgoingReturnTransition : this.mTraversedNwa.returnSuccessorsGivenHier((Object)iPredicate, (Object)iPredicate2)) {
            IPredicate iPredicate3 = (IPredicate)outgoingReturnTransition.getSucc();
            arrayList.add(iPredicate3);
        }
        return arrayList;
    }
}

