/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.annotations.ReachDefStatementAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ReachDefBoogieVisitor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.boogie.ScopedBoogieVarBuilder;
import java.util.Collection;

public class ReachDefBoogieAnnotator {
    private final ReachDefBoogieVisitor mVisitor;
    private final Collection<ReachDefStatementAnnotation> mPredecessors;
    private final ReachDefStatementAnnotation mCurrent;
    private final ILogger mLogger;

    public ReachDefBoogieAnnotator(Collection<ReachDefStatementAnnotation> collection, ReachDefStatementAnnotation reachDefStatementAnnotation, ILogger iLogger, ScopedBoogieVarBuilder scopedBoogieVarBuilder) {
        this(collection, reachDefStatementAnnotation, iLogger, scopedBoogieVarBuilder, null);
    }

    public ReachDefBoogieAnnotator(Collection<ReachDefStatementAnnotation> collection, ReachDefStatementAnnotation reachDefStatementAnnotation, ILogger iLogger, ScopedBoogieVarBuilder scopedBoogieVarBuilder, String string) {
        assert (reachDefStatementAnnotation != null);
        this.mPredecessors = collection;
        this.mCurrent = reachDefStatementAnnotation;
        this.mVisitor = new ReachDefBoogieVisitor(reachDefStatementAnnotation, scopedBoogieVarBuilder, string);
        this.mLogger = iLogger;
    }

    public boolean annotate(Statement statement, UnmodifiableTransFormula unmodifiableTransFormula) throws Throwable {
        ReachDefStatementAnnotation reachDefStatementAnnotation = this.mCurrent.clone();
        this.union(this.mCurrent, this.mPredecessors);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("                                      Old Use: " + this.mCurrent.getUseAsString()));
            this.mLogger.debug((Object)("                                      Old Def: " + this.mCurrent.getDefAsString()));
        }
        this.mVisitor.process(statement, unmodifiableTransFormula);
        return !reachDefStatementAnnotation.equals((Object)this.mCurrent);
    }

    private void union(ReachDefStatementAnnotation reachDefStatementAnnotation, Collection<ReachDefStatementAnnotation> collection) {
        if (collection == null) {
            return;
        }
        assert (collection != null);
        assert (reachDefStatementAnnotation != null);
        for (ReachDefStatementAnnotation reachDefStatementAnnotation2 : collection) {
            if (reachDefStatementAnnotation2 == reachDefStatementAnnotation) continue;
            reachDefStatementAnnotation.unionDef(reachDefStatementAnnotation2);
        }
    }
}

